﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using MySql.Data.MySqlClient;

using Security;
namespace Security
{
    public partial class MyArticle : PageBase
    {
		protected void Page_Load(object sender, EventArgs e)
        {			
			btnDelAll.Attributes.Add("onclick","return confirm(\"是否确认删除？\")") ;
			
			if (!IsPostBack) 
			{ 
				GridviewBind();
			}
        }
		
		public string GetM(string strm)
		{
			if(strm == "False")
				return "[幻灯展示]";
			else
				return "[取消幻灯]";
		}
		
		public string GetS(string strm)
		{
			if(strm == "False")
				return "未审核";
			else
				return "已审核";
		}
		
		protected void GridviewBind() 
		{ 
			///创建数据连接对象：
			MysqlHelp mh = new MysqlHelp();
			///查询文章表中classID在子类集中的记录
			DataTable dt=new DataTable();
			dt = mh.GetDatabysql("Select Article4Deepsoon.ID,Title,Name,Source,Author,DateStr,isSetIndexPic,isPass From Article4DeepSoon,Class4Deepsoon Where Author='"+base.strUser+"' and ClassID=Class4Deepsoon.ID and isDelete=false Order By ID DESC");
			myGridView.DataSource = dt;        
			myGridView.DataBind();
		}
	
		protected void myGridView_PageIndexChanging(object sender, GridViewPageEventArgs e)
		{
			myGridView.PageIndex = e.NewPageIndex;
			GridviewBind();//重新执行自定义的GridView数据绑定函数
			((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text = ""+(myGridView.PageIndex+1);
		}
		
		protected void myGridView_RowCommand(object sender, GridViewCommandEventArgs e) 
		{ 
			if(e.CommandName == "editArticle"){
				Response.Write("获取的ID"+e.CommandArgument.ToString() );
				Response.Redirect( "DeepSoonArticleUpdate.aspx?ID="+e.CommandArgument.ToString() );
			}
			else if(e.CommandName == "deleteArticle"){
				///创建数据连接对象：
				MysqlHelp mh = new MysqlHelp();
				MySqlParameter[] updateParms ={new MySqlParameter("?ID",MySqlDbType.VarChar,8)};
				updateParms[0].Value = ""+e.CommandArgument.ToString();
				mh.Runsql("Update Article4DeepSoon Set isDelete=true Where ID=?ID", updateParms);		
				GridviewBind(); 
			}
			else if(e.CommandName == "headTitleArticle"){
				MysqlHelp mh = new MysqlHelp();
				DataTable dt = new DataTable();
				dt = mh.GetDatabysql("Select * From HeadTitle4DeepSoon");
				if(dt.Rows.Count>0){
					MySqlParameter[] updateHeadTitleParms ={new MySqlParameter("?ArticleID",MySqlDbType.VarChar,8)};
					updateHeadTitleParms[0].Value = ""+e.CommandArgument.ToString();
					mh.Runsql("Update HeadTitle4DeepSoon Set ArticleID=?ArticleID", updateHeadTitleParms);		
				}
				else {
					mh.Runsql("insert into HeadTitle4DeepSoon(ArticleID) Values ("+e.CommandArgument.ToString()+")");
				}
				GridviewBind(); 
			}
			else if(e.CommandName == "indexPicArticle"){
				MysqlHelp mh = new MysqlHelp();
				string ArticleID = e.CommandArgument.ToString();
				DataTable ArticleDt = new DataTable();
				ArticleDt = mh.GetDatabysql("Select isSetIndexPic From Article4DeepSoon Where ID="+ArticleID);
				if(ArticleDt.Rows.Count>0){
					string isSetIndexPic = ArticleDt.Rows[0]["isSetIndexPic"].ToString();
					string isSetIndexPicNowValue = "False";
					if(isSetIndexPic == "False")isSetIndexPicNowValue="True";
					else isSetIndexPicNowValue = "False";
					mh.Runsql( "Update Article4DeepSoon Set isSetIndexPic="+isSetIndexPicNowValue+" Where ID="+ArticleID );
				}
				GridviewBind(); 
			}
			else if(e.CommandName == "setPass"){
				MysqlHelp mh = new MysqlHelp();
				string ArticleID = e.CommandArgument.ToString();
				DataTable ArticleDt = new DataTable();
				ArticleDt = mh.GetDatabysql("Select isPass From Article4DeepSoon Where ID="+ArticleID);
				if(ArticleDt.Rows.Count>0){
					string isPass = ArticleDt.Rows[0]["isPass"].ToString();
					string setPassValue = "False";
					if(isPass == "False")setPassValue="True";
					else setPassValue = "False";
					mh.Runsql( "Update Article4DeepSoon Set isPass="+setPassValue+" Where ID="+ArticleID );
				}
				GridviewBind(); 
			}
		}
	
		protected void btnDelAll_Click(object sender, EventArgs e) 
		{ 
			string sqlText = "("; 
			int countNum = 0;//统计用户选取的记录数目
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				if (cbx.Checked == true) 
				{ 
					sqlText = sqlText + Convert.ToInt32(myGridView.DataKeys[i].Value) + ",";
					countNum ++;
				} 
			} 
			//去掉最后的逗号，并且加上右括号 
			sqlText = sqlText.Substring(0,sqlText.Length - 1) + ")"; 
			if(countNum>0){///如果选择不为空
				sqlText = "Update Article4DeepSoon Set isDelete=true Where ID In" + sqlText; 
				MysqlHelp mh = new MysqlHelp();
				mh.Runsql(sqlText); 
			}
			GridviewBind(); 
		}

		#region 转到触发方法
		protected void btnGo_Click(object sender, EventArgs e)
		{
			if(((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text != ""){
				myGridView.PageIndex = int.Parse(((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text) - 1;
				GridviewBind();   //重新绑定GridView
				((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text = ""+(myGridView.PageIndex+1);
			}
		}
		#endregion
		
    }
}