﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using MySql.Data.MySqlClient;

using Security;
namespace Security
{
    public partial class DeepSoonPWD : PageBase
    {
		protected void Page_Load(object sender, EventArgs e)
        {
			if (!IsPostBack) 
			{ 
				GridviewBind();
				///设置管理员默认账户
				this.txtUpdateLoginName.Text= base.strUser;
			}
			
			btnDelAll.Attributes.Add("onclick","return confirm(\"删除后数据无法恢复，是否确认删除？\")") ;
			
        }
		
		public string GetM(string strm)
		{
			string roleStr = "";
			switch (strm)
			{
				case "super":
					roleStr = "超级用户";
					break;
				case "normal":
					roleStr = "普通用户";
					break;
				default:
					roleStr = "普通用户";
					break;
			}///end switch
			return roleStr;
		}
		
		protected void GridviewBind() 
		{ 
			///创建数据连接对象：
			MysqlHelp mh = new MysqlHelp();
			///查询并显示数据：
			DataTable dt=new DataTable();
			dt = mh.GetDatabysql("Select * From Users4DeepSoon Order By ID DESC");
			myGridView.DataSource = dt;        
			myGridView.DataBind();
		}
	
		protected void myGridView_PageIndexChanging(object sender, GridViewPageEventArgs e)
		{
			myGridView.PageIndex = e.NewPageIndex;
			GridviewBind();//重新执行自定义的GridView数据绑定函数
			((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text = ""+(myGridView.PageIndex+1);
		}

		protected void myGridView_RowDeleting(object sender, GridViewDeleteEventArgs e) 
		{ 
			int deleteID = Convert.ToInt32(myGridView.DataKeys[e.RowIndex].Value);//获取主键
		
			///创建数据连接对象：
			MysqlHelp mh = new MysqlHelp();
			MySqlParameter[] updateParms ={new MySqlParameter("?ID",MySqlDbType.VarChar,4)};
			updateParms[0].Value = ""+deleteID;
			mh.Runsql("Delete From Users4DeepSoon Where ID=?ID", updateParms);
			
			///管理日志：删除管理员
			MySqlParameter[] logParms ={new MySqlParameter("?Name",MySqlDbType.VarChar,20),
			new MySqlParameter("?EventStr",MySqlDbType.VarChar,40),
			new MySqlParameter("?IPStr",MySqlDbType.VarChar,20)};
			logParms[0].Value = ""+base.strUser;
			logParms[1].Value = "删除管理员";
			logParms[2].Value = ""+getClientIP();
			mh.Runsql("Insert Into Log4DeepSoon(Name,EventStr,IPStr) Values (?Name,?EventStr,?IPStr)", logParms);
		
			GridviewBind(); 
		} 
	
		protected void btnDelAll_Click(object sender, EventArgs e) 
		{ 
			string sqlText = "("; 
			int countNum = 0;//统计用户选取的记录数目
			for (int i = 0; i < myGridView.Rows.Count; i++) 
			{ 
				//搜索第n行3列 
				CheckBox cbx = (CheckBox)myGridView.Rows[i].FindControl("cbxId"); 
				if (cbx.Checked == true) 
				{ 
					sqlText = sqlText + Convert.ToInt32(myGridView.DataKeys[i].Value) + ",";
					countNum ++;
				} 
			} 
			//去掉最后的逗号，并且加上右括号 
			sqlText = sqlText.Substring(0,sqlText.Length - 1) + ")"; 
			if(countNum>0){///如果选择不为空
				sqlText = "Delete From Users4DeepSoon Where ID In" + sqlText; 
				MysqlHelp mh = new MysqlHelp();
				mh.Runsql(sqlText);

				///管理日志：删除管理员
				MySqlParameter[] logParms ={new MySqlParameter("?Name",MySqlDbType.VarChar,20),
				new MySqlParameter("?EventStr",MySqlDbType.VarChar,40),
				new MySqlParameter("?IPStr",MySqlDbType.VarChar,20)};
				logParms[0].Value = ""+base.strUser;
				logParms[1].Value = "删除管理员";
				logParms[2].Value = ""+getClientIP();
				mh.Runsql("Insert Into Log4DeepSoon(Name,EventStr,IPStr) Values (?Name,?EventStr,?IPStr)", logParms);
			
			}
			GridviewBind(); 
		}

		#region 转到触发方法
		protected void btnGo_Click(object sender, EventArgs e)
		{
			if(((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text != ""){
				myGridView.PageIndex = int.Parse(((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text) - 1;
				GridviewBind();   //重新绑定GridView
				((TextBox)myGridView.BottomPagerRow.FindControl("txtGoPage")).Text = ""+(myGridView.PageIndex+1);
			}
		}
		#endregion
		
		protected void btnAdd_Click(object sender, EventArgs e)
        {
			///获取用户输入的账号：
			string txtLoginNameValue = this.txtLoginName.Text.Replace("'", "");
			if(txtLoginNameValue.Length>20)txtLoginNameValue = txtLoginNameValue.Substring(0,20);
			///获取用户输入的保密码：
			string txtLoginPWDValue = this.txtLoginPWD.Text.Replace("'", "");
			if(txtLoginPWDValue.Length>8)txtLoginPWDValue = this.txtLoginPWD.Text.Substring(0,8);
			///获取用户输入的确认密码：
			string txtLoginPWDAgainValue = this.txtLoginPWDAgain.Text.Replace("'", "");
			if(txtLoginPWDAgainValue.Length>8)txtLoginPWDAgainValue = txtLoginPWDAgainValue.Substring(0,8);
			///获取用户选择的账户权限：
			string txtClassValue = this.dropListClass.SelectedItem.Value.Replace("'", "");
			if(txtClassValue.Length>20)txtClassValue = txtClassValue.Substring(0,20);
			
			
			if (txtLoginNameValue!="" && txtLoginPWDValue!=""){//判断用户输入的是否为空用户名和密码
				if ( txtLoginPWDValue== txtLoginPWDAgainValue)///如果用户输入的密码和确认密码相同
				{
					///创建数据连接对象：
					MysqlHelp mh = new MysqlHelp();
					///查询数据库，主要检测用户名是否已经存在
					DataTable dt=new DataTable();
					MySqlParameter[] quryParms  = {new MySqlParameter("?Name",MySqlDbType.VarChar,20)};
					quryParms[0].Value = ""+txtLoginNameValue;
					dt = mh.GetDatabysql("Select * From Users4DeepSoon Where Name=?Name",quryParms);
				
					///如果数据库查询到了记录，说明用户名已经存在了
					if (dt.Rows.Count>0){
						this.labelAddInfor.Text = "您输入的用户名已经存在!";
					}
					else {
						///利用MD5进行加密：
						string MD5PWD=System.Web.Security.FormsAuthentication.HashPasswordForStoringInConfigFile(txtLoginPWDValue,"MD5");
						///添加新账户：
						MySqlParameter[] addParms ={new MySqlParameter("?Name",MySqlDbType.VarChar,20),new MySqlParameter("?PWD",MySqlDbType.VarChar,32),new MySqlParameter("?Class",MySqlDbType.VarChar,20)};
						addParms[0].Value = ""+txtLoginNameValue;
						addParms[1].Value = ""+MD5PWD;
						addParms[2].Value = ""+txtClassValue;
						mh.Runsql("Insert Into Users4DeepSoon(Name,PWD,Class) Values (?Name,?PWD,?Class)", addParms);
						this.labelAddInfor.Text = "新账户已经成功添加!";
						GridviewBind();
				
						///管理日志：添加新账户
						MySqlParameter[] logParms ={new MySqlParameter("?Name",MySqlDbType.VarChar,20),
						new MySqlParameter("?EventStr",MySqlDbType.VarChar,40),
						new MySqlParameter("?IPStr",MySqlDbType.VarChar,20)};
						logParms[0].Value = ""+base.strUser;
						logParms[1].Value = "添加新管理员";
						logParms[2].Value = ""+getClientIP();
						mh.Runsql("Insert Into Log4DeepSoon(Name,EventStr,IPStr) Values (?Name,?EventStr,?IPStr)", logParms);
					}
				
				}
				else
				{
					this.labelAddInfor.Text="你输入的前后密码不一致";
				}
			}//end 判断是否账户名和密码为空
			else
			{
				this.labelAddInfor.Text="账户名和密码不允许为空!";
			}
		}///end btnAdd_Click()
		
		protected void btnUpdate_Click(object sender, EventArgs e)
        {
			///获取用户输入的账号：
			string txtUpdateLoginNameValue = this.txtUpdateLoginName.Text.Replace("'", "");
			if(txtUpdateLoginNameValue.Length>20)txtUpdateLoginNameValue = this.txtUpdateLoginName.Text.Substring(0,20);
			///获取用户输入的旧密码：
			string txtUpdateLoginPWDValue = this.txtUpdateLoginPWD.Text.Replace("'", "");
			if(txtUpdateLoginPWDValue.Length>8)txtUpdateLoginPWDValue = this.txtUpdateLoginPWD.Text.Substring(0,8);
			///获取用户输入的新密码：
			string txtUpdateLoginPWDAgainValue = this.txtUpdateLoginPWDAgain.Text.Replace("'", "");
			if(txtUpdateLoginPWDAgainValue.Length>8)txtUpdateLoginPWDAgainValue = this.txtUpdateLoginPWDAgain.Text.Substring(0,8);
			///获取用户选择的账户权限：
			string txtUpdateClassValue = this.dropListUpdateClass.SelectedItem.Value.Replace("'", "");
			if(txtUpdateClassValue.Length>20)txtUpdateClassValue = txtUpdateClassValue.Substring(0,20);
			
			if (txtUpdateLoginNameValue!="" && txtUpdateLoginPWDAgainValue!=""){//判断用户输入的是否为空用户名和密码
				///利用MD5进行加密：
				string MD5PWDOld=System.Web.Security.FormsAuthentication.HashPasswordForStoringInConfigFile(txtUpdateLoginPWDValue,"MD5");
				string MD5PWDNew=System.Web.Security.FormsAuthentication.HashPasswordForStoringInConfigFile(txtUpdateLoginPWDAgainValue,"MD5");
					
				///创建数据连接对象：
				MysqlHelp mh = new MysqlHelp();
				///查询数据库，主要检测用户名和密码是否已经存在
				DataTable dt=new DataTable();
				MySqlParameter[] quryParms  = {new MySqlParameter("?Name",MySqlDbType.VarChar,20),new MySqlParameter("?PWD",MySqlDbType.VarChar,32)};
				quryParms[0].Value = ""+txtUpdateLoginNameValue;
				quryParms[1].Value = ""+MD5PWDOld;
				dt = mh.GetDatabysql("Select * From Users4DeepSoon Where Name=?Name and PWD=?PWD",quryParms);
				
				///如果数据库查询到了记录，说明要修改的账户已经存在于数据库中
				if (dt.Rows.Count>0){
					///修改账户的密码：
					MySqlParameter[] updateParms ={new MySqlParameter("?PWD",MySqlDbType.VarChar,32),new MySqlParameter("?Name",MySqlDbType.VarChar,20),new MySqlParameter("?Class",MySqlDbType.VarChar,20)};
					updateParms[0].Value = ""+MD5PWDNew;
					updateParms[1].Value = ""+txtUpdateLoginNameValue;
					updateParms[2].Value = ""+txtUpdateClassValue;
					mh.Runsql("Update Users4DeepSoon Set PWD=?PWD,Class=?Class Where Name=?Name", updateParms);
					this.labelUpdateInfor.Text = txtUpdateLoginNameValue+"账户已经修改!";
					GridviewBind();
					
					///管理日志：修改密码
					MySqlParameter[] logParms ={new MySqlParameter("?Name",MySqlDbType.VarChar,20),
					new MySqlParameter("?EventStr",MySqlDbType.VarChar,40),
					new MySqlParameter("?IPStr",MySqlDbType.VarChar,20)};
					logParms[0].Value = ""+base.strUser;
					logParms[1].Value = "修改账户密码";
					logParms[2].Value = ""+getClientIP();
					mh.Runsql("Insert Into Log4DeepSoon(Name,EventStr,IPStr) Values (?Name,?EventStr,?IPStr)", logParms);
			
				}
				else{
					this.labelUpdateInfor.Text = "您要修改的账户不存在，或许你输入的旧密码不对!";
				}
			}
			else{
				this.labelUpdateInfor.Text = "新密码不能为空!";
			}
		}///end btnAdd_Click()
    }
}