﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using MySql.Data.MySqlClient;

using Security;
namespace Security
{
    public partial class Tree : PageBase
    {
		MysqlHelp mh = null;
		DataTable dt = null;
		string treeStr = "";
		
		///定义树节点的结构体
		struct ClassTreeNode{
			public string ID;
			public string Name;
			public string OutLinkHref;
			public int Level;
		}
		
		protected void Page_Load(object sender, EventArgs e)
        {
			if (!IsPostBack) 
			{ 
				
			}
			
			btnDelAll.Attributes.Add("onclick","return confirm(\"清除所有频道栏目，数据无法恢复，您确定清空吗？\")") ;
			
			mh = new MysqlHelp();
			dt = mh.GetDatabysql("Select * From Class4DeepSoon Order By Id");
			
			    
            string delID = Request.QueryString["delID"];
			string delName = Request.QueryString["delName"];
			if(delID != null && delName != null){
				Response.Write("取得删除节点信息：ID="+delID+" Name="+delName+"<br>");
				
				///递归方式，删除相关ID
				ClassTreeNode DelNd;
				DelNd.ID = ""+delID;       ///节点ID
				DelNd.Name = ""+delName;   ///节点Name
				DelNd.OutLinkHref = "";    ///节点外链OutLinkHref
				DelNd.Level = 0;           ///节点深度Level
				deleteNodes(DelNd);
			}
				
			///显示ID=?的节点+孩子节点，并设定层级初值level
			ClassTreeNode nd;
            nd.ID="0";               ///节点ID
            nd.Name="门户网";        ///节点Name
			nd.OutLinkHref = "";     ///节点外链OutLinkHref
			nd.Level=0;              ///节点Level
			showNodes(nd);
        }
		
		///显示节点+孩子节点
		private void showNodes(ClassTreeNode node)
        {
			this.showNodesFunction(node);
			this.myLabel.Text = treeStr;
			
		}
		///显示节点递归函数
		private void showNodesFunction(ClassTreeNode node)
        {			
			DataRow [] rows = dt.Select("fatherId = '"+node.ID+"'");///筛选node的孩子节点 
			foreach(DataRow dr in rows)///循环孩子节点
            {
				ClassTreeNode childNd;
				childNd.ID = dr["id"].ToString();                    ///孩子节点ID
                childNd.Name = dr["name"].ToString();                ///孩子节点Name
				childNd.OutLinkHref = dr["outLinkHref"].ToString();  ///孩子节点外链OutLinkHref
				childNd.Level = node.Level+1;                        ///孩子节点Level
				for(int i=0;i<childNd.Level;i++){
					treeStr += "&nbsp;&nbsp;&nbsp;&nbsp;";
				}
				treeStr += "<font style='color:#C0C2C1;'>&brvbar;--</font>";
				treeStr += "" + childNd.Name + " <a href='DeepSoonTreeAdd.aspx?addID="+childNd.ID+"&addName="+childNd.Name+"'>+创建子栏目</a>|<a href='DeepSoonTreeUpdate.aspx?updateID="+childNd.ID+"&updateName="+childNd.Name+"'>修改</a>|<a href='DeepSoonTree.aspx?delID="+childNd.ID+"&delName="+childNd.Name+"' onclick='return confirm(\"删除栏目后无法恢复，确定删除吗？\")'>-删除</a><br>";
				this.showNodesFunction(childNd);//递归调用自身  
            }
		}		
		
		///删除节点及其包含的子节点
		private void deleteNodes(ClassTreeNode node)
        {
			Response.Write("<font color=red>删除"+node.Name+" ID="+node.ID+" 执行SQL：Delete from tree where ID="+node.Name+"</font><br>");
			///删除node记录：
			mh.Runsql("Delete From Class4DeepSoon Where ID="+node.ID);
			///重新搜索数据表
			dt = mh.GetDatabysql("Select * From Class4DeepSoon Order By Id");
			///更新数据库的childId字段
			for(int i=0;i<dt.Rows.Count;i++){
				string opId = dt.Rows[i]["Id"].ToString();
				string oldChildId = dt.Rows[i]["childId"].ToString();
				string newChildId = oldChildId.Replace(","+node.ID, "");
				mh.Runsql("Update Class4DeepSoon Set ChildId='"+newChildId+"' Where ID="+opId);
			}
			this.deleteNodesFunction(node);
			Response.Redirect("DeepSoonTree.aspx");
		}
		///删除节点递归函数：
		private void deleteNodesFunction(ClassTreeNode node)
        {
			DataRow [] rows = dt.Select("fatherId = '"+node.ID+"'"); //筛选出属于父节点 “node”的孩子节点
            foreach(DataRow dr in rows) ///循环孩子节点
            {
                ClassTreeNode childNd;
				childNd.ID = dr["id"].ToString();                    ///孩子节点ID
                childNd.Name = dr["name"].ToString();                ///孩子节点Name
				childNd.OutLinkHref = dr["outLinkHref"].ToString();  ///孩子节点外链OutLinkHref
				childNd.Level = node.Level+1;                        ///孩子节点Level
				Response.Write("<font color=red>删除"+childNd.Name+" ID="+childNd.ID+" 执行SQL：Delete from tree where ID="+childNd.ID+"</font><br>");
				///删除nd记录：
				mh.Runsql("Delete From Class4DeepSoon Where ID="+childNd.ID);
				///重新搜索数据表
				dt = mh.GetDatabysql("Select * From Class4DeepSoon Order By Id");
				///更新数据库的childId字段
				for(int i=0;i<dt.Rows.Count;i++){
					string opId = dt.Rows[i]["Id"].ToString();
					string oldChildId = dt.Rows[i]["childId"].ToString();
					string newChildId = oldChildId.Replace(","+childNd.ID, "");
					mh.Runsql("Update Class4DeepSoon Set ChildId='"+newChildId+"' Where ID="+opId);
				}
				this.deleteNodesFunction(childNd);    ///递归调用自身
            }
		}
		
		
		protected void btnDelAll_Click(object sender, EventArgs e)
		{
			mh.Runsql("Truncate Table Class4DeepSoon");
			Response.Redirect("DeepSoonTree.aspx");
		}
    }
}