﻿using System;
using System.Text.RegularExpressions;
using System.Web;
using System.Xml;
using System.Collections;
using System.Configuration;


	/// <summary>
    /// 重写URL
    /// </summary>
    public class UrlRewriter : System.Web.IHttpModule
    {
        public void Init(HttpApplication app)
        {
            app.BeginRequest += new EventHandler(this.Application_BeginRequest);

        }

        public void Dispose() { }

        protected void Application_BeginRequest(object sender, EventArgs e)
        {
            HttpApplication http = sender as HttpApplication;//得到整个应用程序对象
			HttpContext context = http.Context;//得到请求http信息对象
			string url = context.Request.RawUrl;//得到当前的请求内容
			int start = url.LastIndexOf('/')+1;
			url = url.Substring(start).ToLower();//得到路径中的文件名
			///列表页重定向：
			Regex listReg = new Regex(@"list-(\d+)-(\d+)((.aspx||.html)*)");
			Match listMatch = listReg.Match(url);
			if (listReg.IsMatch(url))
			{
				string classID = listMatch.Groups[1].Value;
				string page = listMatch.Groups[2].Value;
				context.RewritePath("list.aspx?classID=" + classID +"&Page=" + page);
			}
			///正文页重定向：
			Regex viewReg = new Regex(@"view-(\d+)((.aspx||.html)*)");
			Match viewMatch = viewReg.Match(url);
			if (viewReg.IsMatch(url))
			{
				string ID = viewMatch.Groups[1].Value;
				context.RewritePath("view.aspx?ID=" + ID);
			}
			///反馈重定向：
			Regex feedBackReg = new Regex(@"feedback-(\d+)((.aspx||.html)*)");
			Match feedBackMatch = feedBackReg.Match(url);
			if (feedBackReg.IsMatch(url))
			{
				string Page = feedBackMatch.Groups[1].Value;
				context.RewritePath("feedBack.aspx?Page=" + Page);
			}

        }
    }  