﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using MySql.Data.MySqlClient;
using System.Web.Configuration;
using System.Text.RegularExpressions; 
using System.Text;

public class DeepSoonHelp
{
	MysqlHelp mh = null;
	string treeStr = "";
	string feedBackHtml = "";
	DataTable classDt = null;
	
	///说说初始规格
	int feedBackContentWidth = 525;
	int feedBackTextAreaWidth = 520;
	
    public DeepSoonHelp(){
        ///创建数据连接对象：
		mh = new MysqlHelp();
    }
	
	///获取首选项的urlRule配置
	public string getUrlRule(){
		string urlRule = "";
		DataTable urlRuleDt=new DataTable();
		urlRuleDt = mh.GetDatabysql("Select urlRule From Preference4DeepSoon");
		if(urlRuleDt.Rows.Count > 0){
			urlRule = urlRuleDt.Rows[0]["urlRule"].ToString();
		}
		else{
			urlRule = "endWithASPX";
		}
		return urlRule;
	}
	
	///获取模板文件代码的函数
	public string getTheme(string filePath){
		string themeHtmlStr = "";
		System.Text.Encoding code = System.Text.Encoding.GetEncoding("gb2312");
		System.IO.StreamReader reader = new System.IO.StreamReader(HttpContext.Current.Server.MapPath(filePath),code);
		themeHtmlStr = reader.ReadToEnd();
		reader.Close();
		return themeHtmlStr;
	}
	
	///获取模板内容
	public string getThemeHtml(string fileName){
		string themeHtml = "";
		DataTable themeDt = new DataTable();
		themeDt = mh.GetDatabysql("Select * From Theme4DeepSoon");
		if(themeDt.Rows.Count > 0){
			///获取首页模板代码
			themeHtml = getTheme("Theme/"+themeDt.Rows[0]["ThemeName"].ToString()+"/"+fileName);
		}
		else {
			string insertSQLStr = "insert into Theme4DeepSoon(ThemeName) Values('Default')";
			mh.Runsql(insertSQLStr);
			themeHtml = getTheme("~/Theme/Default/"+fileName);
		}
		return themeHtml;
	}
	
	///处理广告标签
	public string replaceAdTag(string themeHtml,string adPos){
		string AdContent = "";
		if( themeHtml.Contains("{dp:AdContent}") ){
			DataTable adDt=new DataTable();
			adDt = mh.GetDatabysql("Select * From AdList4DeepSoon Where AdPos = '"+adPos+"' ");
			if(adDt.Rows.Count > 0 ){
				AdContent = adDt.Rows[0]["AdContent"].ToString();
			}
			else {
				string insertIndexSQLStr = "insert into AdList4DeepSoon(AdContent,AdPos) Values('<a href=\"http://www.deepsoon.com\" target=\"_blank\"><img src=\"System_Img/indexAd.jpg\" title=\"首页左栏广告\"></a>','indexLeft')";
				mh.Runsql(insertIndexSQLStr);
				AdContent = "<a href=\"http://www.deepsoon.com\" target=\"_blank\"><img src=\"System_Img/indexAd.jpg\" title=\"首页左栏广告\"></a>";
			}
			themeHtml = themeHtml.Replace("{dp:AdContent}", AdContent);
		}
		return themeHtml;
	}
	
	///处理头版头条标签
	public string replaceHdTitleTag(string themeHtml,string urlRule){
		string hdTitlePattern = @"\{dp:hdTitle\}([\s\S]*?)\{\/dp:hdTitle\}";
		MatchCollection hdTitleMatches = Regex.Matches(themeHtml,hdTitlePattern, RegexOptions.IgnoreCase);
		foreach (Match match in hdTitleMatches){
			///获取List的行字符串样式
			string rowString = match.Groups[1].Value;
				
			///查询[首页头版头条]的文章ID：
			DataTable headTitleDt = new DataTable();
			headTitleDt = mh.GetDatabysql("Select ArticleID,TIMESTAMPDIFF(DAY,DateStr,NOW())As DiffStr,Title,Author,DateStr,BriefInfor,ReadCount,ClassID,Name From Article4DeepSoon,HeadTitle4DeepSoon,Class4DeepSoon Where HeadTitle4DeepSoon.ArticleID = Article4DeepSoon.ID and Article4DeepSoon.ClassID = Class4DeepSoon.ID");
			string HeadTitleLabel = "";
			if(headTitleDt.Rows.Count>0){
				string ArticleID = headTitleDt.Rows[0]["ArticleID"].ToString();
				string ArticleTitle = headTitleDt.Rows[0]["Title"].ToString();
				string ArticleAuthor = headTitleDt.Rows[0]["Author"].ToString();
				string ArticleDateStr = Convert.ToDateTime( headTitleDt.Rows[0]["DateStr"].ToString() ).ToString("yyyy/MM/dd");
				int ArticleDateDiffInt = Convert.ToInt32( headTitleDt.Rows[0]["DiffStr"] );
				string ArticleDateDiffStr = "";
				if(ArticleDateDiffInt < 14)ArticleDateDiffStr = (ArticleDateDiffInt+1)+" 天前";
				else ArticleDateDiffStr = ArticleDateStr;
				string ArticleBriefInfor = headTitleDt.Rows[0]["BriefInfor"].ToString();
				string ArticleReadCount = headTitleDt.Rows[0]["ReadCount"].ToString();
				string ArticleClassID = headTitleDt.Rows[0]["ClassID"].ToString();
				string ArticleClassName = headTitleDt.Rows[0]["Name"].ToString();
				string ArticleViewURL = "";
				string ArticleClassURL = "";
				switch (urlRule)
				{
					case "endWithASPX":
						ArticleViewURL = "view-"+ArticleID+".aspx";
						ArticleClassURL = "list-"+ArticleClassID+"-0.aspx";
						break;
					case "endWithHTML":
						ArticleViewURL = "view-"+ArticleID+".html";
						ArticleClassURL = "list-"+ArticleClassID+"-0.html";
						break;
					case "noPostfix":
						ArticleViewURL = "view-"+ArticleID+"";
						ArticleClassURL = "list-"+ArticleClassID+"-0";
						break;
					case "activeArgs":
						ArticleViewURL = "view.aspx?ID="+ArticleID+"";
						ArticleClassURL = "list.aspx?classID="+ArticleClassID+"";
						break;
					default:
						ArticleViewURL = "view-"+ArticleID+".aspx";
						ArticleClassURL = "list-"+ArticleClassID+"-0.aspx";
						break;
				}///end switch
			
				HeadTitleLabel += rowString.Replace("[hdTitle:Title]",ArticleTitle).Replace("[hdTitle:ID]",ArticleID).Replace("[hdTitle:viewURL]",ArticleViewURL).Replace("[hdTitle:classURL]",ArticleClassURL).Replace("[hdTitle:BriefInfor]",ArticleBriefInfor).Replace("[hdTitle:ClassID]",ArticleClassID).Replace("[hdTitle:ClassName]",ArticleClassName).Replace("[hdTitle:ReadCount]",ArticleReadCount).Replace("[hdTitle:DateDiffStr]",ArticleDateDiffStr);
			}
			else HeadTitleLabel+="<div class='errorInforTitle'>【头版头条】模块</div> <div class='errorInforContent'>抱歉！管理员还没有对任何文章进行<span class='colorFont'>[头条]</span>操作!<br>请管理员登陆后台，进入：<span class='colorFont'>[管理文章树]</span> &gt; 栏目文章<span class='colorFont'>[管理]</span>，对文章执行<span class='colorFont'>[头条]</span>操作!<br><br><br></div>";
			themeHtml = themeHtml.Replace(match.Groups[0].Value, HeadTitleLabel);
		}
		return themeHtml;
	}
	
	///处理幻灯片标签
	public string replaceImgPlayerTag(string themeHtml,string urlRule){
		string imgPlayerPattern = @"\{dp:IndexImg\}([\s\S]*?)\{\/dp:IndexImg\}";
		MatchCollection imgPlayerMatches = Regex.Matches(themeHtml,imgPlayerPattern, RegexOptions.IgnoreCase);
		foreach (Match match in imgPlayerMatches){
			///获取List的行字符串样式
			string rowString = match.Groups[1].Value;
				
			///[幻灯片]内容载体初始化：
			string ImgPlayerContent = "";
			///[幻灯片]参数初始化：
			string Title1 = "幻灯片标题一";
			string Title2 = "幻灯片标题二";
			string Title3 = "幻灯片标题三";
			string BriefInfor1 = "文摘1";
			string BriefInfor2 = "文摘2";
			string BriefInfor3 = "文摘3";
			string ImgLink1 = "#";
			string ImgLink2 = "#";
			string ImgLink3 = "#";
			string ImgSrc1 = "System_Img/defaultPic.jpg";
			string ImgSrc2 = "System_Img/defaultPic.jpg";
			string ImgSrc3 = "System_Img/defaultPic.jpg";
			///查询被推荐为[幻灯片]的文章记录：
			DataTable imgPlayerDt = new DataTable();
			imgPlayerDt = mh.GetDatabysql("Select ID,Title,BriefInfor,thumbnailImage From Article4DeepSoon Where isSetIndexPic=True and isDelete=false Order By ID DESC Limit 3");
			
			if(imgPlayerDt.Rows.Count == 3){
				if(imgPlayerDt.Rows[0] != null){
					string ID = imgPlayerDt.Rows[0]["ID"].ToString();				
					Title1 = imgPlayerDt.Rows[0]["Title"].ToString();
					if(Title1.Length>18)Title1 = Title1.Substring(0,18);
					BriefInfor1 = imgPlayerDt.Rows[0]["BriefInfor"].ToString();
					switch (urlRule)
					{
						case "endWithASPX":
							ImgLink1 = "view-"+ID+".aspx";
							break;
						case "endWithHTML":
							ImgLink1 = "view-"+ID+".html";
							break;
						case "noPostfix":
							ImgLink1 = "view-"+ID+"";
							break;
						case "activeArgs":
							ImgLink1 = "view.aspx?ID="+ID+"";
							break;
						default:
							ImgLink1 = "view-"+ID+".aspx";
							break;
					}///end switch
					ImgSrc1  = imgPlayerDt.Rows[0]["thumbnailImage"].ToString();
					if(ImgSrc1 == "")ImgSrc1 = "System_Img/defaultPic.jpg";
				}
				if(imgPlayerDt.Rows[1] != null){
					string ID = imgPlayerDt.Rows[1]["ID"].ToString();				
					Title2 = imgPlayerDt.Rows[1]["Title"].ToString();
					if(Title2.Length>18)Title2 = Title2.Substring(0,18);
					BriefInfor2 = imgPlayerDt.Rows[0]["BriefInfor"].ToString();
					switch (urlRule)
					{
						case "endWithASPX":
							ImgLink2 = "view-"+ID+".aspx";
							break;
						case "endWithHTML":
							ImgLink2 = "view-"+ID+".html";
							break;
						case "noPostfix":
							ImgLink2 = "view-"+ID+"";
							break;
						case "activeArgs":
							ImgLink2 = "view.aspx?ID="+ID+"";
							break;
						default:
							ImgLink2 = "view-"+ID+".aspx";
							break;
					}///end switch
					ImgSrc2  = imgPlayerDt.Rows[1]["thumbnailImage"].ToString();
					if(ImgSrc2 == "")ImgSrc2 = "System_Img/defaultPic.jpg";
				}
				if(imgPlayerDt.Rows[2] != null){
					string ID = imgPlayerDt.Rows[2]["ID"].ToString();				
					Title3 = imgPlayerDt.Rows[2]["Title"].ToString();
					if(Title3.Length>18)Title3 = Title3.Substring(0,18);
					BriefInfor3 = imgPlayerDt.Rows[0]["BriefInfor"].ToString();
					switch (urlRule)
					{
						case "endWithASPX":
							ImgLink3 = "view-"+ID+".aspx";
							break;
						case "endWithHTML":
							ImgLink3 = "view-"+ID+".html";
							break;
						case "noPostfix":
							ImgLink3 = "view-"+ID+"";
							break;
						case "activeArgs":
							ImgLink3 = "view.aspx?ID="+ID+"";
							break;
						default:
							ImgLink3 = "view-"+ID+".aspx";
							break;
					}///end switch
					ImgSrc3  = imgPlayerDt.Rows[2]["thumbnailImage"].ToString();
					if(ImgSrc3 == "")ImgSrc3 = "System_Img/defaultPic.jpg";
				}
				ImgPlayerContent += rowString.Replace("[IndexImg:Title1]",Title1).Replace("[IndexImg:Title2]",Title2).Replace("[IndexImg:Title3]",Title3).Replace("[IndexImg:BriefInfor1]",BriefInfor1).Replace("[IndexImg:BriefInfor2]",BriefInfor2).Replace("[IndexImg:BriefInfor3]",BriefInfor3).Replace("[IndexImg:ImgLink1]",ImgLink1).Replace("[IndexImg:ImgLink2]",ImgLink2).Replace("[IndexImg:ImgLink3]",ImgLink3).Replace("[IndexImg:ImgSrc1]",ImgSrc1).Replace("[IndexImg:ImgSrc2]",ImgSrc2).Replace("[IndexImg:ImgSrc3]",ImgSrc3);
			}
			else ImgPlayerContent += "<div id='slideshow'> <div class='errorInforTitle'>【热点图文】模块</div> <div class='errorInforContent'>抱歉！由于系统<span class='colorFont'>[幻灯]</span>的文章总数小于3 幻灯片播放器暂时不能播放.<br>请管理员登陆后台，进入：文章管理页面，增加<span class='colorFont'>[幻灯]</span>的文章数目</div> </div>";
			
			themeHtml = themeHtml.Replace(match.Groups[0].Value, ImgPlayerContent);
		}
		return themeHtml;
	}

	///处理showList文章列表标签
	public string replaceShowListTag(string themeHtml,string urlRule){
		string showListPattern = @"\{dp:showList.*rows=\'(.*?)\'.*className=\'(.*?)\'.*titleLen=\'(.*?)\'\}([\s\S]*?)\{\/dp:showList\}";
		MatchCollection showListMatches = Regex.Matches(themeHtml,showListPattern, RegexOptions.IgnoreCase);
		foreach (Match match in showListMatches){
			///列表的行数：
			string argsRows = match.Groups[1].Value;
			if(argsRows == "")argsRows = "4";
			///列表的栏目名称
			string argsClassName = match.Groups[2].Value;
			if(argsClassName == "")argsClassName = "散文";
			///列表标题字符个数：
			string argsTitleLengthStr = match.Groups[3].Value;
			if(argsTitleLengthStr == "")argsTitleLengthStr = "12";
			int argsTitleLenght = Convert.ToInt32(argsTitleLengthStr);
			///列表每行的样式字符串：
			string rowString = match.Groups[4].Value;
			
			///查询[列表模块]的所有子类集：
			DataTable ChildIdDt=new DataTable();
			ChildIdDt = mh.GetDatabysql("Select ChildID From Class4DeepSoon Where Name like '"+argsClassName+"'");
			///[列表模块]内容载体初始化：
			string ShowListContent = "";
			if(ChildIdDt.Rows.Count>0){
				string ChildIDSet = "("+ChildIdDt.Rows[0]["ChildID"].ToString()+")";
				///查询文章表中classID属于子类集中的记录：
				DataTable showListDt = new DataTable();
				showListDt = mh.GetDatabysql("Select Article4DeepSoon.ID,ClassID,Title,Name,Source,Author,DateStr,BriefInfor,thumbnailImage,ReadCount From Article4DeepSoon,Class4DeepSoon Where ClassID in "+ChildIDSet+" and isDelete=false and Article4DeepSoon.ClassID=Class4DeepSoon.ID Order By ID DESC Limit "+argsRows);
				if(showListDt.Rows.Count>0){
					for(int i = 0 ; i < showListDt.Rows.Count ; i++)
					{
						string ID = showListDt.Rows[i]["ID"].ToString();
						string DateStr = Convert.ToDateTime( showListDt.Rows[i]["DateStr"].ToString() ).ToString("yyyy/MM/dd");
						string Title = showListDt.Rows[i]["Title"].ToString();
						if(Title.Length>argsTitleLenght)Title = Title.Substring(0,argsTitleLenght);
						string ClassID = showListDt.Rows[i]["ClassID"].ToString();
						string ClassName = showListDt.Rows[i]["Name"].ToString();
						string BriefInfor = showListDt.Rows[i]["BriefInfor"].ToString();
						if(BriefInfor.Length>77)BriefInfor = BriefInfor.Substring(0,77)+"...";
						string thumbnailImage = showListDt.Rows[i]["thumbnailImage"].ToString();
						if(thumbnailImage=="")thumbnailImage = "System_Img/defaultPic.jpg";
						string ReadCount = showListDt.Rows[i]["ReadCount"].ToString();
					
						string ViewURL = "";
						string ClassURL = "";
						switch (urlRule)
						{
							case "endWithASPX":
								ViewURL = "view-"+ID+".aspx";
								ClassURL = "list-"+ClassID+"-0.aspx";
								break;
							case "endWithHTML":
								ViewURL = "view-"+ID+".html";
								ClassURL = "list-"+ClassID+"-0.html";
								break;
							case "noPostfix":
								ViewURL = "view-"+ID+"";
								ClassURL = "list-"+ClassID+"-0";
								break;
							case "activeArgs":
								ViewURL = "view.aspx?ID="+ID+"";
								ClassURL = "list.aspx?classID="+ClassID+"";
								break;
							default:
								ViewURL = "view-"+ID+".aspx";
								ClassURL = "list-"+ClassID+"-0.aspx";
								break;
						}///end switch
						
						ShowListContent += rowString.Replace("[showList:i]",""+i).Replace("[showList:ID]",ID).Replace("[showList:viewURL]",ViewURL).Replace("[showList:classURL]",ClassURL).Replace("[showList:DateStr]",DateStr).Replace("[showList:Title]",Title).Replace("[showList:ClassID]",ClassID).Replace("[showList:ClassName]",ClassName).Replace("[showList:BriefInfor]",BriefInfor).Replace("[showList:thumbnailImage]",thumbnailImage).Replace("[showList:ReadCount]",ReadCount);
					}
				}
				else ShowListContent += "<div class='errorInforContent'>抱歉！当前【"+argsClassName+"】栏目下暂时无文章。</div>";				
			}
			else ShowListContent += "<div class='errorInforContent'>抱歉！栏目<span class='colorFont'>【"+argsClassName+"】</span>不存在！请管理员进入Theme文件夹>当前使用的主题包文件夹，打开T_index.html文件，重新配置该模块的栏目名称</div>";
			themeHtml = themeHtml.Replace(match.Groups[0].Value, ShowListContent);
		}
		return themeHtml;
	}
	
	///处理最热文章标签
	public string replaceHotListTag(string themeHtml,string urlRule){
		string hotListPattern = @"\{dp:hotList.*rows=\'(.*?)\'.*titleLen=\'(.*?)\'\}([\s\S]*?)\{\/dp:hotList\}";
		MatchCollection hotListMatches = Regex.Matches(themeHtml,hotListPattern, RegexOptions.IgnoreCase);
		foreach (Match match in hotListMatches){
			///获取hotList的行数，并判断合法性
			string argsRows = match.Groups[1].Value;
			if(argsRows == "")argsRows = "6";
			///获取hotList标题字数，并判断合法性
			string argsTitleLengthStr = match.Groups[2].Value;
			if(argsTitleLengthStr == "")argsTitleLengthStr = "12";
			int argsTitleLenght = Convert.ToInt32(argsTitleLengthStr);
			///获取hotList的行字符串样式
			string rowString = match.Groups[3].Value;			
		
			string HotListContent = "";
			DataTable hotListDt = new DataTable();
			hotListDt = mh.GetDatabysql("Select Article4DeepSoon.ID,Title,DateStr,Name,ClassID,BriefInfor,ReadCount,thumbnailImage From Article4DeepSoon,Class4DeepSoon Where isDelete=false and Article4DeepSoon.ClassID=Class4DeepSoon.ID Order By (Select ReadCount)/( (Select TIMESTAMPDIFF(DAY,DateStr,NOW()))+1 )/10 DESC,ID DESC Limit "+argsRows);
			for(int i = 0 ; i < hotListDt.Rows.Count ; i++)
			{
			string newsID = hotListDt.Rows[i]["ID"].ToString();
			string newsTitle = hotListDt.Rows[i]["Title"].ToString();
			string newsClassName = hotListDt.Rows[i]["Name"].ToString();
			string newsClassID = hotListDt.Rows[i]["ClassID"].ToString();
			string newsBriefInfor = hotListDt.Rows[i]["BriefInfor"].ToString();
			string newsReadCount = hotListDt.Rows[i]["ReadCount"].ToString();
			if(newsTitle.Length>argsTitleLenght)newsTitle = newsTitle.Substring(0,argsTitleLenght);
			string newsDateStr = hotListDt.Rows[i]["DateStr"].ToString();
			string thumbnailImage = hotListDt.Rows[i]["thumbnailImage"].ToString();
			if(thumbnailImage=="")thumbnailImage = "System_Img/defaultPic.jpg";
			string newsViewURL = "";
			string newsClassURL = "";
			switch (urlRule)
			{
				case "endWithASPX":
					newsViewURL = "view-"+newsID+".aspx";
					newsClassURL = "list-"+newsClassID+"-0.aspx";
					break;
				case "endWithHTML":
					newsViewURL = "view-"+newsID+".html";
					newsClassURL = "list-"+newsClassID+"-0.html";
					break;
				case "noPostfix":
					newsViewURL = "view-"+newsID+"";
					newsClassURL = "list-"+newsClassID+"-0";
					break;
				case "activeArgs":
					newsViewURL = "view.aspx?ID="+newsID+"";
					newsClassURL = "list.aspx?classID="+newsClassID+"";
					break;
				default:
					newsViewURL = "view-"+newsID+".aspx";
					newsClassURL = "list-"+newsClassID+"-0.aspx";
					break;
			}///end switch
				
			HotListContent += rowString.Replace("[hotList:i]",""+(i+1)).Replace("[hotList:ID]",newsID).Replace("[hotList:viewURL]",newsViewURL).Replace("[hotList:classURL]",newsClassURL).Replace("[hotList:Title]",newsTitle).Replace("[hotList:ReadCount]",newsReadCount).Replace("[hotList:DateStr]",newsDateStr).Replace("[hotList:ClassID]",newsClassID).Replace("[hotList:BriefInfor]",newsBriefInfor).Replace("[hotList:ClassName]",newsClassName).Replace("[hotList:thumbnailImage]",thumbnailImage);
			}
			themeHtml = themeHtml.Replace(match.Groups[0].Value, HotListContent);
		}
		return themeHtml;
	}
	
	///处理链接标签
	public string replaceLinksTag(string themeHtml){
		string linksPattern = @"\{dp:links\}([\s\S]*)\{\/dp:links\}";
		MatchCollection linksMatches = Regex.Matches(themeHtml,linksPattern, RegexOptions.IgnoreCase);
		foreach (Match match in linksMatches){
			string rowString = match.Groups[1].Value;
			DataTable linksDt = new DataTable();
			linksDt = mh.GetDatabysql("Select * From Links4DeepSoon  Order By ID Limit 16");
			string LinksContent = "";
			for(int i = 0 ; i < linksDt.Rows.Count ; i++)
			{
				string LinkName = linksDt.Rows[i]["LinkName"].ToString();
				if(LinkName.Length>6)LinkName = LinkName.Substring(0,6);
				string LinkHref = linksDt.Rows[i]["LinkHref"].ToString();
				if(LinkHref.Length>150)LinkHref = LinkHref.Substring(0,150);
			
				LinksContent += rowString.Replace("[links:LinkName]",LinkName).Replace("[links:LinkHref]",LinkHref);
			}
			themeHtml = themeHtml.Replace(match.Groups[0].Value, LinksContent);
		}
		return themeHtml;
	}
	
	///处理list文章列表标签
	public string replaceListTag(string themeHtml,string urlRule,string classID,int articlePageCurrent){
		string listPattern = @"\{dp:list.*pageSize=\'(.*?)\'.*titleLen=\'(.*?)\'\}([\s\S]*?)\{\/dp:list\}";
		MatchCollection listMatches = Regex.Matches(themeHtml,listPattern, RegexOptions.IgnoreCase);
		foreach (Match match in listMatches){
			///获取pageSize，并判断合法性
			string argsPageSizeStr = match.Groups[1].Value;
			if(argsPageSizeStr == "")argsPageSizeStr = "6";
			int articlePageSize = Convert.ToInt32(argsPageSizeStr);
			///标题字符个数：
			string argsTitleLengthStr = match.Groups[2].Value;
			if(argsTitleLengthStr == "")argsTitleLengthStr = "12";
			int argsTitleLenght = Convert.ToInt32(argsTitleLengthStr);
			///获取List的行字符串样式
			string rowString = match.Groups[3].Value;
			
			DataTable ChildIdDt=new DataTable();
			DataTable newsDt=new DataTable();
			DataTable countDt=new DataTable();
			
			///查询[文章列表]的所有子类集：
			ChildIdDt=new DataTable();
			ChildIdDt = mh.GetDatabysql("Select ChildID From Class4DeepSoon Where ID = "+classID);
			///如果classID的菜单存在，则继续：
			if(ChildIdDt.Rows.Count>0){
				string ChildIDSet = "("+ChildIdDt.Rows[0]["ChildID"].ToString()+")";
				///查询符合条件的记录总数：
				countDt = mh.GetDatabysql("Select Count(*) As CountNum From Article4DeepSoon,Class4DeepSoon Where ClassID in "+ChildIDSet+" and isDelete=false and Article4DeepSoon.ClassID=Class4DeepSoon.ID");
				int articlePageCount = Convert.ToInt32(countDt.Rows[0]["CountNum"]);
				///计算记录总数总共可以分为多少页：
				int PageCount = articlePageCount/articlePageSize+1;
				if(articlePageCount%articlePageSize==0)PageCount = PageCount-1;
				///如果当前页码越界：
				if( articlePageCurrent < 0 )articlePageCurrent=0;
				if( articlePageCurrent > PageCount)articlePageCurrent = PageCount;
				///查询记录的起始位置：
				int articlePageStart = articlePageSize * articlePageCurrent;
			
				///如果有记录
				if(articlePageCount>0){
				///------ if Start -----
					///查询文章表中classID属于子类集中的记录：
					newsDt = mh.GetDatabysql("Select Article4DeepSoon.ID,ClassID,Title,Name,Source,Author,DateStr,BriefInfor,thumbnailImage,ReadCount From Article4DeepSoon,Class4DeepSoon Where ClassID in "+ChildIDSet+" and isDelete=false and Article4DeepSoon.ClassID=Class4DeepSoon.ID Order By Article4DeepSoon.ID DESC Limit "+articlePageStart+","+articlePageSize);
					///[文章列表]内容载体初始化：
					string ListContent = "";
					for(int i = 0 ; i < newsDt.Rows.Count ; i++)
					{
						string ID = newsDt.Rows[i]["ID"].ToString();
						string Title = newsDt.Rows[i]["Title"].ToString();
						if(Title.Length>argsTitleLenght)Title = Title.Substring(0,argsTitleLenght);
						string DateStr = Convert.ToDateTime( newsDt.Rows[i]["DateStr"].ToString() ).ToString("yyyy/MM/dd");
						string ClassID = newsDt.Rows[i]["ClassID"].ToString();
						string ClassName = newsDt.Rows[i]["Name"].ToString();
						string BriefInfor = newsDt.Rows[i]["BriefInfor"].ToString()+"...";
						BriefInfor = Regex.Replace(BriefInfor, @"\s*|\t|\r|\n", "", RegexOptions.IgnoreCase);
						BriefInfor = Regex.Replace(BriefInfor, "（", "(", RegexOptions.IgnoreCase);
						BriefInfor = Regex.Replace(BriefInfor, "）", ")", RegexOptions.IgnoreCase);		
						
						string thumbnailImage = newsDt.Rows[i]["thumbnailImage"].ToString();
						if(thumbnailImage=="")thumbnailImage = "System_Img/defaultPic.jpg";
						string ReadCount = newsDt.Rows[i]["ReadCount"].ToString();
						
						string ViewURL = "";
						string ClassURL = "";
						switch (urlRule)
						{
							case "endWithASPX":
								ViewURL = "view-"+ID+".aspx";
								ClassURL = "list-"+ClassID+"-0.aspx";
								break;
							case "endWithHTML":
								ViewURL = "view-"+ID+".html";
								ClassURL = "list-"+ClassID+"-0.html";
								break;
							case "noPostfix":
								ViewURL = "view-"+ID+"";
								ClassURL = "list-"+ClassID+"-0";
								break;
							case "activeArgs":
								ViewURL = "view.aspx?ID="+ID+"";
								ClassURL = "list.aspx?classID="+ClassID+"";
								break;
							default:
								ViewURL = "view-"+ID+".aspx";
								ClassURL = "list-"+ClassID+"-0.aspx";
								break;
						}///end switch
				
						ListContent += rowString.Replace("[list:i]",""+i).Replace("[list:viewURL]",ViewURL).Replace("[list:classURL]",ClassURL).Replace("[list:BriefInfor]",BriefInfor).Replace("[list:thumbnailImage]",thumbnailImage).Replace("[list:Title]",Title).Replace("[list:ID]",ID).Replace("[list:DateStr]",DateStr).Replace("[list:ClassName]",ClassName).Replace("[list:ClassID]",ClassID).Replace("[list:ReadCount]",ReadCount);
					}///end For
					themeHtml = themeHtml.Replace(match.Groups[0].Value, ListContent);
				}///------ if 文章存在 -----
				else {
					themeHtml = "<div class='errorBox'><img src='System_Img/cry.gif'> 对不起，该栏目下暂时无文章！</div>";
				}
				
				string PageContent = getPageStr(PageCount,classID,articlePageCurrent,urlRule);
				if( themeHtml.Contains("{dp:listPreNextButton}") ){
					themeHtml = themeHtml.Replace("{dp:listPreNextButton}", PageContent);
				}
				
			}			
		}
		return themeHtml;
	}
	
	///列表页分页
	public string getPageStr(int articlePageSum,string classID,int articlePageCurrent,string urlRule){
		string PageStr = "";
		int start = 0;
		PageStr += "<div style='padding-top:5px;padding-bottom:5px;'>";
		if(articlePageCurrent/5==0)
			start=0; 
		else start=(articlePageCurrent/5)*5-1;
  
		int end1=start+6;

		if(end1>articlePageSum)
			end1=articlePageSum;
		PageStr += "<table cellspacing=2 cellpadding=2><tr>";
		if(articlePageCurrent>0){
			switch (urlRule)
			{
				case "endWithASPX":
					PageStr += "<td class='pageBox'><a href='list-"+classID+"-0.aspx'>首页</a></td>";
					PageStr += "<td class='pageBox'><a href='list-"+classID+"-"+(articlePageCurrent-1)+".aspx'>上一页</a></td>";
					break;
				case "endWithHTML":
					PageStr += "<td class='pageBox'><a href='list-"+classID+"-0.html'>首页</a></td>";
					PageStr += "<td class='pageBox'><a href='list-"+classID+"-"+(articlePageCurrent-1)+".html'>上一页</a></td>";
					break;
				case "noPostfix":
					PageStr += "<td class='pageBox'><a href='list-"+classID+"-0'>首页</a></td>";
					PageStr += "<td class='pageBox'><a href='list-"+classID+"-"+(articlePageCurrent-1)+"'>上一页</a></td>";
					break;
				case "activeArgs":
					PageStr += "<td class='pageBox'><a href='list.aspx?classID="+classID+"'>首页</a></td>";
					PageStr += "<td class='pageBox'><a href='list.aspx?classID="+classID+"&page="+(articlePageCurrent-1)+"'>上一页</a></td>";
					break;
				default:
					PageStr += "<td class='pageBox'><a href='list-"+classID+"-0.aspx'>首页</a></td>";
					PageStr += "<td class='pageBox'><a href='list-"+classID+"-"+(articlePageCurrent-1)+".aspx'>上一页</a></td>";
					break;
			}///end switch
			///PageStr += "<td class='pageBox'><a href='list.aspx?classID="+classID+"'>首页</a></td>";
			///PageStr += "<td class='pageBox'><a href='list.aspx?classID="+classID+"&page="+(articlePageCurrent-1)+"'>上一页</a></td>";
		}
		if(end1>1){
			for(int i=start;i<end1;i++){
				if(i==articlePageCurrent)
					PageStr +="<td class='FocuspageBox'>"+(i+1)+"</td>";
				else {
					switch (urlRule)
					{
					case "endWithASPX":
						PageStr += "<td class='pageBox'><a href='list-"+classID+"-"+i+".aspx'>"+(i+1)+"</a></td>";
						break;
					case "endWithHTML":
						PageStr += "<td class='pageBox'><a href='list-"+classID+"-"+i+".html'>"+(i+1)+"</a></td>";
						break;
					case "noPostfix":
						PageStr += "<td class='pageBox'><a href='list-"+classID+"-"+i+"'>"+(i+1)+"</a></td>";
						break;
					case "activeArgs":
						PageStr += "<td class='pageBox'><a href='list.aspx?classID="+classID+"&page="+i+"'>"+(i+1)+"</a></td>";
						break;
					default:
						PageStr += "<td class='pageBox'><a href='list-"+classID+"-"+i+".aspx'>"+(i+1)+"</a></td>";
						break;
					}///end switch
					///PageStr += "<td class='pageBox'><a href='list.aspx?classID="+classID+"&page="+i+"'>"+(i+1)+"</a></td>";
				}
			}
			if(articlePageCurrent<articlePageSum-1){
				switch (urlRule)
				{
				case "endWithASPX":
					PageStr += "<td class='pageBox'><a href='list-"+classID+"-"+(articlePageCurrent+1)+".aspx'>下一页</a></td>";
					PageStr += "<td class='pageBox'><a href='list-"+classID+"-"+(articlePageSum-1)+".aspx'>末页</a></td>";
					break;
				case "endWithHTML":
					PageStr += "<td class='pageBox'><a href='list-"+classID+"-"+(articlePageCurrent+1)+".html'>下一页</a></td>";
					PageStr += "<td class='pageBox'><a href='list-"+classID+"-"+(articlePageSum-1)+".html'>末页</a></td>";
					break;
				case "noPostfix":
					PageStr += "<td class='pageBox'><a href='list-"+classID+"-"+(articlePageCurrent+1)+"'>下一页</a></td>";
					PageStr += "<td class='pageBox'><a href='list-"+classID+"-"+(articlePageSum-1)+"'>末页</a></td>";
					break;
				case "activeArgs":
					PageStr += "<td class='pageBox'><a href='list.aspx?classID="+classID+"&page="+(articlePageCurrent+1)+"'>下一页</a></td>";
					PageStr += "<td class='pageBox'><a href='list.aspx?classID="+classID+"&page="+(articlePageSum-1)+"'>末页</a></td>";
					break;
				default:
					PageStr += "<td class='pageBox'><a href='list-"+classID+"-"+(articlePageCurrent+1)+".aspx'>下一页</a></td>";
					PageStr += "<td class='pageBox'><a href='list-"+classID+"-"+(articlePageSum-1)+".aspx'>末页</a></td>";
					break;
				}///end switch
				///PageStr += "<td class='pageBox'><a href='list.aspx?classID="+classID+"&page="+(articlePageCurrent+1)+"'>下一页</a></td>";
				///PageStr += "<td class='pageBox'><a href='list.aspx?classID="+classID+"&page="+(articlePageSum-1)+"'>末页</a></td>";
			}
			PageStr += "<td class='pageBox'>第"+(articlePageCurrent+1)+"页/共"+articlePageSum+"页</td>";
		}
		PageStr += "</tr></table></div>";
		return PageStr;
   }
	
	///处理最新发布标签
	public string replaceNewListTag(string themeHtml,string urlRule){
		string newListPattern = @"\{dp:newList.*rows=\'(.*?)\'.*titleLen=\'(.*?)\'\}([\s\S]*?)\{\/dp:newList\}";
		MatchCollection newListMatches = Regex.Matches(themeHtml,newListPattern, RegexOptions.IgnoreCase);
		foreach (Match match in newListMatches){
			///获取hotList的行数，并判断合法性
			string argsRows = match.Groups[1].Value;
			if(argsRows == "")argsRows = "6";
			///获取hotList标题字数，并判断合法性
			string argsTitleLengthStr = match.Groups[2].Value;
			if(argsTitleLengthStr == "")argsTitleLengthStr = "12";
			int argsTitleLenght = Convert.ToInt32(argsTitleLengthStr);
			///获取hotList的行字符串样式
			string rowString = match.Groups[3].Value;			
			
			string NewListContent = "";
			DataTable newListDt=new DataTable();
			newListDt = mh.GetDatabysql("Select Article4DeepSoon.ID,Title,DateStr,Name,ClassID,ReadCount,thumbnailImage,BriefInfor From Article4DeepSoon,Class4DeepSoon Where isDelete=false and Article4DeepSoon.ClassID=Class4DeepSoon.ID Order By ID DESC Limit "+argsRows);
			for(int i = 0 ; i < newListDt.Rows.Count ; i++)
			{
			string newsID = newListDt.Rows[i]["ID"].ToString();
			string newsTitle = newListDt.Rows[i]["Title"].ToString();
			string newsClassName = newListDt.Rows[i]["Name"].ToString();
			string newsClassID = newListDt.Rows[i]["ClassID"].ToString();
			string newsReadCount = newListDt.Rows[i]["ReadCount"].ToString();
			if(newsTitle.Length>argsTitleLenght)newsTitle = newsTitle.Substring(0,argsTitleLenght);
			string newsDateStr = newListDt.Rows[i]["DateStr"].ToString();
			string thumbnailImage = newListDt.Rows[i]["thumbnailImage"].ToString();
			if(thumbnailImage=="")thumbnailImage = "System_Img/defaultPic.jpg";
			string BriefInfor = newListDt.Rows[i]["BriefInfor"].ToString();
			if(BriefInfor.Length>80)BriefInfor = BriefInfor.Substring(0,80);
			string newsViewURL = "";
			string newsClassURL = "";
			switch (urlRule)
			{
				case "endWithASPX":
					newsViewURL = "view-"+newsID+".aspx";
					newsClassURL = "list-"+newsClassID+"-0.aspx";
					break;
				case "endWithHTML":
					newsViewURL = "view-"+newsID+".html";
					newsClassURL = "list-"+newsClassID+"-0.html";
					break;
				case "noPostfix":
					newsViewURL = "view-"+newsID+"";
					newsClassURL = "list-"+newsClassID+"-0";
					break;
				case "activeArgs":
					newsViewURL = "view.aspx?ID="+newsID+"";
					newsClassURL = "list.aspx?classID="+newsClassID+"";
					break;
				default:
					newsViewURL = "view-"+newsID+".aspx";
					newsClassURL = "list-"+newsClassID+"-0.aspx";
					break;
			}///end switch
			
			NewListContent += rowString.Replace("[newList:i]",""+(i+1)).Replace("[newList:BriefInfor]",BriefInfor).Replace("[newList:ID]",newsID).Replace("[newList:viewURL]",newsViewURL).Replace("[newList:classURL]",newsClassURL).Replace("[newList:Title]",newsTitle).Replace("[newList:ReadCount]",newsReadCount).Replace("[newList:DateStr]",newsDateStr).Replace("[newList:ClassID]",newsClassID).Replace("[newList:ClassName]",newsClassName).Replace("[newList:thumbnailImage]",thumbnailImage);
			}
			themeHtml = themeHtml.Replace(match.Groups[0].Value, NewListContent);
		}
		return themeHtml;
	}
	
	///处理随机文章标签
	public string replaceRandListTag(string themeHtml,string urlRule){
		string randListPattern = @"\{dp:randList.*rows=\'(.*?)\'.*titleLen=\'(.*?)\'\}([\s\S]*?)\{\/dp:randList\}";
		MatchCollection randListMatches = Regex.Matches(themeHtml,randListPattern, RegexOptions.IgnoreCase);
		foreach (Match match in randListMatches){
			///获取hotList的行数，并判断合法性
			string argsRows = match.Groups[1].Value;
			if(argsRows == "")argsRows = "6";
			///获取hotList标题字数，并判断合法性
			string argsTitleLengthStr = match.Groups[2].Value;
			if(argsTitleLengthStr == "")argsTitleLengthStr = "12";
			int argsTitleLenght = Convert.ToInt32(argsTitleLengthStr);
			///获取hotList的行字符串样式
			string rowString = match.Groups[3].Value;			
			
			///获取随机文章ID，存储在变量randIDSet里
			DataTable randDt=new DataTable();
			randDt = mh.GetDatabysql("Select ID From Article4DeepSoon Order By rand() Limit "+argsRows);
			string randIDSet = "(";
			for(int i = 0 ; i < randDt.Rows.Count ; i++)
			{
				randIDSet += randDt.Rows[i]["ID"].ToString()+ ",";
			}
			randIDSet = randIDSet.Substring(0,randIDSet.Length - 1) + ")"; 
			
			string RandListContent = "";
			DataTable randListDt=new DataTable();
			randListDt = mh.GetDatabysql("Select Article4DeepSoon.ID,Title,DateStr,Name,ClassID,ReadCount,thumbnailImage,BriefInfor From Article4DeepSoon,Class4DeepSoon Where isDelete=false and Article4DeepSoon.ClassID=Class4DeepSoon.ID and Article4DeepSoon.ID In "+randIDSet);
			for(int i = 0 ; i < randListDt.Rows.Count ; i++)
			{
			string newsID = randListDt.Rows[i]["ID"].ToString();
			string newsTitle = randListDt.Rows[i]["Title"].ToString();
			string newsClassName = randListDt.Rows[i]["Name"].ToString();
			string newsClassID = randListDt.Rows[i]["ClassID"].ToString();
			string newsReadCount = randListDt.Rows[i]["ReadCount"].ToString();
			if(newsTitle.Length>argsTitleLenght)newsTitle = newsTitle.Substring(0,argsTitleLenght);
			string newsDateStr = randListDt.Rows[i]["DateStr"].ToString();
			string thumbnailImage = randListDt.Rows[i]["thumbnailImage"].ToString();
			if(thumbnailImage=="")thumbnailImage = "System_Img/defaultPic.jpg";
			string BriefInfor = randListDt.Rows[i]["BriefInfor"].ToString();
			if(BriefInfor.Length>100)BriefInfor = BriefInfor.Substring(0,100);
			string newsViewURL = "";
			string newsClassURL = "";
			switch (urlRule)
			{
				case "endWithASPX":
					newsViewURL = "view-"+newsID+".aspx";
					newsClassURL = "list-"+newsClassID+"-0.aspx";
					break;
				case "endWithHTML":
					newsViewURL = "view-"+newsID+".html";
					newsClassURL = "list-"+newsClassID+"-0.html";
					break;
				case "noPostfix":
					newsViewURL = "view-"+newsID+"";
					newsClassURL = "list-"+newsClassID+"-0";
					break;
				case "activeArgs":
					newsViewURL = "view.aspx?ID="+newsID+"";
					newsClassURL = "list.aspx?classID="+newsClassID+"";
					break;
				default:
					newsViewURL = "view-"+newsID+".aspx";
					newsClassURL = "list-"+newsClassID+"-0.aspx";
					break;
			}///end switch
			
			RandListContent += rowString.Replace("[randList:i]",""+(i+1)).Replace("[randList:BriefInfor]",BriefInfor).Replace("[randList:ID]",newsID).Replace("[randList:viewURL]",newsViewURL).Replace("[randList:classURL]",newsClassURL).Replace("[randList:Title]",newsTitle).Replace("[randList:ReadCount]",newsReadCount).Replace("[randList:DateStr]",newsDateStr).Replace("[randList:ClassID]",newsClassID).Replace("[randList:ClassName]",newsClassName).Replace("[randList:thumbnailImage]",thumbnailImage);
			}
			themeHtml = themeHtml.Replace(match.Groups[0].Value, RandListContent);
		}
		return themeHtml;
	}
	
	/// 判断输入的是否是数字 
	public bool IsNumberic(string oText){ 
		try 
		{ 
			int var1=Convert.ToInt32 (oText); 
			return true; 
		} 
		catch 
		{ 
			return false; 
		} 
	}
	
	///获取合法的数字字符串
	public string getValidateNumStr(string strNum){
		if( strNum != null && strNum.Length>999999999 )strNum = strNum.Substring(0,999999999);
		if( strNum == null )strNum = "0";
		if( !IsNumberic(strNum) )strNum = "0"; 	
		return strNum;
	}
	
	///获取分页后的文章正文
	public string getPageArticle(string article,string ID,int page){
		string articleStr = "";
		int articleLength = article.Length;
		int pos = 0;
		int i = 0;
		for(i=0;i<articleLength;i++){
			articleLength = article.Length;
			pos = article.IndexOf("&lt;-分页符-&gt;",0);
			if(pos != -1){
				if(i == page){
					articleStr = article.Substring(0,pos);
					///articleLength=0;
				}
				article=article.Remove(0,pos+13);
			}
			else{
				if(i == page){
					articleStr = article;
				}
				articleLength=0;
			}
		}
		string PageStr = "";
		if(i-1>0){
			PageStr += "<center><table cellspacing=2 cellpadding=2 style='line-height:16px;'><tr>";
		
			if(page>0){
				PageStr += "<td class='pageBox'><a href='view.aspx?ID="+ID+"'>首页</a></td>";
				PageStr += "<td class='pageBox'><a href='view.aspx?ID="+ID+"&Page="+(page-1)+"'>上一页</a></td>";
			}
			for(int j=0;j<i;j++){
				if(j != page){
					PageStr += "<td class='pageBox'><a href='view.aspx?ID="+ID+"&Page="+j+"'>"+(j+1)+"</a></td>";
				}
				else {
					PageStr += "<td class='FocuspageBox'>"+(j+1)+"</td>";
				}
			}
			if(page<i-1){
				PageStr += "<td class='pageBox'><a href='view.aspx?ID="+ID+"&Page="+(page+1)+"'>下一页</a></td>";
				PageStr += "<td class='pageBox'><a href='view.aspx?ID="+ID+"&Page="+(i-1)+"'>末页</a></td>";
			}
			PageStr += "<td class='pageBox'>第"+(page+1)+"页/共"+(i)+"页</td>";
			PageStr += "</tr></table></center>";
		}
		articleStr += PageStr;
		return articleStr;
	}
	
	///处理上一篇文章标签
	public string replacePreArticleTag(string themeHtml,string urlRule,string ID){
		string preArticlePattern = @"\{dp:preArticle.*titleLen=\'(.*?)\'\}([\s\S]*?)\{\/dp:preArticle\}";
		MatchCollection preArticleMatches = Regex.Matches(themeHtml,preArticlePattern, RegexOptions.IgnoreCase);
		foreach (Match match in preArticleMatches){
			///获取标题字数，并判断合法性
			string argsTitleLengthStr = match.Groups[1].Value;
			if(argsTitleLengthStr == "")argsTitleLengthStr = "12";
			int argsTitleLenght = Convert.ToInt32(argsTitleLengthStr);
			
			string preContent = "";
			DataTable dt=new DataTable();
			dt = mh.GetDatabysql("Select Id,Title From Article4Deepsoon Where Id < "+ID+" and ClassID in(Select ClassID From Article4Deepsoon Where ID = "+ID+") and isDelete=false Order By Id Desc Limit 1");
			if(dt.Rows.Count > 0 ){
				string preID = dt.Rows[0]["ID"].ToString();
				string preTitle = dt.Rows[0]["Title"].ToString();
				if(preTitle.Length > argsTitleLenght)preTitle = preTitle.Substring(0,argsTitleLenght);
				switch (urlRule)
				{
					case "endWithASPX":
						preContent = "<a href='view-"+preID+".aspx'>"+preTitle+"</a>";
						break;
					case "endWithHTML":
						preContent = "<a href='view-"+preID+".html'>"+preTitle+"</a>";
						break;
					case "noPostfix":
						preContent = "<a href='view-"+preID+"'>"+preTitle+"</a>";
						break;
					case "activeArgs":
						preContent = "<a href='view.aspx?ID="+preID+"'>"+preTitle+"</a>";
						break;
					default:
						preContent = "<a href='view-"+preID+".aspx'>"+preTitle+"</a>";
						break;
				}///end switch
				///preContent = "<a href='view.aspx?ID="+preID+"'>"+preTitle+"</a>";
			}
			else {
				preContent = "已经是最前一篇文章了";
			}
			themeHtml = themeHtml.Replace(match.Groups[0].Value, preContent);
		}
		return themeHtml;
	}
	///处理下一篇文章标签
	public string replaceNextArticleTag(string themeHtml,string urlRule,string ID){
		string nextArticlePattern = @"\{dp:nextArticle.*titleLen=\'(.*?)\'\}([\s\S]*?)\{\/dp:nextArticle\}";
		MatchCollection nextArticleMatches = Regex.Matches(themeHtml,nextArticlePattern, RegexOptions.IgnoreCase);
		foreach (Match match in nextArticleMatches){
			///获取标题字数，并判断合法性
			string argsTitleLengthStr = match.Groups[1].Value;
			if(argsTitleLengthStr == "")argsTitleLengthStr = "12";
			int argsTitleLenght = Convert.ToInt32(argsTitleLengthStr);
			
			string nextContent = "";
			DataTable dt=new DataTable();
			dt = mh.GetDatabysql("Select Id,Title From Article4Deepsoon Where Id > "+ID+" and ClassID in(Select ClassID From Article4Deepsoon Where ID = "+ID+") and isDelete=false Order By Id ASC Limit 1");
			if(dt.Rows.Count > 0 ){
				string nextID = dt.Rows[0]["ID"].ToString();
				string nextTitle = dt.Rows[0]["Title"].ToString();
				if(nextTitle.Length > argsTitleLenght)nextTitle = nextTitle.Substring(0,argsTitleLenght);
				switch (urlRule)
				{
					case "endWithASPX":
						nextContent = "<a href='view-"+nextID+".aspx'>"+nextTitle+"</a>";
						break;
					case "endWithHTML":
						nextContent = "<a href='view-"+nextID+".html'>"+nextTitle+"</a>";
						break;
					case "noPostfix":
						nextContent = "<a href='view-"+nextID+"'>"+nextTitle+"</a>";
						break;
					case "activeArgs":
						nextContent = "<a href='view.aspx?ID="+nextID+"'>"+nextTitle+"</a>";
						break;
					default:
						nextContent = "<a href='view-"+nextID+".aspx'>"+nextTitle+"</a>";
						break;
				}///end switch
				///nextContent = "<a href='view.aspx?ID="+nextID+"'>"+nextTitle+"</a>";
			}
			else {
				nextContent = "已经是最后一篇文章了";
			}
			themeHtml = themeHtml.Replace(match.Groups[0].Value, nextContent);
		}
		return themeHtml;
	}
	
	///处理正文标签
	public string replaceViewTag(string themeHtml,string urlRule,string ID,int Page){
		string viewPattern = @"\{dp:view\}([\s\S]*?)\{\/dp:view\}";
		MatchCollection viewMatches = Regex.Matches(themeHtml,viewPattern, RegexOptions.IgnoreCase);
		foreach (Match match in viewMatches){
			string Title = "文章标题";
			string Author = "地平线";
			string DateStr = DateTime.Now.ToString("yyyy-MM-dd");
			string ClassID = "1";
			string ClassName = "栏目分类";
			string Article = "正文";
			string ReadCount = "0";
			string Source = "地平线";
			DataTable dt=new DataTable();
			dt = mh.GetDatabysql("Select Title,Author,DateStr,ClassID,Name,Article,ReadCount,Source From Article4DeepSoon,Class4DeepSoon Where Article4DeepSoon.ID = " + ID +" and isDelete=false and Article4DeepSoon.ClassID=Class4DeepSoon.ID");
			if(dt.Rows.Count>0)
			{
				Title = dt.Rows[0]["Title"].ToString();
				Author = dt.Rows[0]["Author"].ToString();
				DateStr = dt.Rows[0]["DateStr"].ToString();
				ClassID = dt.Rows[0]["ClassID"].ToString();
				ClassName = dt.Rows[0]["Name"].ToString();
				Article = dt.Rows[0]["Article"].ToString();
				Article = getPageArticle(Article,ID,Page);
				ReadCount = dt.Rows[0]["ReadCount"].ToString();
				Source = dt.Rows[0]["Source"].ToString();
				
				string ViewURL = "";
				string ClassURL = "";
				switch (urlRule)
				{
					case "endWithASPX":
						ViewURL = "view-"+ID+".aspx";
						ClassURL = "list-"+ClassID+"-0.aspx";
						break;
					case "endWithHTML":
						ViewURL = "view-"+ID+".html";
						ClassURL = "list-"+ClassID+"-0.html";
						break;
					case "noPostfix":
						ViewURL = "view-"+ID+"";
						ClassURL = "list-"+ClassID+"-0";
						break;
					case "activeArgs":
						ViewURL = "view.aspx?ID="+ID+"";
						ClassURL = "list.aspx?classID="+ClassID+"";
						break;
					default:
						ViewURL = "view-"+ID+".aspx";
						ClassURL = "list-"+ClassID+"-0.aspx";
						break;
				}///end switch	
				
				///更新文章的点击量
				int newReadCount = Convert.ToInt32(ReadCount) +1;
				mh.Runsql("Update Article4DeepSoon Set ReadCount = " + newReadCount + " Where ID = "+ID);

				themeHtml = themeHtml.Replace("{dp:view}", "");
				themeHtml = themeHtml.Replace("[view:Title]", Title);
				themeHtml = themeHtml.Replace("[view:DateStr]", DateStr);			
				themeHtml = themeHtml.Replace("[view:ClassID]", ClassID);
				themeHtml = themeHtml.Replace("[view:ClassName]", ClassName);
				themeHtml = themeHtml.Replace("[view:ReadCount]", ReadCount);
				themeHtml = themeHtml.Replace("[view:Author]", Author);
				themeHtml = themeHtml.Replace("[view:Article]", Article);
				themeHtml = themeHtml.Replace("[view:Source]", Source);
				themeHtml = themeHtml.Replace("[view:viewURL]", ViewURL);
				themeHtml = themeHtml.Replace("[view:classURL]", ClassURL);
				themeHtml = themeHtml.Replace("{/dp:view}", "");
			}			
			else {
				themeHtml = "<div class='errorBox'><img src='System_Img/cry.gif'> 文章已删除或者不存在！</div>";
			}
		}
		return themeHtml;
	}
	
	///获取正文标题
	public string getViewTitle(string ID){
		string title="文章标题";
		DataTable dt=new DataTable();
		dt = mh.GetDatabysql("Select Title From Article4DeepSoon Where ID = " + ID +" and isDelete=false");
		if(dt.Rows.Count>0)
		{
			title = dt.Rows[0]["Title"].ToString();
		}
		return title;
	}
	
	///获取CSS样式表
	public string getThemeCSS(){
		string ThemeCSS="";
		DataTable themeDt = new DataTable();
		themeDt = mh.GetDatabysql("Select * From Theme4DeepSoon");
		if(themeDt.Rows.Count > 0){
			ThemeCSS = "Theme/"+themeDt.Rows[0]["ThemeName"].ToString()+"/style.css";
		}
		else {
			ThemeCSS = "./Theme/Default/style.css";
		}
		return ThemeCSS;
	}
		
	///获取网站信息SiteInfor
	public SiteInfor getSiteInfor(){
		SiteInfor si = new SiteInfor();
		DataTable dt=new DataTable();
		dt = mh.GetDatabysql("Select * From Preference4DeepSoon");
		if(dt.Rows.Count > 0){
			si.siteName = dt.Rows[0]["siteName"].ToString();
			si.siteTitle = dt.Rows[0]["siteTitle"].ToString();
			si.siteKeywords = dt.Rows[0]["siteKeywords"].ToString();
			si.siteDescribe = dt.Rows[0]["siteDescribe"].ToString();			
			si.siteLogoAddr = dt.Rows[0]["siteLogoAddr"].ToString();
			si.urlRule = dt.Rows[0]["urlRule"].ToString();
			si.siteCopyRight = dt.Rows[0]["siteCopyRight"].ToString();
		}
		else {
			string insertSQLStr = "insert into Preference4DeepSoon(siteName,siteTitle,siteKeywords,siteDescribe,siteMain,siteLogoAddr,htmlDir,uploadFileDir,siteCopyRight,WatermarkLogo,urlRule) Values ('"+si.siteName+"','"+si.siteTitle+"','"+si.siteKeywords+"','"+si.siteDescribe+"','www.DeepSoon.com','System_Img/logo.png','/Html/','/uploadFile/','"+si.siteTitle+" | 版权所有&bull;侵权必究','/System_Img/WatermarkLogo.png','endWithASPX')";
			mh.Runsql(insertSQLStr);
			si.siteName = "地平线";
			si.siteTitle = "地平线官网";
			si.siteKeywords = "地平线，asp.net,门户网，论坛，开源，社区";
			si.siteDescribe = "地平线门户网是用ASP.Net+MySQL技术开发的一个开源产品，利用该软件您可以轻易的订制自己的博客，新闻系统。";			
			si.siteLogoAddr = "System_Img/logo.png";
			si.urlRule = "endWithASPX";
			si.siteCopyRight = "地平线官网 | 版权所有&bull;侵权必究";
		}
		return si;
	}
	
	///显示节点递归函数
	private void listNodesFunction(string classID,ClassTreeNode node,string urlRule){			
		DataRow [] rows = classDt.Select("fatherId = '"+node.ID+"'"); ///筛选node的孩子节点
		if(rows.Length > 0 && node.Level > 0){
			treeStr +=	"<ul class='in'>";
		}
			
		///根据不同的url规则，生成菜单链接地址
		string treeItemStr = "";
			
		foreach(DataRow dr in rows) ///循环孩子节点
        {
			ClassTreeNode childNd = new ClassTreeNode();
			childNd.ID = dr["id"].ToString();                    ///孩子节点ID
            childNd.Name = dr["name"].ToString();                ///孩子节点Name
			childNd.OutLinkHref = dr["outLinkHref"].ToString();  ///孩子节点外链OutLinkHref
			childNd.Level = node.Level+1;                        ///孩子节点Level
			childNd.isHidden = dr["isHidden"].ToString();        ///孩子节点隐藏状态isHidden
			childNd.linkTarget = dr["linkTarget"].ToString();    ///孩子节点打开方式linkTarget
			///if(childNd.isHidden == "False"){
				if(childNd.OutLinkHref != "")
					treeStr += "<li><a href='"+childNd.OutLinkHref+"' target='" + childNd.linkTarget + "'><span class='line'>" + childNd.Name +"</span></a>";
				else{
					if(classID != childNd.ID){
						switch (urlRule)
						{
						case "endWithASPX":
							treeItemStr = "<li><a href='list-"+childNd.ID+"-0.aspx' target='" + childNd.linkTarget + "'><span class='line'>" + childNd.Name +"</span></a>";
							break;
						case "endWithHTML":
							treeItemStr = "<li><a href='list-"+childNd.ID+"-0.html' target='" + childNd.linkTarget + "'><span class='line'>" + childNd.Name +"</span></a>";
							break;
						case "noPostfix":
							treeItemStr = "<li><a href='list-"+childNd.ID+"-0' target='" + childNd.linkTarget + "'><span class='line'>" + childNd.Name +"</span></a>";;
							break;
						case "activeArgs":
							treeItemStr = "<li><a href='list.aspx?classID="+childNd.ID+"' target='" + childNd.linkTarget + "'><span class='line'>" + childNd.Name +"</span></a>";
							break;
						default:
							treeItemStr = "<li><a href='list-"+childNd.ID+"-0.aspx' target='" + childNd.linkTarget + "'><span class='line'>" + childNd.Name +"</span></a>";
							break;
						}///end switch
					}
					else{
						switch (urlRule)
						{
						case "endWithASPX":
							treeItemStr = "<li class='current'><a href='list-"+childNd.ID+"-0.aspx' target='" + childNd.linkTarget + "'><span class='line'>" + childNd.Name +"</span></a>";
							break;
						case "endWithHTML":
							treeItemStr = "<li class='current'><a href='list-"+childNd.ID+"-0.html' target='" + childNd.linkTarget + "'><span class='line'>" + childNd.Name +"</span></a>";
							break;
						case "noPostfix":
							treeItemStr = "<li class='current'><a href='list-"+childNd.ID+"-0' target='" + childNd.linkTarget + "'><span class='line'>" + childNd.Name +"</span></a>";;
							break;
						case "activeArgs":
							treeItemStr = "<li class='current'><a href='list.aspx?classID="+childNd.ID+"' target='" + childNd.linkTarget + "'><span class='line'>" + childNd.Name +"</span></a>";
							break;
						default:
							treeItemStr = "<li class='current'><a href='list-"+childNd.ID+"-0.aspx' target='" + childNd.linkTarget + "'><span class='line'>" + childNd.Name +"</span></a>";
							break;
						}///end switch
					}
					treeStr += treeItemStr;
				}///end else
				this.listNodesFunction(classID,childNd,urlRule);   ///递归调用自身
				treeStr +=	"</li>";
			}///end if	
           ///}
		if(rows.Length > 0 && node.Level > 0)
				treeStr +=	"</ul>";
	}
		
	///获取菜单栏数据
	public string getClassTreeStr(string classID,string urlRule){
		if(classID != "0"){
			treeStr = "<ul id='main-menu' class='sm sm-blue'><li><a href='index.aspx'><span class='line'>首页</span></a></li>";
		}
		else{
			treeStr = "<ul id='main-menu' class='sm sm-blue'><li class='current'><a href='index.aspx'><span class='line'>首页</span></a></li>";
		}
		classDt = new DataTable();
		classDt= mh.GetDatabysql("Select * From Class4DeepSoon Where isHidden = False Order By Id");
		///显示ID=?的节点+孩子节点，并设定层级初值level
		ClassTreeNode nd = new ClassTreeNode();
        listNodesFunction(classID,nd,urlRule);
		treeStr +=	"</ul>";
		return treeStr;
	}
	
	///获取反馈表配置信息：
	public FeedBackInfor getFeedBackInfor(){
		FeedBackInfor fi = new FeedBackInfor();
		DataTable settingDt=new DataTable();
		settingDt = mh.GetDatabysql("Select * From FeedBackSetting4DeepSoon");
		if(settingDt.Rows.Count > 0){
			fi.setTitle = settingDt.Rows[0]["setTitle"].ToString();
			fi.setContent = settingDt.Rows[0]["setContent"].ToString();
			fi.setButtonName = settingDt.Rows[0]["setButtonName"].ToString();
			fi.setOpen = (bool)settingDt.Rows[0]["setOpen"];
			fi.setPass = (bool)settingDt.Rows[0]["setPass"];
			fi.setSize = Convert.ToInt32(settingDt.Rows[0]["setSize"]);
		}
		return fi;
	}
	
	///统计反馈记录总数
	public string countFeedBack(){
		DataTable feedBackCountDt=new DataTable();
		string feedBackCountSQL = "Select Count(ID) As CountNum From FeedBack4DeepSoon";
		feedBackCountDt = mh.GetDatabysql(feedBackCountSQL);
		string feedBackCountSum = feedBackCountDt.Rows[0]["CountNum"].ToString();
		return feedBackCountSum;
	}
	
	///统计符合条件的反馈记录总数
	public int getSumFeedBack(FeedBackInfor fi){
		DataTable countDt=new DataTable();
		string feedBackSQL = "";
		if(fi.setPass){
			feedBackSQL = "Select Count(ID) As CountNum From FeedBack4DeepSoon Where FatherID='0' and isPass=true";
		}
		else{
			feedBackSQL = "Select Count(ID) As CountNum From FeedBack4DeepSoon Where FatherID='0'";
		}
		countDt = mh.GetDatabysql(feedBackSQL);
		int articlePageCount = Convert.ToInt32(countDt.Rows[0]["CountNum"]);
		return articlePageCount;
	}
	
	///显示节点递归函数
	private void showChildNodes(FeedBackInfor fi,FeedBackNode node)
    {	
		string childSQL = "";
		if(fi.setPass){
			childSQL = "Select * From FeedBack4DeepSoon Where FatherID='"+node.ID+"' and isPass=true Order By Id DESC Limit 4";
		}
		else{
			childSQL = "Select * From FeedBack4DeepSoon Where FatherID='"+node.ID+"' Order By Id DESC Limit 4";
		}
		DataTable childDT = mh.GetDatabysql(childSQL);
		for(int i = 0 ; i < childDT.Rows.Count ; i++)
		{
			FeedBackNode childNd = new FeedBackNode();
			childNd.ID = childDT.Rows[i]["id"].ToString();                    ///孩子节点ID
            childNd.Content = childDT.Rows[i]["Content"].ToString();      ///孩子节点Content
			childNd.Author = childDT.Rows[i]["Author"].ToString();  		///孩子节点Author
			childNd.DateStr = childDT.Rows[i]["DateStr"].ToString();        ///孩子节点Date
			childNd.IPAddress = childDT.Rows[i]["IPAddress"].ToString();      ///孩子节点IP
			childNd.Level = node.Level+1;                        ///孩子节点Level
			///计算当前说说规格
			int childNdFeedBackContentWidth = feedBackContentWidth-childNd.Level*55;
			int childNdFeedBackTextAreaWidth = feedBackTextAreaWidth-childNd.Level*55;
			if(childNd.Level>4){
				childNdFeedBackContentWidth = childNdFeedBackContentWidth = feedBackContentWidth-220;
				childNdFeedBackTextAreaWidth = feedBackTextAreaWidth-220;
			}
			
			///节点回复数
			DataTable childNdFeedBackCountDt=new DataTable();
			childNdFeedBackCountDt = mh.GetDatabysql("Select Count(ID) As childNdFeedBackCount From FeedBack4DeepSoon Where FatherID = '"+childNd.ID+"'");
			string childNdFeedBackCount = childNdFeedBackCountDt.Rows[0]["childNdFeedBackCount"].ToString();
			
			feedBackHtml += "<div class='feedBackBox'>";
				feedBackHtml += "<div class='feedBackLogo'>";
					feedBackHtml += "<img src='/System_Img/feedBackLogoSmall.png''>";
				feedBackHtml += "</div>";
			
				feedBackHtml += "<div class='feedBackContent' style='width:"+childNdFeedBackContentWidth+"px;'>";
					feedBackHtml += "<span class='feedBackAuthor'>" + childNd.Author +"</span> 回复 <span class='feedBackAuthor'>"+node.Author+"</span><br>";
					feedBackHtml += "<span class='feedBackContentArticle'>"+childNd.Content + "</span><br>";
					feedBackHtml += "<span class='feedBackInfor'>";
						feedBackHtml += "发布于：" + childNd.DateStr + " ";
						if(fi.setOpen){
							feedBackHtml += "<span onClick='switchHide(\"feedBackForm"+childNd.ID+"\")' class='feedBackSubmit'>回复("+childNdFeedBackCount+")</span>";
							if(Convert.ToInt32 (childNdFeedBackCount) > 4)
								feedBackHtml += " | <a href='feedBack.aspx?feedID="+childNd.ID+"' target='_blank'>查看全部回复</a>";
							feedBackHtml += "";
						}
					feedBackHtml += "</span><br>";
					if(fi.setOpen){
						feedBackHtml += "<div id='feedBackForm"+childNd.ID+"' name='feedBackForm'  class='feedBackForm' style='display:none;'>";
							feedBackHtml += "<span class='feedBackHelp'>";
								feedBackHtml += "#提示："+fi.setSize +"字内";
								if(fi.setPass){
									feedBackHtml += "，新发布的说说需审核后方能显示!";
								}
							feedBackHtml += "</span>";
							feedBackHtml += "<form action='feedBack.aspx' style='margin:0px;' method='post'>";
								feedBackHtml += "<textarea name='feedBackContent' id='feedBackContent"+childNd.ID+"' class='feedBackTextArea' style='width:"+childNdFeedBackTextAreaWidth+"px;'></textarea>";
								feedBackHtml += "<input type='Hidden' name='feedBackFatherID' value='"+childNd.ID+"'>";
								feedBackHtml += "<img src='System_Img/faceLogo.png' onclick='$getElementBy(\"facePanel\").style.position = \"absolute\";showFace(\"feedBackContent"+childNd.ID+"\",event);' style='float:left;cursor:pointer;'>";
								feedBackHtml += "<input type='Text' name='feedBackAuthor' class='author4FeedBack' Value='请输入名字' onblur='if(this.value==\"\"){this.value=\"请输入名字\";}' onfocus='if(this.value==this.defaultValue){this.value=\"\";}'>";
								feedBackHtml += "<input type='submit' value='回复' class='button4FeedBack'>";
								feedBackHtml += "<div id='facePanel4feedBackContent"+childNd.ID+"'></div>";
								feedBackHtml += "<div style='clear:both;'></div>";
							feedBackHtml += "</form>";
						feedBackHtml += "</div>";
					}
					
					this.showChildNodes(fi,childNd);//递归调用自身
					
					if(Convert.ToInt32 (childNdFeedBackCount) > 4)
						feedBackHtml += "......<br><a href='feedBack.aspx?feedID="+childNd.ID+"' target='_blank'>查看全部回复</a>";
					feedBackHtml += "";					
				feedBackHtml += "</div>";
				feedBackHtml += "<div style='clear:both;'></div>";
			feedBackHtml += "</div>";
        }
	}
	
	///获取反馈记录
	public string getFeedBackHtml(FeedBackInfor fi,string feedIDStr,int articlePageStart,int articlePageSize){
		string nodeSQL = "";
		if(fi.setPass){
			nodeSQL = "Select * From FeedBack4DeepSoon Where FatherID='"+feedIDStr+"' and isPass=true Order By Id DESC Limit "+articlePageStart+","+articlePageSize;
		}
		else{
			nodeSQL = "Select * From FeedBack4DeepSoon Where FatherID='"+feedIDStr+"' Order By Id DESC Limit "+articlePageStart+","+articlePageSize;
		}
		DataTable nodeDT = new DataTable();
		nodeDT = mh.GetDatabysql(nodeSQL);
		///显示ID=0的节点+孩子节点，并设定层级初值level
		for(int i = 0 ; i < nodeDT.Rows.Count ; i++){
			FeedBackNode nd = new FeedBackNode();
			nd.ID=nodeDT.Rows[i]["ID"].ToString();               ///节点ID
			nd.Content=nodeDT.Rows[i]["Content"].ToString();        ///节点Content
			nd.Author =nodeDT.Rows[i]["Author"].ToString();     ///节点Suthor
			nd.DateStr=nodeDT.Rows[i]["DateStr"].ToString();   ///节点Date
			nd.IPAddress=nodeDT.Rows[i]["IPAddress"].ToString();    ///节点IP
			nd.Level=0;  ///节点Level
			///节点回复数
			DataTable ndFeedBackCountDt=new DataTable();
			ndFeedBackCountDt = mh.GetDatabysql("Select Count(ID) As ndFeedBackCount From FeedBack4DeepSoon Where FatherID = '"+nd.ID+"'");
			string ndFeedBackCount = ndFeedBackCountDt.Rows[0]["ndFeedBackCount"].ToString();
			
			feedBackHtml += "<div class='feedBackBox'>";
				feedBackHtml += "<div class='feedBackLogo'>";
					feedBackHtml += "<img src='/System_Img/feedBackLogo.png'>";
				feedBackHtml += "</div>";
		
				feedBackHtml += "<div class='feedBackContent' style='width:"+feedBackContentWidth+"px;'>";
					feedBackHtml += "<span class='feedBackAuthor'>" + nd.Author +"</span><br>";
					feedBackHtml += "<span class='feedBackContentArticle'>"+nd.Content + "</span><br>";
					feedBackHtml += "<span class='feedBackInfor'>";
						feedBackHtml += "发布于：" + nd.DateStr +" ";
						if(fi.setOpen){
							feedBackHtml += "<span onClick='switchHide(\"feedBackForm"+nd.ID+"\")' class='feedBackSubmit'>回复("+ndFeedBackCount+")</span>";
							if(Convert.ToInt32 (ndFeedBackCount) > 4)
								feedBackHtml += " | <a href='feedBack.aspx?feedID="+nd.ID+"' target='_blank'>查看全部回复</a>";
							feedBackHtml += "";
						}
					feedBackHtml += "</span><br>";
					if(fi.setOpen){
					feedBackHtml += "<div id='feedBackForm"+nd.ID+"' name='feedBackForm' class='feedBackForm' style='display:none;'>";
						feedBackHtml += "<span class='feedBackHelp'>";
							feedBackHtml += "#提示："+fi.setSize +"字内";
							if(fi.setPass){
								feedBackHtml += "，新发布的说说需审核后方能显示!";
							}
						feedBackHtml += "</span>";
						feedBackHtml += "<form action='feedBack.aspx' method='post'style='margin:0px;'>";
							feedBackHtml += "<textarea name='feedBackContent' id='feedBackContent"+nd.ID+"' class='feedBackTextArea' style='width:"+feedBackTextAreaWidth+"px;'></textarea>";
							feedBackHtml += "<input type='Hidden' name='feedBackFatherID' value='"+nd.ID+"'>";
							feedBackHtml += "<img src='System_Img/faceLogo.png' onclick='$getElementBy(\"facePanel\").style.position = \"absolute\";showFace(\"feedBackContent"+nd.ID+"\",event);' style='float:left;cursor:pointer;'>";
							feedBackHtml += "<input type='Text' name='feedBackAuthor' class='author4FeedBack' Value='请输入名字' onblur='if(this.value==\"\"){this.value=\"请输入名字\";}' onfocus='if(this.value==this.defaultValue){this.value=\"\";}'>";
							feedBackHtml += "<input type='submit' value='回复' class='button4FeedBack'>";
							feedBackHtml += "<div id='facePanel4feedBackContent"+nd.ID+"'></div>";
							feedBackHtml += "<div style='clear:both;'></div>";
						feedBackHtml += "</form>";
					feedBackHtml += "</div>";
					}
					
					showChildNodes(fi,nd);///递归调用子节点
					
					if(Convert.ToInt32 (ndFeedBackCount) > 4)
						feedBackHtml += "......<br><a href='feedBack.aspx?feedID="+nd.ID+"' target='_blank'>查看全部回复 &gt;&gt;</a>";
					feedBackHtml += "";
				feedBackHtml += "</div>";
				feedBackHtml += "<div style='clear:both;'></div>";
			feedBackHtml += "</div>";
		}
		return feedBackHtml;
	}
	
	/// 获取客户端IP
	public static string getClientIP(){
		string result = HttpContext.Current.Request.ServerVariables["HTTP_X_FORWARDED_FOR"];
		if (null == result || result == String.Empty){
			result = HttpContext.Current.Request.ServerVariables["REMOTE_ADDR"];
		} 
		if (null == result || result == String.Empty){
			result = HttpContext.Current.Request.UserHostAddress; 
		} 
		return result;
	}
	
	///添加反馈记录
	public void addFeedBack(FeedBackInfor fi,string feedBackAuthor,string feedBackContent,string feedBackFatherID){
		feedBackAuthor = feedBackAuthor.Replace("'", "").Replace("select", "").Replace("delete", "").Replace("update", "").Replace("insert", "");
		if(feedBackAuthor.Length>20)feedBackAuthor = feedBackAuthor.Substring(0,20);
		feedBackContent = feedBackContent.Replace("'", "").Replace("select", "").Replace("delete", "").Replace("update", "").Replace("insert", "").Replace("<", "&lt;").Replace(">", "&gt;");
		if(feedBackContent.Length>fi.setSize)feedBackContent = feedBackContent.Substring(0,fi.setSize);
						
		feedBackContent = feedBackContent.Replace("[足球]", "<img src=face/basic/football.gif>").Replace("[哨子]", "<img src=face/basic/shao.gif>").Replace("[红牌]", "<img src=face/basic/redcard.gif>").Replace("[黄牌]", "<img src=face/basic/yellowcard.gif>").Replace("[哈哈]", "<img src=face/basic/laugh.gif>").Replace("[呵呵]", "<img src=face/basic/smile.gif>").Replace("[泪]", "<img src=face/basic/cry.gif>").Replace("[汗]", "<img src=face/basic/sweat.gif>").Replace("[爱你]", "<img src=face/basic/love.gif>").Replace("[嘻嘻]", "<img src=face/basic/tooth.gif>").Replace("[哼]", "<img src=face/basic/hate.gif>").Replace("[心]", "<img src=face/basic/heart.gif>");
		feedBackContent = feedBackContent.Replace("[晕]", "<img src=face/basic/dizzy.gif>").Replace("[怒]", "<img src=face/basic/angry.gif>").Replace("[蛋糕]", "<img src=face/basic/cake.gif>").Replace("[花]", "<img src=face/basic/flower.gif>").Replace("[抓狂]", "<img src=face/basic/crazy.gif>").Replace("[困]", "<img src=face/basic/sleepy.gif>").Replace("[干杯]", "<img src=face/basic/cheer.gif>").Replace("[太阳]", "<img src=face/basic/sun.gif>").Replace("[下雨]", "<img src=face/basic/rain.gif>").Replace("[伤心]", "<img src=face/basic/sad.gif>").Replace("[月亮]", "<img src=face/basic/moon.gif>").Replace("[猪头]", "<img src=face/basic/pig.gif>").Replace("[蜡烛]", "<img src=face/basic/candle.gif>");
					
		feedBackFatherID = feedBackFatherID.Replace("'", "").Replace("select", "").Replace("delete", "").Replace("update", "").Replace("insert", "");
			
		if(feedBackContent.Length > 2 && feedBackAuthor != "请输入名字")
			mh.Runsql("Insert Into FeedBack4DeepSoon(Content,Author,IPAddress,FatherID) Values ('"+feedBackContent+"','"+feedBackAuthor+"','"+getClientIP()+"','"+feedBackFatherID+"')");			
		
	}
	
	
}