﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;

namespace Security
{
	public class ValidateBase : System.Web.UI.Page
    {
        public ValidateBase(){ }
        
		/// 基类成员：存放验证码值
        public string strValidate
        {
            get
            {
                if (Session["ValidateCode"] != null)
                    return Session["ValidateCode"].ToString();
                else
                    return "";
            }
            set
            {
				Session["ValidateCode"] = value;
            }
        }
        
		/// 基类成员：存放登录名
        public string strUser
        {
            get
            {
				/*
				if (Session["strUser"] != null)
                    return Session["strUser"].ToString();
                else
                    return "";
				*/
				if (Request.Cookies["strUser4Deepsoon"] != null){
					HttpCookie userCookie = Request.Cookies["strUser4Deepsoon"]; 
					return HttpUtility.UrlDecode(HttpUtility.UrlDecode(userCookie.Value, Encoding.GetEncoding("UTF-8")));
				}
                else
                    return "";
            }
            set
            {
				/// Session["strUser"] = value;
				HttpCookie userCookie = new HttpCookie("strUser4Deepsoon");
				userCookie.Value = HttpUtility.UrlEncode(HttpUtility.UrlEncode(value, Encoding.GetEncoding("UTF-8"))); 
				userCookie.Expires = DateTime.Now.AddDays(7); 
				Response.Cookies.Add(userCookie);
            }
        }
		
		/// 获取客户端IP
		public static string getClientIP(){
			string result = HttpContext.Current.Request.ServerVariables["HTTP_X_FORWARDED_FOR"];
			if (null == result || result == String.Empty){
				result = HttpContext.Current.Request.ServerVariables["REMOTE_ADDR"];
			} 
			if (null == result || result == String.Empty){
				result = HttpContext.Current.Request.UserHostAddress; 
			} 
			return result;
		}
		
    }
}