﻿using System;
using System.Data;
using System.Web.UI;
using System.Web.UI.HtmlControls;

public partial class masterPageClass : System.Web.UI.MasterPage
{
	string themeHtml4Nav = "";
	string themeHtml4Copyright = "";
	string ThemeCSS = "";
	
	string classID = null;
	DeepSoonHelp dh = null;
	
	protected void Page_Load(object sender, EventArgs e)
    {
		///创建函数库
		dh = new DeepSoonHelp();
		
		///获取栏目classID
		classID = Request.QueryString["ClassID"];
		///获取合法的classID
		classID = dh.getValidateNumStr(classID);
		
		///获取导航栏模板代码
		themeHtml4Nav = dh.getThemeHtml("T_nav.html");
		
		///获取版权信息模板代码
		themeHtml4Copyright = dh.getThemeHtml("T_copyright.html");
		
		///获取模板的样式表文件路径
		ThemeCSS = dh.getThemeCSS();
		
		///获取网站的基本信息
		SiteInfor si = dh.getSiteInfor();
		
		///设置网站风格的css文件路径：
		HtmlLink cssLink = new HtmlLink();
		cssLink.Attributes.Add("type","text/css");
		cssLink.Attributes.Add("rel","stylesheet");
		cssLink.Href = ThemeCSS;
		this.Page.Header.Controls.Add(cssLink);		
		
		///处理网站基本信息标签：
		string sitePos = "<a href='/'><b>" + si.siteName + "</b></a> &gt; <b>" + Page.Header.Title+"</b>";
		themeHtml4Nav = themeHtml4Nav.Replace("{dp:siteLogoAddr}", si.siteLogoAddr).Replace("{dp:siteTitle}", si.siteTitle).Replace("{dp:sitePos}", sitePos);
		
		///处理网站头信息
		HtmlMeta metaKeywords = new HtmlMeta();
		metaKeywords.Name = "keywords";
		metaKeywords.Content = si.siteKeywords;
		
		HtmlMeta metaDescribe = new HtmlMeta();
		metaDescribe.Name = "description";
		metaDescribe.Content = si.siteDescribe;
		
		HtmlHead head = Page.Header;
		head.Controls.Add(metaKeywords);
		head.Controls.Add(metaDescribe);
		
		Page.Title = (Page.Header.Title.Replace("</b> &gt; <b>正文</b>", "").Replace("</b> &gt; <b>列表</b>", "") +" &brvbar; "+si.siteTitle).Replace("首页 &brvbar;", "")+" - Powered by deepsoon";
		
		///处理版权标签
		string siteOppInfor = "GMT+8."+DateTime.Now.ToString("yyyy-MM-dd")+" "+DateTime.Now.ToLongTimeString().ToString()+". Deepsoon Open Source Soft";
		DeepSoon deepsoon = new DeepSoon();
		themeHtml4Copyright = themeHtml4Copyright.Replace("{dp:siteSystemInfor}",deepsoon.getSystemInfor()).Replace("{dp:siteCopyRight}",si.siteCopyRight).Replace("{dp:siteOppInfor}",siteOppInfor);
		
		///处理菜单栏标签
		string classTreeStr = dh.getClassTreeStr(classID,si.urlRule);
		themeHtml4Nav = themeHtml4Nav.Replace("{dp:siteNav}", classTreeStr);
		
		///导航栏和版权信息模块显示到网页
		this.labelSiteNav.Text = themeHtml4Nav;
		this.labelSiteCopyright.Text = themeHtml4Copyright;
    }
	
}