﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using MySql.Data.MySqlClient;
using System.Web.Configuration;
using System.Text.RegularExpressions; 


public partial class searchResultClass : System.Web.UI.Page
{
	MysqlHelp mh = null;
	DataTable dt = null;
	string ChildIDSet = "";
	
	string classStr = "";
	string resultHtml = "";
	
	int articlePageSize = 6;
	int articlePageCount = 1;
	int articlePageStart = 0;
	int articlePageCurrent = 0;
	
	/// 功能：判断输入的是否是数字 
	/// 参数：string oText：源文本 
	/// 返回值：　bool true:是　false:否 
	public bool IsNumberic(string oText) 
	{ 
		try 
		{ 
			int var1=Convert.ToInt32 (oText); 
			return true; 
		} 
		catch 
		{ 
			return false; 
		} 
	} 
		
	protected void Page_Load(object sender, EventArgs e)
    {
		///创建数据连接对象：
		mh = new MysqlHelp();		
		
		if(!IsPostBack)
        {
			string Key = Request.QueryString["Key"];
			if( Key == null )Key = Request.Form["Key"];
			if( Key == null )Key = "%";
			
			string selClass = Request.QueryString["ClassID"];
			///判断selClass合法性
			if( selClass != null && selClass.Length>999999999 )selClass = selClass.Substring(0,999999999);
			if( selClass == null )selClass = "-1";
			if( !IsNumberic(selClass) )selClass = "-1"; 
			
			string menuID = Request.QueryString["MenuID"];
			///判断menuID合法性
			if( menuID != null && menuID.Length>999999999 )menuID = menuID.Substring(0,999999999);
			if( menuID == null )menuID = "0";
			if( !IsNumberic(menuID) )menuID = "0"; 
			
			this.keyWord.Text = Key;
						
			///获取栏目的页码
			string articlePageCurrentStr = "0";
			articlePageCurrentStr = Request.QueryString["Page"];
			///栏目页码合法性判断：
			if( articlePageCurrentStr !=null && articlePageCurrentStr.Length>999999999 )
				articlePageCurrentStr = articlePageCurrentStr.Substring(0,999999999);
			if( !IsNumberic(articlePageCurrentStr) )
				articlePageCurrent = 0;
			else articlePageCurrent = Convert.ToInt32(articlePageCurrentStr);
					
			DataTable ChildIdDt = new DataTable();
			DataTable newsDt=new DataTable();
			DataTable countDt=new DataTable();
			
			///查询[文章列表]的所有子类集：
			ChildIdDt=new DataTable();
			if(selClass == "-1"){
				ChildIdDt = mh.GetDatabysql("Select ID From Class4DeepSoon");
			}
			else {
				ChildIdDt = mh.GetDatabysql("Select ChildID From Class4DeepSoon Where ID = "+selClass);
			}
			///如果classID的菜单存在，则继续：
			if(ChildIdDt.Rows.Count>0){
				if(selClass == "-1"){
					ChildIDSet += "(";
					for(int j = 0 ; j < ChildIdDt.Rows.Count ; j++){
						if(j < ChildIdDt.Rows.Count-1)
							ChildIDSet += ChildIdDt.Rows[j]["ID"].ToString()+",";
						else ChildIDSet += ChildIdDt.Rows[j]["ID"].ToString();
					}
					ChildIDSet += ")";
				}
				else {
					ChildIDSet = "("+ChildIdDt.Rows[0]["ChildID"].ToString()+")";
				}
				///Response.Write("所有ID   "+ChildIDSet);
			
				///查询符合条件的记录总数：
				countDt = mh.GetDatabysql("Select Count(*) As CountNum From Article4DeepSoon,Class4DeepSoon Where Title Like '%"+Key+"%' and ClassID in "+ChildIDSet+" and isDelete=false and Article4DeepSoon.ClassID=Class4DeepSoon.ID");
				articlePageCount = Convert.ToInt32(countDt.Rows[0]["CountNum"]);
				///计算记录总数总共可以分为多少页：
				int PageCount = articlePageCount/articlePageSize;
				if(articlePageCount%articlePageSize==0)PageCount = PageCount-1;
				///如果当前页码越界：
				if( articlePageCurrent < 0 )articlePageCurrent=0;
				if( articlePageCurrent > PageCount)articlePageCurrent = PageCount;
				///查询记录的起始位置：
				articlePageStart = articlePageSize * articlePageCurrent;
			
				resultHtml += "共找到"+articlePageCount+"条记录<br><br>";
				///如果有记录
				if(articlePageCount>0){
				///------ if Start -----
					///查询文章表中classID属于子类集中的记录：
					newsDt = mh.GetDatabysql("Select Article4DeepSoon.ID,ClassID,Title,Name,Source,Author,DateStr,BriefInfor,thumbnailImage,ReadCount From Article4DeepSoon,Class4DeepSoon Where Title Like '%"+Key+"%' and ClassID in "+ChildIDSet+" and isDelete=false and Article4DeepSoon.ClassID=Class4DeepSoon.ID Order By Article4DeepSoon.ID DESC Limit "+articlePageStart+","+articlePageSize);
					
					for(int i = 0 ; i < newsDt.Rows.Count ; i++)
					{
						string ID = newsDt.Rows[i]["ID"].ToString();
						string Title = newsDt.Rows[i]["Title"].ToString();
						Title=Title.Replace(Key,"<font color=#BF4014>"+Key+"</font>");
						string DateStr = Convert.ToDateTime( newsDt.Rows[i]["DateStr"].ToString() ).ToString("yyyy/MM/dd");
						string ClassID = newsDt.Rows[i]["ClassID"].ToString();
						string ClassName = newsDt.Rows[i]["Name"].ToString();
						string BriefInfor = newsDt.Rows[i]["BriefInfor"].ToString()+"...";
						BriefInfor = Regex.Replace(BriefInfor, @"\s*|\t|\r|\n", "", RegexOptions.IgnoreCase);
						BriefInfor = Regex.Replace(BriefInfor, "（", "(", RegexOptions.IgnoreCase);
						BriefInfor = Regex.Replace(BriefInfor, "）", ")", RegexOptions.IgnoreCase);		
						BriefInfor=BriefInfor.Replace(Key,"<font color=#BF4014>"+Key+"</font>");
												
						string thumbnailImage = newsDt.Rows[i]["thumbnailImage"].ToString();
						string ReadCount = newsDt.Rows[i]["ReadCount"].ToString();
						
						resultHtml += "<a href='view.aspx?ID="+ID+"' target='_blank'>"+Title+"</a><br>";
						if(thumbnailImage!="")
							resultHtml += "<img src='"+thumbnailImage+"' style='float:left;height:80px;margin-right:10px;'>";
						resultHtml += "<div class='searchBrif'>"+BriefInfor+"</div>";
						resultHtml += "<span class='searchDate'>"+ClassName+"/"+DateStr+"</span><br><br>";
					}
					
					string PageContent = "<div class='ListPageBox'>";
					if(articlePageCurrent-1 >= 0)
						PageContent += "<a href='searchResult.aspx?Key="+Key+"&ClassID="+selClass+"&page="+(articlePageCurrent-1)+"&MenuID="+menuID+"'><div class='pageButton'>&lt;</div></a> ";
					else PageContent += "<div class='pageGrayButton'>&lt;</div>";
				
					if(articlePageCurrent < PageCount)
						PageContent += "<a href='searchResult.aspx?Key="+Key+"&ClassID="+selClass+"&page="+(articlePageCurrent+1)+"&MenuID="+menuID+"'><div class='pageButton'>&gt;</div></a> ";
					else PageContent += "<div class='pageGrayButton'>&gt;</div>";
					PageContent += "</div>";
				
					resultHtml += PageContent;
				}///------ if 文章存在 -----
				else {
					resultHtml = "<div class='errorBox'><img src='System_Img/cry.gif'> 对不起，没有找到您想要的！</div>";
				}
				///将网页数据显示
				this.labelResult.Text = resultHtml;
			}
			
			///获取栏目名称className和栏目模板文件themeFile:
			DataTable classNameDt = new DataTable();
			classNameDt = mh.GetDatabysql("Select * From Class4DeepSoon Where OutLinkHref='' and FatherID=0 Order By Id Limit 5");
			int sumCount = classNameDt.Rows.Count;
			classStr += "<a href='search.aspx'><img src='system_img/logoBanner.png' style='float:left;'></a><br>";
			classStr += "<div class='menuClass' id='Menu0' onClick='setClass(0,"+sumCount+",-1)'>全部</div>";
			if( sumCount > 0){
				for(int i = 0 ; i < sumCount ; i++)
				{
					string NameStr = classNameDt.Rows[i]["Name"].ToString();
					string IDStr = classNameDt.Rows[i]["ID"].ToString();
					classStr += "<div class='menuClass' id='Menu"+(i+1)+"' onClick='setClass("+(i+1)+","+sumCount+","+IDStr+")'>"+NameStr+"</div>";
				}
			}
			classStr += "<div class='menuClass'>更多</div>";
			this.labelClass.Text = classStr;
		
			this.btnSearch.Attributes.Add("onClick", "hiddFieldSelClass.value = document.getElementById('selClassHidden').value;hiddFieldMenuID.value = document.getElementById('menuIDHidden').value;"); 
			Page.RegisterStartupScript("","<script language=javascript>setClass("+menuID+","+sumCount+","+selClass+");</script>"); 
			
		}
		
    }
	
	protected void btnSearch_Click(object sender, EventArgs e)
	{		
		string keyWord = this.keyWord.Text;
		string selClass = this.hiddFieldSelClass.Value;
		string menuID = this.hiddFieldMenuID.Value;
		if(keyWord != "")
		Response.Redirect("searchResult.aspx?Key="+keyWord+"&ClassID="+selClass+"&MenuID="+menuID);
	}
		
	
}