using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class ctrls_articles : System.Web.UI.UserControl
{
	private string cid;
	public string Cid
	{
		get{ return cid; }
		set{ cid = value;}
	}
	
	private int top = 10;
	public int Top
	{
		get{ return top; }
		set{ top = value;}
	}

	private string repeat;
	public string Rrepeat
	{
		get{ return repeat; }
		set{ 
			repeat = value;

			this.data_articles_type_1.RepeatColumns = Int32.Parse(repeat);
			this.data_articles_type_2.RepeatColumns = Int32.Parse(repeat);
            this.data_articles_type_3.RepeatColumns = Int32.Parse(repeat);
            this.data_articles_type_4.RepeatColumns = Int32.Parse(repeat);
            this.data_articles_type_5.RepeatColumns = Int32.Parse(repeat);
        }
	}

	private int titleLength;
	public int TitleLength
	{
		get{ return titleLength; }
		set{ titleLength = value;}
	}

	private int contentLength = 100;
	public int ContentLength
	{
		get{ return contentLength; }
		set{ contentLength = value;}
	}
	
	private string cssclass = "list1";
	public string CssClass
	{
		get{ return cssclass; }
		set{ cssclass = value;}
	}

    private int showclass = 0;
    public int ShowClass
    {
        get { return showclass; }
        set { showclass = value; }
    }

    private int showdatetime = 1;
    public int ShowDateTime
    {
        get { return showdatetime; }
        set { showdatetime = value; }
    }
	
	private int showstate = 0;
	public int ShowState
	{
		get{ return showstate; }
		set{ showstate = value;}
	}

	private int width = 150;
	public int Width
	{
		get{ return width; }
		set{ width = value;}
	}

	private int height = 113;
	public int Height
	{
		get{ return height; }
		set{ height = value;}
	}

	private int type = 1;
	public int Type
	{
		get{ return type; }
		set{ type = value;}
	}

	private LCweb.Data.OleDbClient r;
	public LCweb.Data.OleDbClient R
	{
        set { this.r = value; }
	}

    protected void Page_Load(object sender, EventArgs e)
    {
		try
		{
			r = (LCweb.Data.OleDbClient)Parent;
		}
		catch
		{
			r = new LCweb.Data.OleDbClient();
		}
		
		//
		string sql = "Select top "+ top +" * from [v_articles] where id > 0";
		
		if( cid != null )
		{
 			LCweb.Categories c = new LCweb.Categories(r, cid);
	
			sql += " and cid in (" + c.Childs +")";
		}
		
		switch( type )
		{
			//б1
			default:
			case 1:
		        r.BindList( sql +" order by state desc, addtime desc", "data_articles", data_articles_type_1 );   
				break;
			
			//б2
			case 2:
                r.BindList(sql + " order by state desc, addtime desc", "data_articles", data_articles_type_2);   
				break;

			//б3
			case 3:
                r.BindList(sql + " order by state desc, addtime desc", "data_articles", data_articles_type_3);   
				break;

			//ͼƬ
			case 4:
                r.BindList(sql + " and picture <> '' order by state desc, addtime desc", "data_articles", data_articles_type_4);   
				break;
 
 			//ͼƬ
            case 5:
                r.BindList(sql + " and picture <> '' order by state desc, addtime desc", "data_articles", data_articles_type_5);
                break;
 
 			//̬
            case 6:
                r.BindList(sql + " order by state desc, addtime desc", "data_articles", data_articles_type_6);
                break;
        } 
	}

    public string GetLink(object id, object link, object filename)
    {
        if (link.ToString() != "")
            return link.ToString();
        else
            return "../"+ filename.ToString() +"-"+ id.ToString() + ".aspx";//<%# DataBinder.Eval(Container.DataItem, "id") %>
    }

    public string GetHot(object state)
    {
        if (state.ToString() != "" && showstate == 1)
        {
            if (Int32.Parse(state.ToString()) == 1)
                return "<font color=red></font>";
            else if (Int32.Parse(state.ToString()) == 2)
                return "<font color=red></font>";
			else if (Int32.Parse(state.ToString()) == 3)
                return "<font color=red></font>";
			else
                return "";
        }
        else
            return "";
    }

    public string GetClass(object category)
    {
        if (this.showclass == 1)
            return "" + category.ToString() + " ";
        else
            return "";
    }

    public string GetDateTime(object datetime)
    {
        if (this.showdatetime == 1)
            return "(" + datetime.ToString() + ")";
        else
            return "";
    }
}
