﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using System.Data;
using System.Web.UI.WebControls;
using System.Text.RegularExpressions;

namespace ZPY.Common
{
   public class PublicFc
   {
       #region 分层显示类别层次
       /// <summary>
        /// 可选父类显示
        /// </summary>
        public static void DropList_Bind(DataTable dt, DropDownList dropDownList)
        {

            dropDownList.Items.Clear();
            dropDownList.Items.Add(new ListItem("顶级根类", "0"));
            DataRow[] drs;
            drs = dt.Select("FatherID=0", "ID ASC");
            if (drs.Length > 0)
            {
                foreach (DataRow dr in drs)
                {
                    string className = "╋" + dr["ClassName"].ToString();
                    string valueID = dr["ID"].ToString();
                    int fatherID = int.Parse(valueID);
                    dropDownList.Items.Add(new ListItem(className, valueID));
                    ChileNodeBind(fatherID, dt, System.Web.HttpContext.Current.Server.HtmlDecode("&nbsp;&nbsp;"), dropDownList);
                }
            }

        }

        private static void ChileNodeBind(int fatherID, DataTable dt, string prefix, DropDownList dropDownList)
        {
            DataRow[] drs;
            drs = dt.Select("FatherID=" + fatherID, "ID ASC");
            if (drs.Length > 0)
            {
                foreach (DataRow dr in drs)
                {
                    string className = prefix + "『" + dr["ClassName"].ToString() + "』";
                    string valueID = dr["ID"].ToString();
                    fatherID = int.Parse(valueID);
                    dropDownList.Items.Add(new ListItem(className, valueID));
                    prefix = System.Web.HttpContext.Current.Server.HtmlDecode("&nbsp;&nbsp;") + prefix;
                    ChileNodeBind(fatherID, dt, prefix, dropDownList);
                }
            }
        }
       #endregion

        /// <summary>
        /// 显示消息提示对话框
        /// </summary>
        /// <param name="page">当前页面指针，一般为this</param>
        /// <param name="msg">提示信息</param>
        public static void Show(System.Web.UI.Page page, string msg)
        {
            page.ClientScript.RegisterStartupScript(page.GetType(), "message", "<script language='javascript' defer>alert('" + msg.ToString() + "');</script>");
        
        }

        /// <summary>
        /// 去除HTML标记
        /// </summary>
        /// <param name="Htmlstring">包括HTML的源码 </param>
        /// <returns>已经去除后的文字</returns>
        public static string NoHTML(string Htmlstring)
        {
            //删除脚本
            Htmlstring = Htmlstring.Replace("\r\n", "");
            Htmlstring = Regex.Replace(Htmlstring, @"<script.*?</script>", "", RegexOptions.IgnoreCase);
            Htmlstring = Regex.Replace(Htmlstring, @"<style.*?</style>", "", RegexOptions.IgnoreCase);
            Htmlstring = Regex.Replace(Htmlstring, @"<.*?>", "", RegexOptions.IgnoreCase);
            //删除HTML
            Htmlstring = Regex.Replace(Htmlstring, @"<(.[^>]*)>", "", RegexOptions.IgnoreCase);
            Htmlstring = Regex.Replace(Htmlstring, @"([\r\n])[\s]+", "", RegexOptions.IgnoreCase);
            Htmlstring = Regex.Replace(Htmlstring, @"-->", "", RegexOptions.IgnoreCase);
            Htmlstring = Regex.Replace(Htmlstring, @"<!--.*", "", RegexOptions.IgnoreCase);
            Htmlstring = Regex.Replace(Htmlstring, @"&(quot|#34);", "\"", RegexOptions.IgnoreCase);
            Htmlstring = Regex.Replace(Htmlstring, @"&(amp|#38);", "&", RegexOptions.IgnoreCase);
            Htmlstring = Regex.Replace(Htmlstring, @"&(lt|#60);", "<", RegexOptions.IgnoreCase);
            Htmlstring = Regex.Replace(Htmlstring, @"&(gt|#62);", ">", RegexOptions.IgnoreCase);
            Htmlstring = Regex.Replace(Htmlstring, @"&(nbsp|#160);", "", RegexOptions.IgnoreCase);
            Htmlstring = Regex.Replace(Htmlstring, @"&(iexcl|#161);", "\xa1", RegexOptions.IgnoreCase);
            Htmlstring = Regex.Replace(Htmlstring, @"&(cent|#162);", "\xa2", RegexOptions.IgnoreCase);
            Htmlstring = Regex.Replace(Htmlstring, @"&(pound|#163);", "\xa3", RegexOptions.IgnoreCase);
            Htmlstring = Regex.Replace(Htmlstring, @"&(copy|#169);", "\xa9", RegexOptions.IgnoreCase);
            Htmlstring = Regex.Replace(Htmlstring, @"&#(\d+);", "", RegexOptions.IgnoreCase);
            Htmlstring = Htmlstring.Replace("<", "");
            Htmlstring = Htmlstring.Replace(">", "");
            Htmlstring = Htmlstring.Replace("\r\n", "");
            Htmlstring = HttpContext.Current.Server.HtmlEncode(Htmlstring).Trim();
            return Htmlstring;
        }


   }
}
