using System;
using System.Reflection;
using System.Configuration;
namespace ZPY.DALFactory
{
	/// <summary>
    /// Abstract Factory pattern to create the DAL
    /// ﴴ󱨴web.configǷ޸<add key="DAL" value="Maticsoft.SQLServerDAL" />
	/// </summary>
	public sealed class DataAccess
	{
        private static readonly string AssemblyPath = ConfigurationManager.AppSettings["DAL"];        
		public DataAccess()
		{ }

        #region CreateObject 

		//ʹû
        private static object CreateObjectNoCache(string AssemblyPath,string classNamespace)
		{		
			try
			{
				object objType = Assembly.Load(AssemblyPath).CreateInstance(classNamespace);	
				return objType;
			}
			catch//(System.Exception ex)
			{
				//string str=ex.Message;// ¼־
				return null;
			}			
			
        }
		//ʹû
		private static object CreateObject(string AssemblyPath,string classNamespace)
		{			
			object objType = DataCache.GetCache(classNamespace);
			if (objType == null)
			{
				try
				{
					objType = Assembly.Load(AssemblyPath).CreateInstance(classNamespace);					
					DataCache.SetCache(classNamespace, objType);// д뻺
				}
				catch//(System.Exception ex)
				{
					//string str=ex.Message;// ¼־
				}
			}
			return objType;
		}
        #endregion

        #region CreateSysManage
        public static ZPY.IDAL.ISysManage CreateSysManage()
		{
			//ʽ1			
			//return (ZPY.IDAL.ISysManage)Assembly.Load(AssemblyPath).CreateInstance(AssemblyPath+".SysManage");

			//ʽ2 			
			string classNamespace = AssemblyPath+".SysManage";	
			object objType=CreateObject(AssemblyPath,classNamespace);
            return (ZPY.IDAL.ISysManage)objType;		
		}
		#endregion
             
        
   
		/// <summary>
		/// Tb_Articleݲӿ
		/// </summary>
		public static ZPY.IDAL.ITb_Article CreateTb_Article()
		{

			string ClassNamespace = AssemblyPath +".Tb_Article";
			object objType=CreateObject(AssemblyPath,ClassNamespace);
			return (ZPY.IDAL.ITb_Article)objType;
		}


		/// <summary>
		/// Tb_ArticleClassݲӿ
		/// </summary>
		public static ZPY.IDAL.ITb_ArticleClass CreateTb_ArticleClass()
		{

			string ClassNamespace = AssemblyPath +".Tb_ArticleClass";
			object objType=CreateObject(AssemblyPath,ClassNamespace);
			return (ZPY.IDAL.ITb_ArticleClass)objType;
		}

        //5//1//a//s//p//x
		/// <summary>
		/// Tb_ArticleCommentݲӿ
		/// </summary>
		public static ZPY.IDAL.ITb_ArticleComment CreateTb_ArticleComment()
		{

			string ClassNamespace = AssemblyPath +".Tb_ArticleComment";
			object objType=CreateObject(AssemblyPath,ClassNamespace);
			return (ZPY.IDAL.ITb_ArticleComment)objType;
		}


		/// <summary>
		/// Tb_Userݲӿ
		/// </summary>
		public static ZPY.IDAL.ITb_User CreateTb_User()
		{

			string ClassNamespace = AssemblyPath +".Tb_User";
			object objType=CreateObject(AssemblyPath,ClassNamespace);
			return (ZPY.IDAL.ITb_User)objType;
		}

}
}