using System;
using System.Data;
using System.Text;
using System.Data.SqlClient;
using ZPY.IDAL;
using ZPY.DBUtility;//
namespace ZPY.SQLServerDAL
{
	/// <summary>
	/// ݷTb_Article
	/// </summary>
	public class Tb_Article:ITb_Article
	{
		public Tb_Article()
		{}
		#region  Ա

		/// <summary>
		/// õID
		/// </summary>
		public int GetMaxId()
		{
		return DbHelperSQL.GetMaxID("ID", "Tb_Article"); 
		}

		/// <summary>
		/// Ƿڸü¼
		/// </summary>
		public bool Exists(int ID)
		{
			int rowsAffected;
			SqlParameter[] parameters = {
					new SqlParameter("@ID", SqlDbType.Int,4)};
			parameters[0].Value = ID;

			int result= DbHelperSQL.RunProcedure("UP_Tb_Article_Exists",parameters,out rowsAffected);
			if(result==1)
			{
				return true;
			}
			else
			{
				return false;
			}
		}

		/// <summary>
		///  һ
		/// </summary>
		public int Add(ZPY.Model.Tb_Article model)
		{
			int rowsAffected;
			SqlParameter[] parameters = {
					new SqlParameter("@ID", SqlDbType.Int,4),
					new SqlParameter("@Title", SqlDbType.NVarChar,100),
					new SqlParameter("@Author", SqlDbType.NVarChar,50),
					new SqlParameter("@AddTime", SqlDbType.DateTime),
					new SqlParameter("@ClassID", SqlDbType.Int,4),
					new SqlParameter("@DefaultImage", SqlDbType.NVarChar,200),
					new SqlParameter("@IsTop", SqlDbType.Bit,1),
					new SqlParameter("@IsPass", SqlDbType.Bit,1),
					new SqlParameter("@Hits", SqlDbType.Int,4),
					new SqlParameter("@Content", SqlDbType.NVarChar),
					new SqlParameter("@Source", SqlDbType.NVarChar,100),
					new SqlParameter("@Page_KeyWord", SqlDbType.NVarChar,400),
					new SqlParameter("@Page_Description", SqlDbType.NVarChar,400),
					new SqlParameter("@Page_Title", SqlDbType.NVarChar,200),
                    new SqlParameter("@SavePath",SqlDbType.NVarChar,80),
                    new SqlParameter("@FileName",SqlDbType.NVarChar,30),
                    new SqlParameter("FileExName",SqlDbType.NVarChar,20)};
			parameters[0].Direction = ParameterDirection.Output;
			parameters[1].Value = model.Title;
			parameters[2].Value = model.Author;
			parameters[3].Value = model.AddTime;
			parameters[4].Value = model.ClassID;
			parameters[5].Value = model.DefaultImage;
			parameters[6].Value = model.IsTop;
			parameters[7].Value = model.IsPass;
			parameters[8].Value = model.Hits;
			parameters[9].Value = model.Content;
			parameters[10].Value = model.Source;
			parameters[11].Value = model.Page_KeyWord;
			parameters[12].Value = model.Page_Description;
			parameters[13].Value = model.Page_Title;
            parameters[14].Value = model.SavePath;
            parameters[15].Value = model.FileName;
            parameters[16].Value = model.FileExName;

			DbHelperSQL.RunProcedure("Tb_Article_ADD",parameters,out rowsAffected);
			return (int)parameters[0].Value;
		}

		/// <summary>
		///  һ
		/// </summary>
		public void Update(ZPY.Model.Tb_Article model)
		{
			int rowsAffected;
			SqlParameter[] parameters = {
					new SqlParameter("@ID", SqlDbType.Int,4),
					new SqlParameter("@Title", SqlDbType.NVarChar,100),
					new SqlParameter("@Author", SqlDbType.NVarChar,50),
					new SqlParameter("@AddTime", SqlDbType.DateTime),
					new SqlParameter("@ClassID", SqlDbType.Int,4),
					new SqlParameter("@DefaultImage", SqlDbType.NVarChar,200),
					new SqlParameter("@IsTop", SqlDbType.Bit,1),
					new SqlParameter("@IsPass", SqlDbType.Bit,1),
					new SqlParameter("@Hits", SqlDbType.Int,4),
					new SqlParameter("@Content", SqlDbType.NVarChar),
					new SqlParameter("@Source", SqlDbType.NVarChar,100),
					new SqlParameter("@Page_KeyWord", SqlDbType.NVarChar,400),
					new SqlParameter("@Page_Description", SqlDbType.NVarChar,400),
					new SqlParameter("@Page_Title", SqlDbType.NVarChar,200),
                    new SqlParameter("@SavePath",SqlDbType.NVarChar,80),
                    new SqlParameter("@FileName",SqlDbType.NVarChar,30),
                    new SqlParameter("FileExName",SqlDbType.NVarChar,20) };
			parameters[0].Value = model.ID;
			parameters[1].Value = model.Title;
			parameters[2].Value = model.Author;
			parameters[3].Value = model.AddTime;
			parameters[4].Value = model.ClassID;
			parameters[5].Value = model.DefaultImage;
			parameters[6].Value = model.IsTop;
			parameters[7].Value = model.IsPass;
			parameters[8].Value = model.Hits;
			parameters[9].Value = model.Content;
			parameters[10].Value = model.Source;
			parameters[11].Value = model.Page_KeyWord;
			parameters[12].Value = model.Page_Description;
			parameters[13].Value = model.Page_Title;
            parameters[14].Value = model.SavePath;
            parameters[15].Value = model.FileName;
            parameters[16].Value = model.FileExName;
			DbHelperSQL.RunProcedure("Tb_Article_Update",parameters,out rowsAffected);
		}

		/// <summary>
		/// ɾһ
		/// </summary>
		public void Delete(int ID)
		{
			int rowsAffected;
			SqlParameter[] parameters = {
					new SqlParameter("@ID", SqlDbType.Int,4)};
			parameters[0].Value = ID;

			DbHelperSQL.RunProcedure("Tb_Article_Delete",parameters,out rowsAffected);
		}

		/// <summary>
		/// õһʵ
		/// </summary>
		public ZPY.Model.Tb_Article GetModel(int ID)
		{
			SqlParameter[] parameters = {
					new SqlParameter("@ID", SqlDbType.Int,4)};
			parameters[0].Value = ID;

			ZPY.Model.Tb_Article model=new ZPY.Model.Tb_Article();
			DataSet ds= DbHelperSQL.RunProcedure("Tb_Article_GetModel",parameters,"ds");
			if(ds.Tables[0].Rows.Count>0)
			{
				if(ds.Tables[0].Rows[0]["ID"].ToString()!="")
				{
					model.ID=int.Parse(ds.Tables[0].Rows[0]["ID"].ToString());
				}
				model.Title=ds.Tables[0].Rows[0]["Title"].ToString();
				model.Author=ds.Tables[0].Rows[0]["Author"].ToString();
				if(ds.Tables[0].Rows[0]["AddTime"].ToString()!="")
				{
					model.AddTime=DateTime.Parse(ds.Tables[0].Rows[0]["AddTime"].ToString());
				}
				if(ds.Tables[0].Rows[0]["ClassID"].ToString()!="")
				{
					model.ClassID=int.Parse(ds.Tables[0].Rows[0]["ClassID"].ToString());
				}
				model.DefaultImage=ds.Tables[0].Rows[0]["DefaultImage"].ToString();
				if(ds.Tables[0].Rows[0]["IsTop"].ToString()!="")
				{
					if((ds.Tables[0].Rows[0]["IsTop"].ToString()=="1")||(ds.Tables[0].Rows[0]["IsTop"].ToString().ToLower()=="true"))
					{
						model.IsTop=true;
					}
					else
					{
						model.IsTop=false;
					}
				}
				if(ds.Tables[0].Rows[0]["IsPass"].ToString()!="")
				{
					if((ds.Tables[0].Rows[0]["IsPass"].ToString()=="1")||(ds.Tables[0].Rows[0]["IsPass"].ToString().ToLower()=="true"))
					{
						model.IsPass=true;
					}
					else
					{
						model.IsPass=false;
					}
				}
				if(ds.Tables[0].Rows[0]["Hits"].ToString()!="")
				{
					model.Hits=int.Parse(ds.Tables[0].Rows[0]["Hits"].ToString());
				}
				model.Content=ds.Tables[0].Rows[0]["Content"].ToString();
				model.Source=ds.Tables[0].Rows[0]["Source"].ToString();
				model.Page_KeyWord=ds.Tables[0].Rows[0]["Page_KeyWord"].ToString();
				model.Page_Description=ds.Tables[0].Rows[0]["Page_Description"].ToString();
				model.Page_Title=ds.Tables[0].Rows[0]["Page_Title"].ToString();
                model.SavePath = ds.Tables[0].Rows[0]["SavePath"].ToString();
                model.FileName = ds.Tables[0].Rows[0]["FileName"].ToString();
                model.FileExName = ds.Tables[0].Rows[0]["FileExName"].ToString();
				return model;
			}
			else
			{
				return null;
			}
		}

		/// <summary>
		/// б
		/// </summary>
		public DataSet GetList(string strWhere)
		{
			StringBuilder strSql=new StringBuilder();
            strSql.Append("select ID,Title,Author,AddTime,ClassID,DefaultImage,IsTop,IsPass,Hits,Content,Source,Page_KeyWord,Page_Description,Page_Title,SavePath,FileName,FileExName ");
			strSql.Append(" FROM Tb_Article ");
			if(strWhere.Trim()!="")
			{
				strSql.Append(" where "+strWhere);
			}
			return DbHelperSQL.Query(strSql.ToString());
		}

		/// <summary>
		/// ǰ
		/// </summary>
		public DataSet GetList(int Top,string strWhere,string filedOrder)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select ");
			if(Top>0)
			{
				strSql.Append(" top "+Top.ToString());
			}
            strSql.Append(" ID,Title,Author,AddTime,ClassID,DefaultImage,IsTop,IsPass,Hits,Content,Source,Page_KeyWord,Page_Description,Page_Title,SavePath,FileName,FileExName ");
			strSql.Append(" FROM Tb_Article ");
			if(strWhere.Trim()!="")
			{
				strSql.Append(" where "+strWhere);
			}
			strSql.Append(" order by " + filedOrder);
			return DbHelperSQL.Query(strSql.ToString());
		}

		/*
		/// <summary>
		/// ҳȡб
		/// </summary>
		public DataSet GetList(int PageSize,int PageIndex,string strWhere)
		{
			SqlParameter[] parameters = {
					new SqlParameter("@tblName", SqlDbType.VarChar, 255),
					new SqlParameter("@fldName", SqlDbType.VarChar, 255),
					new SqlParameter("@PageSize", SqlDbType.Int),
					new SqlParameter("@PageIndex", SqlDbType.Int),
					new SqlParameter("@IsReCount", SqlDbType.Bit),
					new SqlParameter("@OrderType", SqlDbType.Bit),
					new SqlParameter("@strWhere", SqlDbType.VarChar,1000),
					};
			parameters[0].Value = "Tb_Article";
			parameters[1].Value = "ID";
			parameters[2].Value = PageSize;
			parameters[3].Value = PageIndex;
			parameters[4].Value = 0;
			parameters[5].Value = 0;
			parameters[6].Value = strWhere;	
			return DbHelperSQL.RunProcedure("UP_GetRecordByPage",parameters,"ds");
		}*/

		#endregion  Ա
	}
}

