using System;
using System.Data;
using System.Text;
using System.Data.SqlClient;
using ZPY.IDAL;
using ZPY.DBUtility;//
namespace ZPY.SQLServerDAL
{
	/// <summary>
	/// ݷTb_ArticleClass
	/// </summary>
	public class Tb_ArticleClass:ITb_ArticleClass
	{
		public Tb_ArticleClass()
		{}
		#region  Ա

		/// <summary>
		/// õID
		/// </summary>
		public int GetMaxId()
		{
		return DbHelperSQL.GetMaxID("ID", "Tb_ArticleClass");
      
		}

		/// <summary>
		/// Ƿڸü¼
		/// </summary>
		public bool Exists(int ID)
		{
			int rowsAffected;
			SqlParameter[] parameters = {
					new SqlParameter("@ID", SqlDbType.Int,4)};
			parameters[0].Value = ID;

			int result= DbHelperSQL.RunProcedure("Tb_ArticleClass_Exists",parameters,out rowsAffected);
			if(result==1)
			{
				return true;
			}
			else
			{
				return false;
			}
		}

		/// <summary>
		///  һ
		/// </summary>
		public int Add(ZPY.Model.Tb_ArticleClass model)
		{
			int rowsAffected;
			SqlParameter[] parameters = {
					new SqlParameter("@ID", SqlDbType.Int,4),
					new SqlParameter("@ClassName", SqlDbType.NVarChar,50),
					new SqlParameter("@FatherID", SqlDbType.Int,4),
					new SqlParameter("@Summary", SqlDbType.NVarChar),
					new SqlParameter("@SerialNumber", SqlDbType.Int,4),
                    new SqlParameter("@ClassDirectory",SqlDbType.NVarChar,40),
                    new SqlParameter("@IndexTemplet",SqlDbType.NVarChar,100),
                    new SqlParameter("@ContentTemplet",SqlDbType.NVarChar,100),
                    new SqlParameter("@ListCount",SqlDbType.Int,4)

                                        };
			parameters[0].Direction = ParameterDirection.Output;
			parameters[1].Value = model.ClassName;
			parameters[2].Value = model.FatherID;
			parameters[3].Value = model.Summary;
			parameters[4].Value = model.SerialNumber;
            parameters[5].Value = model.ClassDirectory;
            parameters[6].Value = model.IndexTemplet;
            parameters[7].Value = model.ContentTemplet;
            parameters[8].Value = model.ListCount;

			DbHelperSQL.RunProcedure("Tb_ArticleClass_ADD",parameters,out rowsAffected);
			return (int)parameters[0].Value;
		}

		/// <summary>
		///  һ
		/// </summary>
		public void Update(ZPY.Model.Tb_ArticleClass model)
		{
			int rowsAffected;
			SqlParameter[] parameters = {
					new SqlParameter("@ID", SqlDbType.Int,4),
					new SqlParameter("@ClassName", SqlDbType.NVarChar,50),
					new SqlParameter("@FatherID", SqlDbType.Int,4),
					new SqlParameter("@Summary", SqlDbType.NVarChar),
					new SqlParameter("@SerialNumber", SqlDbType.Int,4),
                    new SqlParameter("@ClassDirectory",SqlDbType.NVarChar,40),
                    new SqlParameter("@IndexTemplet",SqlDbType.NVarChar,100),
                    new SqlParameter("@ContentTemplet",SqlDbType.NVarChar,100),
                    new SqlParameter("@ListCount",SqlDbType.Int,4)                    
                                        };
			parameters[0].Value = model.ID;
			parameters[1].Value = model.ClassName;
			parameters[2].Value = model.FatherID;
			parameters[3].Value = model.Summary;
			parameters[4].Value = model.SerialNumber;
            parameters[5].Value = model.ClassDirectory;
            parameters[6].Value = model.IndexTemplet;
            parameters[7].Value = model.ContentTemplet;
            parameters[8].Value = model.ListCount;
			DbHelperSQL.RunProcedure("Tb_ArticleClass_Update",parameters,out rowsAffected);
		}

		/// <summary>
		/// ɾһ
		/// </summary>
		public void Delete(int ID)
		{
			int rowsAffected;
			SqlParameter[] parameters = {
					new SqlParameter("@ID", SqlDbType.Int,4)};
			parameters[0].Value = ID;

			DbHelperSQL.RunProcedure("Tb_ArticleClass_Delete",parameters,out rowsAffected);
		}

		/// <summary>
		/// õһʵ
		/// </summary>
		public ZPY.Model.Tb_ArticleClass GetModel(int ID)
		{
            SqlParameter[] parameters = {
                    new SqlParameter("@ID", SqlDbType.Int,4)};
            parameters[0].Value = ID;

            ZPY.Model.Tb_ArticleClass model = new ZPY.Model.Tb_ArticleClass();
            DataSet ds = DbHelperSQL.RunProcedure("Tb_ArticleClass_GetModel", parameters, "ds");
            if (ds.Tables[0].Rows.Count > 0)
            {
                if (ds.Tables[0].Rows[0]["ID"].ToString() != "")
                {
                    model.ID = int.Parse(ds.Tables[0].Rows[0]["ID"].ToString());
                }
                model.ClassName = ds.Tables[0].Rows[0]["ClassName"].ToString();
                if (ds.Tables[0].Rows[0]["FatherID"].ToString() != "")
                {
                    model.FatherID = int.Parse(ds.Tables[0].Rows[0]["FatherID"].ToString());
                }
                model.Summary = ds.Tables[0].Rows[0]["Summary"].ToString();
                if (ds.Tables[0].Rows[0]["SerialNumber"].ToString() != "")
                {
                    model.SerialNumber = int.Parse(ds.Tables[0].Rows[0]["SerialNumber"].ToString());
                }
                model.ClassDirectory = ds.Tables[0].Rows[0]["ClassDirectory"].ToString();
                model.IndexTemplet = ds.Tables[0].Rows[0]["IndexTemplet"].ToString();
                model.ContentTemplet = ds.Tables[0].Rows[0]["ContentTemplet"].ToString();
                if (ds.Tables[0].Rows[0]["ListCount"].ToString() != "")
                {
                    model.ListCount = int.Parse(ds.Tables[0].Rows[0]["ListCount"].ToString());
                }
                return model;
            }
            else
            {
                return null;
            }

           
		}

		/// <summary>
		/// б
		/// </summary>
		public DataSet GetList(string strWhere)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select ID,ClassName,FatherID,Summary,SerialNumber,ClassDirectory,IndexTemplet,ContentTemplet,ListCount ");
			strSql.Append(" FROM Tb_ArticleClass ");
			if(strWhere.Trim()!="")
			{
				strSql.Append(" where "+strWhere);
			}
			return DbHelperSQL.Query(strSql.ToString());
		}

		/// <summary>
		/// ǰ
		/// </summary>
		public DataSet GetList(int Top,string strWhere,string filedOrder)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select ");
			if(Top>0)
			{
				strSql.Append(" top "+Top.ToString());
			}
			strSql.Append(" ID,ClassName,FatherID,Summary,SerialNumber,ClassDirectory,IndexTemplet,ContentTemplet,ListCount ");
			strSql.Append(" FROM Tb_ArticleClass ");
			if(strWhere.Trim()!="")
			{
				strSql.Append(" where "+strWhere);
			}
			strSql.Append(" order by " + filedOrder);
			return DbHelperSQL.Query(strSql.ToString());
		}

		/*
		/// <summary>
		/// ҳȡб
		/// </summary>
		public DataSet GetList(int PageSize,int PageIndex,string strWhere)
		{
			SqlParameter[] parameters = {
					new SqlParameter("@tblName", SqlDbType.VarChar, 255),
					new SqlParameter("@fldName", SqlDbType.VarChar, 255),
					new SqlParameter("@PageSize", SqlDbType.Int),
					new SqlParameter("@PageIndex", SqlDbType.Int),
					new SqlParameter("@IsReCount", SqlDbType.Bit),
					new SqlParameter("@OrderType", SqlDbType.Bit),
					new SqlParameter("@strWhere", SqlDbType.VarChar,1000),
					};
			parameters[0].Value = "Tb_ArticleClass";
			parameters[1].Value = "ID";
			parameters[2].Value = PageSize;
			parameters[3].Value = PageIndex;
			parameters[4].Value = 0;
			parameters[5].Value = 0;
			parameters[6].Value = strWhere;	
			return DbHelperSQL.RunProcedure("UP_GetRecordByPage",parameters,"ds");
		}*/

		#endregion  Ա
	}
}

