using System;
using System.Data;
using System.Text;
using System.Data.SqlClient;
using ZPY.IDAL;
using ZPY.DBUtility;//
namespace ZPY.SQLServerDAL
{
	/// <summary>
	/// ݷTb_ArticleComment
	/// </summary>
	public class Tb_ArticleComment:ITb_ArticleComment
	{
		public Tb_ArticleComment()
		{}
		#region  Ա

		/// <summary>
		/// õID
		/// </summary>
		public int GetMaxId()
		{
		return DbHelperSQL.GetMaxID("ID", "Tb_ArticleComment"); 
		}

		/// <summary>
		/// Ƿڸü¼
		/// </summary>
		public bool Exists(int ID)
		{
			int rowsAffected;
			SqlParameter[] parameters = {
					new SqlParameter("@ID", SqlDbType.Int,4)};
			parameters[0].Value = ID;

			int result= DbHelperSQL.RunProcedure("UP_Tb_ArticleComment_Exists",parameters,out rowsAffected);
			if(result==1)
			{
				return true;
			}
			else
			{
				return false;
			}
		}

		/// <summary>
		///  һ
		/// </summary>
		public void Add(ZPY.Model.Tb_ArticleComment model)
		{
			int rowsAffected;
			SqlParameter[] parameters = {
					new SqlParameter("@ID", SqlDbType.Int,4),
					new SqlParameter("@ArticleID", SqlDbType.Int,4),
					new SqlParameter("@UserName", SqlDbType.NVarChar,30),
					new SqlParameter("@UserIP", SqlDbType.NChar,40),
					new SqlParameter("@CommentTitle", SqlDbType.NVarChar,50),
					new SqlParameter("@CommentContent", SqlDbType.NVarChar,1000),
					new SqlParameter("@CommentTime", SqlDbType.DateTime)};
			parameters[0].Value = model.ID;
			parameters[1].Value = model.ArticleID;
			parameters[2].Value = model.UserName;
			parameters[3].Value = model.UserIP;
			parameters[4].Value = model.CommentTitle;
			parameters[5].Value = model.CommentContent;
			parameters[6].Value = model.CommentTime;

			DbHelperSQL.RunProcedure("UP_Tb_ArticleComment_ADD",parameters,out rowsAffected);
		}

		/// <summary>
		///  һ
		/// </summary>
		public void Update(ZPY.Model.Tb_ArticleComment model)
		{
			int rowsAffected;
			SqlParameter[] parameters = {
					new SqlParameter("@ID", SqlDbType.Int,4),
					new SqlParameter("@ArticleID", SqlDbType.Int,4),
					new SqlParameter("@UserName", SqlDbType.NVarChar,30),
					new SqlParameter("@UserIP", SqlDbType.NChar,40),
					new SqlParameter("@CommentTitle", SqlDbType.NVarChar,50),
					new SqlParameter("@CommentContent", SqlDbType.NVarChar,1000),
					new SqlParameter("@CommentTime", SqlDbType.DateTime)};
			parameters[0].Value = model.ID;
			parameters[1].Value = model.ArticleID;
			parameters[2].Value = model.UserName;
			parameters[3].Value = model.UserIP;
			parameters[4].Value = model.CommentTitle;
			parameters[5].Value = model.CommentContent;
			parameters[6].Value = model.CommentTime;

			DbHelperSQL.RunProcedure("UP_Tb_ArticleComment_Update",parameters,out rowsAffected);
		}

		/// <summary>
		/// ɾһ
		/// </summary>
		public void Delete(int ID)
		{
			int rowsAffected;
			SqlParameter[] parameters = {
					new SqlParameter("@ID", SqlDbType.Int,4)};
			parameters[0].Value = ID;

			DbHelperSQL.RunProcedure("UP_Tb_ArticleComment_Delete",parameters,out rowsAffected);
		}

		/// <summary>
		/// õһʵ
		/// </summary>
		public ZPY.Model.Tb_ArticleComment GetModel(int ID)
		{
			SqlParameter[] parameters = {
					new SqlParameter("@ID", SqlDbType.Int,4)};
			parameters[0].Value = ID;

			ZPY.Model.Tb_ArticleComment model=new ZPY.Model.Tb_ArticleComment();
			DataSet ds= DbHelperSQL.RunProcedure("UP_Tb_ArticleComment_GetModel",parameters,"ds");
			if(ds.Tables[0].Rows.Count>0)
			{
				if(ds.Tables[0].Rows[0]["ID"].ToString()!="")
				{
					model.ID=int.Parse(ds.Tables[0].Rows[0]["ID"].ToString());
				}
				if(ds.Tables[0].Rows[0]["ArticleID"].ToString()!="")
				{
					model.ArticleID=int.Parse(ds.Tables[0].Rows[0]["ArticleID"].ToString());
				}
				model.UserName=ds.Tables[0].Rows[0]["UserName"].ToString();
				model.UserIP=ds.Tables[0].Rows[0]["UserIP"].ToString();
				model.CommentTitle=ds.Tables[0].Rows[0]["CommentTitle"].ToString();
				model.CommentContent=ds.Tables[0].Rows[0]["CommentContent"].ToString();
				if(ds.Tables[0].Rows[0]["CommentTime"].ToString()!="")
				{
					model.CommentTime=DateTime.Parse(ds.Tables[0].Rows[0]["CommentTime"].ToString());
				}
				return model;
			}
			else
			{
				return null;
			}
		}

		/// <summary>
		/// б
		/// </summary>
		public DataSet GetList(string strWhere)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select ID,ArticleID,UserName,UserIP,CommentTitle,CommentContent,CommentTime ");
			strSql.Append(" FROM Tb_ArticleComment ");
			if(strWhere.Trim()!="")
			{
				strSql.Append(" where "+strWhere);
			}
			return DbHelperSQL.Query(strSql.ToString());
		}

		/// <summary>
		/// ǰ
		/// </summary>
		public DataSet GetList(int Top,string strWhere,string filedOrder)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select ");
			if(Top>0)
			{
				strSql.Append(" top "+Top.ToString());
			}
			strSql.Append(" ID,ArticleID,UserName,UserIP,CommentTitle,CommentContent,CommentTime ");
			strSql.Append(" FROM Tb_ArticleComment ");
			if(strWhere.Trim()!="")
			{
				strSql.Append(" where "+strWhere);
			}
			strSql.Append(" order by " + filedOrder);
			return DbHelperSQL.Query(strSql.ToString());
		}

		/*
		/// <summary>
		/// ҳȡб
		/// </summary>
		public DataSet GetList(int PageSize,int PageIndex,string strWhere)
		{
			SqlParameter[] parameters = {
					new SqlParameter("@tblName", SqlDbType.VarChar, 255),
					new SqlParameter("@fldName", SqlDbType.VarChar, 255),
					new SqlParameter("@PageSize", SqlDbType.Int),
					new SqlParameter("@PageIndex", SqlDbType.Int),
					new SqlParameter("@IsReCount", SqlDbType.Bit),
					new SqlParameter("@OrderType", SqlDbType.Bit),
					new SqlParameter("@strWhere", SqlDbType.VarChar,1000),
					};
			parameters[0].Value = "Tb_ArticleComment";
			parameters[1].Value = "ID";
			parameters[2].Value = PageSize;
			parameters[3].Value = PageIndex;
			parameters[4].Value = 0;
			parameters[5].Value = 0;
			parameters[6].Value = strWhere;	
			return DbHelperSQL.RunProcedure("UP_GetRecordByPage",parameters,"ds");
		}*/

		#endregion  Ա
	}
}

