using System;
using System.Data;
using System.Text;
using System.Data.SqlClient;
using ZPY.IDAL;
using ZPY.DBUtility;//
namespace ZPY.SQLServerDAL
{
	/// <summary>
	/// ݷTb_User
	/// </summary>
	public class Tb_User:ITb_User
	{
		public Tb_User()
		{}
		#region  Ա

		/// <summary>
		/// Ƿڸü¼
		/// </summary>
		public bool Exists(string UserID)
		{
			int rowsAffected;
			SqlParameter[] parameters = {
					new SqlParameter("@UserID", SqlDbType.NVarChar,50)};
			parameters[0].Value = UserID;

			int result= DbHelperSQL.RunProcedure("UP_Tb_User_Exists",parameters,out rowsAffected);
			if(result==1)
			{
				return true;
			}
			else
			{
				return false;
			}
		}

		/// <summary>
		///  һ
		/// </summary>
		public void Add(ZPY.Model.Tb_User model)
		{
			int rowsAffected;
			SqlParameter[] parameters = {
					new SqlParameter("@UserID", SqlDbType.NVarChar,30),
					new SqlParameter("@UserName", SqlDbType.NVarChar,30),
					new SqlParameter("@Password", SqlDbType.NVarChar,100),
					new SqlParameter("@RegisterTime", SqlDbType.DateTime),
					new SqlParameter("@RegisterIP", SqlDbType.NVarChar,40)};
			parameters[0].Value = model.UserID;
			parameters[1].Value = model.UserName;
			parameters[2].Value = model.Password;
			parameters[3].Value = model.RegisterTime;
			parameters[4].Value = model.RegisterIP;

			DbHelperSQL.RunProcedure("UP_Tb_User_ADD",parameters,out rowsAffected);
		}

		/// <summary>
		///  һ
		/// </summary>
		public void Update(ZPY.Model.Tb_User model)
		{
			int rowsAffected;
			SqlParameter[] parameters = {
					new SqlParameter("@UserID", SqlDbType.NVarChar,30),
					new SqlParameter("@UserName", SqlDbType.NVarChar,30),
					new SqlParameter("@Password", SqlDbType.NVarChar,100),
					new SqlParameter("@RegisterTime", SqlDbType.DateTime),
					new SqlParameter("@RegisterIP", SqlDbType.NVarChar,40)};
			parameters[0].Value = model.UserID;
			parameters[1].Value = model.UserName;
			parameters[2].Value = model.Password;
			parameters[3].Value = model.RegisterTime;
			parameters[4].Value = model.RegisterIP;

			DbHelperSQL.RunProcedure("UP_Tb_User_Update",parameters,out rowsAffected);
		}

		/// <summary>
		/// ɾһ
		/// </summary>
		public void Delete(string UserID)
		{
			int rowsAffected;
			SqlParameter[] parameters = {
					new SqlParameter("@UserID", SqlDbType.NVarChar,50)};
			parameters[0].Value = UserID;

			DbHelperSQL.RunProcedure("UP_Tb_User_Delete",parameters,out rowsAffected);
		}

		/// <summary>
		/// õһʵ
		/// </summary>
		public ZPY.Model.Tb_User GetModel(string UserID)
		{
			SqlParameter[] parameters = {
					new SqlParameter("@UserID", SqlDbType.NVarChar,50)};
			parameters[0].Value = UserID;

			ZPY.Model.Tb_User model=new ZPY.Model.Tb_User();
			DataSet ds= DbHelperSQL.RunProcedure("UP_Tb_User_GetModel",parameters,"ds");
			if(ds.Tables[0].Rows.Count>0)
			{
				model.UserID=ds.Tables[0].Rows[0]["UserID"].ToString();
				model.UserName=ds.Tables[0].Rows[0]["UserName"].ToString();
				model.Password=ds.Tables[0].Rows[0]["Password"].ToString();
				if(ds.Tables[0].Rows[0]["RegisterTime"].ToString()!="")
				{
					model.RegisterTime=DateTime.Parse(ds.Tables[0].Rows[0]["RegisterTime"].ToString());
				}
				model.RegisterIP=ds.Tables[0].Rows[0]["RegisterIP"].ToString();
				return model;
			}
			else
			{
				return null;
			}
		}

		/// <summary>
		/// б
		/// </summary>
		public DataSet GetList(string strWhere)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select UserID,UserName,Password,RegisterTime,RegisterIP ");
			strSql.Append(" FROM Tb_User ");
			if(strWhere.Trim()!="")
			{
				strSql.Append(" where "+strWhere);
			}
			return DbHelperSQL.Query(strSql.ToString());
		}

		/// <summary>
		/// ǰ
		/// </summary>
		public DataSet GetList(int Top,string strWhere,string filedOrder)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select ");
			if(Top>0)
			{
				strSql.Append(" top "+Top.ToString());
			}
			strSql.Append(" UserID,UserName,Password,RegisterTime,RegisterIP ");
			strSql.Append(" FROM Tb_User ");
			if(strWhere.Trim()!="")
			{
				strSql.Append(" where "+strWhere);
			}
			strSql.Append(" order by " + filedOrder);
			return DbHelperSQL.Query(strSql.ToString());
		}

		/*
		/// <summary>
		/// ҳȡб
		/// </summary>
		public DataSet GetList(int PageSize,int PageIndex,string strWhere)
		{
			SqlParameter[] parameters = {
					new SqlParameter("@tblName", SqlDbType.VarChar, 255),
					new SqlParameter("@fldName", SqlDbType.VarChar, 255),
					new SqlParameter("@PageSize", SqlDbType.Int),
					new SqlParameter("@PageIndex", SqlDbType.Int),
					new SqlParameter("@IsReCount", SqlDbType.Bit),
					new SqlParameter("@OrderType", SqlDbType.Bit),
					new SqlParameter("@strWhere", SqlDbType.VarChar,1000),
					};
			parameters[0].Value = "Tb_User";
			parameters[1].Value = "ID";
			parameters[2].Value = PageSize;
			parameters[3].Value = PageIndex;
			parameters[4].Value = 0;
			parameters[5].Value = 0;
			parameters[6].Value = strWhere;	
			return DbHelperSQL.RunProcedure("UP_GetRecordByPage",parameters,"ds");
		}*/

		#endregion  Ա
	}
}

