﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

namespace WebForm.Manage.BasicSet
{
    public partial class MakeHtml : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {

        }

        public string shortStr(string str,int length)
        {
            str = str.Length > length ? str.Substring(0, length) : str;
            return str;
        
        }

       /// <summary>
       /// 生成静态首页
       /// </summary>
       /// <param name="sender"></param>
       /// <param name="e"></param>
        protected void Button_Index_Click(object sender, EventArgs e)
        {
            BaseFunction.XmlControl xlmControl = new WebForm.BaseFunction.XmlControl("/XML/BasicSet.xml");
            string templetPath = xlmControl.GetXmlNodeValue("/basicSet/indexTemplet");//得到首页模板路径
            string tempContent = ZPY.Common.DirFile.ReadFile(templetPath);//读取列表页面的模板内容
            ZPY.BLL.Tb_ArticleClass bll_tb_articleclass = new ZPY.BLL.Tb_ArticleClass();
            DataSet ds = bll_tb_articleclass.GetList(" 1=1 Order by SerialNumber desc");
            int rowCount = ds.Tables[0].Rows.Count;
            DataRow[] drs = ds.Tables[0].Select();
            string subContent = "";
            ZPY.BLL.Tb_Article bll_tb_article = new ZPY.BLL.Tb_Article();
            for (int i = 1; i <= rowCount; i++)
            {
                if (i % 2 == 1)//栏目内容显示在左边
                {
                    subContent += "<div class=\"index_left\">\r";
                   
                }
                else//栏目内容显示在右边
                {
                    subContent += "<div class=\"index_right\">\r";                 
                  
                }

                subContent += " <div class=\"index_title\">" + drs[i - 1]["ClassName"].ToString() + "</div>\r <div class=\"index_content\">\r <p> ";
                int classID = int.Parse(drs[i - 1]["ID"].ToString());
                DataSet ds2 = bll_tb_article.GetList(7, "IsPass=1 and ClassID=" + classID, "AddTime Desc");
                //取得栏目视图的地址
                DataSet dsImage = bll_tb_article.GetList(1, "IsPass=1 and ClassID=" + classID + " and DefaultImage<>''", "AddTime Desc");

                if (dsImage.Tables[0].Rows.Count > 0)
                {
                    string imageUrl = dsImage.Tables[0].Rows[0]["DefaultImage"].ToString();
                    string imageTitle = dsImage.Tables[0].Rows[0]["Title"].ToString();
                    subContent += "<img class=\"leftalign\" src=\"" + imageUrl + "\" alt=\"" + imageTitle + "\" />";

                }
                else
                {
                    subContent += "<img class=\"leftalign\" src=\"/Images/img3.jpg\" alt=\"暂无栏目视图\" />";
                }

                foreach (DataRow dr in ds2.Tables[0].Rows)
                {
                    subContent += "&nbsp;<img src=\"Images/Tx_Ar4.gif\">&nbsp;<a href=\"/" + dr["SavePath"].ToString() + dr["FileName"] + dr["FileEXName"] + "\" title=\"" + dr["Title"].ToString() + "\" target=\"_blank\">" + shortStr(dr["Title"].ToString(), 19) + "</a></br>\r";
                }
                subContent += "\r</p> \r</div>\r </div> ";
                if (i % 2 == 0)
                {
                    subContent += " \r<div  class=\"clear\"></div> ";
                }
                
            }
            tempContent = tempContent.Replace("{$IndexMainSub$}",subContent);
            tempContent = tempContent.Replace("{$WebSiteKeyWords$}", xlmControl.GetXmlNodeValue("/basicSet/webSiteKeyWord"));
            tempContent = tempContent.Replace("{$WebSiteDescription$}", xlmControl.GetXmlNodeValue("/basicSet/webSiteDescription"));
            tempContent = tempContent.Replace("{$Head$}", "首页 - "+xlmControl.GetXmlNodeValue("/basicSet/webSiteName"));

            tempContent = MenuBuild(tempContent);//菜单生成
            string saveClassListHtmlPath = "/index.html";
            ZPY.Common.DirFile.CreateFile(saveClassListHtmlPath, tempContent);
            ZPY.Common.PublicFc.Show(this,"恭喜，生成网站静态首页成功！");
        }

        /// <summary>
        /// 菜单生成
        /// </summary>
        private string MenuBuild(string str)
        {
            ZPY.BLL.Tb_ArticleClass bll_tb_ac = new ZPY.BLL.Tb_ArticleClass();
            DataSet ds = bll_tb_ac.GetList("1=1 order by SerialNumber Desc");
            string menuStr = "";
            foreach (DataRow dr in ds.Tables[0].Rows)
            {
                menuStr += " <li><a href=\"/news/"+dr["ClassDirectory"].ToString()+"/list_1.html\">" + dr["ClassName"].ToString() +"</a></li>";
            
            }
            str = str.Replace("{$MenuList$}",menuStr);
            return str;
        }
    }
}
