﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

namespace WebForm.Manage.BasicSet
{
    public partial class WebSiteSet : System.Web.UI.Page
    {
        BaseFunction.XmlControl xmlControl = new WebForm.BaseFunction.XmlControl("/XML/BasicSet.xml");
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                
                TextBox_WebSiteName.Text = xmlControl.GetXmlNodeValue("/basicSet/webSiteName");
                TextBox_KeyWords.Text = xmlControl.GetXmlNodeValue("/basicSet/webSiteKeyWord");
                TextBox_WebSiteDescription.Text = xmlControl.GetXmlNodeValue("/basicSet/webSiteDescription");
                TextBox_IndexTemplet.Text = xmlControl.GetXmlNodeValue("/basicSet/indexTemplet");
                CheckBox_IsClose.Checked = xmlControl.GetXmlNodeValue("/basicSet/isClose") == "0" ? false : true;
                TextBox_CloseDescription.Text = xmlControl.GetXmlNodeValue("/basicSet/closeDescription");
            }
        }
        /// <summary>
        /// 保存设置
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void Button_Save_Click(object sender, EventArgs e)
        {
            xmlControl.SetXmlNodeValue("/basicSet/webSiteName", TextBox_WebSiteName.Text.Trim());
            xmlControl.SetXmlNodeValue("/basicSet/webSiteKeyWord", TextBox_KeyWords.Text);
            xmlControl.SetXmlNodeValue("/basicSet/webSiteDescription", TextBox_WebSiteDescription.Text);
            xmlControl.SetXmlNodeValue("/basicSet/indexTemplet", TextBox_IndexTemplet.Text);
            xmlControl.SetXmlNodeValue("/basicSet/isClose", CheckBox_IsClose.Checked ? "1" : "0");
            xmlControl.SetXmlNodeValue("/basicSet/webSiteKeyWord", TextBox_CloseDescription.Text);
            Label_Message.Text = "保存成功！";
        }
    }
}
