﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Text;
/* 
 *创建时间：2009/09/17
 *创建人：邹培扬
 *联系QQ：595955182
 *联系Email：zpy333@163.com
 */
namespace WebForm.Manage.NewsManage
{
    public partial class NewsClass_List : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                if (Request.QueryString["action"] != null)
                {
                   
                    int delID = int.Parse(Request.QueryString["classID"].ToString());
                    DelID(delID);//删除
                    ZPY.Common.PublicFc.Show(this, "删除成功！");                 
                }
                Repeater_NewsClass_List_DataBind();
            }

        }

        /// <summary>
        /// 删除某个ID值的类别
        /// </summary>
        /// <param name="id"></param>
        protected void DelID(int id)
        {
            ZPY.BLL.Tb_ArticleClass bll_tb_ac = new ZPY.BLL.Tb_ArticleClass();
            if (bll_tb_ac.GetList("FatherID=" + id).Tables[0].Rows.Count > 0)
            {
                ZPY.Common.PublicFc.Show(this, "存在子类别，请先删除子类别！");
                return;
            }
            bll_tb_ac.Delete(id);//51aspx
        
        }
        /// <summary>
        /// 把所有要显示的列表行放在单独的一个字段列里面
        /// </summary>
        protected void Repeater_NewsClass_List_DataBind()
        {
            ZPY.BLL.Tb_ArticleClass bll_tb_articleClass = new ZPY.BLL.Tb_ArticleClass();
            DataTable dt = bll_tb_articleClass.GetAllList().Tables[0];


            if (dt != null)
            {
                dt.Columns.Add("Operate", typeof(string));//操作
                dt.Columns.Add("Colum",typeof(String));//在dt中增加字段名为Colum的列
                DataRow[] drs = dt.Select("FatherID=0");
                foreach (DataRow dr in drs)
                {
                    string strchar = null;
                    string classID = dr["ID"].ToString();
                    dr["operate"] = "<a href=\"NewsClass_Add.aspx?action=modify&classID=" + classID + "\"  class=\"list_link\" title=\"修改此项\"><img src=\"../../sysImages/default/sysico/edit.gif\" border=\"0\" alt=\"修改此项\" /></a><a href=\"NewsClass_List.aspx?action=delone_class&classID=" + classID + "\"  class=\"list_link\" title=\"删除此项\" onclick=\"{if(confirm('确认删除吗？')){return true;}return false;}\"><img src=\"../../sysImages/default/sysico/del.gif\" border=\"0\" alt=\"删除此项\" /></a><input type='checkbox' name='define_checkbox' id='define_checkbox' value=\"" + classID + "\"/>";
                    #region 列表
                    strchar += "<tr class=\"TR_BG_list\" onmouseover=\"this.style.backgroundColor='#BEFBD1'\" onmouseout=\"this.style.backgroundColor='#FFFFFF'\">";
                    strchar += "<td width=\"30%\" align=\"left\" valign=\"middle\">" + dr["ClassName"] + "</td>";
                    strchar += "<td align=\"center\" valign=\"middle\" >" + dr["ClassDirectory"].ToString() + "</td>";
                    strchar += "<td align=\"center\" valign=\"middle\" >" + dr["SerialNumber"].ToString() + "</td>";
                    strchar += "<td align=\"center\" valign=\"middle\" >" + dr["Operate"].ToString() + "</td>";
                    strchar += "</tr>";
                    strchar += GetChildList(dt, classID, "┝");
                    dr["Colum"] = strchar;
                    #endregion
                   
                }
            }


            Repeater_NewsClass_List.DataSource = dt;//5*1*a*s*p*x
            Repeater_NewsClass_List.DataBind();
        }

        #region 递归

        string GetChildList(DataTable dt,string Classid, string sign)
        {
            String strchar = null;
            DataRow[] drs = dt.Select("FatherID="+Classid);
            sign += "┉";
          
            foreach (DataRow dr in drs)
            {
                //51(aspx)
                string classID = dr["ID"].ToString();
                dr["operate"] = "<a href=\"NewsClass_Add.aspx?action=modify&classID=" + classID + "\"  class=\"list_link\" title=\"修改此项\"><img src=\"../../sysImages/default/sysico/edit.gif\" border=\"0\" alt=\"修改此项\" /></a><a href=\"NewsClass_List.aspx?action=delone_class&classID=" + classID + "\"  class=\"list_link\" title=\"删除此项\" onclick=\"{if(confirm('确认删除吗？')){return true;}return false;}\"><img src=\"../../sysImages/default/sysico/del.gif\" border=\"0\" alt=\"删除此项\" /></a><input type='checkbox' name='define_checkbox' id='define_checkbox' value=\"" + classID + "\"/>";
                #region 列表
                strchar += "<tr class=\"TR_BG_list\" onmouseover=\"this.style.backgroundColor='#BEFBD1'\" onmouseout=\"this.style.backgroundColor='#FFFFFF'\">";
                strchar += "<td width=\"30%\" align=\"left\" valign=\"middle\">" + sign + dr["ClassName"] + "</td>";
                strchar += "<td align=\"center\" valign=\"middle\" >" + dr["ClassDirectory"].ToString() + "</td>";
                strchar += "<td align=\"center\" valign=\"middle\" >" + dr["SerialNumber"].ToString() + "</td>";
                strchar += "<td align=\"center\" valign=\"middle\" >" + dr["Operate"].ToString() + "</td>";
                strchar += "</tr>";
                strchar += GetChildList(dt, classID, sign);
               
                #endregion
              
            }

            return strchar;
           
        }
        #endregion

        #region 删除所选
        protected void DelP_Click(object sender, EventArgs e)
        {
            string define_checkbox = Request.Form["define_checkbox"];
            if (define_checkbox == null || define_checkbox == String.Empty)
            {
                ZPY.Common.PublicFc.Show(this,"请选择批量删除的选项！");
                return;
            }
            else
            {
                String[] CheckboxArray = define_checkbox.Split(',');
                define_checkbox = null;
                for (int i = 0; i < CheckboxArray.Length; i++)
                {
                    DelID(int.Parse(CheckboxArray[i]));
                }
                ZPY.Common.PublicFc.Show(this, "恭喜，删除成功！");
            }
            Repeater_NewsClass_List_DataBind();
        }
        #endregion

        #region 生成各新闻类别的静态列表页面
        /// <summary>
        /// 生成各新闻类别的静态列表页面
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void LinkButton_MarkHtml_Click(object sender, EventArgs e)
        {
            string define_checkbox = Request.Form["define_checkbox"];
            if (define_checkbox == null || define_checkbox == String.Empty)
            {
                ZPY.Common.PublicFc.Show(this, "请选择批量生成静态列表的选项！");
                return;
            }
            else
            {
                String[] CheckboxArray = define_checkbox.Split(',');
                define_checkbox = null;
                for (int i = 0; i < CheckboxArray.Length; i++)
                {
                     MakeClassListHtml(int.Parse(CheckboxArray[i]));
                }
                ZPY.Common.PublicFc.Show(this, "恭喜，生成静态列表页面成功！");
            }
        }

        /// <summary>
        /// 根据类别ID生成该类别的静态列表页面
        /// </summary>
        /// <param name="classID">类别ID</param>
        protected void MakeClassListHtml(int classID)
        {
            ZPY.BLL.Tb_ArticleClass bll_tb_articleclass = new ZPY.BLL.Tb_ArticleClass();
            ZPY.Model.Tb_ArticleClass model_tb_articleclass = bll_tb_articleclass.GetModel(classID);
            string classDirectory = model_tb_articleclass.ClassDirectory;//得到类别目录
            string className = model_tb_articleclass.ClassName;
            classDirectory = "news/" + classDirectory;
            int pageSize = model_tb_articleclass.ListCount;//读取页面的新闻条数
            pageSize = (pageSize < 0 ? 20 : pageSize);
            string templetPath = model_tb_articleclass.IndexTemplet;//得到列表页面的模板路径


            BaseFunction.XmlControl xlmControl = new WebForm.BaseFunction.XmlControl("/XML/BasicSet.xml");
            ZPY.BLL.Tb_Article bll_tb_article = new ZPY.BLL.Tb_Article();
            DataSet ds = bll_tb_article.GetList("ClassID="+classID);
            DataTable dt = ds.Tables[0];
            int pageCount = dt.Rows.Count % pageSize == 0 ? dt.Rows.Count / pageSize : dt.Rows.Count / pageSize + 1;//得到分页的数量
            //生成每一个分页
            for (int i = 1; i <= pageCount; i++)
            {
                string tempContent = ZPY.Common.DirFile.ReadFile(templetPath);//读取列表页面的模板内容
                string pageTitle = className + " - " +xlmControl.GetXmlNodeValue("/basicSet/webSiteName");
                tempContent = tempContent.Replace("{$ClassName$}", className);
                tempContent = tempContent.Replace("{$Head$}", pageTitle);
                string saveClassListHtmlPath = classDirectory + "/list_"+i.ToString()+".html";//得到分页保存的路径和文件名
                string filedOrder = "AddTime Desc";
                string strWhere = " ClassID=" + classID + " and ID not in (Select top " + (i - 1).ToString() + " ID from Tb_Article where ClassID=" + classID.ToString() + " order by "+filedOrder+") ";
                DataSet dataSet = bll_tb_article.GetList(pageSize, strWhere, filedOrder);
                string listStr = "";
                foreach (DataRow dr in dataSet.Tables[0].Rows)
                {
                    string newPath = "../../" + dr["SavePath"].ToString() + dr["FileName"].ToString() + dr["FileExName"].ToString();
                    listStr += "<li><a href=\"" + newPath + "\" target='_blank'>" + dr["Title"].ToString() + "</a>&nbsp;&nbsp;&nbsp;&nbsp;" + System.DateTime.Parse(dr["AddTime"].ToString()).ToShortDateString() + "</li>\r";
                }
                listStr = listStr == "" ? "暂无内容" : listStr;
                tempContent = tempContent.Replace("{$ClassList$}",listStr);
                tempContent = tempContent.Replace("{$Pagination$}", GetHtmlPager(pageCount, i, "./list_", ".html"));

                //生成左边的推荐列表
                DataTable dt_left = bll_tb_article.GetList(8, "ClassID="+classID+"and IsTop=1", "AddTime desc").Tables[0];
                string hotNewsList = null;
                foreach (DataRow dr in dt_left.Rows)
                {
                    string newPath = "../../" + dr["SavePath"].ToString() + dr["FileName"].ToString() + dr["FileExName"].ToString();
                    string newTitle = dr["Title"].ToString().Length > 18 ? dr["Title"].ToString().Substring(0, 18) : dr["Title"].ToString();
                    hotNewsList += "<li><a href=\"/" + newPath + "\" target='_blank' title='" + dr["Title"].ToString() + "'>" + newTitle + "</a></li>";
                }

                tempContent = tempContent.Replace("{$HotNews$}", hotNewsList);
              
                tempContent = tempContent.Replace("{$WebSiteKeyWords$}", xlmControl.GetXmlNodeValue("/basicSet/webSiteKeyWord"));
                tempContent = tempContent.Replace("{$WebSiteDescription$}", xlmControl.GetXmlNodeValue("/basicSet/webSiteDescription"));
                tempContent = MenuBuild(tempContent);
                ZPY.Common.DirFile.CreateFile(saveClassListHtmlPath, tempContent);
            }

           

        }

        /// <summary>
        /// 菜单生成
        /// </summary>
        private string MenuBuild(string str)
        {
            ZPY.BLL.Tb_ArticleClass bll_tb_ac = new ZPY.BLL.Tb_ArticleClass();
            DataSet ds = bll_tb_ac.GetList("1=1 order by SerialNumber Desc");
            string menuStr = "";
            foreach (DataRow dr in ds.Tables[0].Rows)
            {
                menuStr += " <li><a href=\"/news/" + dr["ClassDirectory"].ToString() + "/list_1.html\">" + dr["ClassName"].ToString() + "</a></li>";

            }
            str = str.Replace("{$MenuList$}", menuStr);
            return str;
        }

        /// <summary>
        /// 写出分页
        /// </summary>
        /// <param name="pageCount">页数</param>
        /// <param name="currentPage">当前页</param>
        /// <returns></returns>
        public static string GetHtmlPager(int pageCount, int currentPage, string prefix, string suffix)
        {
            int stepNum = 4;
            int pageRoot = 1;
            pageCount = pageCount == 0 ? 1 : pageCount;
            currentPage = currentPage == 0 ? 1 : currentPage;

            StringBuilder sb = new StringBuilder();
            sb.Append("<table cellpadding=0 cellspacing=1 class=\"pager\">\r<tr>\r");
            sb.Append("<td class=pagerTitle>&nbsp;分页&nbsp;</td>\r");
            sb.Append("<td class=pagerTitle>&nbsp;" + currentPage.ToString() + "/" + pageCount.ToString() + "&nbsp;</td>\r");
            if (currentPage - stepNum < 2)
                pageRoot = 1;
            else
                pageRoot = currentPage - stepNum;
            int pageFoot = pageCount;
            if (currentPage + stepNum >= pageCount)
                pageFoot = pageCount;
            else
                pageFoot = currentPage + stepNum;
            if (pageRoot == 1)
            {
                if (currentPage > 1)
                {
                    sb.Append("<td>&nbsp;<a href='" + prefix + "1" + suffix + "' title='首页'>首页</a>&nbsp;</td>\r");
                    sb.Append("<td>&nbsp;<a href='" + prefix + Convert.ToString(currentPage - 1) + suffix + "' title='上页'>上页</a>&nbsp;</td>\r");
                }
            }
            else
            {
                sb.Append("<td>&nbsp;<a href='" + prefix + "1" + suffix + "' title='首页'>首页</a>&nbsp;</td>");
                sb.Append("<td>&nbsp;<a href='" + prefix + Convert.ToString(currentPage - 1) + suffix + "' title='上页'>上页</a>&nbsp;</td>\r");
            }
            for (int i = pageRoot; i <= pageFoot; i++)
            {
                if (i == currentPage)
                {
                    sb.Append("<td class='current'>&nbsp;" + i.ToString() + "&nbsp;</td>\r");
                }
                else
                {
                    sb.Append("<td>&nbsp;<a href='" + prefix + i.ToString() + suffix + "' title='第" + i.ToString() + "页'>" + i.ToString() + "</a>&nbsp;</td>\r");
                }
                if (i == pageCount)
                    break;
            }
            if (pageFoot == pageCount)
            {
                if (pageCount > currentPage)
                {
                    sb.Append("<td>&nbsp;<a href='" + prefix + Convert.ToString(currentPage + 1) + suffix + "' title='下页'>下页</a>&nbsp;</td>\r");
                    sb.Append("<td>&nbsp;<a href='" + prefix + pageCount.ToString() + suffix + "' title='尾页'>尾页</a>&nbsp;</td>\r");
                }
            }
            else
            {
                sb.Append("<td>&nbsp;<a href='" + prefix + Convert.ToString(currentPage + 1) + suffix + "' title='下页'>下页</a>&nbsp;</td>\r");
                sb.Append("<td>&nbsp;<a href='" + prefix + pageCount.ToString() + suffix + "' title='尾页'>尾页</a>&nbsp;</td>\r");
            }
            sb.Append("</tr>\r</table>");
            return sb.ToString();
        }
        #endregion
    }
}
