﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.IO;

namespace WebForm.Manage.NewsManage
{
    public partial class News_Add : System.Web.UI.Page
    {
      
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                DropDownList_ArticleClass_DataBind();
                if (Request.QueryString["action"] != null)
                {
                    string action = Request.QueryString["action"].ToString();
                    if (action == "modify")
                    {
                        int modID = int.Parse(Request.QueryString["ID"].ToString());
                        ZPY.BLL.Tb_Article bll_tb_ac = new ZPY.BLL.Tb_Article();
                        ZPY.Model.Tb_Article model_tb_ac = bll_tb_ac.GetModel(modID);
                        TextBox_Title.Text = model_tb_ac.Title;
                        TextBox_Author.Text = model_tb_ac.Author;
                        DropDownList_ArticleClass.SelectedValue = model_tb_ac.ClassID.ToString();
                        TextBox_DefaultPic.Text = model_tb_ac.DefaultImage;
                        CheckBox_IsTop.Checked = model_tb_ac.IsTop;
                        CheckBox_IsPass.Checked = model_tb_ac.IsPass;
                        TextBox_Hits.Text = model_tb_ac.Hits.ToString();
                        txtContent.Value = model_tb_ac.Content;
                        TextBox_Source.Text = model_tb_ac.Source;
                        ViewState["AddTime"] = model_tb_ac.AddTime;
                        ViewState["SavePath"] = model_tb_ac.FileName;
                        ViewState["FileName"] = model_tb_ac.SavePath;
                        ViewState["FileExName"] = model_tb_ac.FileExName;
                        ViewState["modifyID"] = modID;
                        Button_Save.Text = "保存修改";

                    }
                }
            }
        }

        /// <summary>
        /// 新闻类别绑定
        /// </summary>
        private void DropDownList_ArticleClass_DataBind()
        {
            ZPY.BLL.Tb_ArticleClass bll_tb_articleclass = new ZPY.BLL.Tb_ArticleClass();
            DataSet ds = bll_tb_articleclass.GetAllList();
            DataTable dt = ds.Tables[0];
            ZPY.Common.PublicFc.DropList_Bind(dt, DropDownList_ArticleClass);
            DropDownList_ArticleClass.Items.RemoveAt(0);//去掉了第一个类别即根类别
        
        }

        /// <summary>
        /// 保存新闻
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void Button_Save_Click(object sender, EventArgs e)
        {
            string classID = DropDownList_ArticleClass.SelectedValue;
           
            ZPY.BLL.Tb_ArticleClass bll_tb_articleclass = new ZPY.BLL.Tb_ArticleClass();
            ZPY.Model.Tb_ArticleClass model_tb_articleclass = bll_tb_articleclass.GetModel(int.Parse(classID));
            string classDiretory = model_tb_articleclass.ClassDirectory;//获得新闻对应的类别的目录
            string contentTemplet = model_tb_articleclass.ContentTemplet;//获得新闻内容静态模板
            string className = model_tb_articleclass.ClassName;
            string newTitle = TextBox_Title.Text;
            string author = TextBox_Author.Text;
           
            string defaultImage = TextBox_DefaultPic.Text;
            bool isTop = CheckBox_IsTop.Checked;
            bool isPass = CheckBox_IsPass.Checked;
            string hit = TextBox_Hits.Text;//51aspx
            string content = txtContent.Value;//51aspx
            string source = TextBox_Source.Text;
            string newComment ="0";
            DateTime addTime = DateTime.Now;
           
            string savePath = "news/"+classDiretory+"/" + ZPY.Common.DirFile.GetDateDir() + "/";
            string fileName =ZPY.Common.DirFile.GetDateFile();
            string fileEXName = ".html";
            string sff = savePath + fileName + fileEXName;

         

           #region 写入数据库
            ZPY.Model.Tb_Article model_tb_article = new ZPY.Model.Tb_Article();
            model_tb_article.Title = newTitle;
            model_tb_article.Author = author;
            model_tb_article.AddTime = DateTime.Now;
            model_tb_article.ClassID = int.Parse(classID);
            model_tb_article.DefaultImage = defaultImage;
            model_tb_article.IsTop = isTop;
            model_tb_article.IsPass = isPass;
            model_tb_article.Hits = int.Parse(hit);
            model_tb_article.Content = content;
            model_tb_article.Source = source;
            model_tb_article.Page_KeyWord = "";
            model_tb_article.Page_Title = "";
            model_tb_article.Page_Description = "";
            model_tb_article.SavePath = savePath;
            model_tb_article.FileName = fileName;
            model_tb_article.FileExName = fileEXName;
            ZPY.BLL.Tb_Article bll_tb_ac = new ZPY.BLL.Tb_Article();
            if (((Button)sender).Text == "保存修改")
            {
              
                model_tb_article.ID = int.Parse(ViewState["modifyID"].ToString());
                model_tb_article.SavePath = ViewState["SavePath"].ToString();
                model_tb_article.FileName = ViewState["FileName"].ToString();
                model_tb_article.FileExName = ViewState["FileExName"].ToString();
                model_tb_article.AddTime = (DateTime)ViewState["AddTime"];
                bll_tb_ac.Update(model_tb_article);
                sff = model_tb_article.SavePath + model_tb_article.FileName + model_tb_article.FileExName;
            }
            else
            {
                bll_tb_ac.Add(model_tb_article);
            }
            #endregion

            #region 进行静态生成
          
            string tempContent = ZPY.Common.DirFile.ReadFile(contentTemplet);//读取新闻模板内容
            tempContent = tempContent.Replace("{$NewTitle$}", newTitle);
            tempContent = tempContent.Replace("{$NewSource$}", source);
            tempContent = tempContent.Replace("{$NewAuthor$}", author);
            tempContent = tempContent.Replace("{$NewAddTime$}", addTime.ToString());
            tempContent = tempContent.Replace("{$NewHits$}", hit);
            tempContent = tempContent.Replace("{$NewComment$}", newComment);
            tempContent = tempContent.Replace("{$NewContent$}", content);
            tempContent = tempContent.Replace("{$ClassName$}", className);
            BaseFunction.XmlControl xlmControl = new WebForm.BaseFunction.XmlControl("/XML/BasicSet.xml");
            tempContent = tempContent.Replace("{$WebSiteKeyWords$}", xlmControl.GetXmlNodeValue("/basicSet/webSiteKeyWord"));
            tempContent = tempContent.Replace("{$WebSiteDescription$}", xlmControl.GetXmlNodeValue("/basicSet/webSiteDescription"));
            tempContent = tempContent.Replace("{$Head$}", newTitle + " - " + className + xlmControl.GetXmlNodeValue("/basicSet/webSiteName"));
            tempContent = MenuBuild(tempContent);//栏目菜单生成
            //新闻推荐列表生成
            DataTable dt = bll_tb_ac.GetList(8, "IsTop=1", "AddTime desc").Tables[0];
            string hotNewsList = null;
            foreach (DataRow dr in dt.Rows)
            {
                string newPath = "./" + dr["SavePath"].ToString() + dr["FileName"].ToString() + dr["FileExName"].ToString();
                string newsTitle = dr["Title"].ToString().Length > 18 ? dr["Title"].ToString().Substring(0, 18) : dr["Title"].ToString();
                hotNewsList += "<li><a href=\"/" + newPath + "\" title='" + dr["Title"].ToString() + "'>" + newsTitle + "</a></li>";
            }
            tempContent = tempContent.Replace("{$HotNews$}", hotNewsList);
            ZPY.Common.DirFile.CreateFile(sff, tempContent);
            #endregion 
            if (((Button)sender).Text == "保存修改")
            {
                ZPY.Common.PublicFc.Show(this,"修改成功！");
                Response.Redirect("News_List.aspx");
            }
            if (CheckBox_Again.Checked)
            {
                Label_Message.Text = "恭喜您，保存成功并创建静态页面成功！";
            }
            else
            {
                ZPY.Common.PublicFc.Show(this, "添加成功！");
                Response.Redirect("News_List.aspx");
            }
           
        }

        /// <summary>
        /// 菜单生成
        /// </summary>
        private string MenuBuild(string str)
        {
            ZPY.BLL.Tb_ArticleClass bll_tb_ac = new ZPY.BLL.Tb_ArticleClass();
            DataSet ds = bll_tb_ac.GetList("1=1 order by SerialNumber Desc");
            string menuStr = "";
            foreach (DataRow dr in ds.Tables[0].Rows)
            {
                menuStr += " <li><a href=\"/news/" + dr["ClassDirectory"].ToString() + "/list_1.html\">" + dr["ClassName"].ToString() + "</a></li>";

            }
            str = str.Replace("{$MenuList$}", menuStr);//51aspx
            return str;
        }

       
    }
}
