﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

namespace WebForm.Manage.NewsManage
{
    public partial class News_List : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                if (Request.QueryString["action"] != null)
                {

                    int delID = int.Parse(Request.QueryString["ID"].ToString());
                    DelID(delID);//删除
                    ZPY.Common.PublicFc.Show(this, "删除成功！");
                }
                Repeater_News_List_DataBind(); }
        }

        /// <summary>
        /// 删除某个ID值的新闻
        /// </summary>
        /// <param name="id"></param>
        protected void DelID(int id)
        {
            ZPY.BLL.Tb_Article bll_tb_ac = new ZPY.BLL.Tb_Article();
           
            bll_tb_ac.Delete(id);

        }

        #region 删除所选
        protected void DelP_Click(object sender, EventArgs e)
        {
            string define_checkbox = Request.Form["define_checkbox"];
            if (define_checkbox == null || define_checkbox == String.Empty)
            {
                ZPY.Common.PublicFc.Show(this, "请选择批量删除的选项！");
                return;
            }
            else
            {
                String[] CheckboxArray = define_checkbox.Split(',');
                define_checkbox = null;
                for (int i = 0; i < CheckboxArray.Length; i++)
                {
                    DelID(int.Parse(CheckboxArray[i]));
                }
                ZPY.Common.PublicFc.Show(this, "恭喜，删除成功！");
            }
            Repeater_News_List_DataBind();
        }
        #endregion

        protected void LinkButton_MakeHtml_Click(object sender, EventArgs e)
        {
            string define_checkbox = Request.Form["define_checkbox"];
            if (define_checkbox == null || define_checkbox == String.Empty)
            {
                ZPY.Common.PublicFc.Show(this, "请选择批量生成静态页的选项！");
                return;
            }//5+1+a+s+p+x
            else
            {
                String[] CheckboxArray = define_checkbox.Split(',');
                define_checkbox = null;
                for (int i = 0; i < CheckboxArray.Length; i++)
                {
                    MakeHtmlID(int.Parse(CheckboxArray[i]));
                }
                ZPY.Common.PublicFc.Show(this, "恭喜，生成静态页成功！");
            }
            
        }
        /// <summary>
        /// 根据新闻ID生成该新闻的静态页面
        /// </summary>
        /// <param name="newID"></param>
        protected void MakeHtmlID(int newID)
        {
            ZPY.BLL.Tb_Article bll_tb_ac = new ZPY.BLL.Tb_Article();
            ZPY.Model.Tb_Article model_tb_ac = bll_tb_ac.GetModel(newID);
            string savePath = model_tb_ac.SavePath + model_tb_ac.FileName + model_tb_ac.FileExName;

            ZPY.BLL.Tb_ArticleClass bll_tb_articleclass = new ZPY.BLL.Tb_ArticleClass();
            ZPY.Model.Tb_ArticleClass model_tb_articleclass = bll_tb_articleclass.GetModel(model_tb_ac.ClassID);
            
            string contentTemplet = model_tb_articleclass.ContentTemplet;//获得新闻内容静态模板
           
            string tempContent = ZPY.Common.DirFile.ReadFile(contentTemplet);//读取新闻模板内容
            tempContent = tempContent.Replace("{$NewTitle$}", model_tb_ac.Title);
            tempContent = tempContent.Replace("{$NewSource$}", model_tb_ac.Source);
            tempContent = tempContent.Replace("{$NewAuthor$}", model_tb_ac.Author);
            tempContent = tempContent.Replace("{$NewAddTime$}", model_tb_ac.AddTime.ToString());
            tempContent = tempContent.Replace("{$NewHits$}", model_tb_ac.Hits.ToString());
            tempContent = tempContent.Replace("{$NewComment$}", "0");
            tempContent = tempContent.Replace("{$ClassName$}", model_tb_articleclass.ClassName);
            tempContent = tempContent.Replace("{$NewContent$}", model_tb_ac.Content);
            BaseFunction.XmlControl xlmControl = new WebForm.BaseFunction.XmlControl("/XML/BasicSet.xml");
            tempContent = tempContent.Replace("{$Head$}", model_tb_ac.Title + " - " + model_tb_articleclass.ClassName + " - " + xlmControl.GetXmlNodeValue("/basicSet/webSiteName"));
            //新闻推荐列表生成
            DataTable dt = bll_tb_ac.GetList(8,"IsTop=1","AddTime desc").Tables[0];
            string hotNewsList = null;
            foreach (DataRow dr in dt.Rows)
            {
                string newPath ="./"+ dr["SavePath"].ToString() + dr["FileName"].ToString() + dr["FileExName"].ToString();
                string newTitle = dr["Title"].ToString().Length > 18 ? dr["Title"].ToString().Substring(0, 18) : dr["Title"].ToString();
                hotNewsList += "<li><a href=\"/" + newPath + "\" title='" + dr["Title"].ToString() + "'>" + newTitle + "</a></li>";
            }
           
            tempContent = tempContent.Replace("{$HotNews$}", hotNewsList);
           
            tempContent = tempContent.Replace("{$WebSiteKeyWords$}", xlmControl.GetXmlNodeValue("/basicSet/webSiteKeyWord"));
            tempContent = tempContent.Replace("{$WebSiteDescription$}", xlmControl.GetXmlNodeValue("/basicSet/webSiteDescription"));
            tempContent = MenuBuild(tempContent);//菜单生成
            ZPY.Common.DirFile.CreateFile(savePath, tempContent);//5|1|a|s|p|x
        }
        /// <summary>
        /// 菜单生成
        /// </summary>
        private string MenuBuild(string str)
        {
            ZPY.BLL.Tb_ArticleClass bll_tb_ac = new ZPY.BLL.Tb_ArticleClass();
            DataSet ds = bll_tb_ac.GetList("1=1 order by SerialNumber Desc");
            string menuStr = "";
            foreach (DataRow dr in ds.Tables[0].Rows)
            {
                menuStr += " <li><a href=\"/news/" + dr["ClassDirectory"].ToString() + "/list_1.html\">" + dr["ClassName"].ToString() + "</a></li>";

            }
            str = str.Replace("{$MenuList$}", menuStr);
            return str;
        }
        /// <summary>
        /// 新闻列表
        /// </summary>
        protected void Repeater_News_List_DataBind()
        {
            ZPY.BLL.Tb_Article bll_tb_article = new ZPY.BLL.Tb_Article();
            DataTable dt = bll_tb_article.GetAllList().Tables[0];


            if (dt != null)
            {
                dt.Columns.Add("Operate", typeof(string));//操作
                dt.Columns.Add("Colum", typeof(String));//在dt中增加字段名为Colum的列
              //  DataRow[] drs = dt.Select("");
                ZPY.BLL.Tb_ArticleClass bll_ac = new ZPY.BLL.Tb_ArticleClass();
                ZPY.Model.Tb_ArticleClass model_ta = null;

                foreach (DataRow dr in dt.Rows)
                {
                    string strchar = null;
                    string newID = dr["ID"].ToString();
                    //获取该新闻所属类别名称
                    string classID = dr["ClassID"].ToString();
                    model_ta = bll_ac.GetModel(int.Parse(classID));
                    string className = model_ta.ClassName;//5~1+a~s~p~x
                    

                    dr["operate"] = "<a href=\"News_Add.aspx?action=modify&ID=" + newID + "\"  class=\"list_link\" title=\"修改此项\"><img src=\"../../sysImages/default/sysico/edit.gif\" border=\"0\" alt=\"修改此项\" /></a><a href=\"News_List.aspx?action=delone_class&ID=" + newID + "\"  class=\"list_link\" title=\"删除此项\" onclick=\"{if(confirm('确认删除吗？')){return true;}return false;}\"><img src=\"../../sysImages/default/sysico/del.gif\" border=\"0\" alt=\"删除此项\" /></a><input type='checkbox' name='define_checkbox' id='define_checkbox' value=\"" + newID + "\"/>";
                    #region 列表
                    strchar += "<tr class=\"TR_BG_list\" onmouseover=\"this.style.backgroundColor='#BEFBD1'\" onmouseout=\"this.style.backgroundColor='#FFFFFF'\">";
                    strchar += "<td  align=\"left\" valign=\"middle\">" + dr["Title"] + "</td>";
                    strchar += "<td align=\"center\" valign=\"middle\" >" + className + "</td>";
                    strchar += "<td align=\"center\" valign=\"middle\" >" + dr["AddTime"].ToString() + "</td>";
                    strchar += "<td align=\"center\" valign=\"middle\" >" + (dr["IsTop"].ToString().ToLower()=="true" ? "推荐" : "未推荐") + "</td>";
                    strchar += "<td align=\"center\" valign=\"middle\" >" + (dr["IsPass"].ToString().ToLower()=="true" ? "通过" : "未通过") + "</td>";
                    strchar += "<td align=\"center\" valign=\"middle\" >" + dr["Operate"].ToString() + "</td>";
                    strchar += "</tr>";
                    dr["Colum"] = strchar;
                    #endregion

                }
            }

            AspNetPager1.RecordCount = dt.Rows.Count;
            PagedDataSource pds = new PagedDataSource();
            pds.AllowPaging = true;
            pds.PageSize = AspNetPager1.PageSize;
            pds.CurrentPageIndex = AspNetPager1.CurrentPageIndex - 1;
            pds.DataSource = dt.DefaultView;
            this.Repeater_News_List.DataSource = pds;
            this.Repeater_News_List.DataBind();
            
        }

        protected void AspNetPager1_PageChanged(object src, EventArgs e)
        {

            Repeater_News_List_DataBind();
        }

    }
}
