﻿using System;
using System.Collections.Generic;
using System.Text;
using DAL;
using Models;

namespace BLL
{
    public class UserInfoManager
    {
        //查找所有用户
        public static IList<UserInfo> GetAllUserInfo()
        {
            return UserInfoService.GetAllUserInfo();
        }
        //系统管理员修改用户信息
        public static void ModifyUserInfo(int userid,string username, string loginname,string email,int roleid,string remark)
        {
            UserInfo userinfo = new UserInfo();
            userinfo.Userid = userid;
            userinfo.Username = username;
            userinfo.Loginname = loginname;
            userinfo.Email = email;
            userinfo.Roleid = roleid;
            userinfo.State = 1;
            userinfo.Remark = remark;
            string times = DateTime.Now.ToString("yyyy-MM-dd hh:mm:ss");
            userinfo.Modifytime = times;
            //userinfo.Createtime = createtime;
            UserInfoService.ModifyUserInfo(userinfo);
        }
        //用户修改自己信息
        public static void ModifyUser(int userid, string username, string loginname, string password, string email, string remark, string modifytime)
        {
            UserInfo userinfo = new UserInfo();
            userinfo.Userid = userid;
            userinfo.Username = username;
            userinfo.Loginname = loginname;
            userinfo.Password = password;
            userinfo.Email = email;
            userinfo.Remark = remark;
            userinfo.Modifytime = modifytime;
            UserInfoService.ModifyUser(userinfo);
        }

        //i修改密码，add by 51aspx
        /// <summary>
        /// 修改密码
        /// </summary>
        /// <param name="userid">用户id</param>
        /// <param name="pwd">要修改的密码</param>
        public static int ModifyPassword(int userid, string pwd)
        {
            UserInfo userinfo = new UserInfo();
            userinfo.Userid = userid;
            userinfo.Password = pwd;
            string times = DateTime.Now.ToString("yyyy-MM-dd hh:mm:ss");
            //userinfo.Modifytime = times;
            //userinfo.Createtime = createtime;
           return UserInfoService.ModifyPassword(userinfo);
        }

        //根据用户登录ID来查找用户
        public static UserInfo GetUserInfoById(int userid)
        {
            return UserInfoService.GetUserInfoById(userid);
        }
        //根据用户登录名称来查找用户
        public static IList<UserInfo> GetUserInfoByName(string name)
        {
            return UserInfoService.GetUserInfoByName(name);
        }
        //判断用户名是否存在
        public static UserInfo CheckLogin(string loginname, string password)
        {
            return UserInfoService.CheckLogin(loginname, password);
        }
        //根据用户ID来删除用户信息
        public static void DeleteUserInfo(int userid)
        {

            UserInfoService.DeleteUserInfo(userid);
        }

        //新增用户信息
        public static int InsertUserInfo(string username, string loginname, string password,string email, int roleid,string remark,string createtime)
        {
            UserInfo userinfo = new UserInfo();
            userinfo.Username = username;
            userinfo.Loginname = loginname;
            userinfo.Password = password;
            userinfo.Email = email;
            userinfo.Roleid = roleid;
            userinfo.State = 1;
            userinfo.Remark = remark;
            userinfo.Createtime = createtime;
            return UserInfoService.InsertUserInfo(userinfo);
        }
    }
}
