﻿using System;
using System.Collections.Generic;
using System.Text;
using Models;
using System.Data.SqlClient;
using System.Data;
//5-/1a/s/px

namespace DAL
{
    public class NewsSerivce
    {
        public static int add_news(NewsInfo news)
        {
            int count = 0;
            string sql = "insert into News (newtitle,newcontent,userid,typeid,remake,createtime,image,state) values (@title,@content,@userid,@typeid,@remake,@createtime,@image,0)";
            SqlParameter[] para = new SqlParameter[] { new SqlParameter("@title", news.Newtitle), new SqlParameter("@content", news.Newcontent), new SqlParameter("@userid", news.Userid), new SqlParameter("@typeid ", news.Typeid), new SqlParameter("@remake", news.Remark), new SqlParameter("@createtime", news.Createtime), new SqlParameter("@image", news.Image) };
            try
            {
                count = DBHelper.ExecuteCommand(sql, para);
            }
            catch (SqlException e)
            {
                throw e;

            }
            return count;
        }

        public static NewsInfo select_by_newid(int newid)
        {
            string sql = string.Format("select * from News where newid={0} ", newid);
            return return_NewInfo(sql);

        }

        public static NewsInfo select_by_newid(int newid, int statie)
        {
            string sql = string.Format("select * from News where newid={0} and state={1}", newid, statie);
            return return_NewInfo(sql);
        }

        //根据新闻分类和是否发布查询新闻
        public static List<NewsInfo> select_by_typeid(int typeid, int state)
        {
            string sql = string.Format("select * from News where typeid={0} and state = {1}", typeid, state);
            return return_List(sql);
        }

        public static int modify_state(int state, string time, int newid)
        {
            string sql = string.Format("update News set  newtime = '{0}',state={1} where newid ={2} ", time, state, newid);
            int a = DBHelper.ExcuteCommand(sql);
            return a;
        }

        public static int modify(NewsInfo news)
        {
            string sql = string.Format("update News set newtitle ='{0}', newcontent = '{1}', typeid = {2}, remake = '{3}', modifytime = '{4}', image ={5} where newid ={6}", news.Newtitle, news.Newcontent, news.Typeid, news.Remark, news.Modifytime, news.Image, news.Newid);
            int a = DBHelper.ExcuteCommand(sql);
            return a;
        }

        public static int delete(int newid)
        {
            string sql = string.Format("delete from News where newid = {0}", newid);
            int a = DBHelper.ExcuteCommand(sql);
            return a;
        }

        public static List<NewsInfo> select_by_state(int state)
        {
            string sql = string.Format("select * from News where state={0} order by readcount desc", state);
            return return_List(sql);
        }


        public static DataTable select_all(int state)
        {
            string sql = string.Format("select * from News where  state = {0}", state);
            DataTable dt = DBHelper.GetDataSet(sql);
            return dt;
        }

        //用typeid查找，判断是否有存在typeid
        public static List<NewsInfo> selectbytypeid(int id)
        {
            string sql = "select * from News where typeid=" + id;
            return return_List(sql);  
        }

        public static List<NewsInfo> select_by_userid(int userid) 
        {
            string sql = "select * from News where userid=" + userid;
            return return_List(sql);  
        }

        public static List<NewsInfo> select_by_userid_and_state(int userid, int state) 
        {
            string sql = "select * from News where userid=" + userid+"and state ="+state;
            return return_List(sql);  
        }
        public static  List<NewsInfo> return_List(string sql) 
        {
            NewsInfo news = null;
            DataTable dt = DBHelper.GetDataSet(sql);
            List<NewsInfo> list = new List<NewsInfo>();
            foreach (DataRow dr in dt.Rows)
            {
                news = new NewsInfo();
                news.Newid = (int)dr["newid"];
                news.Newtitle = (string)dr["newtitle"];
                news.Newcontent = (string)dr["newcontent"];
                news.Newtime = (string)dr["newtime"].ToString();
                news.User = UserInfoService.GetUserInfoById((int)dr["userid"]);
                news.Typeid = (int)dr["typeid"];
                news.TypeInfo = TypeService.select_by_Typeid((int)dr["typeid"]);
                news.Remark = (string)dr["remake"];
                news.Modifytime = (string)dr["modifytime"].ToString();
                news.Createtime = (string)dr["createtime"].ToString();
                news.Image = (string)dr["image"].ToString();
                news.State = (int)dr["state"];
                news.Readcount = (int)dr["readcount"];
                list.Add(news);
            }
            return list;
        }

        public static NewsInfo return_NewInfo(string sql) 
        {
            DataTable dt = DBHelper.GetDataSet(sql);
            NewsInfo news = new NewsInfo();
            foreach (DataRow dr in dt.Rows)
            {
                news.Newid = (int)dr["newid"];
                news.Newtitle = (string)dr["newtitle"];
                news.Newcontent = (string)dr["newcontent"];
                news.Newtime = (string)dr["newtime"].ToString();
                news.User = UserInfoService.select_by_userid((int)dr["userid"]);
                news.Typeid = (int)dr["typeid"];
                news.TypeInfo = TypeService.select_by_Typeid((int)dr["typeid"]);
                news.Remark = (string)dr["remake"];
                news.Modifytime = (string)dr["modifytime"].ToString();
                news.Createtime = (string)dr["createtime"].ToString();
                news.Image = (string)dr["image"].ToString();
                news.State = (int)dr["state"];
                news.Readcount = (int)dr["readcount"];
            }
            return news;
        }
//修改阅读次数
        public static int modifyReadcount(int count, int newid)
        {
            string sql = string.Format("update News set readcount={0} where newid ={1}",count, newid);
            int a = DBHelper.ExcuteCommand(sql);
            return a;
        }

        public static List<NewsInfo> select_top5_order_newtime(int state)
        {
            string sql = string.Format("select top 5 * from News where state={0} order by newtime desc", state);
            return return_List(sql);
        }

        public static List<NewsInfo> select_top5_order_readcount(int state)
        {
            string sql = string.Format("select top 5 * from News where state={0} order by readcount desc", state);
            return return_List(sql);
        }

        public static List<NewsInfo> select_by_newtitle(string title, int typeid, int state) 
        {
            string sql = string.Format("select * from News where newtitle like '%{0}%' and typeid ={1} and state={2} order by readcount desc", title, typeid, state);
            return return_List(sql);
        }

        public static List<NewsInfo> select_top5_by_typeid(int typeid) 
        {
            string sql = "select top 5  *  from News where typeid=" + typeid+" and state = 1 order by newtime desc";
            return return_List(sql); 
        }
    }
}
