using System;
using System.Collections.Generic;
using System.Text;
using Models;
using System.Data.SqlClient;

namespace DAL
{
    public class RoleService
    {
        public static IList<Role> GetAllRole()
        {

            string sqlstr = "select * from Role where roleid !=3";
            return GetRoleBySql(sqlstr, null);

        }
        public static IList<Role> GetRoleBySql(string sqlstr, params SqlParameter[] values)
        {

            try
            {
                SqlDataReader dr;
                if (values == null)
                {
                    dr = DBHelper.GetReader(sqlstr);
                }
                else
                {
                    dr = DBHelper.GetReader(sqlstr, values);
                }
                if (dr != null)
                {
                    List<Role> list = new List<Role>();
                    while (dr.Read())
                    {
                        Role role = new Role();
                        role.Roleid= (int)dr["roleid"];
                        role.Rolename = (string)dr["rolename"];
                        list.Add(role);
                    }
                    dr.Close();
                    return list;
                }
                else
                {
                    dr.Close();
                    return null;
                }

            }
            catch (Exception e)
            {
                throw e;
            }

        }



        public static Role GetRoleById(int roleid)
        {
            string sqlstr = "select * from Role where roleid=@roleid";
            SqlParameter[] pare = new SqlParameter[] {
           new SqlParameter("@roleid",roleid)
           };
            SqlDataReader dr = DBHelper.GetReader(sqlstr, pare);
            Role role = null;
            try
            {
                
                if (dr.Read())
                {
                    role =new Role();
                    role.Roleid = (int)dr["roleid"];
                    role.Rolename = (string)dr["rolename"];
                    
                   
                }
                

            }
            catch (Exception e)
            {
                throw e;
            }
            dr.Close();
            return role;
        } 
    }
}
