using System;
using System.Collections.Generic;
using System.Text;
using Models;
using System.Data.SqlClient;
using System.Data;

namespace DAL
{
    public class UserInfoService
    {
        //û
        public static IList<UserInfo> GetAllUserInfo()
        {
            string sqlstr = "select * from UserInfo";
            return GetUserInfoBySql(sqlstr, null);

        }
        //ûϢǷȷ
        public static UserInfo CheckLogin(string loginname, string password)
        {
            UserInfo userinfo = null;
            string sqlstr = string.Format("select * from UserInfo where loginname='{0}' and password='{1}' ", loginname,  password);
            DataTable table = DBHelper.GetDataSet(sqlstr);
            if (table != null)
            {
                
                foreach (DataRow dr in table.Rows)
                {
                    userinfo = new UserInfo();
                    userinfo.Userid = (int)dr["userid"];
                    userinfo.Username = (string)dr["username"];
                    userinfo.Loginname = (string)dr["loginname"];
                    userinfo.Password = (string)dr["password"];
                    userinfo.Email = (string)dr["email"];
                    userinfo.State = (int)dr["state"];
                    userinfo.Roleid = (int)dr["roleid"];
                    //userinfo.UserState = StateService.GetStateById((int)dr["state"]);
                    //userinfo.UserRole = RoleService.GetRoleById((int)dr["roleid"]);
                    userinfo.Remark = (string)dr["remark"];
                    userinfo.Modifytime = (string)dr["modifytime"].ToString();
                    userinfo.Createtime = (string)dr["createtime"].ToString();
                   
                } 
            }
            return userinfo;
        }
        //ѯ
        public static IList<UserInfo> GetUserInfoBySql(string sql, params System.Data.SqlClient.SqlParameter[] values)
        {
            if (values == null)
            {
                try
                {
                    System.Data.DataTable table = DBHelper.GetDataSet(sql);
                    if (table != null)
                    {
                        List<UserInfo> list = new List<UserInfo>();
                        foreach (System.Data.DataRow dr in table.Rows)
                        {
                            UserInfo userinfo = new UserInfo();
                            userinfo.Userid = (int)dr["userid"];
                            userinfo.Username = (string)dr["username"];
                            userinfo.Loginname = (string)dr["loginname"];
                            userinfo.Password = (string)dr["password"];
                            userinfo.Email = (string)dr["email"];
                            userinfo.UserRole = RoleService.GetRoleById((int)dr["roleid"]);
                            userinfo.UserState = StateService.GetStateById((int)dr["state"]);
                            userinfo.Remark = (string)dr["remark"];
                            userinfo.Modifytime = (string)dr["modifytime"].ToString();
                            userinfo.Createtime = (string)dr["createtime"].ToString();
                            list.Add(userinfo);
                        }
                        return list;
                    }
                    else
                    {
                        return null;
                    }

                }
                catch (Exception e)
                {
                    throw e;
                }

            }
            else
            {
                return null;
            }

        }

 
        //ϵͳԱ޸ûϢ
        public static void ModifyUserInfo(UserInfo userinfo)
        {
            try
            {
                string sqlstr = "update UserInfo set username=@username,loginname=@loginname,email=@email,state=@state,roleid=@roleid,remark=@remark,modifytime=@modifytime where userid=@userid";
                SqlParameter[] para = new SqlParameter[]{
                new SqlParameter("@userid",userinfo.Userid),new SqlParameter("@username",userinfo.Username),new SqlParameter("@loginname",userinfo.Loginname),new SqlParameter("@email",userinfo.Email),new SqlParameter("@state", userinfo.State), new SqlParameter("@roleid", userinfo.Roleid),new SqlParameter("@remark",userinfo.Remark),new SqlParameter("@modifytime",userinfo.Modifytime)};
                DBHelper.ExecuteCommand(sqlstr, para);
            }
            catch (Exception e)
            {
                throw e;
            }
        }
        //û޸ԼϢ
        public static void ModifyUser(UserInfo userinfo)
        {
            try
            {
                string sqlstr = "update UserInfo set username=@username,loginname=@loginname,password=@password,email=@email,remark=@remark,modifytime=@modifytime where userid=@userid";
                SqlParameter[] para = new SqlParameter[]{
                new SqlParameter("@username",userinfo.Username),new SqlParameter("@loginname",userinfo.Loginname),new SqlParameter("@password",userinfo.Password),new SqlParameter("@email",userinfo.Email),new SqlParameter("@remark",userinfo.Remark),new SqlParameter("@modifytime",userinfo.Modifytime),new SqlParameter("@userid",userinfo.Userid)};
                DBHelper.ExecuteCommand(sqlstr, para);
            }
            catch (Exception e)
            {
                throw e;
            }
        }

        /// <summary>
        /// ޸
        /// </summary>
        /// <param name="userinfo"></param>
        public static int ModifyPassword(UserInfo userinfo)
        {
            try
            {
                string sqlstr = "update UserInfo set password=@password where userid=@userid";
                SqlParameter[] para = new SqlParameter[]{
                new SqlParameter("@password",userinfo.Password),new SqlParameter("@userid",userinfo.Userid)};
               return  DBHelper.ExecuteCommand(sqlstr, para);
            }
            catch (Exception e)
            {
                return 0;
                throw e;
            }
        }
      

        //ɾûϢ
        public static void DeleteUserInfo(int userid)
        {
            string sqlstr = "delete from UserInfo where userid=@userid";
            SqlParameter[] para = new SqlParameter[] { new SqlParameter("@userid", userid) };
            DBHelper.ExecuteCommand(sqlstr, para);
        }
        //ûIDûϢ
        public static UserInfo GetUserInfoById(int userid)
        {
            string sqlstr = string.Format("select * from UserInfo where userid={0}",userid);
            UserInfo userinfo = null;

            DataTable table = DBHelper.GetDataSet(sqlstr);
            if (table != null)
            {
                List<UserInfo> list = new List<UserInfo>();
                foreach (DataRow dr in table.Rows)
                {
                    userinfo = new UserInfo();
                    userinfo.Userid = (int)dr["userid"];
                    userinfo.Username = (string)dr["username"];
                    userinfo.Loginname = (string)dr["loginname"];
                    userinfo.Password = (string)dr["password"];
                    userinfo.Email = (string)dr["email"];
                    userinfo.UserState = StateService.GetStateById((int)dr["state"]);
                    userinfo.UserRole = RoleService.GetRoleById((int)dr["roleid"]);
                    userinfo.Remark = (string)dr["remark"];
                    userinfo.Modifytime = (string)dr["modifytime"].ToString();
                    userinfo.Createtime = (string)dr["createtime"].ToString();
                  
                }
                
            }
           
                return userinfo; 
          
        }
        //ûûϢ
        public static IList<UserInfo> GetUserInfoByName(string name)
        {
            string strsql;
            strsql = "select * from UserInfo where username='" + name + "'";
            DataTable table = DBHelper.GetDataSet(strsql);
            if (table != null)
            {
                List<UserInfo> list = new List<UserInfo>();
                foreach (DataRow dr in table.Rows)
                {
                    UserInfo userinfo = new UserInfo();
                    userinfo.Userid = (int)dr["userid"];
                    userinfo.Username = (string)dr["username"];
                    userinfo.Loginname = (string)dr["loginname"];
                    userinfo.Password = (string)dr["password"];
                    userinfo.Email = (string)dr["email"];
                    userinfo.UserState = StateService.GetStateById((int)dr["state"]);
                    userinfo.UserRole = RoleService.GetRoleById((int)dr["roleid"]);
                    userinfo.Remark = (string)dr["remark"];
                    userinfo.Modifytime = (string)dr["modifytime"].ToString();
                    userinfo.Createtime = (string)dr["createtime"].ToString();
                    list.Add(userinfo);
                }
                return list;
            }
            return null;
        }
        //Ϣ
        public static int InsertUserInfo(UserInfo userinfo)
        {
            string sqlstr = "Insert into UserInfo (username, loginname, password, email, state, roleid, remark, createtime) values(@username,@loginname,@password,@email,@state,@roleid,@remark,@createtime)";
            SqlParameter[] para = new SqlParameter[] { new SqlParameter("@userid", userinfo.Userid), new SqlParameter("@username", userinfo.Username), new SqlParameter("@loginname", userinfo.Loginname), new SqlParameter("@password", userinfo.Password), new SqlParameter("@email", userinfo.Email), new SqlParameter("@state", userinfo.State), new SqlParameter("@roleid", userinfo.Roleid), new SqlParameter("@remark", userinfo.Remark),  new SqlParameter("@createtime", userinfo.Createtime) };
            try
            {
                return DBHelper.ExecuteCommand(sqlstr, para);
            }
            catch (Exception e)
            {
                throw e;
            }
        }


        public static UserInfo select_by_userid(int userid)
        {
            UserInfo user = new UserInfo();
            string sql = string.Format("select * from UserInfo where userid = {0}", userid);
            SqlDataReader dr = DBHelper.GetReader(sql);
            while (dr.Read())
            {
                user.Userid = (int)dr["userid"];
                user.Username = (string)dr["username"];
                user.Loginname = (string)dr["loginname"];
                user.Password = (string)dr["password"];
                user.Email = (string)dr["email"];
                user.State = (int)dr["state"];
                user.Roleid = (int)dr["roleid"];
                user.Remark = (string)dr["remark"];
                user.Modifytime = (string)dr["modifytime"].ToString();
                user.Createtime = (string)dr["createtime"].ToString();


            }
            dr.Close();
            return user;
        }
    }
}
