﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;
using Models;
using BLL;
public partial class News : System.Web.UI.MasterPage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            if (Session["User"] == null)
            {
                Response.Redirect("~/Login.aspx");
            }
            else
            {
                UserInfo user = Session["User"] as UserInfo;
                Display(user);
            }
        }
    }

    private TreeNode CreatTreaNode(string strText, int strId, string strUrl, string strImage) 
    {
        TreeNode newNode = new TreeNode();
        newNode.Text = strText.ToString();
        newNode.Value = strId.ToString();
        newNode.NavigateUrl = strUrl;
        newNode.ImageUrl = strImage;
        return newNode;
    }

    private void Display(UserInfo user)
    {
        int roleid = user.Roleid;


                TreeView1.Nodes.Clear();
                List<viewUserRightInfo> parent = viewUserRightInfoManager.GetAllParentNodeInfoByUserId(0,user.Userid);
                foreach (viewUserRightInfo sf in parent) 
                {
                    int nodeid = sf.Funid;
                    string funname = sf.Funname;
                    string image = "images/plugin_add.png";
                    TreeNode fatherNode = this.CreatTreaNode(funname, nodeid, "", image);
                    CreateChildTree(nodeid, user.Userid, fatherNode);
                    TreeView1.Nodes.Add(fatherNode);
                }

        }

            private void CreateChildTree(int nodeid, int userid, TreeNode fatherNode) 
            {

                List<viewUserRightInfo> child = viewUserRightInfoManager.GetAllParentNodeInfoByUserId(nodeid, userid);
                foreach (viewUserRightInfo sfchild in child)
                {
                    int id = sfchild.Funid;
                    string childname = sfchild.Funname;
                    string nodeurl = ResolveUrl(sfchild.Funurl.Trim());
                    string image = "images/plugin_edit.png";
                    TreeNode childNode = this.CreatTreaNode(childname, nodeid,nodeurl, image);
                    CreateChildTree(id, userid, fatherNode);
                    AddTree(fatherNode, childNode);
                }
                
            }

            private void AddTree(TreeNode fathernode, TreeNode chilenode) 
            {
                fathernode.ChildNodes.Add(chilenode);
            }


        //List<Roleright> list = new List<Roleright>();
        //list = RolerightManager.select_by_roleid(roleid);
        //for (int i = 0; i < list.Count; i++)
        //{
        //    int nodeid = list[i].Funid;
        //    List<Funinfo> funlist = Funinfomessage.select_by_funid(nodeid);
        //    for (int j = 0; j < funlist.Count; j++)
        //    {

        //        TreeNode fathernode = CreatNode(funlist[j].Funname.ToString(), "");
        //        int fatherid = funlist[j].Funid;
        //        List<Funinfo> fulist = Funinfomessage.select_by_fatherid(fatherid);
                
        //        for (int e = 0; e < fulist.Count; e++)
        //        {
                    
        //                TreeNode chilenode = CreatNode(fulist[e].Funname.ToString(), fulist[e].Funurl.ToString());

        //                fathernode.ChildNodes.Add(chilenode);
                    
        //        }
        //        this.TreeView1.Nodes.Add(fathernode);

        //    }

        //}

    //}

    
    private TreeNode CreatNode(string strtext, string strurl)
    {
        TreeNode node = new TreeNode();
        node.Text = strtext;
        node.NavigateUrl = strurl;
        return node;
    }
}
