﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using BLL;
using Models;

public partial class admin_UserNews : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            if (Session["User"] == null)
            {
                Response.Redirect("~/Login.aspx");
            }
            else
            {
                UserInfo user = Session["User"] as UserInfo;
                display();
            }
        }
    }

    private void display() 
    {
        UserInfo user = Session["User"] as UserInfo;
        int userid = user.Userid;
        GridView2.DataSource = NewsInfomessage.select_by_userid(userid);
        GridView2.DataBind();
        
    }
    protected void GridView2_DataBound(object sender, EventArgs e)
    {
        for (int i = 0; i < this.GridView2.Rows.Count; i++)
        {
            Label state = this.GridView2.Rows[i].FindControl("lblstate") as Label;
            
            Label image = this.GridView2.Rows[i].FindControl("lblImage") as Label;

            Label newtimes = this.GridView2.Rows[i].FindControl("Label1") as Label;
            if (!newtimes.Text.Equals(""))
            {
                newtimes.Text = Convert.ToDateTime(newtimes.Text).ToShortDateString();
            }
            else
            {
                newtimes.Text = "无审核记录";
            }
            if (state.Text == "0")
            {

                state.Text = "未通过审核";
                
            }
            else
            {

                state.Text = "已审核";
              
            }
            if (image.Text == "0")
            {
                image.Text = "文章";
            }
            else
            {
                image.Text = "图文";
            }
        }
    }
    protected void GridView2_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.Attributes.Add("onmouseover", "currentcolor = this.style.backgroundColor; this.style.backgroundColor='#ccffcc'");
            e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=currentcolor");
            e.Row.Cells[4].Text = Convert.ToDateTime(e.Row.Cells[4].Text).ToShortDateString();
        }
    }

    protected void GridView2_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        this.GridView2.PageIndex = e.NewPageIndex;
        display();
    }
    protected void btnSelect_Click(object sender, EventArgs e)
    {
        int state = int.Parse(DropDownList1.SelectedValue);
        if (state == 2) 
        {
            display();
         }
         else if (state == 0) 
        {
            UserInfo user = Session["User"] as UserInfo;
            int userid = user.Userid;
            GridView2.DataSource = NewsInfomessage.select_by_userid_and_state(userid, 0);
            GridView2.DataBind();
        }
        else if (state == 1) 
        {
            UserInfo user = Session["User"] as UserInfo;
            int userid = user.Userid;
            GridView2.DataSource = NewsInfomessage.select_by_userid_and_state(userid, 1);
            GridView2.DataBind();
        }
    }
}
