﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Models;
using BLL;

public partial class NewTypeManager : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            databind();
        }
    }

    protected void GridView1_RowEditing(object sender, GridViewEditEventArgs e)
    {
        this.GridView1.EditIndex = e.NewEditIndex;
        databind();
    }

    protected void btnselect_Click(object sender, EventArgs e)
    {
        string typetitle = txtnewtypename.Text;
        int i = 0;
        dataBind(typetitle,i);
    }

    protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        Label lbltypeid = this.GridView1.Rows[e.RowIndex].FindControl("lblID") as Label;
        int typeid = int.Parse(lbltypeid.Text);
        int i = TypeManager.DeleteType(typeid);
        if(i==0)
        {
            Response.Write("<script>alert('此新闻类型下有新闻信息，无法删除!')</script>");
        }
        this.GridView1.EditIndex = -1;
        databind();
    }

    protected void dataBind(string typetitle,int i)
    {
        if ((typetitle != null) || (i == 0))
        {
            this.GridView1.DataSource = TypeManager.select_by_typetitle(typetitle);
            
        }
        else if ((typetitle == null) || (i > 0))
        {
            this.GridView1.DataSource = TypeManager.selectbyparenttypeid(i);
        }
        else 
        {
            this.GridView1.DataSource = TypeManager.GetAllTypeInfo();
        }
        this.GridView1.DataBind();
    }
    protected void GridView1_RowUpdating(object sender, GridViewUpdateEventArgs e)
    {
        //Label typeid = this.GridView1.Rows[e.RowIndex].FindControl("lblID") as Label;
        //TextBox typetitle = this.GridView1.Rows[e.RowIndex].FindControl("txttypetitle") as TextBox;
        //TextBox descrption = this.GridView1.Rows[e.RowIndex].FindControl("txtdescrption") as TextBox;
        //TextBox modifytime = this.GridView1.Rows[e.RowIndex].FindControl("txtmodifytime") as TextBox;
        //TextBox createtime = this.GridView1.Rows[e.RowIndex].FindControl("txtcreatetime") as TextBox;
        //DropDownList state = this.GridView1.Rows[e.RowIndex].FindControl("drpstate") as DropDownList;
        //DropDownList parenttypeid = this.GridView1.Rows[e.RowIndex].FindControl("drpparenttypeid") as DropDownList;
        //TypeManager.ModifyType(int.Parse(typeid.Text), typetitle.Text, descrption.Text, modifytime.Text, createtime.Text, int.Parse(state.SelectedValue), int.Parse(parenttypeid.SelectedValue));
        //this.GridView1.EditIndex = -1;
        //databind();
    }
    protected void GridView1_SelectedIndexChanged(object sender, EventArgs e)
    {
        this.GridView1.EditIndex = -1;
        databind();
    }
    protected void GridView1_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
    {
        this.GridView1.EditIndex = -1;
        databind();
    }

   
    protected void btnselecttype_Click(object sender, EventArgs e)
    {
        int i = int.Parse(drpparenttype.SelectedValue);
        string typetitle = null;
        dataBind(typetitle, i);
    }
    protected void btnselectall_Click(object sender, EventArgs e)
    {
        databind();
    }

    protected void databind()
    {
        this.GridView1.DataSource = TypeManager.GetAllTypeInfo();
        this.GridView1.DataBind();
    }
    protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.Attributes.Add("onmouseover", "currentcolor = this.style.backgroundColor; this.style.backgroundColor='#ccffcc'");
            e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=currentcolor");
            //e.Row.Cells[7].Text = Convert.ToDateTime(e.Row.Cells[7].Text).ToShortDateString();、、
        }
    }
}


