﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Models;
using BLL;
using DAL;

public partial class admin_new : System.Web.UI.Page
{
    public int state=0;
    
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            Session["state"]=1;
            if (state == null) 
            {
                state = 1;
            }
            dataBind1(state);
        }
        else 
        {
            if (Session["state"] != null)
            {
                state = (int)Session["state"];
            }
            else 
            {
                state = 1;
            }
        }
    }

    protected void Button3_Click(object sender, EventArgs e)
    {        
           state  = int.Parse(Select1.Value);
           Session["state"] = state;
           //dataBind1(state);
           int typeid = int.Parse(DropDownList1.SelectedValue.ToString());
           this.GridView2.DataSource = NewsInfomessage.select_by_typeid_guojing(typeid, state);
           this.GridView2.DataBind();
    }

    private void dataBind1(int name)
    {
        if (name <=0)
        {
            this.GridView2.DataSource = NewsInfomessage.select_by_state(name);
        }
        else
        {
            this.GridView2.DataSource = NewsInfomessage.select_by_state(state);
        }
        this.GridView2.DataBind();
    }
  
    protected void GridView2_DataBound(object sender, EventArgs e)
    {
        for (int i = 0; i < this.GridView2.Rows.Count; i++)
        {
            Label state = this.GridView2.Rows[i].FindControl("lblstate") as Label;
            LinkButton state2 = this.GridView2.Rows[i].FindControl("lbtnstate") as LinkButton;
            Label image = this.GridView2.Rows[i].FindControl("lblImage") as Label;
            Label newtimes = this.GridView2.Rows[i].FindControl("newtime") as Label;
            if (!newtimes.Text.Equals(""))
            {
                newtimes.Text = Convert.ToDateTime(newtimes.Text).ToShortDateString();
            }
            else 
            {
                newtimes.Text = "无审核记录";
            }
            if (state.Text == "0")
            {

                state.Text = "未审核";
                state2.Text = "审核";
            }
            else
            {

                state.Text = "已审核";
                state2.Text = "停止";
            }
            if (image.Text == "0")
            {
                image.Text = "文章";
            }
            else
            {
                image.Text = "图文";
            }
        }
        //if (e.Row.RowType == DataControlRowType.DataRow)
        //{
            
        //    e.Row.Cells[3].Text = Convert.ToDateTime(e.Row.Cells[3].Text).ToShortDateString();
        //}
    }

    protected void GridView2_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "modify")
        {
            string times =  DateTime.Now.ToString("yyyy-MM-dd hh:mm:ss");
            NewsInfo news = NewsInfomessage.select_by_newsid(int.Parse(e.CommandArgument.ToString()));
            if (news.State == 1)
            {

                NewsInfomessage.modify_state(0, times, news.Newid);
                this.GridView2.DataSource = NewsInfomessage.select_by_state(1);
                this.GridView2.DataBind();
            }
            if (news.State == 0)
            {
                NewsInfomessage.modify_state(1, times, news.Newid);
                this.GridView2.DataSource = NewsInfomessage.select_by_state(0);
                this.GridView2.DataBind();
            }
        }
    }
    
    protected void GridView2_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        Label lblid = this.GridView2.Rows[e.RowIndex].FindControl("lblNewid") as Label;
        int id = int.Parse(lblid.Text);
        NewsInfomessage.delete(id);
        this.GridView2.EditIndex = -1;
        this.GridView2.DataSource = NewsInfomessage.select_by_state(state);
        this.GridView2.DataBind();
    }

    protected void GridView2_SelectedIndexChanged(object sender, EventArgs e)
    {
        this.GridView2.EditIndex = -1;
        int name = 1;
        dataBind1(name);
    }

    protected void GridView2_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        this.GridView2.PageIndex=e.NewPageIndex ;
        this.GridView2.DataSource = NewsInfomessage.select_by_state(state);
        this.GridView2.DataBind();

    }

    protected void GridView2_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow) 
        {
            e.Row.Attributes.Add("onmouseover", "currentcolor = this.style.backgroundColor; this.style.backgroundColor='#ccffcc'");
            e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=currentcolor");
        
        }
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            //e.Row.Cells[3].Text = Convert.ToDateTime(e.Row.Cells[3].Text).ToShortDateString();
            e.Row.Cells[4].Text = Convert.ToDateTime(e.Row.Cells[4].Text).ToShortDateString();
        }

    }
    
    protected void GridView2_Sorting(object sender, GridViewSortEventArgs e)
    {
        if (ViewState["order"] == null)
        {
            ViewState["order"] = "ASC";
        }
        else
        {
            if (ViewState["order"].ToString() == "ASC")
            {
                ViewState["order"] = "DESC";
            }
            else
            {
                ViewState["order"] = "ASC";
            }
            DataTable dt = NewsSerivce.select_all( state);
            dt.DefaultView.Sort = e.SortExpression + " " + ViewState["order"].ToString();
            this.GridView2.DataSource = dt.DefaultView;
            this.GridView2.DataBind();
        }
    }
    //protected void btnSelectByType_Click(object sender, EventArgs e)
    //{
    //    int typeid = int.Parse(DropDownList1.SelectedValue.ToString());
    //    this.GridView2.DataSource = NewsInfomessage.select_by_typeid_guojing(typeid, state);
    //    this.GridView2.DataBind();
    //}
    protected void btnSelect_Click(object sender, EventArgs e)
    {
        state = int.Parse(Select1.Value);
        Session["state"] = state;
        dataBind1(state);
    }
    protected void btnSelectByUserName_Click(object sender, EventArgs e)
    {
        int userid = int.Parse(dropUsername.SelectedValue);
        int s = int.Parse(dropState.SelectedValue);
        GridView2.DataSource = NewsSerivce.select_by_userid_and_state(userid, s);
        GridView2.DataBind();
    }
}
