﻿/// <reference path="~/Scripts/_references.js" />
$("form").submit(function (event) {
    var $form = $(this);
    if ($form.valid()) {
        Generic_Form_Functions_LoadDialog();
    }
});

var symbol = "$";

var totalSelects = 1;
var isLoading = true;
var isDomain = false;
var isHost = false;
var dropDiv = "ZPriceID";
var optDomain = "";
var VAT = null;

function Domain_Create()
{
    $("input[name=domainType]:first").attr('checked', true);
    isDomain = true;
    OnDomainChoiseChange(parseInt($('input[name=domainType]:checked').val()));
}

function Host_Create(hasDomain, tax)
{
    //priceTable
    if (tax != null && tax != '')
    {
        VAT = tax;
    }
    
    isHost = true;
    dropDiv = "TLDPriceDomain";
    if (hasDomain)
    {
        $("input[name=domainType]:first").attr('checked', true);
        isDomain = true;
        OnDomainForHostChange(parseInt($('input[name=domainType]:checked').val()));
    } else {
        SetTotalOrder();
    }
   
}

function Other_Create() {
    SetTotalOrder();
}

function SaaS_Create()
{
    SetTotalOrder();
}

function License_Create()
{
    SetTotalOrder();
}

//**** COMON FUNCTIONS *********

function SetTotalOrder() {
    var message = "<img src='" + ZB_Relative_Path + "images/ajax-loader.gif'/>";
  
    $("#loadPrice").html(message).show();

    $("#priceTable").find("tr:gt(0)").remove();

    var $inputs = $('#form select');

    totalSelects = $inputs.length;
    
    var stringArray = new Array();

    $inputs.each(function () {
        stringArray.push($(this).val());
    });

    GetCart(stringArray);
    
}

function GetCart(ids)
{
    $.post(ZB_Relative_Path + "NewOrder/StepFour/GetCart/?domainType=" + optDomain, { model: ids })
          .success(function (data) {

              symbol = data.CurrencySymbol;

              for (var i = 0; i < data.Lines.length; i++) {
                  $("#priceTable").append("<tr><td>" + data.Lines[i].Item + "</td><td>" + data.Lines[i].Period + "</td><td>" + symbol+"" + data.Lines[i].Total + "</td></tr>");
              }

              if (data.VATPercentage != 0)
              {
                  $("#priceTable").append("<tr><th colspan='2'><span class='pull-right'>" + Languages_FrontOffice_Resource_subtotal + "</span></th><th>" + symbol + "" + data.SubTotal + "</th></tr>");
                  $("#priceTable").append("<tr><th colspan='2'><span class='pull-right'>" + Languages_FrontOffice_Resource_Tax + " " + data.VATPercentage + "%</span></th><th>" + symbol + "" + data.VATTotal + "</th></tr>");
              }

              $("#priceTable").append("<tr><th colspan='2'><span class='pull-right'>" + Languages_FrontOffice_Resource_total + "</span></th><th>" + symbol + "" + data.Total + "</th></tr>");
              $("#priceTable").append("<tr><td colspan='3'><input type='submit' class='pull-right btn btn-success' value='" + Languages_FrontOffice_Resource_CheckOut + "'></a></td></tr></tbody>");

              $("#loadPrice").html("");

          }).fail(function (data) {

              alert(JSON.stringify(data));
              $("#loadPrice").html("");
          });
}

//For domain ************+
function OnChangeTLD(tld, productId) {
    
    if (optDomain != 3) //myown
    {
       
        var procemessage = "<option value='0'> " + Languages_BackOffice_Resource_Pleasewait + "</option>";

        $("#" + dropDiv).html(procemessage).show();

        $.ajax({
            url: ZB_Relative_Path + "NewOrder/StepFour/GetTLDPrices/" + productId + "/" + tld,
            cache: false,
            type: "POST",
            success: function (data) {
                //alert(JSON.stringify(data));
                var markup = "";
                for (var x = 0; x < data.length; x++) {

                    markup += "<option value=" + data[x].Value + ">" + data[x].Text + "</option>";
                }
                $("#" + dropDiv).html(markup).show();
                SetTotalOrder();
            },
            error: function (reponse) {
                //alert(JSON.stringify(reponse));
                SetTotalOrder();
            }
        });
    }
}

function OnDomainChoiseChange(id) {

    var opt = parseInt(id);
    optDomain = opt;
    $("#ZPriceID").show();
    SetTotalOrder();
}

//For Host **************
function OnDomainForHostChange(id) {
    
    var opt = parseInt(id);
    optDomain = opt;
    if (opt == 3) {
        $("#TLDPriceDomain").hide();
        $("#ProductDomainPrice").text("");
       
        $("#TLD").hide();
        $("#TLD_OWN").text("");
        $("#TLD_OWN").show();

    } else {
        $("#TLDPriceDomain").show();
        $("#TLD_OWN").text("com");
        $("#TLD_OWN").hide();

        $("#TLD").show();
    }
    SetTotalOrder();
}