﻿/// <reference path="~/Scripts/_references.js" />

function EmailTemplate_Create() {

}

function EmailTemplate_Edit(modelID, emailType) {
    Generic_Forms_SelectTab();
}

function EmailTemplate_List(emailType) {
    Generic_List_LoadDataTable("ListEmailTemplateDataTable", 1, 2, "EmailTemplate", "Edit", "Delete", "List/" + emailType, true, true, false, null, true, true, null, null, true, "Copy");
}

function CopyItem(id) {
    Generic_Forms_LoadDialog();

    var jqxhr = $.get(ZB_Relative_Path + "ZBAdmin/EmailTemplate/Copy/" + id)
         .success(function (data) {
             var table = $('#ListEmailTemplateDataTable').DataTable();
             table.ajax.reload();
             Generic_Forms_CloseLoadDialog();
         })
         .fail(function (data) {
             Generic_Forms_CloseLoadDialog();
             Generic_Functions_ShowErrorDialog(Languages_BackOffice_Resource_Error, Languages_BackOffice_Resource_ErrorDelete)
         });

}

function ShowRecords(emailType) {

    if (emailType == 0) {
        ShowClientModal();
    }
    else if (emailType == 3) {
        ShowInvoiceModal();
    }
    else if (emailType == 2) {
        ShowOrderModal();
    }
    else if (emailType == 1) {
        ShowSupportModal();
    }
}

function ShowSupportModal() {
  
    var link = "<a href='#' onclick=\"TestEmailNow('[ID]', '1')\">[DATA]</a>";


    var columns = [
     { "targets": 4, "visible": false }
    ];

    BootstrapDialog.show({
        size: BootstrapDialog.SIZE_WIDE,
        title: Languages_BackOffice_Resource_SelectOne,
        message: "<div class='table-responsive'>" +
                "<table class='table table-bordered' id='ListTicketDataTable'>" +
                   " <thead>" +
                        "<tr>" +
                        "<th>" + Languages_BackOffice_Resource_Title + "</th>" +
                        "<th>" + Languages_BackOffice_Resource_Client + "</th>" +
                       "<th>" + Languages_BackOffice_Resource_Status + "</th>" +
                        "<th>" + Languages_BackOffice_Resource_Owner + "</th>" +
                             "<th hidden='hidden'>..</th>" +
                    "</tr>" +
               " </thead>" +
                "<tbody></tbody>" +
            "</table>" +
       " </div>",
        buttons: [{
            label: Languages_BackOffice_Resource_Close,
            action: function (dialogRef) {
                dialogRef.close();
            }
        }],
        onshown: function (dialog) {
            Generic_List_LoadDataTable("ListTicketDataTable", 2, 4, "Ticket", "", "", "ListEmailTemplate", false, false, false, null, true, true, link, columns, false, null, false);
        }
    });
}

function ShowOrderModal() {
    var link = "<a href='#' onclick=\"TestEmailNow('[ID]', '2')\">[DATA]</a>";
  
    var columns = [
  { "targets": 3, "visible": false }
    ];


    BootstrapDialog.show({
        size: BootstrapDialog.SIZE_WIDE,
        title: Languages_BackOffice_Resource_SelectOne,
        message: "<div class='table-responsive'>" +
                "<table class='table table-bordered' id='ListOrderDataTable'>" +
                   " <thead>" +
                       " <tr>" +
                       "<th>" + Languages_BackOffice_Resource_Client + "</th>" +
                       " <th>" + Languages_BackOffice_Resource_Product + "</th>" +
                        "<th>" + Languages_BackOffice_Resource_Status + "</th>" +
                            "<th hidden='hidden'>..</th>" +
                    "</tr>" +
               " </thead>" +
                "<tbody></tbody>" +
            "</table>" +
       " </div>",
        buttons: [{
            label: Languages_BackOffice_Resource_Close,
            action: function (dialogRef) {
                dialogRef.close();
            }
        }],
        onshown: function (dialog) {
            Generic_List_LoadDataTable("ListOrderDataTable", 0, 3, "Order", "", "", "ListEmailTemplate", false, false, false, null, true, true, link, columns);
        }
    });

}

function ShowInvoiceModal() {

    var link = "<a href='#' onclick=\"TestEmailNow('[ID]', '3')\">[DATA]</a>";
   
    var columns = [
      { "targets": 3, "visible": false }
    ];

    BootstrapDialog.show({
        size: BootstrapDialog.SIZE_WIDE,
        title: Languages_BackOffice_Resource_SelectOne,
        message: "<div class='table-responsive'>" +
                "<table class='table table-bordered' id='ListInvoiceDataTable'>" +
                   " <thead>" +
                       " <tr>" +
                           " <th>" + Languages_BackOffice_Resource_InvoiceNumber + "</th>" +
                            "<th>" + Languages_BackOffice_Resource_Client + "</th>" +
                            "<th>" + Languages_BackOffice_Resource_Status + "</th>" +
                              "<th hidden='hidden'>..</th>" +
                        "</tr>" +
                   " </thead>" +
                    "<tbody></tbody>" +
                "</table>" +
           " </div>",
        buttons: [{
            label: Languages_BackOffice_Resource_Close,
            action: function (dialogRef) {
                dialogRef.close();
            }
        }],
        onshown: function (dialog) {
            Generic_List_LoadDataTable("ListInvoiceDataTable", 0, 3, "Invoice", "", "", "ListEmailTemplate", false, false, false, null, true, true, link, columns);

        }
    });

}

function ShowClientModal() {


    var link = "<a href='#' onclick=\"TestEmailNow('[ID]', '0')\">[DATA]</a>";

    var columns = [
       { "targets": 2, "visible": false }
    ];

    BootstrapDialog.show({
        size: BootstrapDialog.SIZE_WIDE,
        title: Languages_BackOffice_Resource_SelectOne,
        message: "<div class='table-responsive'>" +
                "<table class='table table-bordered' id='ListClientDataTable'>" +
                   " <thead>" +
                       " <tr>" +
                           "<th>" + Languages_BackOffice_Resource_FullName + "</th>" +
                           "<th>" + Languages_BackOffice_Resource_Email + "</th>" +
                           "<th hidden='hidden'>..</th>" +
                        "</tr>" +
                   " </thead>" +
                    "<tbody></tbody>" +
                "</table>" +
           " </div>",
        buttons: [{
            label: Languages_BackOffice_Resource_Close,
            action: function (dialogRef) {
                dialogRef.close();
            }
        }],
        onshown: function (dialog) {

            Generic_List_LoadDataTable("ListClientDataTable", 0, 2, "Client", "", "", "ListEmailTemplate", false, false, false, null, true, true, link, columns);
        }
    });
}

function TestEmailNow(id, emailType) {

   
    $.each(BootstrapDialog.dialogs, function (id, dialog) {
        dialog.close();
    });

    Generic_Forms_LoadDialog();

    var model = $('form').serialize();

    var jqxhr = $.post(ZB_Relative_Path + "ZBAdmin/EmailTemplate/TestTemplate/" + id + "/" + emailType, model)
            .success(function (data) {

                Generic_Forms_CloseLoadDialog();

                if (data.HasErrors != true) {

                    Generic_Functions_ShowSuccessDialog(Languages_BackOffice_Resource_Success, Languages_BackOffice_Resource_OperationSuccess);

                } else {
                    Generic_Functions_ShowErrorDialog(Languages_BackOffice_Resource_Error, data.Description);
                }

            })
            .fail(function (data) {

                Generic_Forms_CloseLoadDialog();

                Generic_Functions_ShowErrorDialog(Languages_BackOffice_Resource_Error, JSON.stringify(data));

            });
}
