﻿function Generic_Functions_OpenExternalURL(url) {
    /// <summary>Open URL in new window</summary>
    /// <returns type="void"></returns>
    var win = window.open(url, '_blank');
    win.focus();
}


function Generic_Functions_ShowErrorDialog(title, description) {
    /// <summary>Show Error Dialog with Close Button</summary>
    /// <returns type="void"></returns>

    BootstrapDialog.show({
        title: title,
        type: BootstrapDialog.TYPE_DANGER,
        message: description,
        buttons: [{
            label: Languages_BackOffice_Resource_Close,
            action: function (dialogRef) {
                dialogRef.close();
            }
        }]
    });
}

function Generic_Functions_ShowSuccessDialog(title, description) {
    /// <summary>Show Success Dialog with Close Button</summary>
    /// <returns type="void"></returns>

    BootstrapDialog.show({
        title: title,
        type: BootstrapDialog.TYPE_SUCCESS,
        message: description,
        buttons: [{
            label: Languages_BackOffice_Resource_Close,
            action: function (dialogRef) {
                dialogRef.close();
            }
        }]
    });
}

function Generic_Functions_DeleteRecordPrompt(id, controler, action, dataTable) {
    /// <summary>Delete record</summary>
    /// <returns type="void"></returns>
    BootstrapDialog.confirm(Languages_BackOffice_Resource_DeleteMessage, function (result) {
        if (result) {

            waitingDialog.show(Languages_BackOffice_Resource_Pleasewait);

            var stringArray = new Array();
            stringArray[0] = "" + id + "";

            $.post(ZB_Relative_Path +"ZBAdmin/" + controler + "/" + action + "/", { model: stringArray })
               .success(function (data) {

                   if (data.HasErrors == false) {
                       var table = $("#" + dataTable).DataTable();
                       table.ajax.reload();
                       waitingDialog.hide();

                   }
                   else if (data.HasErrors == true) {
                       waitingDialog.hide();
                       Generic_Functions_ShowErrorDialog(data.Title, data.Description);
                   }
                   else {
                       waitingDialog.hide();
                       Generic_Functions_ShowErrorDialog(Languages_BackOffice_Resource_Error, Languages_BackOffice_Resource_ErrorGeneric);
                   }
               }).fail(function (data) {
                   waitingDialog.hide();
                   Generic_Functions_ShowErrorDialog(Languages_BackOffice_Resource_Error, Languages_BackOffice_Resource_ErrorGeneric);
               });
        }
    });
}

function Generic_Functions_CopyRecordPrompt(id, controler, action, dataTable)
{
    BootstrapDialog.confirm(Languages_BackOffice_Resource_Copy+". "+Languages_BackOffice_Resource_SureContinue, function (result) {
        if (result) {

            waitingDialog.show(Languages_BackOffice_Resource_Pleasewait);

           

            $.post(ZB_Relative_Path + controler + "/" + action + "/"+ id)
               .success(function (data) {

                   if (data.HasErrors == false) {
                       var table = $("#" + dataTable).DataTable();
                       table.ajax.reload();
                       waitingDialog.hide();

                   }
                   else if (data.HasErrors == true) {
                       Generic_Functions_ShowErrorDialog(Languages_BackOffice_Resource_Error, data.Description);
                       waitingDialog.hide();         
                   }
                   else {
                       waitingDialog.hide();
                       Generic_Functions_ShowErrorDialog(Languages_BackOffice_Resource_Error, Languages_BackOffice_Resource_ErrorGeneric);
                   }
               }).fail(function (data) {
                   waitingDialog.hide();
                   Generic_Functions_ShowErrorDialog(Languages_BackOffice_Resource_Error, Languages_BackOffice_Resource_ErrorGeneric);
               });
        }
    });
}

