﻿/// <reference path="~/Scripts/_references.js" />

function Generic_List_LoadDataTable(targetDiv, orderColumn, idColumn, controller, editAction, deleteAction, listAction, hasEditBtn, hasDeleteBtn, hasImage, idColumnImage, hasSearch, hasOrder, customHtmlFirstColumn, columnDefExtra, hasCoppyBtn, coppyAction, debug)
{
    /// <summary>Load database with 2 links. First and Last column as link to edit page.</summary>
    /// <returns type="void"></returns>
    var editUrl = ZB_Relative_Path+ "ZBAdmin/" + controller + "/" + editAction;
    var deleteUrl = ZB_Relative_Path + "ZBAdmin/" + controller + "/" + deleteAction;
    var loadImage = ZB_Relative_Path + "images/ajax-loader.gif";
    var urlData = ZB_Relative_Path + "ZBAdmin/" + controller + "/" + listAction;
  
    if (debug == true)
    {
        alert("Edit: " + editUrl);
        alert("deleteUrl: " + deleteUrl);
        alert("loadImage: " + loadImage);
        alert("urlData: " + urlData);
    }


    $('#'+targetDiv).dataTable({
        "processing": true,
        "ordering": hasOrder,
        "searching": hasSearch,
        "serverSide": true,
        "stateSave": false,
        "order": [[orderColumn, "desc"]],
        "ajax": urlData,
        "language": {
            "emptyTable": Languages_BackOffice_Resource_NoRecordsFound,
            "emptyTable": Languages_BackOffice_Resource_NoRecordsFound,
            "info": Languages_BackOffice_Resource_ShowingPage,
            "infoEmpty": "",
            "lengthMenu": Languages_BackOffice_Resource_DataGridNumberRecords,
            "infoFiltered": "",
            "infoPostFix": "",
            "thousands": ",",
            "loadingRecords": Languages_BackOffice_Resource_Loading,
            "processing": "&nbsp;&nbsp;&nbsp;<img src='"+loadImage+"' />",
            "search": Languages_BackOffice_Resource_Search + "&nbsp;",
            "zeroRecords": Languages_BackOffice_Resource_NoRecordsFound,
            "paginate": {
                "first": Languages_BackOffice_Resource_First,
                "last":  Languages_BackOffice_Resource_Last,
                "next": Languages_BackOffice_Resource_Next,
                "previous": Languages_BackOffice_Resource_Previous
            }
        }, 
        "columnDefs": [
                  {
                      "targets": idColumn,
                      "render": function (data, type, row) {

                          var editBtn = "<a class='btn btn-primary btn-xs' href='" + editUrl + "/" + row[idColumn] + "'><i class='fa fa-pencil'></i></a>";
                          var deleteBtn = "<a class='btn btn-danger btn-xs' onclick=\"Generic_Functions_DeleteRecordPrompt('" + row[idColumn] + "', '" + controller + "', '" + deleteAction + "', '" + targetDiv + "' )\" ><i class='fa fa-times'></i></a>";

                          var cell = "";
                          if (hasEditBtn == true) {
                              cell += editBtn;
                          }

                          if (hasCoppyBtn == true)
                          {
                              var coppyBtn = "<a class='btn btn-default btn-xs' onclick=\"Generic_Functions_CopyRecordPrompt('" + row[idColumn] + "', '" + controller + "', '" + coppyAction + "', '" + targetDiv + "' )\" ><i class='fa fa-copy'></i></a>";
                              cell += coppyBtn;
                          }

                          if (hasDeleteBtn == true) {
                              cell += deleteBtn;
                          }
                          if (cell == "")
                          {
                              cell = data;
                          }
                          return cell;
                      }
                  },
                  { orderable: false, targets: [idColumn] },
                  {
                      "targets": 0,
                      "render": function (data, type, row) {

                          if (customHtmlFirstColumn != null)
                          {
                              var extra = customHtmlFirstColumn.replace("[ID]", row[idColumn]);
                              extra = extra.replace("[DATA]", data);

                              for (var i = 0; i < row.length; i++) {
                                  
                                  var codigo = "[" + i + "]";

                                  extra = extra.replace(codigo, row[i]);
                                  extra = extra.replace(codigo, row[i]);
                                  extra = extra.replace(codigo, row[i]);

                              }
                             
                              return extra;
                          }
                          else if (hasImage != null && hasImage == true) {
                              return "<img src='http://www.gravatar.com/avatar/" + row[idColumnImage] + "?s=30' />&nbsp;&nbsp; <a href='" + editUrl + "/" + row[idColumn] + "'>" + data + "</a>";

                          } else {
                              return "<a href='" + editUrl + "/" + row[idColumn] + "'>" + data + "</a>";
                          }

                      }
                  }
                  
        ]
    });

  
    if (columnDefExtra != null)
    {
        var oTable = $('#' + targetDiv).dataTable();

        for (i = 0; i < columnDefExtra.length; i++) {

            var record = columnDefExtra[i];
            //oTable.fnSetColumnVis(record.targets, record.visible);
            oTable.fnSettings().aoColumns[record.targets].bVisible = record.visible;
        }
    }

    App.dataTables();

}


function Generic_List_RefreshDataGrid(targetDiv)
{
    var table = $("#" + targetDiv).DataTable();
    table.ajax.reload();
}


