﻿/// <reference path="~/Scripts/_references.js" />

function HostingServer_Create() {
    OnPanelIntegrationCheck();
}

function HostingServer_Edit(modelID, panelId) {
    OnPanelIntegrationCheck();
    OnPanelChange(panelId, modelID);
}


function HostingServer_List() {
    Generic_List_LoadDataTable("ListServerDataTable", 0, 3, "HostingServer", "Edit", "Delete", "List", true, true, false, null, false, false);
}


$('#IsPanelIntegration').on('ifChanged', function (event) {
    OnPanelIntegrationCheck();
});

function OnPanelIntegrationCheck() {

    if ($('#IsPanelIntegration').is(':checked') == true) {

        $('#PanelArea').show();
    } else {
        $('#PanelArea').hide();
    }
}

function OnPanelChange(panelId, modelId) {
    $("#PanelConfig").html("<img src='"+ZB_Relative_Path+"images/ajax-loader.gif' alt='' />");
    ImageLoad(panelId);
    $("#PanelConfig").load(ZB_Relative_Path+"ZBAdmin/HostingServer/PanelForm/" + panelId+"/"+modelId);
}

function ImageLoad(panelId) {

    if (panelId == 0 || panelId == 'WebSitePanel') {
        $("#panelLogo").html("<img src='"+ZB_Relative_Path+"images/websitepanel.png' class='img-responsive' style='max-height:60px' />");

    } else if (panelId == 1 || panelId == 'Cpanel') {
        $("#panelLogo").html("<img src='"+ZB_Relative_Path+"images/cpanel.png' class='img-responsive' style='max-height:60px' />");

    } else if (panelId == 2 || panelId == 'Plesk') {
        $("#panelLogo").html("<img src='" + ZB_Relative_Path + "images/plesk.png' class='img-responsive' style='max-height:60px' />");
    } else {
        $("#panelLogo").html("");
    }

}