﻿/// <reference path="~/Scripts/_references.js" />

function Invoice_Create() {

}

function Invoice_Line_Create() {

}

function Invoice_Line_Edit(invoiceID, invoiceStatus)
{
    if (invoiceStatus != 0) {
        $("#form1 :input").attr("disabled", true); 
      }
}

function Invoice_Edit(modelID, statusID) {
    Generic_Forms_SelectTab();
    $("#auditing").load(ZB_Relative_Path + "ZBAdmin/Audit/PartialList/" + modelID);

    var hasDelete = true;
    if (statusID != 0)
    {
        hasDelete = false;
    }

    Generic_List_LoadDataTable("ListInvoiceLineDataTable", 1, 3, "Invoice", "EditLine", "DeleteLine", "ListLines/" + modelID, true, hasDelete, false, null, false, false);

    OnStatusChange(statusID, modelID);

    if (statusID != 0) //0 == unpaid
    {
        $("#form1 :input").attr("disabled", true);
        $("#UpdateOrderArea").hide();
        $("#NotifyClientArea").hide();
    }
}


function Invoice_List(status) {
    Generic_List_LoadDataTable("ListInvoiceDataTable", 2, 5, "Invoice", "Edit", "Delete", "List/" + status, true, true, false, null, true, true);
}

function GetOrders(id) {

    var procemessage = "<option value=''> "+Languages_BackOffice_Resource_Pleasewait+"...</option>";

    $("#ZOrderID").html(procemessage).show();

    $.ajax({
        url: ZB_Relative_Path + "ZBAdmin/Invoice/GetOrdersForClient/" + id,
        cache: false,
        type: "POST",
        success: function (data) {
            var markup = "<option value=\"\">" + Languages_BackOffice_Resource_SelectOne + "</option>";
            for (var x = 0; x < data.length; x++) {
                markup += "<option value=" + data[x].Value + ">" + data[x].Text + "</option>";
            }
            $("#ZOrderID").html(markup).show();
            $("#ZOrderID").select2("val", "");
        },
        error: function (reponse) {
            var markup = "<option value=\"\">" + Languages_BackOffice_Resource_SelectOne + "</option>";
            $("#ZOrderID").html(markup).show();
            alert(response);
        }
    });
}

function OnStatusChange(id, orderId) {

    if (id == 1) {
        $("#PaidDateArea").show();
        $("#NotifyClientArea").show();

        if (orderId != null) {
            $("#UpdateOrderArea").show();
        }
    }
    else if (id == 2) //cancel
    {
        $("#PaidDateArea").hide();
        $("#NotifyClientArea").show();

        if (orderId != null) {
            $("#UpdateOrderArea").hide();
        }

    } else { //

        $("#PaidDateArea").hide();
        $("#NotifyClientArea").hide();

        if (orderId != null) {
            $("#UpdateOrderArea").hide();
        }

        $("#PaidDate").val(null);
    }
}

function SendInvoice(modelID) {
    Generic_Forms_LoadDialog();

    var jqxhr = $.post(ZB_Relative_Path + "ZBAdmin/Invoice/Send/" + modelID)
        .success(function (data) {
            Generic_Forms_CloseLoadDialog();

            if (data.HasErrors != true) {
                Generic_Functions_ShowSuccessDialog(Languages_BackOffice_Resource_Success, Languages_BackOffice_Resource_OperationSuccess);
            } else {
                Generic_Functions_ShowErrorDialog(Languages_BackOffice_Resource_Error, data.Description);
            }
        })
    .fail(function (data) {
        Generic_Forms_CloseLoadDialog();

        Generic_Functions_ShowErrorDialog(Languages_BackOffice_Resource_Error, data.Description);
    });

}