﻿/// <reference path="~/Scripts/_references.js" />

function Order_Create(parentId) {

    if (parentId != "")
    {
        $("#ZClientID").prop('readonly', true);
    }
    
}

function Order_Edit(modelID, typeOrder) {

    Generic_Forms_SelectTab();
    OnPriceOverwriteChange();

    $("#auditing").load(ZB_Relative_Path + "ZBAdmin/Audit/PartialList/" + modelID);
    $("#btActions").load(ZB_Relative_Path + "ZBAdmin/Base/ActionButtons/" + typeOrder + "/" + modelID);

    Generic_List_LoadDataTable("ListSubOrders", 3, 4, "Order", "Edit", "Delete", "ListSubProducts/" + modelID, true, true, false, null, false, false, null, null, null, null, false);
    Generic_List_LoadDataTable("ListInvoiceDataTable", 0, 5, "Invoice", "Edit", "Delete", "ListOrder/" + modelID, true, true, false, null, true, true);
}


function Order_List(ostatus) {
    Generic_List_LoadDataTable("ListOrderDataTable", 3, 4, "Order", "Edit", "Delete", "List/" + ostatus, true, true, false, null, true, true, null, null, false, false, false);
  
}

function Order_Other_Edit(modelID) {
    Order_Edit(modelID, 10);
}

function Order_License_Edit(modelID) {
    Order_Edit(modelID, 9);
}

function Order_SaaS_Edit(modelID)
{
    Order_Edit(modelID, 27);
}

function Order_AddOn_Edit(modelID) {
    Order_Edit(modelID, 28);
}

function Order_Host_Edit(modelID)
{
    LoadPanelsBTN(modelID);
    Order_Edit(modelID, 1);
}

function Order_Domain_Edit(modelID) {
    
    Order_Edit(modelID, 8);
    LoadRegistrarBTN(modelID);
}

//share functions *****************

function OnPriceOverwriteChange() {

    if ($('#PriceOverWrite').is(':checked') == true) {
        $('#Price').attr("readonly", false);
    } else {
        $('#Price').attr("readonly", true);
    }
}

function GetPrice(id, relativeURL) {

    if ($('#PriceOverWrite').is(':checked') == false) {
        $("#Price").val("Loading price...");
        $.get(relativeURL + "ZBAdmin/Order/GetPrice/" + id, function (data) {
            if (data != null) {

                $("#Price").val(data);
            }
        });
    }

}

function GetPriceDrop(idProduct) {


    var procemessage = "<option value=\"0\"> " + Languages_BackOffice_Resource_Pleasewait + "...</option>";

    $("#ZPriceID").html(procemessage).show();

    $.ajax({
        url: ZB_Relative_Path + "ZBAdmin/Order/GetPricesByProduct/" + idProduct,
        cache: false,
        type: "POST",
        success: function (data) {

            var markup = "<option value=\"\">" + Languages_BackOffice_Resource_SelectOne + "</option>";

            for (var x = 0; x < data.length; x++) {
                markup += "<option value=" + data[x].Value + ">" + data[x].Text + "</option>";
            }
            $("#ZPriceID").html(markup).show();

            $("#ZPriceID").select2("val", "");
        },
        error: function (reponse) {


            Generic_Functions_ShowErrorDialog(Languages_BackOffice_Resource_Error, Languages_BackOffice_Resource_ErrorGeneric);
        }
    });

}

//Hosting ***************

function LoadPanelsBTN(modelID) {
    $("#btPanel").load(ZB_Relative_Path+"ZBAdmin/Order/HostingPanelBtn/"+modelID);
}



function ExecutePanelAction(objectid, regardingid) {

    Generic_Forms_LoadDialog();

    var jqxhr = $.post(ZB_Relative_Path+"ZBAdmin/Order/HostingPanelAction/" + objectid + "/" + regardingid)
         .success(function (data) {
             Generic_Forms_CloseLoadDialog();
             if (data.HasErrors != true)
             {
                 Generic_Functions_ShowSuccessDialog(Languages_BackOffice_Resource_Success, Languages_BackOffice_Resource_OperationSuccess);
                 LoadPanelsBTN();
             } else {
                 Generic_Functions_ShowErrorDialog(data.Title, data.Description);
             }
         })
         .fail(function (data) {
             Generic_Functions_ShowErrorDialog(Languages_BackOffice_Resource_Error, Languages_BackOffice_Resource_ErrorGeneric);
         });
}


//domain ************************
function LoadRegistrarBTN(modelID) {
    $("#btRegistrar").load(ZB_Relative_Path + "ZBAdmin/Order/DomainRegistrarBtn/" + modelID);
}

function ExecuteRegistrarAction(objectid, regardingid) {

    Generic_Forms_LoadDialog();

    var jqxhr = $.post(ZB_Relative_Path+"ZBAdmin/Order/DomainRegistrarAction/" + objectid + "/" + regardingid)
            .success(function (data) {

                Generic_Forms_CloseLoadDialog();

                if (data.HasErrors != true) {

                    Generic_Functions_ShowSuccessDialog(Languages_BackOffice_Resource_Success, Languages_BackOffice_Resource_OperationSuccess);
                    LoadRegistrarBTN();

                } else {
                    Generic_Functions_ShowErrorDialog(data.Title, data.Description);
                }
            })
            .fail(function (data) {
                Generic_Functions_ShowErrorDialog(Languages_BackOffice_Resource_Error, Languages_BackOffice_Resource_ErrorGeneric);
            });
}