﻿/// <reference path="~/Scripts/_references.js" />

function Registrar_Create() {
    OnRegistrarIntegrationCheck();
}

function Registrar_Edit(modelID, registrarID) {
    OnRegistrarIntegrationCheck();

    if (registrarID != null)
    {
        OnRegistrarChange(registrarID, modelID);
    }
}


function Registrar_List() {
    Generic_List_LoadDataTable("ListRegistrarTable", 0, 1, "Registrar", "Edit", "Delete", "List", true, true, false, null, false, false);
}


function OnRegistrarIntegrationCheck() {

    if ($('#IsRegistrarIntegration').is(':checked') == true) {

        $('#RegistrarArea').show();
    } else {
        $('#RegistrarArea').hide();
    }
}

$('#IsRegistrarIntegration').on('ifChanged', function (event) {
    OnRegistrarIntegrationCheck();
});


function OnRegistrarChange(panelId, idRecord) {
    $("#RegistrarConfig").html("<img src='"+ZB_Relative_Path+"images/ajax-loader.gif' alt='' />");
    ImageLoad(panelId);
    $("#RegistrarConfig").load(ZB_Relative_Path + "ZBAdmin/Registrar/RegistrarForm/" + panelId + "/" + idRecord);
}

function ImageLoad(panelId) {
    if (panelId == 0 || panelId == 'Enom') {
        $("#registrarLogo").html("<img src='"+ZB_Relative_Path+"images/enom.png' class='img-responsive' style='max-height:60px' />");
          
    } else {
        $("#registrarLogo").html("");
    }
}