﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class A_Detail_TransferInfo : PageBase
{
    private static int accountTypeIdOutBefore = 0;//修改前的转出账户类型id
    private static int accountIdOutBefore = 0;//修改前的账户id
    private static int accountTypeIdEnterBefore = 0;//修改前的转入账户类型id
    private static int accountIdEnterBefore = 0;//修改前的转入账户id
    private static double transferMoneyBefore = 0.00;//修改前的转账金额
    private static int accountTypeIdOut = 0;//修改后的转出账户类型id
    private static int accountIdOut = 0;//修改后的转出账户id
    private static int accountTypeIdEnter = 0;//修改后的转入账户id
    private static int accountIdEnter = 0;//修改后的转入账户id
    protected void Page_Load(object sender, EventArgs e)
    {
        if(!this.Page.IsPostBack)
        {
            BindPage();
        }
    }
    #region 功能栏事件（全部、支出、收入、转账、借贷按钮）
    protected void btnAllDetail_Click(object sender, EventArgs e)//全部明细
    {
        Response.Redirect("Detail.aspx");
    }
    protected void btnExpenditure_Click(object sender, EventArgs e)//支出明细
    {
        Response.Redirect("Detail_Expenditure.aspx");
    }
    protected void btnIncome_Click(object sender, EventArgs e)//收入明细
    {
        Response.Redirect("Detail_Income.aspx");
    }
    protected void btnTransfer_Click(object sender, EventArgs e)//转账明细
    {
        Response.Redirect("Detail_Transfer.aspx");
    }
    protected void btnLoan_Click(object sender, EventArgs e)//借贷明细
    {
        Response.Redirect("Detail_Loan.aspx");
    }
    #endregion
    #region 绑定转账记录信息
    /// <summary>
    /// 绑定转账记录信息
    /// </summary>
    public void BindPage()
    {
        if (!string.IsNullOrEmpty(Request["tiid"]))
        {
            DataSet ds = SqlHelper.GetDataSet("SELECT RTOutAccountTypeId,RTOutAccountId,RTEnterAccountTypeId, RTEnterAccountId,RecordTransferMoney,RTransferDateTime,RTransferRemarks,HandlerId FROM dbo.V_Detail_Transfer WHERE State=1 AND RecordTransferId=" + ConvertHelper.GetInteger(Request["tiid"]) + "", "constring");
            if(ds.Tables[0].Rows.Count>0)
            {
                #region 修改前的转出账户类型id，转出账户id，转入账户类型id，转入账户id，转账金额
                accountTypeIdOutBefore = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RTOutAccountTypeId"]);//修改前转出账户类型
                accountIdOutBefore = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RTOutAccountId"]);//修改前转出账户id
                accountTypeIdEnterBefore = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RTEnterAccountTypeId"]);//修改前转入账户类型
                accountIdEnterBefore = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RTEnterAccountId"]);//修改前转入账户id
                transferMoneyBefore = ConvertHelper.GetDouble(ds.Tables[0].Rows[0]["RecordTransferMoney"]);//修改前的转账金额
                #endregion
                #region 转出账户类型及账户id
                uclAccount.AccountTypeID=ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RTOutAccountTypeId"]);//转出账户类型
                accountTypeIdOut = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RTOutAccountTypeId"]);//修改后转出账户类型id
                if(uclAccount.AccountTypeID==1)//转出现金账户
                {
                    #region 转出现金账户
                    DataSet dsCashAccount = SqlHelper.GetDataSet("SELECT CashAccountName,State FROM dbo.tabA_Account_Cash WHERE CashAccountId=" + ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RTOutAccountId"]) + "", "constring");
                    if (dsCashAccount.Tables[0].Rows.Count > 0)
                    {
                        if (ConvertHelper.GetInteger(dsCashAccount.Tables[0].Rows[0]["State"]) == 0)//转出现金账户已删除
                        {
                            spanAccountNameOut.InnerHtml = ConvertHelper.GetString(dsCashAccount.Tables[0].Rows[0]["CashAccountName"]);//已删除的转出现金账户名
                            accountIdOut = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RTOutAccountId"]);//修改后转出账户id
                        }
                        else//转出现金账户未删除
                        {
                            uclAccount.CashAccountID = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RTOutAccountId"]);//转出现金账户
                        }
                    }
                    #endregion
                }
                else if(uclAccount.AccountTypeID==2)//转出信用卡
                {
                    #region 转出信用卡
                    DataSet dsCreditCard = SqlHelper.GetDataSet("SELECT CreditCardName,State FROM dbo.tabA_Account_CreditCard WHERE CreditCardId=" + ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RTOutAccountId"]) + "", "constring");
                    if (dsCreditCard.Tables[0].Rows.Count > 0)
                    {
                        if (ConvertHelper.GetInteger(dsCreditCard.Tables[0].Rows[0]["State"]) == 0)//转出信用卡已删除
                        {
                            spanAccountNameOut.InnerHtml = ConvertHelper.GetString(dsCreditCard.Tables[0].Rows[0]["CreditCardName"]);//已删除的转出信用卡名
                            accountIdOut = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RTOutAccountId"]);//修改后的转出账户id
                        }
                        else//转出信用卡未删除
                        {
                            uclAccount.CreditCardID = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RTOutAccountId"]);//转出信用卡
                        }
                    }
                    #endregion
                }
                else if(uclAccount.AccountTypeID==3)//转出储蓄卡
                {
                    #region 转出储蓄卡
                    DataSet dsSavingsCard = SqlHelper.GetDataSet("SELECT SavingsCardName,State FROM dbo.tabA_Account_SavingsCard WHERE SavingsCardId=" + ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RTOutAccountId"]) + "", "constring");
                     if (dsSavingsCard.Tables[0].Rows.Count > 0)
                     {
                         if (ConvertHelper.GetInteger(dsSavingsCard.Tables[0].Rows[0]["State"]) == 0)//转出储蓄卡已删除
                         {
                             spanAccountNameOut.InnerHtml = ConvertHelper.GetString(dsSavingsCard.Tables[0].Rows[0]["SavingsCardName"]);//已删除的转出储蓄卡名
                             accountIdOut = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RTOutAccountId"]);//修改后的转出账户id
                         }
                         else//转出储蓄卡未删除
                         {
                             uclAccount.SavingsCardID = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RTOutAccountId"]);//转出储蓄卡
                         }
                     }
                    #endregion
                }
                else if(uclAccount.AccountTypeID==4)//转出网上支付
                {
                    #region 转出网上支付
                    DataSet dsOnlinePay = SqlHelper.GetDataSet("SELECT OnlinePayName,State FROM dbo.tabA_Account_OnlinePay WHERE OnlinePayId=" + ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RTOutAccountId"]) + "", "constring");
                     if (dsOnlinePay.Tables[0].Rows.Count > 0)
                     {
                         if (ConvertHelper.GetInteger(dsOnlinePay.Tables[0].Rows[0]["State"]) == 0)//转出网上支付已删除
                         {
                             spanAccountNameOut.InnerHtml = ConvertHelper.GetString(dsOnlinePay.Tables[0].Rows[0]["OnlinePayName"]);//已删除的转出网上支付名
                             accountIdOut = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RTOutAccountId"]);//修改后的转出账户id
                         }
                         else//转出网上支付未删除
                         {
                             uclAccount.OnlinePayID = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RTOutAccountId"]);//转出网上支付
                         }
                     }
                    #endregion
                }
                #endregion
                #region 转入账户类型及账户id
                uclAccountEnter.AccountTypeID = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RTEnterAccountTypeId"]);//转入账户类型
                accountTypeIdEnter = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RTEnterAccountTypeId"]);//修改后转入账户类型id
                if (uclAccountEnter.AccountTypeID == 1)//转入现金账户
                {
                    #region 转入现金账户
                    DataSet dsCashAccount = SqlHelper.GetDataSet("SELECT CashAccountName,State FROM dbo.tabA_Account_Cash WHERE CashAccountId=" + ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RTEnterAccountId"]) + "", "constring");
                    if (dsCashAccount.Tables[0].Rows.Count > 0)
                    {
                        if (ConvertHelper.GetInteger(dsCashAccount.Tables[0].Rows[0]["State"]) == 0)//转入现金账户已删除
                        {
                            spanAccountNameOut.InnerHtml = ConvertHelper.GetString(dsCashAccount.Tables[0].Rows[0]["CashAccountName"]);//已删除的转入现金账户名
                            accountIdOut = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RTEnterAccountId"]);//修改后转入账户id
                        }
                        else//转入现金账户未删除
                        {
                            uclAccountEnter.CashAccountID = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RTEnterAccountId"]);//转入现金账户
                        }
                    }
                    #endregion
                }
                else if (uclAccountEnter.AccountTypeID == 2)//转入信用卡
                {
                    #region 转入信用卡
                    DataSet dsCreditCard = SqlHelper.GetDataSet("SELECT CreditCardName,State FROM dbo.tabA_Account_CreditCard WHERE CreditCardId=" + ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RTEnterAccountId"]) + "", "constring");
                     if (dsCreditCard.Tables[0].Rows.Count > 0)
                     {
                         if (ConvertHelper.GetInteger(dsCreditCard.Tables[0].Rows[0]["State"]) == 0)//转入信用卡已删除
                         {
                             spanAccountNameOut.InnerHtml = ConvertHelper.GetString(dsCreditCard.Tables[0].Rows[0]["CreditCardName"]);//已删除的转入信用卡名
                             accountIdOut = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RTEnterAccountId"]);//修改后的转入账户id
                         }
                         else//转入信用卡未删除
                         {
                             uclAccountEnter.CreditCardID = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RTEnterAccountId"]);//转入信用卡
                         }
                     }
                    #endregion 
                }
                else if (uclAccountEnter.AccountTypeID == 3)//转入储蓄卡
                {
                    #region 转入储蓄卡
                    DataSet dsSavingsCard = SqlHelper.GetDataSet("SELECT SavingsCardName,State FROM dbo.tabA_Account_SavingsCard WHERE SavingsCardId=" + ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RTEnterAccountId"]) + "", "constring");
                    if (dsSavingsCard.Tables[0].Rows.Count > 0)
                    {
                        if (ConvertHelper.GetInteger(dsSavingsCard.Tables[0].Rows[0]["State"]) == 0)//转入储蓄卡已删除
                        {
                            spanAccountNameOut.InnerHtml = ConvertHelper.GetString(dsSavingsCard.Tables[0].Rows[0]["SavingsCardName"]);//已删除的转入储蓄卡名
                            accountIdOut = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RTEnterAccountId"]);//修改后的转入账户id
                        }
                        else//转入储蓄卡未删除
                        {
                            uclAccountEnter.SavingsCardID = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RTEnterAccountId"]);//转入储蓄卡
                        }
                    }
                    #endregion 
                }
                else if (uclAccountEnter.AccountTypeID == 4)//转入网上支付
                {
                    #region 转入网上支付
                    DataSet dsOnlinePay = SqlHelper.GetDataSet("SELECT OnlinePayName,State FROM dbo.tabA_Account_OnlinePay WHERE OnlinePayId=" + ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RTEnterAccountId"]) + "", "constring");
                    if (dsOnlinePay.Tables[0].Rows.Count > 0)
                    {
                        if (ConvertHelper.GetInteger(dsOnlinePay.Tables[0].Rows[0]["State"]) == 0)//转入网上支付已删除
                        {
                            spanAccountNameOut.InnerHtml = ConvertHelper.GetString(dsOnlinePay.Tables[0].Rows[0]["OnlinePayName"]);//已删除的转入网上支付名
                            accountIdOut = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RTEnterAccountId"]);//修改后的转入账户id
                        }
                        else//转入网上支付未删除
                        {
                            uclAccountEnter.OnlinePayID = ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["RTEnterAccountId"]);//转入网上支付
                        }
                    }
                    #endregion
                }
                #endregion
                txtTransferMoney.Text = ConvertHelper.GetString(ds.Tables[0].Rows[0]["RecordTransferMoney"]);//转账金额
                txtTransferDateTime.Text = ConvertHelper.GetString(ds.Tables[0].Rows[0]["RTransferDateTime"]);//转账时间
                txtTransferRemarks.Text = ConvertHelper.GetString(ds.Tables[0].Rows[0]["RTransferRemarks"]);//转账备注时
            }
        }
    }
    #endregion 
    protected void btnSubmit_Click(object sender, EventArgs e)
    {
        if (!string.IsNullOrEmpty(Request["tiid"]))
        {
            #region 修改后的转出账户类型id及转出账户id
            if (spanAccountNameOut.InnerHtml == "")//转出账户未删除
            {
                #region 转出账户未删除的情况下修改后的转出账户类型id及转出账户id
                accountTypeIdOut = ConvertHelper.GetInteger(uclAccount.AccountTypeID);//转出账户类型id
                if (accountTypeIdOut == 1)//转出现金账户
                {
                    accountIdOut = ConvertHelper.GetInteger(uclAccount.CashAccountID);
                }
                else if (accountTypeIdOut == 2)//转出信用卡
                {
                    accountIdOut = ConvertHelper.GetInteger(uclAccount.CreditCardID);
                }
                else if (accountTypeIdOut == 3)//转出储蓄卡
                {
                    accountIdOut = ConvertHelper.GetInteger(uclAccount.SavingsCardID);
                }
                else if (accountTypeIdOut == 4)//转出网上支付
                {
                    accountIdOut = ConvertHelper.GetInteger(uclAccount.OnlinePayID);
                }
                #endregion
            }
            else//转出账户已删除
            {
                #region 转出账户已删除的情况下修改后的转出账户类型id及转出账户id
                if (!(uclAccount.CashAccountID==0&&uclAccount.CreditCardID==0&&uclAccount.SavingsCardID==0&&uclAccount.OnlinePayID==0))
                {
                    accountTypeIdOut = ConvertHelper.GetInteger(uclAccount.AccountTypeID);//转出账户类型id
                    if (accountTypeIdOut == 1)//转出现金账户
                    {
                        accountIdOut = ConvertHelper.GetInteger(uclAccount.CashAccountID);
                    }
                    else if (accountTypeIdOut == 2)//转出信用卡
                    {
                        accountIdOut = ConvertHelper.GetInteger(uclAccount.CreditCardID);
                    }
                    else if (accountTypeIdOut == 3)//转出储蓄卡
                    {
                        accountIdOut = ConvertHelper.GetInteger(uclAccount.SavingsCardID);
                    }
                    else if (accountTypeIdOut == 4)//转出网上支付
                    {
                        accountIdOut = ConvertHelper.GetInteger(uclAccount.OnlinePayID);
                    }
                }
                #endregion
            }
            #endregion
            #region 修改后的转入账户类型id及账户id
            if (spanAccountNameEnter.InnerHtml=="")//转入账户未删除
            {
                #region 转入账户未删除的情况下修改后的转入账户类型id及转入账户id
                accountTypeIdEnter = ConvertHelper.GetInteger(uclAccountEnter.AccountTypeID);//转出账户类型id
                if (accountTypeIdEnter == 1)//转出现金账户
                {
                    accountIdEnter = ConvertHelper.GetInteger(uclAccountEnter.CashAccountID);
                }
                else if (accountTypeIdEnter == 2)//转出信用卡
                {
                    accountIdEnter = ConvertHelper.GetInteger(uclAccountEnter.CreditCardID);
                }
                else if (accountTypeIdEnter == 3)//转出储蓄卡
                {
                    accountIdEnter = ConvertHelper.GetInteger(uclAccountEnter.SavingsCardID);
                }
                else if (accountTypeIdEnter == 4)//转出网上支付
                {
                    accountIdEnter = ConvertHelper.GetInteger(uclAccountEnter.OnlinePayID);
                }
                #endregion
            }
            else//转入账户已删除
            {
                #region 转入账户未删除的情况下修改后的转入账户类型id及转入账户id
                if (!(uclAccountEnter.CashAccountID == 0 && uclAccountEnter.CreditCardID == 0 && uclAccountEnter.SavingsCardID == 0 && uclAccountEnter.OnlinePayID == 0))
                {
                    accountTypeIdEnter = ConvertHelper.GetInteger(uclAccountEnter.AccountTypeID);//转出账户类型id
                    if (accountTypeIdEnter == 1)//转出现金账户
                    {
                        accountIdEnter = ConvertHelper.GetInteger(uclAccountEnter.CashAccountID);
                    }
                    else if (accountTypeIdEnter == 2)//转出信用卡
                    {
                        accountIdEnter = ConvertHelper.GetInteger(uclAccountEnter.CreditCardID);
                    }
                    else if (accountTypeIdEnter == 3)//转出储蓄卡
                    {
                        accountIdEnter = ConvertHelper.GetInteger(uclAccountEnter.SavingsCardID);
                    }
                    else if (accountTypeIdEnter == 4)//转出网上支付
                    {
                        accountIdEnter = ConvertHelper.GetInteger(uclAccountEnter.OnlinePayID);
                    }
                }
                #endregion
            }
            #endregion
            if (accountTypeIdOut == accountTypeIdEnter && accountIdOut == accountIdEnter)
            {
                ScriptHelper.AlertMessage(this.Page,"转账的两个账户必须不同，请重新选择！");
            }
            else
            {
                int flag = SqlHelper.Operation("UPDATE dbo.tabA_Record_Transfer SET RTOutAccountTypeId=" + accountTypeIdOut + ",RTOutAccountId=" + accountIdOut + ",RTEnterAccountTypeId=" + accountTypeIdEnter + ",RTEnterAccountId=" + accountIdEnter + ",RecordTransferMoney=" + ConvertHelper.GetDecimal(txtTransferMoney.Text.Trim()) + ",RTransferDateTime='" + ConvertHelper.GetDateTime(txtTransferDateTime.Text.Trim()) + "',RTransferRemarks='" + txtTransferRemarks.Text.Trim() + "',UpdateTime='" + System.DateTime.Now + "' WHERE RecordTransferId=" + ConvertHelper.GetInteger(Request["tiid"]) + " AND State=1", "constring");
                if (flag > 0)//修改转账记录成功
                {
                    #region 修改前后转出账户类型，转出账户，转入账户类型，转入账户，转账金额都相同时，账户表不做任何操作，直接跳转到转账明细页面
                    if (accountTypeIdOut == accountTypeIdOutBefore && accountIdOut == accountIdOutBefore && accountTypeIdEnter == accountTypeIdEnterBefore && accountIdEnter == accountIdEnterBefore && ConvertHelper.GetDecimal(txtTransferMoney.Text.Trim()) == ConvertHelper.GetDecimal(transferMoneyBefore))
                    {
                        Response.Redirect("Detail_Transfer.aspx");
                    }
                    #endregion
                    #region 修改前后转出账户类型或转出账户或转入账户类型或转入账户或转账金额不同时
                    #region 修改的步骤注释
                    /*修改的步骤：1-修改前的转出账户余额还原，成功则执行下一步，否则提示修改失败
                 *2-修改前的转入账号余额还原，成功则执行下一步，否则提示修改失败
                 *3-修改后的转出账户余额修改，成功则执行下一步，否则提示修改失败
                 *4-修改后的转入账号余额修改，成功则跳转到转账明细页，否则提示修改失败
                 */
                    #endregion
                    #region 修改具体步骤（修改前后转出账户类型或转出账户或转入账户类型或转入账户或转账金额不同时）
                    int flagAccountOutBefore = 0;//修改前转出账户余额还原是否成功的标志
                    #region 修改前的转出账户余额还原
                    if (accountTypeIdOutBefore == 1)//现金账户
                    {
                        flagAccountOutBefore = SqlHelper.Operation("UPDATE dbo.tabA_Account_Cash SET CashRemainder=CashRemainder+" + transferMoneyBefore + " WHERE CashAccountId=" + accountIdOutBefore + "", "constring");
                    }
                    else if (accountTypeIdOutBefore == 2)//信用卡(CardArrears:欠款金额（支出则”+“，收入则”-“）)
                    {
                        flagAccountOutBefore = SqlHelper.Operation("UPDATE dbo.tabA_Account_CreditCard SET CardArrears=CardArrears-" + transferMoneyBefore + " WHERE CreditCardId=" + accountIdOutBefore + "", "constring");
                    }
                    else if (accountTypeIdOutBefore == 3)//储蓄卡
                    {
                        flagAccountOutBefore = SqlHelper.Operation("UPDATE dbo.tabA_Account_SavingsCard SET SavingsCardRemainder=SavingsCardRemainder+" + transferMoneyBefore + " WHERE SavingsCardId=" + accountIdOutBefore + "", "constring");
                    }
                    else if (accountTypeIdOutBefore == 4)//网上支付
                    {
                        flagAccountOutBefore = SqlHelper.Operation("UPDATE dbo.tabA_Account_OnlinePay SET OnlinePayRemainder=OnlinePayRemainder+" + transferMoneyBefore + " WHERE OnlinePayId=" + accountIdOutBefore + "", "constring");
                    }
                    #endregion
                    if (flagAccountOutBefore > 0)//修改前的转出账户余额还原成功
                    {
                        #region 修改前的转入账户余额还原
                        int flagLoanAccountEnterBefore = 0;//修改前的转入账户余额还原是否成功的标志
                        if (accountTypeIdEnterBefore == 1)//现金账户
                        {
                            flagLoanAccountEnterBefore = SqlHelper.Operation("UPDATE dbo.tabA_Account_Cash SET CashRemainder=CashRemainder-" + transferMoneyBefore + " WHERE CashAccountId=" + accountIdEnterBefore + "", "constring");
                        }
                        else if (accountTypeIdEnterBefore == 2)//信用卡(CardArrears:欠款金额（支出则”+“，收入则”-“）)
                        {
                            flagLoanAccountEnterBefore = SqlHelper.Operation("UPDATE dbo.tabA_Account_CreditCard SET CardArrears=CardArrears+" + transferMoneyBefore + " WHERE CreditCardId=" + accountIdEnterBefore + "", "constring");
                        }
                        else if (accountTypeIdEnterBefore == 3)//储蓄卡
                        {
                            flagLoanAccountEnterBefore = SqlHelper.Operation("UPDATE dbo.tabA_Account_SavingsCard SET SavingsCardRemainder=SavingsCardRemainder-" + transferMoneyBefore + " WHERE SavingsCardId=" + accountIdEnterBefore + "", "constring");
                        }
                        else if (accountTypeIdEnterBefore == 4)//网上支付
                        {
                            flagLoanAccountEnterBefore = SqlHelper.Operation("UPDATE dbo.tabA_Account_OnlinePay SET OnlinePayRemainder=OnlinePayRemainder-" + transferMoneyBefore + " WHERE OnlinePayId=" + accountIdEnterBefore + "", "constring");
                        }
                        #endregion
                        if (flagLoanAccountEnterBefore > 0)//修改前的转入账户余额还原成功
                        {
                            int flagAccountOutAfter = 0;//修改后转出账户余额修改是否成功的标志
                            #region 修改后的转出账户余额修改
                            if (accountTypeIdOut == 1)//现金账户
                            {
                                flagAccountOutAfter = SqlHelper.Operation("UPDATE dbo.tabA_Account_Cash SET CashRemainder=CashRemainder-" + ConvertHelper.GetDecimal(txtTransferMoney.Text.Trim()) + " WHERE CashAccountId=" + accountIdOut + "", "constring");
                            }
                            else if (accountTypeIdOut == 2)//信用卡(CardArrears:欠款金额（支出则”+“，收入则”-“）)
                            {
                                flagAccountOutAfter = SqlHelper.Operation("UPDATE dbo.tabA_Account_CreditCard SET CardArrears=CardArrears+" + ConvertHelper.GetDecimal(txtTransferMoney.Text.Trim()) + " WHERE CreditCardId=" + accountIdOut + "", "constring");
                            }
                            else if (accountTypeIdOut == 3)//储蓄卡
                            {
                                flagAccountOutAfter = SqlHelper.Operation("UPDATE dbo.tabA_Account_SavingsCard SET SavingsCardRemainder=SavingsCardRemainder-" + ConvertHelper.GetDecimal(txtTransferMoney.Text.Trim()) + " WHERE SavingsCardId=" + accountIdOut + "", "constring");
                            }
                            else if (accountTypeIdOut == 4)//网上支付
                            {
                                flagAccountOutAfter = SqlHelper.Operation("UPDATE dbo.tabA_Account_OnlinePay SET OnlinePayRemainder=OnlinePayRemainder-" + ConvertHelper.GetDecimal(txtTransferMoney.Text.Trim()) + " WHERE OnlinePayId=" + accountIdOut + "", "constring");
                            }
                            #endregion
                            if (flagAccountOutAfter > 0)//修改后的转出账户余额修改成功
                            {
                                int flagAccountEnterAfter = 0;//修改后的转入账户余额修改是否成功的标志
                                #region 修改后的转入账户余额修改
                                if (accountTypeIdEnter == 1)//现金账户
                                {
                                    flagAccountEnterAfter = SqlHelper.Operation("UPDATE dbo.tabA_Account_Cash SET CashRemainder=CashRemainder+" + ConvertHelper.GetDecimal(txtTransferMoney.Text.Trim()) + " WHERE CashAccountId=" + accountIdEnter + "", "constring");
                                }
                                else if (accountTypeIdEnter == 2)//信用卡(CardArrears:欠款金额（支出则”+“，收入则”-“）)
                                {
                                    flagAccountEnterAfter = SqlHelper.Operation("UPDATE dbo.tabA_Account_CreditCard SET CardArrears=CardArrears-" + ConvertHelper.GetDecimal(txtTransferMoney.Text.Trim()) + " WHERE CreditCardId=" + accountIdEnter + "", "constring");
                                }
                                else if (accountTypeIdEnter == 3)//储蓄卡
                                {
                                    flagAccountEnterAfter = SqlHelper.Operation("UPDATE dbo.tabA_Account_SavingsCard SET SavingsCardRemainder=SavingsCardRemainder+" + ConvertHelper.GetDecimal(txtTransferMoney.Text.Trim()) + " WHERE SavingsCardId=" + accountIdEnter + "", "constring");
                                }
                                else if (accountTypeIdEnter == 4)//网上支付
                                {
                                    flagAccountEnterAfter = SqlHelper.Operation("UPDATE dbo.tabA_Account_OnlinePay SET OnlinePayRemainder=OnlinePayRemainder+" + ConvertHelper.GetDecimal(txtTransferMoney.Text.Trim()) + " WHERE OnlinePayId=" + accountIdEnter + "", "constring");
                                }
                                #endregion
                                if (flagAccountEnterAfter > 0)//修改后的转入账户余额修改成功
                                {
                                    Response.Redirect("Detail_Transfer.aspx");
                                }
                                else//修改后的转入账户余额修改失败
                                {
                                    ScriptHelper.AlertMessage(this.Page, "修改失败，请联系管理员！");
                                }
                            }
                            else//修改后的转出账户余额修改失败
                            {
                                ScriptHelper.AlertMessage(this.Page, "修改失败，请联系管理员！");
                            }
                        }
                        else//修改前的转入账户余额还原失败
                        {
                            ScriptHelper.AlertMessage(this.Page, "修改失败，请联系管理员！");
                        }
                    }
                    else//修改前的转出账户余额修改失败
                    {
                        ScriptHelper.AlertMessage(this.Page, "修改失败，请联系管理员！");
                    }
                    #endregion
                    #endregion
                }
                else
                {
                    ScriptHelper.AlertMessage(this.Page, "修改失败，请联系管理员！");
                }
            }
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)//取消事件
    {
        Response.Redirect("Detail_Transfer.aspx");
    }
}