﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text;
using System.Data;
using System.Web.UI.HtmlControls;

public partial class A_Info_CreditCardInfo :PageBase
{
    private static int currentPageNum = 1;//当前页数
    private static int pageCount = 1;//总页数
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!this.Page.IsPostBack)
        {
            pageCount = GetPageCount();//总页数
            spanPageCount.InnerHtml = ConvertHelper.GetString(pageCount);//总页数
            BindrptCreditCardInfo();
        }
    }
    #region 功能列表
    protected void btnLoanInfo_Click(object sender, EventArgs e)//借贷信息
    {
        Response.Redirect("Information.aspx");
    }
    protected void btnCreditCardInfo_Click(object sender, EventArgs e)//信用卡还款信息
    {
        Response.Redirect("CreditCardInfo.aspx");
    }
    #endregion
    /// <summary>
    /// 绑定信用卡还款消息
    /// </summary>
    public void BindrptCreditCardInfo()
    {
        SetStrWhere();
        ControlHelper.BindRepeater(this.rptCreditCardInfo,"constring",StrWhere+" AND Row BETWEEN (" + currentPageNum + "-1)*15+1 AND " + currentPageNum + "*15 ");
    }
    protected void rptCreditCardInfo_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        int creditCardId = ConvertHelper.GetInteger((e.Item.FindControl("hdCreditCardId") as HiddenField).Value);//信用卡id
        if (e.CommandName == "know")//知道了（将InfoType改为1无需提醒）
        {
            int flag = SqlHelper.Operation("UPDATE dbo.tabA_Account_CreditCard SET InfoType=1 WHERE CreditCardId="+creditCardId+"", "constring");
            if(flag>0)//知道了成功
            {
                BindrptCreditCardInfo();
            }
        }
    }
    protected void rptCreditCardInfo_ItemDataBound(object sender, RepeaterItemEventArgs e)
    {
        #region 绑定消息内容
        string info = "";//消息内容
        int creditCardInfoTypeId = ConvertHelper.GetInteger((e.Item.FindControl("hdInfoType") as HiddenField).Value);//提醒方式（1-无需提醒，2-当天提醒，3-提前三天提醒）
        int repaymentDay = ConvertHelper.GetInteger((e.Item.FindControl("hdRepaymentDay") as HiddenField).Value);//还款日（1-31）
        string creditCardName = ConvertHelper.GetString((e.Item.FindControl("hdCreditCardName") as HiddenField).Value);//信用卡名
        if(creditCardInfoTypeId==2)//当天提醒
        {
            info = "您的\"" + creditCardName + "\",须在1天内还款. 千万别忘了哦~ ";
        }
        else if(creditCardInfoTypeId==3)//提前三天提醒
        {
            int timespan = repaymentDay - ConvertHelper.GetInteger(System.DateTime.Now.Day)+1;//距离还款日的时间
            info = "您的\"" + creditCardName + "\",须在"+timespan+"天内还款. 千万别忘了哦~ ";
        }
        (e.Item.FindControl("spanInfo") as HtmlGenericControl).InnerHtml = info;//消息内容
        #endregion
    }
    #region 分页
    #region 获取分页总页数
    /// <summary>
    /// 获取分页总页数
    /// </summary>
    /// <returns></returns>
    public int GetPageCount()
    {
        int pagecount = 0;//总页数
        SetStrWhere();
        DataSet ds = SqlHelper.GetDataSet(StrWhere, "constring");
        if (ds.Tables[0].Rows.Count > 0)
        {
            int loanAccountCount = ConvertHelper.GetInteger(ds.Tables[0].Rows.Count);//借贷用户总个数
            if (loanAccountCount % 15 == 0)
            {
                pagecount = loanAccountCount / 15;
            }
            else
            {
                pagecount = loanAccountCount / 15 + 1;
            }
        }
        else
        {
            pagecount = 1;
        }
        return pagecount;
    }
    #endregion
    #region 首页
    protected void lbtnPageFirst_Click(object sender, EventArgs e)//首页
    {
        currentPageNum = 1;
        BindrptCreditCardInfo();
        spanPageCurrent.InnerHtml = "1";//当前页为1
    }
    #endregion
    #region 上页
    protected void lbtnPageUp_Click(object sender, EventArgs e)//上页
    {
        if (spanPageCurrent.InnerHtml != "1")//不是首页时
        {
            currentPageNum = ConvertHelper.GetInteger(spanPageCurrent.InnerHtml) - 1;
            BindrptCreditCardInfo();
            spanPageCurrent.InnerHtml = ConvertHelper.GetString(currentPageNum);//当前页spanPageCurrent赋值
        }
    }
    #endregion
    #region 下页
    protected void lbtnPageDown_Click(object sender, EventArgs e)//下页
    {
        if (spanPageCurrent.InnerHtml != ConvertHelper.GetString(pageCount))//不是尾页时
        {
            currentPageNum = ConvertHelper.GetInteger(spanPageCurrent.InnerHtml) + 1;
            BindrptCreditCardInfo();
            spanPageCurrent.InnerHtml = ConvertHelper.GetString(currentPageNum);//当前页spanPageCurrent赋值
        }
    }
    #endregion
    #region 末页
    protected void lbtnPageLast_Click(object sender, EventArgs e)//末页
    {
        currentPageNum = GetPageCount();
        BindrptCreditCardInfo();
        spanPageCurrent.InnerHtml = ConvertHelper.GetString(pageCount);//当前页等于总页数
    }
    #endregion
    #endregion
    #region 查询sql语句属性
    /// <summary>
    /// 查询sql语句属性
    /// </summary>
    public string StrWhere
    {
        get { return Convert.ToString(ViewState["StrWhere"]); }
        set { ViewState["StrWhere"] = value; }
    }
    /// <summary>
    /// 修改sql语句属性的方法
    /// </summary>
    public void SetStrWhere()
    {
        StringBuilder strb = new StringBuilder();
        //V_Detail_Expenditure视图：支出明细视图
        strb.Append("SELECT * FROM (SELECT ROW_NUMBER() OVER(ORDER BY CreateTime) AS Row,CreditCardId,CreditCardName,RepaymentDay,InfoType FROM dbo.tabA_Account_CreditCard WHERE (InfoType=2 AND RepaymentDay=" + System.DateTime.Now.Day + ") OR (InfoType=3 AND (RepaymentDay-" + System.DateTime.Now.Day + ">=0 AND RepaymentDay-" + System.DateTime.Now.Day + "<3)) AND State=1) AS temptable  WHERE 1=1 ");
        //if (uclBankCard.BankCardID != 0)//查询事件中的银行卡
        //{
        //    strb.Append("AND BankCardID=" + uclBankCard.BankCardID + " ");//银行卡id
        //}
        //else if (!string.IsNullOrEmpty(Request["BankId"]))//从银行卡列表页点击查看明细跳转到明细页面（即本页面）
        //{
        //    strb.Append("AND BankCardID=" + Request["BankId"] + " ");//银行卡id
        //}
        //if (!string.IsNullOrEmpty(txtCardNumber.Text.Trim()))
        //{
        //    strb.Append("AND BankCardNumber like '%" + txtCardNumber.Text.Trim() + "%' ");//银行卡号（模糊查询）
        //}
        //if (!string.IsNullOrEmpty(txtHeader.Text.Trim()))
        //{
        //    strb.Append("AND Header like '%" + txtHeader.Text.Trim() + "%' ");//户主名（模糊查询）
        //}
        //if (!string.IsNullOrEmpty(txtOther.Text.Trim()))
        //{
        //    strb.Append("AND OtherName like '%" + txtOther.Text.Trim() + "%'");//交易对方（模糊查询）
        //}
        //strb.Append(string.Format(timewhere.WhereString, " a.CreateTime"));
        StrWhere = strb.ToString();
    }
    #endregion
    
}