﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Text;
using System.Data;

public partial class A_Info_Information :PageBase
{
    private static int currentPageNum = 1;//当前页数
    private static int pageCount = 1;//总页数
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!this.Page.IsPostBack)
        {
            pageCount = GetPageCount();//总页数
            spanPageCount.InnerHtml = ConvertHelper.GetString(pageCount);//总页数
            BindRptLoanInformation();
        }
    }
    #region 功能列表
    protected void btnLoanInfo_Click(object sender, EventArgs e)//借贷信息
    {
        Response.Redirect("Information.aspx");
    }
    protected void btnCreditCardInfo_Click(object sender, EventArgs e)//信用卡还款信息
    {
        Response.Redirect("CreditCardInfo.aspx");
    }
    #endregion
    /// <summary>
    /// 绑定借贷消息rptLoanInformation
    /// </summary>
    public void BindRptLoanInformation()
    {
        SetStrWhere();
        ControlHelper.BindRepeater(this.rptLoanInformation, "constring", StrWhere + "AND Row BETWEEN (" + currentPageNum + "-1)*15+1 AND " + currentPageNum + "*15 ");
    }
    protected void rptLoanInformation_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        int loanid = ConvertHelper.GetInteger((e.Item.FindControl("hdRecordLoanId") as HiddenField).Value);//借贷记录id
        if (e.CommandName == "select")//查看详细
        {
            //Response.Redirect("");
        }
        else if (e.CommandName == "know")//知道了（如果点击知道了将把还款提醒改为1-无需提醒，并不显示在借贷消息页面）
        {
            int flag = SqlHelper.Operation("UPDATE dbo.V_Detail_Loan SET RLoanInfoWay=1 WHERE RecordLoanId="+loanid+"", "constring");
            if(flag>0)//执行成功
            {
                BindRptLoanInformation();
            }
        }
    }
    protected void rptLoanInformation_ItemDataBound(object sender, RepeaterItemEventArgs e)
    {
        string InfoContent = "";//消息内容
        int loanTypeId = ConvertHelper.GetInteger((e.Item.FindControl("hdRecordLoanTypeId") as HiddenField).Value);//借贷方式（1-借入，2-借出）
        string loanAccountName = ConvertHelper.GetString((e.Item.FindControl("hdLoanAccountName") as HiddenField).Value);//借贷方名
        string loanTime = ConvertHelper.GetDateTime((e.Item.FindControl("hdRLoanDateTime") as HiddenField).Value).ToString("yyyy年MM月dd日");//借贷日期
        double loanMoney = ConvertHelper.GetDouble((e.Item.FindControl("hdRecordLoanMoney") as HiddenField).Value);//借贷金额
        if (loanTypeId == 1)//借入
        {
            InfoContent = loanTime + "," + "从" + loanAccountName + "借入" + ConvertHelper.GetString(loanMoney);
        }
        else if (loanTypeId == 2)//借出
        {
            InfoContent = loanTime + "," + "向" + loanAccountName + "借出" + ConvertHelper.GetString(loanMoney);
        }
        (e.Item.FindControl("spanInfo") as HtmlGenericControl).InnerHtml = InfoContent;
    }
    #region 分页
    #region 获取分页总页数
    /// <summary>
    /// 获取分页总页数
    /// </summary>
    /// <returns></returns>
    public int GetPageCount()
    {
        int pagecount = 0;//总页数
        SetStrWhere();
        DataSet ds = SqlHelper.GetDataSet(StrWhere, "constring");
        if (ds.Tables[0].Rows.Count > 0)
        {
            int loanAccountCount = ConvertHelper.GetInteger(ds.Tables[0].Rows.Count);//借贷用户总个数
            if (loanAccountCount % 15 == 0)
            {
                pagecount = loanAccountCount / 15;
            }
            else
            {
                pagecount = loanAccountCount / 15 + 1;
            }
        }
        else
        {
            pagecount = 1;
        }
        return pagecount;
    }
    #endregion
    #region 首页
    protected void lbtnPageFirst_Click(object sender, EventArgs e)//首页
    {
        currentPageNum = 1;
        BindRptLoanInformation();
        spanPageCurrent.InnerHtml = "1";//当前页为1
    }
    #endregion
    #region 上页
    protected void lbtnPageUp_Click(object sender, EventArgs e)//上页
    {
        if (spanPageCurrent.InnerHtml != "1")//不是首页时
        {
            currentPageNum = ConvertHelper.GetInteger(spanPageCurrent.InnerHtml) - 1;
            BindRptLoanInformation();
            spanPageCurrent.InnerHtml = ConvertHelper.GetString(currentPageNum);//当前页spanPageCurrent赋值
        }
    }
    #endregion
    #region 下页
    protected void lbtnPageDown_Click(object sender, EventArgs e)//下页
    {
        if (spanPageCurrent.InnerHtml != ConvertHelper.GetString(pageCount))//不是尾页时
        {
            currentPageNum = ConvertHelper.GetInteger(spanPageCurrent.InnerHtml) + 1;
            BindRptLoanInformation();
            spanPageCurrent.InnerHtml = ConvertHelper.GetString(currentPageNum);//当前页spanPageCurrent赋值
        }
    }
    #endregion
    #region 末页
    protected void lbtnPageLast_Click(object sender, EventArgs e)//末页
    {
        currentPageNum = GetPageCount();
        BindRptLoanInformation();
        spanPageCurrent.InnerHtml = ConvertHelper.GetString(pageCount);//当前页等于总页数
    }
    #endregion
    #endregion
    #region 查询sql语句属性
    /// <summary>
    /// 查询sql语句属性
    /// </summary>
    public string StrWhere
    {
        get { return Convert.ToString(ViewState["StrWhere"]); }
        set { ViewState["StrWhere"] = value; }
    }
    /// <summary>
    /// 修改sql语句属性的方法
    /// </summary>
    public void SetStrWhere()
    {
        StringBuilder strb = new StringBuilder();
        //V_Detail_Expenditure视图：支出明细视图
        strb.Append("SELECT * FROM (SELECT ROW_NUMBER() OVER(ORDER BY RLRepaymentDateTime DESC) AS Row,RecordLoanId,RecordLoanMoney,RecordLoanTypeId,LoanAccountName,RLoanDateTime,RLRepaymentDateTime,RLoanInfoWay FROM dbo.V_Detail_Loan WHERE (RLoanInfoWay=2 AND RLRepaymentDateTime='" + ConvertHelper.GetShortDateString(System.DateTime.Now) + "') OR (RLoanInfoWay=3 AND (DATEDIFF(day,'" + ConvertHelper.GetShortDateString(System.DateTime.Now) + "',RLRepaymentDateTime)>=0 AND datediff (day,'" + ConvertHelper.GetShortDateString(System.DateTime.Now) + "',RLRepaymentDateTime) <3) ) AND RecordLoanTypeId IN (1,2) AND State=1) AS temptable  WHERE 1=1 ");
        //if (uclBankCard.BankCardID != 0)//查询事件中的银行卡
        //{
        //    strb.Append("AND BankCardID=" + uclBankCard.BankCardID + " ");//银行卡id
        //}
        //else if (!string.IsNullOrEmpty(Request["BankId"]))//从银行卡列表页点击查看明细跳转到明细页面（即本页面）
        //{
        //    strb.Append("AND BankCardID=" + Request["BankId"] + " ");//银行卡id
        //}
        //if (!string.IsNullOrEmpty(txtCardNumber.Text.Trim()))
        //{
        //    strb.Append("AND BankCardNumber like '%" + txtCardNumber.Text.Trim() + "%' ");//银行卡号（模糊查询）
        //}
        //if (!string.IsNullOrEmpty(txtHeader.Text.Trim()))
        //{
        //    strb.Append("AND Header like '%" + txtHeader.Text.Trim() + "%' ");//户主名（模糊查询）
        //}
        //if (!string.IsNullOrEmpty(txtOther.Text.Trim()))
        //{
        //    strb.Append("AND OtherName like '%" + txtOther.Text.Trim() + "%'");//交易对方（模糊查询）
        //}
        //strb.Append(string.Format(timewhere.WhereString, " a.CreateTime"));
        StrWhere = strb.ToString();
    }
    #endregion
}