﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class A_Record_Record_Expenditure : PageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if(!this.Page.IsPostBack)
        {
            OfficeManage.BindDdlExpenditureType(ddlExpenditureType);//绑定支出类型
            OfficeManage.BindDdlSeller(ddlSeller);//绑定商家
            OfficeManage.BindDdlProject(ddlProject);//绑定项目
        }
    }
    #region 功能栏事件（支出、收入、转账、借贷按钮）
    protected void btnExpenditure_Click(object sender, EventArgs e)//支出记账
    {
        Response.Redirect("Record_Expenditure.aspx");
    }
    protected void btnIncome_Click(object sender, EventArgs e)//收入记账
    {
        Response.Redirect("Record_Income.aspx");
    }
    protected void btnTransfer_Click(object sender, EventArgs e)//转账记账
    {
        Response.Redirect("Record_transfer.aspx");
    }
    protected void btnLoan_Click(object sender, EventArgs e)//借贷记账
    {
        Response.Redirect("Record_ Loan.aspx");
    }
    #endregion
    protected void btnSubmit_Click(object sender, EventArgs e)//添加支出信息
    {
        int accountId=0;//账户ID
        if(uclAccount.AccountTypeID==1)//现金账户
        {
            accountId=uclAccount.CashAccountID;
        }
        else if(uclAccount.AccountTypeID==2)//信用卡
        {
            accountId=uclAccount.CreditCardID;
        }
        else if(uclAccount.AccountTypeID==3)//储蓄卡
        {
            accountId=uclAccount.SavingsCardID;
        }
        else if(uclAccount.AccountTypeID==4)//网上支付
        {
            accountId=uclAccount.OnlinePayID;
        }
        int flag = SqlHelper.Operation("INSERT INTO dbo.tabA_Record_Expenditure(RExpenditureMoney,RExpenditureTypeId,RExpenditureSellerId,REAccountTypeId,REAccountId,RExpenditureDateTime,REProjectId,RExpenditureRemarks,CreateTime) VALUES(" + ConvertHelper.GetDecimal(txtExpenditureMoney.Text.Trim()) + "," + ConvertHelper.GetInteger(ddlExpenditureType.SelectedValue) + "," + ConvertHelper.GetInteger(ddlSeller.SelectedValue) + "," + uclAccount.AccountTypeID + "," + accountId + ",'" + ConvertHelper.GetDateTime(txtExpenditureDateTime.Text.Trim()) + "'," + ConvertHelper.GetInteger(ddlProject.SelectedValue) + ",'" + txtExpenditureRemarks.Text.Trim() + "','" + System.DateTime.Now + "')", "constring");
        if (flag > 0)//添加支出记录成功
        {
            int flags = 0;//修改的账户id
            if(uclAccount.AccountTypeID==1)//现金账户
            {
                flags = SqlHelper.Operation("UPDATE dbo.tabA_Account_Cash SET CashRemainder=CashRemainder-" + ConvertHelper.GetDecimal(txtExpenditureMoney.Text.Trim()) + " WHERE CashAccountId="+uclAccount.CashAccountID+"", "constring");//修改现金用户余额
            }
            else if (uclAccount.AccountTypeID == 2)//信用卡账户(cardArrears:欠款金额)
            {
                flags = SqlHelper.Operation("UPDATE dbo.tabA_Account_CreditCard SET CardArrears=CardArrears+" + ConvertHelper.GetDecimal(txtExpenditureMoney.Text.Trim()) + " WHERE CreditCardId=" + uclAccount.CreditCardID + "", "constring");//修改信用卡账户欠款金额
            }
            else if(uclAccount.AccountTypeID==3)//储蓄卡账户
            {
                flags = SqlHelper.Operation("UPDATE dbo.tabA_Account_SavingsCard SET SavingsCardRemainder=SavingsCardRemainder-" + ConvertHelper.GetDecimal(txtExpenditureMoney.Text.Trim()) + " WHERE SavingsCardId=" + uclAccount.SavingsCardID + "", "constring");//修改储蓄卡账户余额
            }
            else if (uclAccount.AccountTypeID == 4)//网上支付账户
            {
                flags = SqlHelper.Operation("UPDATE dbo.tabA_Account_OnlinePay SET OnlinePayRemainder=OnlinePayRemainder-" + ConvertHelper.GetDecimal(txtExpenditureMoney.Text.Trim()) + " WHERE OnlinePayId=" + uclAccount.OnlinePayID + "", "constring");//修改网上支付账户余额
            }
            if (flags > 0)
            {
                ScriptHelper.AlertMessage(this.Page, "添加成功！");
                ExpenditureClear();
            }
            else//账户余额修改失败，删除刚添加的支出记录
            {
                SqlHelper.Operation("DELETE FROM dbo.tabA_Record_Expenditure WHERE RecordExpenditureId=" + flag + "", "constring");//删除刚添加的支出记录
                ScriptHelper.AlertMessage(this.Page, "添加失败，请联系管理员！");
            }
        }
        else
        {
            ScriptHelper.AlertMessage(this.Page,"添加失败，请联系管理员！");
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)//取消事件（即数据重置）
    {
        ExpenditureClear();
    }
    /// <summary>
    /// 支出页数据重置
    /// </summary>
    public void ExpenditureClear()
    {
        txtExpenditureMoney.Text = "";//支出金额
        OfficeManage.BindDdlExpenditureType(ddlExpenditureType);//绑定支出类型
        OfficeManage.BindDdlSeller(ddlSeller);//绑定商家
        uclAccount.AccountTypeID = 1;//账户类型为现金类型
        uclAccount.CashAccountID = 0;//账户为空
        txtExpenditureDateTime.Text = "";//支出时间
        OfficeManage.BindDdlProject(ddlProject);//绑定项目
        txtExpenditureRemarks.Text = "";//备注
    }
}