﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class A_Record_Record_transfer : PageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {

    }
    #region 功能栏事件（支出、收入、转账、借贷按钮）
    protected void btnExpenditure_Click(object sender, EventArgs e)//支出记账
    {
        Response.Redirect("Record_Expenditure.aspx");
    }
    protected void btnIncome_Click(object sender, EventArgs e)//收入记账
    {
        Response.Redirect("Record_Income.aspx");
    }
    protected void btnTransfer_Click(object sender, EventArgs e)//转账记账
    {
        Response.Redirect("Record_transfer.aspx");
    }
    protected void btnLoan_Click(object sender, EventArgs e)//借贷记账
    {
        Response.Redirect("Record_ Loan.aspx");
    }
    #endregion
    /// <summary>
    /// 转账操作
    /// 思想及步骤：1、添加转账记录（添加成功则继续下一步，添加失败则提示添加失败）
    /// 2.添加转账记录后修改转出账户的余额（修改转出账户余额-转账金额成功则进行下一步，否则删除刚添加的转账记录，最后提示添加失败）
    /// 3.修改转出账户余额成功后修改转入账户余额（修改转入账户余额+转账金额成功后提示添加成功，否则修改转出账户余额恢复(即转出账户余额+转账金额)），恢复成功则删除刚添加的转账记录再提示添加失败，否则提示添加失败
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSubmit_Click(object sender, EventArgs e)
    {
        #region 获取转出账户id
        int accountId = 0;//转出账户ID
        if (uclAccount.AccountTypeID == 1)//转出现金账户
        {
            accountId = uclAccount.CashAccountID;
        }
        else if (uclAccount.AccountTypeID == 2)//转出信用卡
        {
            accountId = uclAccount.CreditCardID;
        }
        else if (uclAccount.AccountTypeID == 3)//转出储蓄卡
        {
            accountId = uclAccount.SavingsCardID;
        }
        else if (uclAccount.AccountTypeID == 4)//转出网上支付
        {
            accountId = uclAccount.OnlinePayID;
        }
        #endregion
        #region 获取转入账户id
        int acccountEnterId = 0;//转入账户id
        if (uclAccountEnter.AccountTypeID == 1)//转入现金账户
        {
            acccountEnterId = uclAccountEnter.CashAccountID;
        }
        else if (uclAccountEnter.AccountTypeID == 2)//转入信用卡
        {
            acccountEnterId = uclAccountEnter.CreditCardID;
        }
        else if (uclAccountEnter.AccountTypeID == 3)//转入储蓄卡
        {
            acccountEnterId = uclAccountEnter.SavingsCardID;
        }
        else if (uclAccountEnter.AccountTypeID == 4)//转入网上支付
        {
            acccountEnterId = uclAccountEnter.OnlinePayID;
        }
        #endregion
        //添加转账记录
        int flag = SqlHelper.Operation("INSERT INTO dbo.tabA_Record_Transfer(RTOutAccountTypeId,RTOutAccountId,RTEnterAccountTypeId,RTEnterAccountId,RecordTransferMoney,RTransferDateTime,RTransferRemarks,CreateTime) VALUES("+ConvertHelper.GetInteger(uclAccount.AccountTypeID)+","+accountId+","+ConvertHelper.GetInteger(uclAccountEnter.AccountTypeID)+","+acccountEnterId+","+ConvertHelper.GetDecimal(txtTransferMoney.Text.Trim())+",'"+ConvertHelper.GetDateTime(txtTransferDateTime.Text.Trim())+"','"+txtTransferRemarks.Text.Trim()+"','"+System.DateTime.Now+"')", "constring");
        if (flag > 0)//添加转账记录成功
        {
            #region 修改转出账户余额
            int flags = 0;//转出账户修改的id
            if (uclAccount.AccountTypeID == 1)//转出现金账户
            {
                flags = SqlHelper.Operation("UPDATE dbo.tabA_Account_Cash SET CashRemainder=CashRemainder-" + ConvertHelper.GetDecimal(txtTransferMoney.Text.Trim()) + " WHERE CashAccountId=" + uclAccount.CashAccountID + "", "constring");//修改现金用户余额
            }
            else if (uclAccount.AccountTypeID == 2)//转出信用卡账户(cardArrears:欠款金额)
            {
                flags = SqlHelper.Operation("UPDATE dbo.tabA_Account_CreditCard SET CardArrears=CardArrears+" + ConvertHelper.GetDecimal(txtTransferMoney.Text.Trim()) + " WHERE CreditCardId=" + uclAccount.CreditCardID + "", "constring");//修改信用卡账户欠款金额
            }
            else if (uclAccount.AccountTypeID == 3)//转出储蓄卡账户
            {
                flags = SqlHelper.Operation("UPDATE dbo.tabA_Account_SavingsCard SET SavingsCardRemainder=SavingsCardRemainder-" + ConvertHelper.GetDecimal(txtTransferMoney.Text.Trim()) + " WHERE SavingsCardId=" + uclAccount.SavingsCardID + "", "constring");//修改储蓄卡账户余额
            }
            else if (uclAccount.AccountTypeID == 4)//转出网上支付账户
            {
                flags = SqlHelper.Operation("UPDATE dbo.tabA_Account_OnlinePay SET OnlinePayRemainder=OnlinePayRemainder-" + ConvertHelper.GetDecimal(txtTransferMoney.Text.Trim()) + " WHERE OnlinePayId=" + uclAccount.OnlinePayID + "", "constring");//修改网上支付账户余额
            }
            #endregion
            if (flags > 0)//转出账户余额修改成功
            {
                #region 修改转入账户余额
                int flagss = 0;//转入账户修改的id
                if (uclAccountEnter.AccountTypeID == 1)//转入现金账户
                {
                    flagss = SqlHelper.Operation("UPDATE dbo.tabA_Account_Cash SET CashRemainder=CashRemainder+" + ConvertHelper.GetDecimal(txtTransferMoney.Text.Trim()) + " WHERE CashAccountId=" + uclAccountEnter.CashAccountID + "", "constring");//修改现金用户余额
                }
                else if (uclAccountEnter.AccountTypeID == 2)//转入信用卡账户(cardArrears:欠款金额)
                {
                    flagss = SqlHelper.Operation("UPDATE dbo.tabA_Account_CreditCard SET CardArrears=CardArrears-" + ConvertHelper.GetDecimal(txtTransferMoney.Text.Trim()) + " WHERE CreditCardId=" + uclAccountEnter.CreditCardID + "", "constring");//修改信用卡账户欠款金额
                }
                else if (uclAccountEnter.AccountTypeID == 3)//转入储蓄卡账户
                {
                    flagss = SqlHelper.Operation("UPDATE dbo.tabA_Account_SavingsCard SET SavingsCardRemainder=SavingsCardRemainder+" + ConvertHelper.GetDecimal(txtTransferMoney.Text.Trim()) + " WHERE SavingsCardId=" + uclAccountEnter.SavingsCardID + "", "constring");//修改储蓄卡账户余额
                }
                else if (uclAccountEnter.AccountTypeID == 4)//转入网上支付账户
                {
                    flagss = SqlHelper.Operation("UPDATE dbo.tabA_Account_OnlinePay SET OnlinePayRemainder=OnlinePayRemainder+" + ConvertHelper.GetDecimal(txtTransferMoney.Text.Trim()) + " WHERE OnlinePayId=" + uclAccountEnter.OnlinePayID + "", "constring");//修改网上支付账户余额
                }
                #endregion
                if (flagss>0)//转入账户余额修改成功
                {
                    ScriptHelper.AlertMessage(this.Page, "添加成功！");
                    TransferClear();
                }
                else//转入账户余额修改失败，恢复转出账户余额，再删除刚添加的转账记录
                {
                    #region 转入账户余额修改失败，恢复转出账户余额，再删除刚添加的转账记录
                    int flagOutRenew = 0;//转出账户恢复
                    if (uclAccount.AccountTypeID == 1)//转出现金账户
                    {
                        flagOutRenew = SqlHelper.Operation("UPDATE dbo.tabA_Account_Cash SET CashRemainder=CashRemainder+" + ConvertHelper.GetDecimal(txtTransferMoney.Text.Trim()) + " WHERE CashAccountId=" + uclAccount.CashAccountID + "", "constring");//修改现金用户余额
                    }
                    else if (uclAccount.AccountTypeID == 2)//转出信用卡账户(cardArrears:欠款金额)
                    {
                        flagOutRenew = SqlHelper.Operation("UPDATE dbo.tabA_Account_CreditCard SET CardArrears=CardArrears-" + ConvertHelper.GetDecimal(txtTransferMoney.Text.Trim()) + " WHERE CreditCardId=" + uclAccount.CreditCardID + "", "constring");//修改信用卡账户欠款金额
                    }
                    else if (uclAccount.AccountTypeID == 3)//转出储蓄卡账户
                    {
                        flagOutRenew = SqlHelper.Operation("UPDATE dbo.tabA_Account_SavingsCard SET SavingsCardRemainder=SavingsCardRemainder+" + ConvertHelper.GetDecimal(txtTransferMoney.Text.Trim()) + " WHERE SavingsCardId=" + uclAccount.SavingsCardID + "", "constring");//修改储蓄卡账户余额
                    }
                    else if (uclAccount.AccountTypeID == 4)//转出网上支付账户
                    {
                        flagOutRenew = SqlHelper.Operation("UPDATE dbo.tabA_Account_OnlinePay SET OnlinePayRemainder=OnlinePayRemainder+" + ConvertHelper.GetDecimal(txtTransferMoney.Text.Trim()) + " WHERE OnlinePayId=" + uclAccount.OnlinePayID + "", "constring");//修改网上支付账户余额
                    }
                    if (flagOutRenew > 0)
                    {
                        SqlHelper.Operation("DELETE FROM dbo.tabA_Record_Transfer WHERE RecordTransferId=" + flag + "", "constring");//删除刚添加的支出记录
                        ScriptHelper.AlertMessage(this.Page, "添加失败，请联系管理员！");
                    }
                    else
                    {
                        ScriptHelper.AlertMessage(this.Page,"添加失败，请联系管理员！");
                    }
                    #endregion
                }
            }
            else//转出账户余额修改失败，删除刚添加的转账记录
            {
                SqlHelper.Operation("DELETE FROM dbo.tabA_Record_Transfer WHERE RecordTransferId=" + flag + "", "constring");//删除刚添加的支出记录
                ScriptHelper.AlertMessage(this.Page, "添加失败，请联系管理员！");
            }
        }
        else
        {
            ScriptHelper.AlertMessage(this.Page,"添加失败，请联系管理员！");
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)//取消事件（即重置）
    {
        TransferClear();
    }
    /// <summary>
    /// 转账重置
    /// </summary>
    public void TransferClear()
    {
        uclAccount.AccountTypeID = 1;//转出账户类型id变为1现金账户
        uclAccount.CashAccountID = 0;//转出账户id为0
        uclAccountEnter.AccountTypeID = 1;//转入账户类型id变为1现金账户
        uclAccountEnter.CashAccountID = 0;//转出账户id为0
        txtTransferMoney.Text = "";//转出金额
        txtTransferDateTime.Text = "";//转出时间
        txtTransferRemarks.Text = "";//备注
    }
}