﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Account_Account : PageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!this.Page.IsPostBack)
        {
            BindrptCashAccount();
            BindRptCreditCard();
            BindRptSavingsCard();
            BindRptOnlinePay();
            BindRptLoanAccount();
        }
    }
    #region 功能列表
    protected void btnAllAccount_Click(object sender, EventArgs e)//全部账户
    {
        Response.Redirect("Account.aspx");
    }
    protected void btnCashAccount_Click(object sender, EventArgs e)//现金账户
    {
        Response.Redirect("Account_Cash.aspx");
    }
    protected void btnCreditCard_Click(object sender, EventArgs e)//信用卡账户
    {
        Response.Redirect("Account_CreditCard.aspx");
    }
    protected void btnSavingsCard_Click(object sender, EventArgs e)//储蓄卡账户
    {
        Response.Redirect("Account_SavingsCard.aspx");
    }
    protected void btnOnlinPay_Click(object sender, EventArgs e)//网上支付
    {
        Response.Redirect("Account_OnlinePay.aspx");
    }
    protected void btnLoan_Click(object sender, EventArgs e)//借贷账户
    {
        Response.Redirect("Account_Loan.aspx");
    }
    #endregion

    #region 现金账户
    /// <summary>
    /// 绑定现金账户rptCashAccount
    /// </summary>
    public void BindrptCashAccount()
    {
        ControlHelper.BindRepeater(this.rptCashAccount, "constring", "SELECT CashAccountId,CashAccountName,CashRemainder,State FROM dbo.tabA_Account_Cash");
    }
    //现金账户ItemCommand事件
    protected void rptCashAccount_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        int cashAccountid = ConvertHelper.GetInteger((e.Item.FindControl("hfCashAccountId") as HiddenField).Value);//现金账户id
        if(e.CommandName=="edit")//现金账户编辑
        {
            Response.Redirect("CashAccountInfo.aspx?caid="+cashAccountid+"");
        }
        else if(e.CommandName=="block")//现金账户的停用与恢复
        {
            int state=ConvertHelper.GetInteger((e.Item.FindControl("hfCashBlockState") as HiddenField).Value);//现金账户的停用状态（0-已停用，1-未停用）
            if (state > 0)//未停用的账户
            {
                int flag = SqlHelper.Operation("UPDATE dbo.tabA_Account_Cash SET State=0 WHERE CashAccountId=" + cashAccountid + "", "constring");
                if (flag > 0)
                {
                    BindrptCashAccount();
                    (e.Item.FindControl("lbtnBlockCash") as LinkButton).Text = "恢复";//停用按钮变为恢复按钮
                    (e.Item.FindControl("lbtnEditCash") as LinkButton).Visible = false;//编辑不可用
                }
                else
                {
                    ScriptHelper.AlertMessage(this.Page, "停用失败，请联系管理员！");
                }
            }
            else//已停用的账户
            {
                int flag = SqlHelper.Operation("UPDATE dbo.tabA_Account_Cash SET State=1 WHERE CashAccountId=" + cashAccountid + "", "constring");
                if (flag > 0)
                {
                    BindrptCashAccount();
                    (e.Item.FindControl("lbtnBlockCash") as LinkButton).Text = "停用";//恢复按钮变为停用按钮
                    (e.Item.FindControl("lbtnEditCash") as LinkButton).Visible = true;//编辑可用
                }
                else
                {
                    ScriptHelper.AlertMessage(this.Page, "恢复失败，请联系管理员！");
                }
            }
        }
    }
    //现金账户ItemDateBound事件
    protected void rptCashAccount_ItemDataBound(object sender, RepeaterItemEventArgs e)
    {
        int cashAccountid = ConvertHelper.GetInteger((e.Item.FindControl("hfCashAccountId") as HiddenField).Value);//现金账户id
        int state = ConvertHelper.GetInteger((e.Item.FindControl("hfCashBlockState") as HiddenField).Value);//现金账户的停用状态（0-已停用，1-未停用）
        if (state > 0)//未停用的现金账户
        {
            (e.Item.FindControl("lbtnBlockCash") as LinkButton).Text = "停用";//停用按钮
            (e.Item.FindControl("lbtnEditCash") as LinkButton).Visible = true;//编辑可用
        }
        else
        {
            (e.Item.FindControl("lbtnBlockCash") as LinkButton).Text = "恢复";//恢复按钮
            (e.Item.FindControl("lbtnEditCash") as LinkButton).Visible = false;//编辑不可用
        }
    }
    #endregion

    #region 信用卡
    /// <summary>
    /// 绑定信用卡rptCreditCard
    /// </summary>
    public void BindRptCreditCard()
    {
        ControlHelper.BindRepeater(this.rptCreditCard, "constring", "SELECT CreditCardId,CreditCardName,CardArrears,State FROM dbo.tabA_Account_CreditCard");
    }
    //信用卡ItemCommand事件
    protected void rptCreditCard_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        int creditCardId =ConvertHelper.GetInteger((e.Item.FindControl("hfCreditCardId") as HiddenField).Value);//信用卡id
        if(e.CommandName=="edit")//信用卡编辑
        {
            Response.Redirect("CreditCardInfo.aspx?ccid="+creditCardId+"");
        }
        else if(e.CommandName=="block")//信用卡停用与恢复
        {
            int state = ConvertHelper.GetInteger((e.Item.FindControl("hfCreditCardBlockState") as HiddenField).Value);//信用卡停用状态（0-已停用，1-未停用）
            if (state > 0)//未停用信用卡
            {
                int flag = SqlHelper.Operation("UPDATE dbo.tabA_Account_CreditCard SET State=0 WHERE CreditCardId=" + creditCardId + "", "constring");
                if (flag > 0)
                {
                    BindRptCreditCard();
                    (e.Item.FindControl("lbtnBlockCreditCard") as LinkButton).Text = "恢复";//停用按钮变为恢复按钮
                    (e.Item.FindControl("lbtnEditCreditCard") as LinkButton).Visible = false;//编辑不可用
                }
            }
            else//已停用信用卡
            {
                int flag = SqlHelper.Operation("UPDATE dbo.tabA_Account_CreditCard SET State=1 WHERE CreditCardId=" + creditCardId + "", "constring");
                if (flag > 0)
                {
                    BindRptCreditCard();
                    (e.Item.FindControl("lbtnBlockCreditCard") as LinkButton).Text = "停用";//恢复按钮变为停用按钮
                    (e.Item.FindControl("lbtnEditCreditCard") as LinkButton).Visible = true;//编辑可用
                }
            }
        }
    }
    //信用卡ItemDateBound
    protected void rptCreditCard_ItemDataBound(object sender, RepeaterItemEventArgs e)
    {
        int state = ConvertHelper.GetInteger((e.Item.FindControl("hfCreditCardBlockState") as HiddenField).Value);
        if (state > 0)//未停用信用卡
        {
            (e.Item.FindControl("lbtnBlockCreditCard") as LinkButton).Text = "停用";//停用按钮
            (e.Item.FindControl("lbtnEditCreditCard") as LinkButton).Visible = true;//编辑可用
        }
        else//已停用信用卡
        {
            (e.Item.FindControl("lbtnBlockCreditCard") as LinkButton).Text = "恢复";//恢复按钮
            (e.Item.FindControl("lbtnEditCreditCard") as LinkButton).Visible = false;//编辑不可用
        }
    }
    #endregion

    #region 储蓄卡
    /// <summary>
    /// 绑定储蓄卡rptSavingsCard
    /// </summary>
    public void BindRptSavingsCard()
    {
        ControlHelper.BindRepeater(this.rptSavingsCard, "constring", "SELECT SavingsCardId,SavingsCardName,SavingsCardRemainder,State FROM dbo.tabA_Account_SavingsCard");
    }
    //储蓄卡ItemCommand
    protected void rptSavingsCard_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        int savingsCardId = ConvertHelper.GetInteger((e.Item.FindControl("hfSavingsCardId") as HiddenField).Value);//储蓄卡id
        if (e.CommandName == "edit")//储蓄卡编辑
        {
            Response.Redirect("SavingsCardInfo.aspx?scid=" + savingsCardId + "");
        }
        else if(e.CommandName=="block")//储蓄卡的停用与恢复
        {
            int state = ConvertHelper.GetInteger((e.Item.FindControl("hfSavingsCardState") as HiddenField).Value);//储蓄卡停用状态（0-已停用，1-未停用）
            if (state > 0)//未停用储蓄卡
            {
                int flag = SqlHelper.Operation("UPDATE dbo.tabA_Account_SavingsCard SET State=0 WHERE SavingsCardId=" + savingsCardId + "", "constring");//改为停用
                if (flag > 0)
                {
                    BindRptSavingsCard();
                    (e.Item.FindControl("lbtnBlockSavingsCard") as LinkButton).Text = "恢复";//停用按钮变为恢复按钮
                    (e.Item.FindControl("lbtnEditSavingsCard") as LinkButton).Visible = false;//编辑不可用
                }
            }
            else//已停用储蓄卡
            {
                int flag = SqlHelper.Operation("UPDATE dbo.tabA_Account_SavingsCard SET State=1 WHERE SavingsCardId=" + savingsCardId + "", "constring");//改为未停用
                if (flag > 0)
                {
                    BindRptSavingsCard();
                    (e.Item.FindControl("lbtnBlockSavingsCard") as LinkButton).Text = "停用";//恢复按钮变为停用按钮
                    (e.Item.FindControl("lbtnEditSavingsCard") as LinkButton).Visible = true;//编辑可用
                }
            }
        }
    }
    //储蓄卡ItemDateBound事件
    protected void rptSavingsCard_ItemDataBound(object sender, RepeaterItemEventArgs e)
    {
        int state = ConvertHelper.GetInteger((e.Item.FindControl("hfSavingsCardState") as HiddenField).Value);//储蓄卡停用状态（0-已停用，1-未停用）
        if (state > 0)//未停用储蓄卡
        {
            (e.Item.FindControl("lbtnBlockSavingsCard") as LinkButton).Text = "停用";//停用按钮
            (e.Item.FindControl("lbtnEditSavingsCard") as LinkButton).Visible = true;//编辑可用
        }
        else//已停用储蓄卡
        {
            (e.Item.FindControl("lbtnBlockSavingsCard") as LinkButton).Text = "恢复";//恢复按钮
            (e.Item.FindControl("lbtnEditSavingsCard") as LinkButton).Visible = false;//编辑不可用
        }
    }
    #endregion

    #region 网上支付
    /// <summary>
    /// 绑定网上支付rptOnlinePay
    /// </summary>
    public void BindRptOnlinePay()
    {
        ControlHelper.BindRepeater(this.rptOnlinePay, "constring", "SELECT OnlinePayId,OnlinePayName,OnlinePayRemainder,State FROM dbo.tabA_Account_OnlinePay");
    }
    //网上支付ItemCommand事件
    protected void rptOnlinePay_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        int onlinePayId = ConvertHelper.GetInteger((e.Item.FindControl("hdOnlinePayId") as HiddenField).Value);//网上支付id
        if (e.CommandName == "edit")//网上支付编辑
        {
            Response.Redirect("OnlinePayInfo.aspx?opid=" + onlinePayId + "");
        }
        else if (e.CommandName == "block")//网上支付的停用与恢复
        {
            int state = ConvertHelper.GetInteger((e.Item.FindControl("hdOnlinPayState") as HiddenField).Value);//网上支付的停用状态（0-已停用，1-未停用）
            if (state > 0)//未停用储蓄卡
            {
                int flag = SqlHelper.Operation("UPDATE dbo.tabA_Account_OnlinePay SET State=0 WHERE OnlinePayId=" + onlinePayId + "", "constring");//改为停用
                if (flag > 0)
                {
                    BindRptOnlinePay();
                    (e.Item.FindControl("lbtnBlockOnlinePay") as LinkButton).Text = "恢复";//停用按钮变为恢复按钮
                    (e.Item.FindControl("lbtnEditOnlinePay") as LinkButton).Visible = false;//编辑不可用
                }
            }
            else//已停用储蓄卡
            {
                int flag = SqlHelper.Operation("UPDATE dbo.tabA_Account_OnlinePay SET State=1 WHERE OnlinePayId=" + onlinePayId + "", "constring");//改为未停用
                if (flag > 0)
                {
                    BindRptOnlinePay();
                    (e.Item.FindControl("lbtnBlockOnlinePay") as LinkButton).Text = "停用";//恢复按钮变为停用按钮
                    (e.Item.FindControl("lbtnEditOnlinePay") as LinkButton).Visible = true;//编辑可用
                }
            }
        }
    }
    //网上支付ItemDataBound事件
    protected void rptOnlinePay_ItemDataBound(object sender, RepeaterItemEventArgs e)
    {
        int state = ConvertHelper.GetInteger((e.Item.FindControl("hdOnlinPayState") as HiddenField).Value);//网上支付的停用状态（0-已停用，1-未停用）
        if (state > 0)//未停用储蓄卡
        {
            (e.Item.FindControl("lbtnBlockOnlinePay") as LinkButton).Text = "停用";//停用按钮
            (e.Item.FindControl("lbtnEditOnlinePay") as LinkButton).Visible = true;//编辑可用
        }
        else//已停用储蓄卡
        {
            (e.Item.FindControl("lbtnBlockOnlinePay") as LinkButton).Text = "恢复";//恢复按钮
            (e.Item.FindControl("lbtnEditOnlinePay") as LinkButton).Visible = false;//编辑不可用
        }
    }
    #endregion

    #region 借贷账户
    /// <summary>
    /// 绑定借贷账户rptLoanAccount
    /// </summary>
    public void BindRptLoanAccount()
    {
        ControlHelper.BindRepeater(this.rptLoanAccount, "constring", "SELECT LoanAccountId,LoanAccountId,LoanAccountName,LoanRemainder,State FROM dbo.tabA_Account_Loan");
    }
    //借贷账户ItemCommand事件
    protected void rptLoanAccount_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        int loanAccountId = ConvertHelper.GetInteger((e.Item.FindControl("hfLoanAccountId") as HiddenField).Value);//借贷账户id
        if (e.CommandName == "edit")//借贷账户编辑
        {
            Response.Redirect("LoanAccountInfo.aspx?laid=" + loanAccountId + "");
        }
        else if (e.CommandName == "block")//借贷账户的停用与恢复
        {
            int state = ConvertHelper.GetInteger((e.Item.FindControl("hfLoanState") as HiddenField).Value);//网上支付的停用状态（0-已停用，1-未停用）
            if (state > 0)//未停用借贷账户
            {
                int flag = SqlHelper.Operation("UPDATE dbo.tabA_Account_Loan SET State=0 WHERE LoanAccountId=" + loanAccountId + "", "constring");//改为停用
                if (flag > 0)
                {
                    BindRptLoanAccount();
                    (e.Item.FindControl("lbtnBlockLoanAccount") as LinkButton).Text = "恢复";//停用按钮变为恢复按钮
                    (e.Item.FindControl("lbtnEditLoanAccount") as LinkButton).Visible = false;//编辑不可用
                }
            }
            else//已停用借贷账户
            {
                int flag = SqlHelper.Operation("UPDATE dbo.tabA_Account_Loan SET State=1 WHERE LoanAccountId=" + loanAccountId + "", "constring");//改为未停用
                if (flag > 0)
                {
                    BindRptLoanAccount();
                    (e.Item.FindControl("lbtnBlockLoanAccount") as LinkButton).Text = "停用";//恢复按钮变为停用按钮
                    (e.Item.FindControl("lbtnEditLoanAccount") as LinkButton).Visible = true;//编辑可用
                }
            }
        }
        //else if (e.CommandName == "selectDetail")//查看明细
        //{
        //    Response.Redirect("");
        //}
    }
    protected void rptLoanAccount_ItemDataBound(object sender, RepeaterItemEventArgs e)
    {
        int state = ConvertHelper.GetInteger((e.Item.FindControl("hfLoanState") as HiddenField).Value);//网上支付的停用状态（0-已停用，1-未停用）
        if (state > 0)//未停用借贷账户
        {
            (e.Item.FindControl("lbtnBlockLoanAccount") as LinkButton).Text = "停用";//停用按钮
            (e.Item.FindControl("lbtnEditLoanAccount") as LinkButton).Visible = true;//编辑可用
        }
        else//已停用借贷账户
        {
            (e.Item.FindControl("lbtnBlockLoanAccount") as LinkButton).Text = "恢复";//恢复按钮
            (e.Item.FindControl("lbtnEditLoanAccount") as LinkButton).Visible = false;//编辑不可用
        }
    }
    #region 获取借贷账户当前状况
    /// <summary>
    /// 获取借贷账户当前状况
    /// </summary>
    /// <param name="Remainder">余额</param>
    /// <returns></returns>
    public string GetRemainderState(object Remainder)
    {
        string remainderState = "";
        if (ConvertHelper.GetDecimal(Remainder) > 0)
        {
            remainderState = "他欠您￥" + ConvertHelper.GetString(Remainder);
        }
        else if (ConvertHelper.GetDouble(Remainder) == 0.00)
        {
            remainderState = "你们没有借贷关系";
        }
        else
        {
            remainderState = "您欠他￥" + ConvertHelper.GetString(0 - ConvertHelper.GetDouble(Remainder));
        }
        return remainderState;
    }
    #endregion
    #endregion
    protected void btnAddAccount_Click(object sender, EventArgs e)//新增（现金账户）
    {
        Response.Redirect("CashAccountInfo.aspx");
    }
}