﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text;
using System.Data;

public partial class Account_BankList : PageBase
{
    private static int currentPageNum = 1;//当前页数
    private static int pageCount = 1;//总页数
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!this.Page.IsPostBack)
        {
            pageCount = GetPageCount();//总页数
            spanPageCount.InnerHtml = ConvertHelper.GetString(pageCount);//总页数
            BindRptBank();
        }
    }
    /// <summary>
    /// 绑定rptBank银行列表
    /// </summary>
    public void BindRptBank()
    {
        SetStrWhere();
        ControlHelper.BindRepeater(this.rptBank, "constring", StrWhere + "AND Row BETWEEN (" + currentPageNum + "-1)*20+1 AND " + currentPageNum + "*20 ");
    }
    protected void rptBank_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        int bankId = Convert.ToInt32((e.Item.FindControl("hfBankId") as HiddenField).Value);//银行id
        if (e.CommandName == "edit")//编辑
        {
            Response.Redirect("BankInfo.aspx?bid=" + bankId + "");
        }
        //else if (e.CommandName == "block")//停用
        //{
        //    int state = ConvertHelper.GetInteger((e.Item.FindControl("hfBankState") as HiddenField).Value);//银行的停用状态(0-已停用，1-未停用)
        //    if (state > 0)//未停用银行
        //    {
        //        int flag = SqlHelper.Operation("UPDATE tabA_Account_Bank SET State=0 WHERE BankID=" + bankId + "", "constring");
        //        if (flag > 0)
        //        {
        //            BindRptBank();
        //            (e.Item.FindControl("lbtnBlock") as LinkButton).Text = "恢复";//停用按钮变为了恢复按钮
        //            (e.Item.FindControl("lbtnEdit") as LinkButton).Visible = false;//编辑不可用
        //        }
        //        else
        //        {
        //            ScriptHelper.AlertMessage(this.Page, "停用失败，请联系管理员！");
        //        }
        //    }
        //    else//已停用银行卡
        //    {
        //        int flag = SqlHelper.Operation("UPDATE tabA_Account_Bank SET State=1 WHERE BankID=" + bankId + "", "constring");
        //        if (flag > 0)
        //        {
        //            BindRptBank();
        //            (e.Item.FindControl("lbtnBlock") as LinkButton).Text = "停用";//恢复按钮变为了停用按钮
        //            (e.Item.FindControl("lbtnEdit") as LinkButton).Visible = true;//编辑可用
        //        }
        //        else
        //        {
        //            ScriptHelper.AlertMessage(this.Page, "停用失败，请联系管理员！");
        //        }
        //    }
        //}
    }
    protected void rptBank_ItemDataBound(object sender, RepeaterItemEventArgs e)
    {
        //int state = ConvertHelper.GetInteger((e.Item.FindControl("hfBankState") as HiddenField).Value);//银行的停用状态(0-已停用，1-未停用)
        //if (state > 0)//未停用银行
        //{
        //    (e.Item.FindControl("lbtnBlock") as LinkButton).Text = "停用";//停用按钮
        //    (e.Item.FindControl("lbtnEdit") as LinkButton).Visible = true;//编辑可用
        //}
        //else//已停用银行卡
        //{
        //    (e.Item.FindControl("lbtnBlock") as LinkButton).Text = "恢复";//恢复按钮
        //    (e.Item.FindControl("lbtnEdit") as LinkButton).Visible = false;//编辑不可用   
        //}
    }
    #region 分页
    #region 获取分页总页数
    /// <summary>
    /// 获取分页总页数
    /// </summary>
    /// <returns></returns>
    public int GetPageCount()
    {
        int pagecount = 0;//总页数
        SetStrWhere();
        DataSet ds = SqlHelper.GetDataSet(StrWhere, "constring");
        if (ds.Tables[0].Rows.Count > 0)
        {
            int loanAccountCount = ConvertHelper.GetInteger(ds.Tables[0].Rows.Count);//借贷用户总个数
            if (loanAccountCount % 20 == 0)
            {
                pagecount = loanAccountCount / 20;
            }
            else
            {
                pagecount = loanAccountCount / 20 + 1;
            }
        }
        else
        {
            pagecount = 1;
        }
        return pagecount;
    }
    #endregion
    #region 首页
    protected void lbtnPageFirst_Click(object sender, EventArgs e)//首页
    {
        currentPageNum = 1;
        BindRptBank();
        spanPageCurrent.InnerHtml = "1";//当前页为1
    }
    #endregion
    #region 上页
    protected void lbtnPageUp_Click(object sender, EventArgs e)//上页
    {
        if (spanPageCurrent.InnerHtml != "1")//不是首页时
        {
            currentPageNum = ConvertHelper.GetInteger(spanPageCurrent.InnerHtml) - 1;
            BindRptBank();
            spanPageCurrent.InnerHtml = ConvertHelper.GetString(currentPageNum);//当前页spanPageCurrent赋值
        }
    }
    #endregion
    #region 下页
    protected void lbtnPageDown_Click(object sender, EventArgs e)//下页
    {
        if (spanPageCurrent.InnerHtml != ConvertHelper.GetString(pageCount))//不是尾页时
        {
            currentPageNum = ConvertHelper.GetInteger(spanPageCurrent.InnerHtml) + 1;
            BindRptBank();
            spanPageCurrent.InnerHtml = ConvertHelper.GetString(currentPageNum);//当前页spanPageCurrent赋值
        }
    }
    #endregion
    #region 末页
    protected void lbtnPageLast_Click(object sender, EventArgs e)//末页
    {
        currentPageNum = GetPageCount();
        BindRptBank();
        spanPageCurrent.InnerHtml = ConvertHelper.GetString(pageCount);//当前页等于总页数
    }
    #endregion
    #endregion
    #region 查询sql语句属性
    /// <summary>
    /// 查询sql语句属性
    /// </summary>
    public string StrWhere
    {
        get { return Convert.ToString(ViewState["StrWhere"]); }
        set { ViewState["StrWhere"] = value; }
    }
    /// <summary>
    /// 修改sql语句属性的方法
    /// </summary>
    public void SetStrWhere()
    {
        StringBuilder strb = new StringBuilder();
        strb.Append("SELECT * FROM (SELECT ROW_NUMBER() OVER(ORDER BY CreateTime) AS Row,BankID,BankName,State FROM tabA_Account_Bank) AS temptable  WHERE 1=1 ");
        //if (uclBankCard.BankCardID != 0)//查询事件中的银行卡
        //{
        //    strb.Append("AND BankCardID=" + uclBankCard.BankCardID + " ");//银行卡id
        //}
        //else if (!string.IsNullOrEmpty(Request["BankId"]))//从银行卡列表页点击查看明细跳转到明细页面（即本页面）
        //{
        //    strb.Append("AND BankCardID=" + Request["BankId"] + " ");//银行卡id
        //}
        //if (!string.IsNullOrEmpty(txtCardNumber.Text.Trim()))
        //{
        //    strb.Append("AND BankCardNumber like '%" + txtCardNumber.Text.Trim() + "%' ");//银行卡号（模糊查询）
        //}
        //if (!string.IsNullOrEmpty(txtHeader.Text.Trim()))
        //{
        //    strb.Append("AND Header like '%" + txtHeader.Text.Trim() + "%' ");//户主名（模糊查询）
        //}
        //if (!string.IsNullOrEmpty(txtOther.Text.Trim()))
        //{
        //    strb.Append("AND OtherName like '%" + txtOther.Text.Trim() + "%'");//交易对方（模糊查询）
        //}
        //strb.Append(string.Format(timewhere.WhereString, " a.CreateTime"));
        StrWhere = strb.ToString();
    }
    #endregion
    protected void btnAddBank_Click(object sender, EventArgs e)//添加银行
    {
        Response.Redirect("BankInfo.aspx");
    }
}
