﻿using System;
using System.Data;
using System.Configuration;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

/// <summary>
///ControlHelper 的摘要说明
/// </summary>
public class ControlHelper
{
    public ControlHelper()
    {
        //
        //TODO: 在此处添加构造函数逻辑
        //
    }
    #region 绑定Repeater
    /// <summary>
    /// 绑定Repeater
    /// </summary>
    /// <param name="rpt">repeater控件名</param>
    /// <param name="sql">sql语句</param>
    public static void BindRepeater(Repeater rpt,string constr, string sql)
    {
        DataSet ds = SqlHelper.GetDataSet(sql,constr);
        rpt.DataSource = ds;
        rpt.DataBind();
    }
    #endregion

    #region 绑定GridView
    /// <summary>
    /// 绑定GridView
    /// </summary>
    /// <param name="gv">GridView控件名</param>
    /// <param name="constr">数据库连接字符串</param>
    /// <param name="sql">sql语句</param>
    public static void BindGridView(GridView gv,string constr, string sql)
    {
        DataSet ds = SqlHelper.GetDataSet(sql,constr);
        gv.DataSource = ds;
        gv.DataBind();
    }
    #endregion

    #region 绑定DropDownList
    /// <summary>
    /// 绑定DropDownList
    /// </summary>
    /// <param name="ddl">DropDownList控件名</param>
    /// <param name="sql">sql语句</param>
    /// <param name="constr">数据库连接字符串</param>
    /// <param name="dataValueFiled">DropDownList的Value值的数据库字段</param>
    /// <param name="dataTextFiled">DropDownList的Text值的数据库字段</param>
    public static void BindDropDownList(DropDownList ddl,string constr, string sql, string dataValueFiled, string dataTextFiled)
    {
        DataSet ds = SqlHelper.GetDataSet(sql,constr);
        ddl.DataValueField = dataValueFiled;
        ddl.DataTextField = dataTextFiled;
        ddl.DataSource = ds;
        ddl.DataBind();
    }
    #endregion
}
