﻿using System;
using System.Data;
using System.Configuration;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Data.SqlClient;
using System.Text;

/// <summary>
///Operation 的摘要说明
/// </summary>
public class Operation
{
	public Operation()
	{
		//
		//TODO: 在此处添加构造函数逻辑
		//
    }
    #region 获取sqlconnection对象
    /// <summary>
    /// 获取sqlconnection对象
    /// </summary>
    /// <returns></returns>
    public static SqlConnection GetSqlconnection()
    {
        string constring = ConfigurationManager.ConnectionStrings["constring"].ConnectionString;
        SqlConnection con = new SqlConnection(constring);
        return con;
    }
    #endregion  

    #region 获取DataSet对象
    /// <summary>
    /// 获取DataSet对象
    /// </summary>
    /// <param name="sql">sql语句</param>
    /// <returns></returns>
    public static DataSet GetDataSet(string sql)
    {
        SqlConnection cn = GetSqlconnection();
        SqlDataAdapter sda = new SqlDataAdapter(sql, cn);
        DataSet ds = new DataSet();
        sda.Fill(ds);
        return ds;
    }
    #endregion

    #region 增删改操作并返回受影响行数
    /// <summary>
    /// 增删改操作并返回受影响行数
    /// </summary>
    /// <param name="sql"></param>
    /// <returns></returns>
    public static int Operations(string sql)
    {
        SqlConnection cn = GetSqlconnection();
        SqlCommand cmd = new SqlCommand(sql,cn);
        cn.Open();
        int flag= cmd.ExecuteNonQuery();
        cn.Close();
        return flag;
    }
    #endregion

    #region 绑定repeate
    /// <summary>
    /// 绑定Repeater
    /// </summary>
    /// <param name="sql">sql查询语句</param>
    /// <param name="rpt">绑定的repeater名</param>
    public static void BindRepeater(string sql,Repeater rpt)
    {
        rpt.DataSource = GetDataSet(sql);
        rpt.DataBind();
    }
    #endregion

    #region 由用户Id获取用户名
    /// <summary>
    /// 由用户Id获取用户名
    /// </summary>
    /// <param name="uid"></param>
    /// <returns></returns>
    public static string GetUserName(int uid)
    {
        string username = "";
        DataSet ds = GetDataSet("SELECT LoginName FROM dbo.tabP_Personnel WHERE Pid=" + uid + "");
        if (ds.Tables[0].Rows.Count > 0)
        {
            username = Convert.ToString(ds.Tables[0].Rows[0]["LoginName"]);
        }
        return username;
    }
    #endregion

    #region 由用户id获取用户真实姓名
    /// <summary>
    /// 由用户id获取用户真实姓名
    /// </summary>
    /// <param name="uid">用户id</param>
    /// <returns>用户真实姓名</returns>
    public static string GetName(int uid)
    {
        string name = "";
        DataSet ds = GetDataSet("SELECT PersonnelName FROM dbo.tabP_Personnel WHERE Pid=" + uid + "");
        if(ds.Tables[0].Rows.Count>0)
        {
            name = Convert.ToString(ds.Tables[0].Rows[0]["PersonnelName"]);
        }
        return name;
    }
    #endregion

    #region 由用户id获取用户职位id
    public static int GetWorkId(int uid)
    {
        int workid = 0;
        DataSet ds = GetDataSet("SELECT WorkId FROM dbo.tabP_Personnel WHERE Pid=" + uid + "");
        if(ds.Tables[0].Rows.Count>0)
        {
            workid = Convert.ToInt32(ds.Tables[0].Rows[0]["WorkId"]);
        }
        return workid;
    }
    #endregion

    #region 获取网站名
    /// <summary>
    /// 获取网站名
    /// </summary>
    /// <returns></returns>
    public string GetWebName()
    {
        string webname = "";
        DataSet ds = GetDataSet("SELECT webName FROM dbo.tabCompany WHERE Cid=1");
        if(ds.Tables[0].Rows.Count>0)
        {
            webname = Convert.ToString(ds.Tables[0].Rows[0]["webName"]);
        }
        return webname;
    }
    #endregion

    #region 由部门id获取部门名称
    /// <summary>
    /// 由部门id获取部门名称
    /// </summary>
    /// <param name="departmentId">部门id</param>
    /// <returns>部门名称</returns>
    public static string GetDepartmentName(int departmentId)
    {
        string departmentName = "";
        DataSet ds = GetDataSet("SELECT DepartmentName FROM dbo.tabP_Department WHERE DepartmentId=" + departmentId + "");
        if (ds.Tables[0].Rows.Count > 0)
        {
            departmentName = Convert.ToString(ds.Tables[0].Rows[0]["DepartmentName"]);
        }
        return departmentName;
    }
    #endregion

    #region 由公告类型id获取公告类型名
    /// <summary>
    /// 由公告类型id获取公告类型名
    /// </summary>
    /// <param name="newsTypeId">公告类型id</param>
    /// <returns>公告类型名</returns>
    public static string GetNewsTypeName(int newsTypeId)
    {
        string newsTypeName = "";
        DataSet ds = GetDataSet("SELECT NewsTypeName FROM dbo.tabN_NewsType WHERE Nid=" + newsTypeId + "");
        if(ds.Tables[0].Rows.Count>0)
        {
            newsTypeName = Convert.ToString(ds.Tables[0].Rows[0]["NewsTypeName"]);
        }
        return newsTypeName;
    }
    #endregion

    //#region 由公告id获取公告已查看人员列表
    ///// <summary>
    ///// 由公告id获取公告已查看人员列表
    ///// </summary>
    ///// <param name="newsId">公告id</param>
    ///// <returns>已查看人员列表</returns>
    //public static string GetSelectPerson(int newsId)
    //{
    //    string selectPersonNameString = "";//查看人员名字符串
    //    string selectPersonidString= "";//查看人员id字符串
    //    DataSet ds = GetDataSet("SELECT SelectPersonId FROM dbo.tabNews WHERE Nid=" + newsId + "");
    //    if(ds.Tables[0].Rows.Count>0)
    //    {
    //        selectPersonidString = Convert.ToString(ds.Tables[0].Rows[0]["SelectPersonId"]);
    //        if(selectPersonidString!="")
    //        {
    //            string[] personid=selectPersonidString.Split(',');
    //            for (int i = 0; i < personid.Length; i++)
    //            {
    //                DataSet dsUserName = GetDataSet("SELECT UserName FROM dbo.tabUser WHERE ID=" + personid[i] + "");
    //                if (dsUserName.Tables[0].Rows.Count > 0)
    //                {
    //                    selectPersonNameString+=Convert.ToString(dsUserName.Tables[0].Rows[0]["UserName"]);
    //                    selectPersonNameString += ",";
    //                }
    //            }
    //            selectPersonNameString = selectPersonNameString.ToString().TrimEnd(',');
    //        }
    //    }
    //    return selectPersonNameString;
    //}
    //#endregion
}
