﻿using System;
using System.Data;
using System.Configuration;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Data.SqlClient;

/// <summary>
///SqlHelper 的摘要说明
/// </summary>
public class SqlHelper
{
    public SqlHelper()
    {
        //
        //TODO: 在此处添加构造函数逻辑
        //
    }
    #region 获取sqlConnection对象
    /// <summary>
    /// 获取sqlConnection对象
    /// </summary>
    /// <returns></returns>
    public static SqlConnection GetSqlCon(string connectionString)
    {
        string constring = ConfigurationManager.ConnectionStrings[connectionString].ConnectionString;
        SqlConnection cn = new SqlConnection(constring);
        return cn;
    }
    #endregion

    #region 获取DataSet数据集
    /// <summary>
    /// 获取DataSet数据集
    /// </summary>
    /// <param name="sql">sql语句</param>
    /// <param name="connectionString">数据库连接字符串</param>
    /// <returns>DataSet数据集</returns>
    public static DataSet GetDataSet(string sql,string connectionString)
    {
        SqlDataAdapter sda = new SqlDataAdapter(sql, GetSqlCon(connectionString));
        DataSet ds = new DataSet();
        sda.Fill(ds);
        return ds;
    }
    #endregion

    #region 数据库数据增加、删除、修改（返回受影响的行数）
    /// <summary>
    /// 数据库数据增加、删除、修改（返回受影响的行数）
    /// </summary>
    /// <param name="sql">sql语句</param>
    /// <param name="connectionString">数据库连接字符串</param>
    /// <returns>受影响的行数：大于0-执行成功，小于0-执行失败</returns>
    public static int Operation(string sql,string connectionString)
    {
        SqlConnection cn = GetSqlCon(connectionString);
        SqlCommand cmd = new SqlCommand(sql, cn);
        cn.Open();
        int flag = 0;
        try
        {
            flag = cmd.ExecuteNonQuery();
        }
        catch { }
        finally
        {
            cn.Close();
        }
        return flag;
    }
    #endregion

    #region  数据库数据增加、删除、修改（返回bool值）
    /// <summary>
    ///  数据库数据增加、删除、修改（返回bool值）
    /// </summary>
    /// <param name="sql">sql语句</param>
    /// <param name="connectionString">数据库连接字符串</param>
    /// <returns>bool值：true-执行成功，false-执行失败</returns>
    public static bool Operations(string sql,string connectionString)
    {
        SqlConnection cn = GetSqlCon(connectionString);
        SqlCommand cmd = new SqlCommand(sql, cn);
        try
        {
            cn.Open();
            int flag = cmd.ExecuteNonQuery();
            cn.Close();
            return true;
        }
        catch { return false; }
    }
    #endregion

}
