﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Ucontrol_UcAccount : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!this.Page.IsPostBack)
        {
            AccountShow();
        }
    }

    #region 账户类型
    #region 账户类型ID
    /// <summary>
    /// 账户类型ID：AccountTypeID属性
    /// </summary>
    public int AccountTypeID
    {
        get
        {
            return ConvertHelper.GetInteger(ddlAccountType.SelectedValue);
        }
        set
        {
            ddlAccountType.SelectedValue = ConvertHelper.GetString(value);
        }
    }
    #endregion

    #region 由账户类型选择显示账户事件
    /// <summary>
    /// 由账户类型选择显示账户事件（思想：先所有隐藏，再根据账户类型显示）
    /// </summary>
    public void AccountShow()
    {
        divCashAccount.Visible = false;//现金账户隐藏
        divCreditCard.Visible = false;//信用卡隐藏
        divSavingsCard.Visible = false;//储蓄卡隐藏
        divOnlinePay.Visible = false;//网上支付
        if (AccountTypeID == 1)//现金账户
        {
            divCashAccount.Visible = true;//现金账户显示
            #region 现金账户
            BindDdlCashAccount();
            #endregion
        }
        else if (AccountTypeID == 2)//信用卡
        {
            divCreditCard.Visible = true;//信用卡显示
            #region 信用卡账户
            BindDdlBank();
            if (BankID != 0)
            {
                ddlBank.SelectedValue = hdBankId.Value;
            }
            BindDdlCreditCard();
            if (CreditCardID != 0)
            {
                ddlCreditCard.SelectedValue = hdCreditCardId.Value;
            }
            #endregion
        }
        else if (AccountTypeID == 3)//储蓄卡
        {
            divSavingsCard.Visible = true;//储蓄卡显示
            #region 储蓄卡账户
            BindDdlSavingsCardBank();
            if (SavingsCardBankID != 0)
            {
                ddlSavingsCardBank.SelectedValue = hdSCBankId.Value;
            }
            BindDdlSavingsCard();
            if (SavingsCardID != 0)
            {
                ddlSavingsCard.SelectedValue = HdSavingsCardId.Value;
            }
            #endregion
        }
        else if (AccountTypeID == 4)//网上支付
        {
            divOnlinePay.Visible = true;//网上支付显示
            #region 网上支付
            BindDdlOnlinePay();
            #endregion
        }
    }
    #endregion

    #region 账户类型选择索引改变事件
    protected void ddlAccountType_SelectedIndexChanged(object sender, EventArgs e)
    {
        AccountShow();
    }
    #endregion
    #endregion

    #region 现金账户
    #region 绑定现金账户ddlCashAccount
    /// <summary>
    /// 绑定现金账户ddlCashAccount
    /// </summary>
    public void BindDdlCashAccount()
    {
        ControlHelper.BindDropDownList(this.ddlCashAccount, "constring", "SELECT CashAccountId,CashAccountName FROM dbo.tabA_Account_Cash WHERE State=1", "CashAccountId", "CashAccountName");
        ddlCashAccount.Items.Insert(0,new ListItem("请选择现金账户","0"));
    }
    #endregion

    #region 现金账户ID：CashAccountID属性
    /// <summary>
    /// 现金账户ID：CashAccountID属性
    /// </summary>
    public int CashAccountID
    {
        get
        {
            return ConvertHelper.GetInteger(ddlCashAccount.SelectedValue); 
        }
        set
        {
            ddlCashAccount.SelectedValue = ConvertHelper.GetString(value);
        }
    }
    #endregion
    #endregion

    #region 信用卡账户
    #region //信用卡异步页路径属性
    /// <summary>
    /// 信用卡异步页路径属性
    /// </summary>
    public string OpenAjaxUrl
    {
        get
        {
            return ConvertHelper.GetString(ViewState["OpenAjaxUrl"]);
        }
        set
        {
            ViewState["OpenAjaxUrl"] = value;
        }
    }
    #endregion

    #region 绑定信用卡银行ddlBank
    /// <summary>
    /// 绑定信用卡银行ddlBank
    /// </summary>
    public void BindDdlBank()
    {
        ControlHelper.BindDropDownList(this.ddlBank, "constring", "SELECT BankID,BankName FROM dbo.tabA_Account_Bank WHERE State=1", "BankID", "BankName");
        ddlBank.Items.Insert(0, new ListItem("请选择银行", "0"));
    }
    #endregion

    #region 绑定信用卡ddlCreditCard
    /// <summary>
    /// 绑定信用卡ddlCreditCard
    /// </summary>
    public void BindDdlCreditCard()
    {
        ControlHelper.BindDropDownList(this.ddlCreditCard, "constring", "SELECT CreditCardId,CreditCardName FROM dbo.tabA_Account_CreditCard WHERE CCIssueBankId=" + ddlBank.SelectedValue + " AND State=1", "CreditCardId", "CreditCardName");
        ddlCreditCard.Items.Insert(0, new ListItem("请选择信用卡", "0"));
    }
    #endregion

    #region 信用卡账户属性
    #region //信用卡银行ID:BankID属性
    /// <summary>
    /// 信用卡银行ID:BankID属性
    /// </summary>
    public int BankID
    {
        get
        {
            return ConvertHelper.GetInteger(hdBankId.Value);
        }
        set
        {
            hdBankId.Value = ConvertHelper.GetString(value);
        }
    }
    #endregion
    #region //信用卡ID:CreditCardID属性
    /// <summary>
    /// 信用卡ID:CreditCardID属性
    /// </summary>
    public int CreditCardID
    {
        get
        {
            return ConvertHelper.GetInteger(hdCreditCardId.Value);
        }
        set
        {
            if (BankID == 0)
            {
                BankID = GetBankIdByCreditCardId(value);
            }
            hdCreditCardId.Value = ConvertHelper.GetString(value);
        }
    }
    #endregion
    #endregion

    #region 由银行卡id获取信用卡银行id
    /// <summary>
    /// 由信用卡id获取信用卡银行id
    /// </summary>
    /// <param name="creditCardId">信用卡id</param>
    /// <returns>信用卡银行id</returns>
    public int GetBankIdByCreditCardId(int creditCardId)
    {
        DataSet ds = SqlHelper.GetDataSet("SELECT CCIssueBankId FROM dbo.tabA_Account_CreditCard WHERE CreditCardId=" + creditCardId + " AND State=1", "constring");
        if (ds.Tables[0].Rows.Count > 0)
        {
            return ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["CCIssueBankId"]);
        }
        else
        {
            return 0;
        }
    }
    #endregion
    #endregion

    #region 储蓄卡账户
    #region //储蓄卡异步页路径属性
    /// <summary>
    /// 储蓄卡异步页路径属性
    /// </summary>
    public string OpenSavingsCardAjaxUrl
    {
        get
        {
            return ConvertHelper.GetString(ViewState["OpenSavingsCardAjaxUrl"]);
        }
        set
        {
            ViewState["OpenSavingsCardAjaxUrl"] = value;
        }
    }
    #endregion

    #region 绑定储蓄卡银行ddlSavingsCardBank
    /// <summary>
    /// 绑定储蓄卡银行ddlSavingsCardBank
    /// </summary>
    public void BindDdlSavingsCardBank()
    {
        ControlHelper.BindDropDownList(this.ddlSavingsCardBank, "constring", "SELECT BankID,BankName FROM dbo.tabA_Account_Bank WHERE State=1", "BankID", "BankName");
        ddlSavingsCardBank.Items.Insert(0, new ListItem("请选择银行", "0"));
    }
    #endregion

    #region 绑定储蓄卡ddlSavingsCard
    /// <summary>
    /// 绑定储蓄卡ddlSavingsCard
    /// </summary>
    public void BindDdlSavingsCard()
    {
        ControlHelper.BindDropDownList(this.ddlSavingsCard, "constring", "SELECT SavingsCardId,SavingsCardName FROM dbo.tabA_Account_SavingsCard WHERE SCIssueBankId=" + ddlSavingsCardBank.SelectedValue + " AND State=1", "SavingsCardId", "SavingsCardName");
        ddlSavingsCard.Items.Insert(0, new ListItem("请选择储蓄卡", "0"));
    }
    #endregion

    #region 储蓄卡账户属性
    #region //储蓄卡银行ID:SavingsCardBankID属性
    /// <summary>
    /// 储蓄卡银行ID:SavingsCardBankID属性
    /// </summary>
    public int SavingsCardBankID
    {
        get
        {
            return ConvertHelper.GetInteger(hdSCBankId.Value);
        }
        set
        {
            hdSCBankId.Value = ConvertHelper.GetString(value);
        }
    }
    #endregion
    #region //储蓄卡ID:SavingsCardID属性
    /// <summary>
    /// 储蓄卡ID:SavingsCardID属性
    /// </summary>
    public int SavingsCardID
    {
        get
        {
            return ConvertHelper.GetInteger(HdSavingsCardId.Value);
        }
        set
        {
            if (SavingsCardBankID == 0)
            {
                SavingsCardBankID = GetBankIdBySavingsCardId(value);
            }
            HdSavingsCardId.Value = ConvertHelper.GetString(value);
        }
    }
    #endregion
    #endregion

    #region 由储蓄卡id获取储蓄卡银行id
    /// <summary>
    /// 由储蓄卡id获取储蓄卡银行id
    /// </summary>
    /// <param name="savingsCardId">储蓄卡id</param>
    /// <returns>储蓄卡银行id</returns>
    public int GetBankIdBySavingsCardId(int savingsCardId)
    {
        DataSet ds = SqlHelper.GetDataSet("SELECT SCIssueBankId FROM dbo.tabA_Account_SavingsCard WHERE SavingsCardId=" + savingsCardId + " AND State=1", "constring");
        if (ds.Tables[0].Rows.Count > 0)
        {
            return ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["SCIssueBankId"]);
        }
        else
        {
            return 0;
        }
    }
    #endregion
    #endregion

    #region 网上支付
    #region 绑定网上支付ddlOnlinePay
    /// <summary>
    /// 绑定网上支付ddlOnlinePay
    /// </summary>
    public void BindDdlOnlinePay()
    {
        ControlHelper.BindDropDownList(this.ddlOnlinePay, "constring", "SELECT OnlinePayId,OnlinePayName  FROM dbo.tabA_Account_OnlinePay WHERE State=1", "OnlinePayId", "OnlinePayName");
        ddlOnlinePay.Items.Insert(0,new ListItem("请选择网上支付","0"));
    }
    #endregion

    #region 网上支付id：OnlinePayID属性
    /// <summary>
    /// 网上支付id：OnlinePayID属性
    /// </summary>
    public int OnlinePayID
    {
        get 
        {
            return ConvertHelper.GetInteger(ddlOnlinePay.SelectedValue);        
        }
        set
        {
            ddlOnlinePay.SelectedValue = ConvertHelper.GetString(value);
        }
    }
    #endregion
    #endregion

  
}