﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

public partial class Ucontrol_UcBankCard : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!this.Page.IsPostBack)
        {
            BindDdlBank();
            if(BankID!=0)
            {
                ddlBank.SelectedValue = hdBankId.Value;
            }
            BindDdlBankCard();
            if(BankCardID!=0)
            {
                ddlBankCard.SelectedValue = hdBankCardId.Value;
            }
        }
    }

    #region //异步页路径属性
    /// <summary>
    /// 异步页路径属性
    /// </summary>
    public string OpenAjaxUrl
    {
        get
        {
            return ConvertHelper.GetString(ViewState["OpenAjaxUrl"]);
        }
        set
        {
            ViewState["OpenAjaxUrl"] = value;
        }
    }
    #endregion

    #region 绑定银行ddlBank
    /// <summary>
    /// 绑定银行ddlBank
    /// </summary>
    public void BindDdlBank()
    {
        ControlHelper.BindDropDownList(this.ddlBank, "constring", "SELECT BankID,BankName FROM dbo.tabB_Bank WHERE State=1", "BankID", "BankName");
        ddlBank.Items.Insert(0,new ListItem("请选择银行","0"));
    }
    #endregion

    #region 绑定银行卡ddlBankCard
    /// <summary>
    /// 绑定银行卡ddlBankCard
    /// </summary>
    public void BindDdlBankCard()
    {
        ControlHelper.BindDropDownList(this.ddlBankCard, "constring", "SELECT BankCardID,BankCardNumber FROM dbo.tabB_BankCard WHERE BankId="+ddlBank.SelectedValue+" AND State=1", "BankCardID", "BankCardNumber");
        ddlBankCard.Items.Insert(0,new ListItem("请选择银行卡","0"));
    }
    #endregion

    #region 属性
    #region //银行ID:BankID属性
    /// <summary>
    /// 银行ID:CaseTypeID属性
    /// </summary>
    public int BankID
    {
        get
        {
            return ConvertHelper.GetInteger(hdBankId.Value);
        }
        set
        {
            hdBankId.Value = ConvertHelper.GetString(value);
        }
    }
    #endregion
    #region //银行卡ID:BankCardID属性
    /// <summary>
    /// 银行卡ID:BankCardID属性
    /// </summary>
    public int BankCardID
    {
        get
        {
            return ConvertHelper.GetInteger(hdBankCardId.Value);
        }
        set
        {
            if (BankID == 0)
            {
                BankID = GetBankIdByBankCardId(value);
            }
            hdBankCardId.Value = ConvertHelper.GetString(value);
        }
    }
    #endregion
    #endregion

    #region 由银行卡id获取银行id
    /// <summary>
    /// 由银行卡id获取银行id
    /// </summary>
    /// <param name="bankCardId">银行卡id</param>
    /// <returns></returns>
    public int GetBankIdByBankCardId(int bankCardId)
    {
        DataSet ds = SqlHelper.GetDataSet("SELECT BankId FROM dbo.tabB_BankCard WHERE BankCardID="+bankCardId+" AND State=1", "constring");
        if (ds.Tables[0].Rows.Count > 0)
        {
            return ConvertHelper.GetInteger(ds.Tables[0].Rows[0]["BankId"]);
        }
        else
        {
            return 0;
        }
    }
    #endregion
}
