﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Web.UI.HtmlControls;

public partial class rptList_rpt_IncomeType : PageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        GetIncomeCount();
        BindRptITypeMoneyCount();
    }
    #region 功能列表
    protected void btnRptExpenditureType_Click(object sender, EventArgs e)//类别支出
    {
        Response.Redirect("../rptList/rpt_ExpenditureType.aspx");
    }
    protected void btnRptExpenditureAccount_Click(object sender, EventArgs e)//账户支出
    {
        Response.Redirect("../rptList/rpt_ExpenditureAccount.aspx");
    }
    protected void btnRptExpenditureSeller_Click(object sender, EventArgs e)//商家支出
    {
        Response.Redirect("../rptList/rpt_ExpenditureSeller.aspx");
    }
    protected void btnRptExpenditureProject_Click(object sender, EventArgs e)//项目支出
    {
        Response.Redirect("../rptList/rpt_ExpenditureProject.aspx");
    }
    protected void btnRptIncomeType_Click(object sender, EventArgs e)//类别收入
    {
        Response.Redirect("../rptList/rpt_IncomeType.aspx");
    }
    protected void btnRptIncomeAccount_Click(object sender, EventArgs e)//账户收入
    {
        Response.Redirect("../rptList/rpt_IncomeAccount.aspx");
    }
    protected void btnRptIncomeSeller_Click(object sender, EventArgs e)//付款方收入
    {
        Response.Redirect("../rptList/rpt_IncomeSeller.aspx");
    }
    protected void btnRptIncomeProject_Click(object sender, EventArgs e)//项目收入
    {
        Response.Redirect("../rptList/rpt_IncomeProject.aspx");
    }
    protected void btnRptBalance_Click(object sender, EventArgs e)//余额状况
    {
        Response.Redirect("../rptList/rpt_Balance.aspx");
    }
    #endregion
    /// <summary>
    /// 获取收入总数
    /// </summary>
    public void GetIncomeCount()
    {
        DataSet ds = SqlHelper.GetDataSet("SELECT SUM(RIncomeMoney) AS IncomeSum FROM dbo.tabA_Record_Income WHERE State=1", "constring");
        if(ds.Tables[0].Rows.Count>0)
        {
            spanIncomeMoney.InnerHtml = ConvertHelper.GetString(ds.Tables[0].Rows[0]["IncomeSum"]);
        }
    }
    /// <summary>
    /// 绑定类型收入报表
    /// </summary>
    public void BindRptITypeMoneyCount()
    {
        ControlHelper.BindRepeater(this.rptITypeMoneyCount, "constring", "SELECT RIncomeTypeId,IncomeTypeName,ITypeMoney,ITypeRate FROM dbo.V_List_IncomeType");
    }
    protected void rptITypeMoneyCount_ItemDataBound(object sender, RepeaterItemEventArgs e)
    {
        (e.Item.FindControl("spanITypeRate") as HtmlGenericControl).InnerHtml = ConvertHelper.GetString(ConvertHelper.GetDouble(ConvertHelper.GetDouble((e.Item.FindControl("spanITypeRate") as HtmlGenericControl).InnerHtml).ToString("#0.0000")) * 100);
    }
}