IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[dbo].[UrlEncodingRule]') AND type in (N'U'))
DROP TABLE [dbo].[UrlEncodingRule]
GO

CREATE TABLE [dbo].[UrlEncodingRule](
	[RuleId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Name] [nvarchar](20) NOT NULL,
	[TagName] [nvarchar](40) NOT NULL,
	[AttributeName] [nvarchar](200) NULL,
	[DefaultFileType] [nvarchar](40) NULL,
	[Priority] [int] NULL CONSTRAINT [DF_UrlEncodingRule_Priority]  DEFAULT ((1)),
	[KeepOriginalFileType] [bit] NOT NULL CONSTRAINT [DF_UrlEncodingRule_KeepOriginalFileType]  DEFAULT ((0)),
	[IsEnable] [bit] NOT NULL CONSTRAINT [DF_UrlEncodingRule_IsEnable]  DEFAULT ((1)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_UrlEncodingRule_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_UrlEncodingRule] PRIMARY KEY CLUSTERED 
(
	[RuleId] ASC
)--WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[dbo].[NonStaticUrl]') AND type in (N'U'))
DROP TABLE [dbo].[NonStaticUrl]
GO

CREATE TABLE [dbo].[NonStaticUrl](
	[UrlId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Name] [nvarchar](200) NOT NULL,
	[Url] [nvarchar](4000) NOT NULL,
	[IsEnable] [bit] NOT NULL CONSTRAINT [DF_NonStaticUrl_IsEnable]  DEFAULT ((1)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_NonStaticUrl_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_NonStaticUrl] PRIMARY KEY CLUSTERED 
(
	[UrlId] ASC
)--WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[dbo].[MultiSite]') AND type in (N'U'))
DROP TABLE [dbo].[MultiSite]
GO

CREATE TABLE [dbo].[MultiSite](
	[MultiSiteId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[SiteName] [nvarchar](200) NOT NULL,
	[RootDomain] [nvarchar](200) NULL,
	[IsEnable] [bit] NOT NULL CONSTRAINT [DF_MultiSite_IsEnable]  DEFAULT ((1)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_MultiSite_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_MultiSite] PRIMARY KEY CLUSTERED 
(
	[MultiSiteId] ASC
)--WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[dbo].[DomainSetting]') AND type in (N'U'))
DROP TABLE [dbo].[DomainSetting]
GO

CREATE TABLE [dbo].[DomainSetting](
	[DomainId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[DomainName] [nvarchar](200) NULL,
	[Domain] [nvarchar](200) NOT NULL,
	[Charset] [nvarchar](20) NULL CONSTRAINT [DF_Table_1_Priority]  DEFAULT ((1)),
	[IsEnable] [bit] NOT NULL CONSTRAINT [DF_Domain_IsEnable]  DEFAULT ((1)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_Domain_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_Domain] PRIMARY KEY CLUSTERED 
(
	[DomainId] ASC
)--WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[dbo].[ContentExtractionRule]') AND type in (N'U'))
DROP TABLE [dbo].[ContentExtractionRule]
GO

CREATE TABLE [dbo].[ContentExtractionRule](
	[RuleId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Name] [nvarchar](20) NOT NULL,
	[Url] [nvarchar](1000) NOT NULL,
	[ContentExpression] [nvarchar](2000) NOT NULL,
	[ChildExpression] [nvarchar](2000) NOT NULL,
	[Encoding] [nvarchar](50) NULL,
	[NoResultText] [nvarchar](60) NULL,
	[ContentTemplate] [nvarchar](2000) NULL,
	[ContentOutTemplate] [nvarchar](2000) NULL,
	[IsConvertToLocalUrl] [bit] NOT NULL,
	[IsEnable] [bit] NOT NULL CONSTRAINT [DF_ContentExtractionRule_IsEnable]  DEFAULT ((1)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_ContentExtractionRule_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_ContentExtractionRule] PRIMARY KEY CLUSTERED 
(
	[RuleId] ASC
)--WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO


ALTER TABLE dbo.NodeRule ADD IsDefault bit NOT NULL CONSTRAINT DF_NodeRule_IsDefault DEFAULT 0
GO

ALTER TABLE dbo.SiteSetting ADD ConvertToRedirectLink bit NOT NULL CONSTRAINT DF_SiteSetting_ConvertToRedirectLink DEFAULT 0
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TitleOriginalRule]') AND type in (N'U'))
DROP TABLE [dbo].[TitleOriginalRule]
GO

CREATE TABLE [dbo].[TitleOriginalRule](
	[RuleId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Name] [nvarchar](60) NOT NULL,
	[RuleType] [int] NOT NULL,
	[Delimiter] [nvarchar](60) NULL,
	[Count] [int] NOT NULL,
	[CategoryId] [int] NOT NULL,
	[MatchUrl] [bit] NOT NULL,
	[Url] [nvarchar](2000) NULL,
	[ExactMatch] [bit] NOT NULL,
	[Priority] [int] NOT NULL,
	[IsEnable] [bit] NOT NULL,
	[IsDefault] [bit] NOT NULL,
	[CreatedOn] [datetime] NOT NULL,
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_TitleOriginalRule] PRIMARY KEY CLUSTERED 
(
	[RuleId] ASC
)--WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TitleOriginal]') AND type in (N'U'))
DROP TABLE [dbo].[TitleOriginal]
GO

CREATE TABLE [dbo].[TitleOriginal](
	[OriginalId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[CategoryId] [int] NOT NULL,
	[Vocabulary] [nvarchar](1000) NOT NULL,
	[IsDefault] [bit] NOT NULL CONSTRAINT [DF_TitleOriginal_IsDefault]  DEFAULT ((0)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_TitleOriginal_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [TitleOriginal] PRIMARY KEY CLUSTERED 
(
	[OriginalId] ASC
)--WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TitleCategory]') AND type in (N'U'))
DROP TABLE [dbo].[TitleCategory]
GO

CREATE TABLE [dbo].[TitleCategory](
	[CategoryId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[CategoryName] [nvarchar](100) NOT NULL,
	[IsDefault] [bit] NOT NULL CONSTRAINT [DF_TitleCategory_IsDefault]  DEFAULT ((0)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_TitleCategory_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_TitleCategory] PRIMARY KEY CLUSTERED 
(
	[CategoryId] ASC
)--WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PageTitle]') AND type in (N'U'))
DROP TABLE [dbo].[PageTitle]
GO

CREATE TABLE [dbo].[PageTitle](
	[PageId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[PageIdentity] [nvarchar](36) NOT NULL,
	[Title] [nvarchar](2000) NOT NULL,
	[OldTitle] [nvarchar](2000) NOT NULL,
	[TitleMainPart] [nvarchar](2000) NOT NULL,
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_PageTitle_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_PageTitle] PRIMARY KEY CLUSTERED 
(
	[PageId] ASC
)--WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO


if exists (select * from dbo.sysobjects where id = object_id(N'[ContentExtractionRule_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ContentExtractionRule_GetMaxId]
GO
------------------------------------
--;õֵֶ 
--Ŀƣ
--˵
--ʱ䣺2013/4/5 0:05:53
------------------------------------
CREATE PROCEDURE ContentExtractionRule_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([RuleId])+1 FROM [ContentExtractionRule]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ContentExtractionRule_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ContentExtractionRule_Exists]
GO
------------------------------------
--;ǷѾ 
--Ŀƣ
--˵
--ʱ䣺2013/4/5 0:05:53
------------------------------------
CREATE PROCEDURE ContentExtractionRule_Exists
@RuleId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [ContentExtractionRule] WHERE RuleId=@RuleId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ContentExtractionRule_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ContentExtractionRule_ADD]
GO
------------------------------------
--;һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/5 0:05:53
------------------------------------
CREATE PROCEDURE ContentExtractionRule_ADD
@RuleId int output,
@SiteId int,
@Name nvarchar(20),
@Url nvarchar(1000),
@ContentExpression nvarchar(2000),
@ChildExpression nvarchar(2000),
@Encoding nvarchar(50),
@NoResultText nvarchar(60),
@ContentTemplate nvarchar(2000),
@ContentOutTemplate nvarchar(2000),
@IsConvertToLocalUrl bit,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [ContentExtractionRule](
	[SiteId],[Name],[Url],[ContentExpression],[ChildExpression],[Encoding],[NoResultText],[ContentTemplate],[ContentOutTemplate],[IsConvertToLocalUrl],[IsEnable],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Name,@Url,@ContentExpression,@ChildExpression,@Encoding,@NoResultText,@ContentTemplate,@ContentOutTemplate,@IsConvertToLocalUrl,@IsEnable,@CreatedOn,@UpdatedOn
	)
	SET @RuleId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ContentExtractionRule_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ContentExtractionRule_Update]
GO
------------------------------------
--;޸һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/5 0:05:53
------------------------------------
CREATE PROCEDURE ContentExtractionRule_Update
@RuleId int,
@SiteId int,
@Name nvarchar(20),
@Url nvarchar(1000),
@ContentExpression nvarchar(2000),
@ChildExpression nvarchar(2000),
@Encoding nvarchar(50),
@NoResultText nvarchar(60),
@ContentTemplate nvarchar(2000),
@ContentOutTemplate nvarchar(2000),
@IsConvertToLocalUrl bit,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [ContentExtractionRule] SET 
	[SiteId] = @SiteId,[Name] = @Name,[Url] = @Url,[ContentExpression] = @ContentExpression,[ChildExpression] = @ChildExpression,[Encoding] = @Encoding,[NoResultText] = @NoResultText,[ContentTemplate] = @ContentTemplate,[ContentOutTemplate] = @ContentOutTemplate,[IsConvertToLocalUrl] = @IsConvertToLocalUrl,[IsEnable] = @IsEnable,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ContentExtractionRule_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ContentExtractionRule_Delete]
GO
------------------------------------
--;ɾһ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/5 0:05:53
------------------------------------
CREATE PROCEDURE ContentExtractionRule_Delete
@RuleId int
 AS 
	DELETE [ContentExtractionRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ContentExtractionRule_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ContentExtractionRule_GetModel]
GO
------------------------------------
--;õʵϸϢ 
--Ŀƣ
--˵
--ʱ䣺2013/4/5 0:05:53
------------------------------------
CREATE PROCEDURE ContentExtractionRule_GetModel
@RuleId int
 AS 
	SELECT 
	RuleId,SiteId,Name,Url,ContentExpression,ChildExpression,Encoding,NoResultText,ContentTemplate,ContentOutTemplate,IsConvertToLocalUrl,IsEnable,CreatedOn,UpdatedOn
	 FROM [ContentExtractionRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ContentExtractionRule_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ContentExtractionRule_GetList]
GO
------------------------------------
--;ѯ¼Ϣ 
--Ŀƣ
--˵
--ʱ䣺2013/4/5 0:05:53
------------------------------------
CREATE PROCEDURE ContentExtractionRule_GetList
 AS 
	SELECT 
	RuleId,SiteId,Name,Url,ContentExpression,ChildExpression,Encoding,NoResultText,ContentTemplate,ContentOutTemplate,IsConvertToLocalUrl,IsEnable,CreatedOn,UpdatedOn
	 FROM [ContentExtractionRule]

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[DomainSetting_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [DomainSetting_GetMaxId]
GO
------------------------------------
--;õֵֶ 
--Ŀƣ
--˵
--ʱ䣺2013/4/5 0:08:17
------------------------------------
CREATE PROCEDURE DomainSetting_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([DomainId])+1 FROM [DomainSetting]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[DomainSetting_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [DomainSetting_Exists]
GO
------------------------------------
--;ǷѾ 
--Ŀƣ
--˵
--ʱ䣺2013/4/5 0:08:17
------------------------------------
CREATE PROCEDURE DomainSetting_Exists
@DomainId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [DomainSetting] WHERE DomainId=@DomainId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[DomainSetting_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [DomainSetting_ADD]
GO
------------------------------------
--;һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/5 0:08:17
------------------------------------
CREATE PROCEDURE DomainSetting_ADD
@DomainId int output,
@SiteId int,
@DomainName nvarchar(200),
@Domain nvarchar(200),
@Charset nvarchar(20),
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [DomainSetting](
	[SiteId],[DomainName],[Domain],[Charset],[IsEnable],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@DomainName,@Domain,@Charset,@IsEnable,@CreatedOn,@UpdatedOn
	)
	SET @DomainId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[DomainSetting_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [DomainSetting_Update]
GO
------------------------------------
--;޸һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/5 0:08:17
------------------------------------
CREATE PROCEDURE DomainSetting_Update
@DomainId int,
@SiteId int,
@DomainName nvarchar(200),
@Domain nvarchar(200),
@Charset nvarchar(20),
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [DomainSetting] SET 
	[SiteId] = @SiteId,[DomainName] = @DomainName,[Domain] = @Domain,[Charset] = @Charset,[IsEnable] = @IsEnable,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE DomainId=@DomainId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[DomainSetting_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [DomainSetting_Delete]
GO
------------------------------------
--;ɾһ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/5 0:08:17
------------------------------------
CREATE PROCEDURE DomainSetting_Delete
@DomainId int
 AS 
	DELETE [DomainSetting]
	 WHERE DomainId=@DomainId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[DomainSetting_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [DomainSetting_GetModel]
GO
------------------------------------
--;õʵϸϢ 
--Ŀƣ
--˵
--ʱ䣺2013/4/5 0:08:17
------------------------------------
CREATE PROCEDURE DomainSetting_GetModel
@DomainId int
 AS 
	SELECT 
	DomainId,SiteId,DomainName,Domain,Charset,IsEnable,CreatedOn,UpdatedOn
	 FROM [DomainSetting]
	 WHERE DomainId=@DomainId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[DomainSetting_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [DomainSetting_GetList]
GO
------------------------------------
--;ѯ¼Ϣ 
--Ŀƣ
--˵
--ʱ䣺2013/4/5 0:08:17
------------------------------------
CREATE PROCEDURE DomainSetting_GetList
 AS 
	SELECT 
	DomainId,SiteId,DomainName,Domain,Charset,IsEnable,CreatedOn,UpdatedOn
	 FROM [DomainSetting]

GO


if exists (select * from dbo.sysobjects where id = object_id(N'[MultiSite_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [MultiSite_GetMaxId]
GO
------------------------------------
--;õֵֶ 
--Ŀƣ
--˵
--ʱ䣺2013/4/5 0:08:46
------------------------------------
CREATE PROCEDURE MultiSite_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([MultiSiteId])+1 FROM [MultiSite]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[MultiSite_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [MultiSite_Exists]
GO
------------------------------------
--;ǷѾ 
--Ŀƣ
--˵
--ʱ䣺2013/4/5 0:08:46
------------------------------------
CREATE PROCEDURE MultiSite_Exists
@MultiSiteId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [MultiSite] WHERE MultiSiteId=@MultiSiteId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[MultiSite_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [MultiSite_ADD]
GO
------------------------------------
--;һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/5 0:08:46
------------------------------------
CREATE PROCEDURE MultiSite_ADD
@MultiSiteId int output,
@SiteId int,
@SiteName nvarchar(200),
@RootDomain nvarchar(200),
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [MultiSite](
	[SiteId],[SiteName],[RootDomain],[IsEnable],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@SiteName,@RootDomain,@IsEnable,@CreatedOn,@UpdatedOn
	)
	SET @MultiSiteId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[MultiSite_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [MultiSite_Update]
GO
------------------------------------
--;޸һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/5 0:08:46
------------------------------------
CREATE PROCEDURE MultiSite_Update
@MultiSiteId int,
@SiteId int,
@SiteName nvarchar(200),
@RootDomain nvarchar(200),
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [MultiSite] SET 
	[SiteId] = @SiteId,[SiteName] = @SiteName,[RootDomain] = @RootDomain,[IsEnable] = @IsEnable,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE MultiSiteId=@MultiSiteId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[MultiSite_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [MultiSite_Delete]
GO
------------------------------------
--;ɾһ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/5 0:08:46
------------------------------------
CREATE PROCEDURE MultiSite_Delete
@MultiSiteId int
 AS 
	DELETE [MultiSite]
	 WHERE MultiSiteId=@MultiSiteId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[MultiSite_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [MultiSite_GetModel]
GO
------------------------------------
--;õʵϸϢ 
--Ŀƣ
--˵
--ʱ䣺2013/4/5 0:08:46
------------------------------------
CREATE PROCEDURE MultiSite_GetModel
@MultiSiteId int
 AS 
	SELECT 
	MultiSiteId,SiteId,SiteName,RootDomain,IsEnable,CreatedOn,UpdatedOn
	 FROM [MultiSite]
	 WHERE MultiSiteId=@MultiSiteId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[MultiSite_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [MultiSite_GetList]
GO
------------------------------------
--;ѯ¼Ϣ 
--Ŀƣ
--˵
--ʱ䣺2013/4/5 0:08:46
------------------------------------
CREATE PROCEDURE MultiSite_GetList
 AS 
	SELECT 
	MultiSiteId,SiteId,SiteName,RootDomain,IsEnable,CreatedOn,UpdatedOn
	 FROM [MultiSite]

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NonStaticUrl_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NonStaticUrl_GetMaxId]
GO
------------------------------------
--;õֵֶ 
--Ŀƣ
--˵
--ʱ䣺2013/4/6 11:01:57
------------------------------------
CREATE PROCEDURE NonStaticUrl_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([UrlId])+1 FROM [NonStaticUrl]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NonStaticUrl_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NonStaticUrl_Exists]
GO
------------------------------------
--;ǷѾ 
--Ŀƣ
--˵
--ʱ䣺2013/4/6 11:01:57
------------------------------------
CREATE PROCEDURE NonStaticUrl_Exists
@UrlId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [NonStaticUrl] WHERE UrlId=@UrlId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NonStaticUrl_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NonStaticUrl_ADD]
GO
------------------------------------
--;һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/6 11:01:57
------------------------------------
CREATE PROCEDURE NonStaticUrl_ADD
@UrlId int output,
@SiteId int,
@Name nvarchar(200),
@Url nvarchar(4000),
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [NonStaticUrl](
	[SiteId],[Name],[Url],[IsEnable],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Name,@Url,@IsEnable,@CreatedOn,@UpdatedOn
	)
	SET @UrlId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NonStaticUrl_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NonStaticUrl_Update]
GO
------------------------------------
--;޸һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/6 11:01:57
------------------------------------
CREATE PROCEDURE NonStaticUrl_Update
@UrlId int,
@SiteId int,
@Name nvarchar(200),
@Url nvarchar(4000),
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [NonStaticUrl] SET 
	[SiteId] = @SiteId,[Name] = @Name,[Url] = @Url,[IsEnable] = @IsEnable,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE UrlId=@UrlId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NonStaticUrl_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NonStaticUrl_Delete]
GO
------------------------------------
--;ɾһ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/6 11:01:57
------------------------------------
CREATE PROCEDURE NonStaticUrl_Delete
@UrlId int
 AS 
	DELETE [NonStaticUrl]
	 WHERE UrlId=@UrlId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NonStaticUrl_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NonStaticUrl_GetModel]
GO
------------------------------------
--;õʵϸϢ 
--Ŀƣ
--˵
--ʱ䣺2013/4/6 11:01:57
------------------------------------
CREATE PROCEDURE NonStaticUrl_GetModel
@UrlId int
 AS 
	SELECT 
	UrlId,SiteId,Name,Url,IsEnable,CreatedOn,UpdatedOn
	 FROM [NonStaticUrl]
	 WHERE UrlId=@UrlId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NonStaticUrl_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NonStaticUrl_GetList]
GO
------------------------------------
--;ѯ¼Ϣ 
--Ŀƣ
--˵
--ʱ䣺2013/4/6 11:01:57
------------------------------------
CREATE PROCEDURE NonStaticUrl_GetList
 AS 
	SELECT 
	UrlId,SiteId,Name,Url,IsEnable,CreatedOn,UpdatedOn
	 FROM [NonStaticUrl]

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[UrlEncodingRule_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [UrlEncodingRule_GetMaxId]
GO
------------------------------------
--;õֵֶ 
--Ŀƣ
--˵
--ʱ䣺2013/4/6 10:59:31
------------------------------------
CREATE PROCEDURE UrlEncodingRule_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([RuleId])+1 FROM [UrlEncodingRule]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[UrlEncodingRule_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [UrlEncodingRule_Exists]
GO
------------------------------------
--;ǷѾ 
--Ŀƣ
--˵
--ʱ䣺2013/4/6 10:59:31
------------------------------------
CREATE PROCEDURE UrlEncodingRule_Exists
@RuleId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [UrlEncodingRule] WHERE RuleId=@RuleId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[UrlEncodingRule_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [UrlEncodingRule_ADD]
GO
------------------------------------
--;һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/6 10:59:31
------------------------------------
CREATE PROCEDURE UrlEncodingRule_ADD
@RuleId int output,
@SiteId int,
@TagName nvarchar(40),
@AttributeName nvarchar(200),
@DefaultFileType nvarchar(20),
@Priority int,
@KeepOriginalFileType bit,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [UrlEncodingRule](
	[SiteId],[TagName],[AttributeName],[DefaultFileType],[Priority],[KeepOriginalFileType],[IsEnable],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@TagName,@AttributeName,@DefaultFileType,@Priority,@KeepOriginalFileType,@IsEnable,@CreatedOn,@UpdatedOn
	)
	SET @RuleId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[UrlEncodingRule_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [UrlEncodingRule_Update]
GO
------------------------------------
--;޸һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/6 10:59:31
------------------------------------
CREATE PROCEDURE UrlEncodingRule_Update
@RuleId int,
@SiteId int,
@TagName nvarchar(40),
@AttributeName nvarchar(200),
@DefaultFileType nvarchar(20),
@Priority int,
@KeepOriginalFileType bit,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [UrlEncodingRule] SET 
	[SiteId] = @SiteId,[TagName] = @TagName,[AttributeName] = @AttributeName,[DefaultFileType] = @DefaultFileType,[Priority] = @Priority,[KeepOriginalFileType] = @KeepOriginalFileType,[IsEnable] = @IsEnable,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[UrlEncodingRule_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [UrlEncodingRule_Delete]
GO
------------------------------------
--;ɾһ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/6 10:59:31
------------------------------------
CREATE PROCEDURE UrlEncodingRule_Delete
@RuleId int
 AS 
	DELETE [UrlEncodingRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[UrlEncodingRule_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [UrlEncodingRule_GetModel]
GO
------------------------------------
--;õʵϸϢ 
--Ŀƣ
--˵
--ʱ䣺2013/4/6 10:59:31
------------------------------------
CREATE PROCEDURE UrlEncodingRule_GetModel
@RuleId int
 AS 
	SELECT 
	RuleId,SiteId,TagName,AttributeName,DefaultFileType,Priority,KeepOriginalFileType,IsEnable,CreatedOn,UpdatedOn
	 FROM [UrlEncodingRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[UrlEncodingRule_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [UrlEncodingRule_GetList]
GO
------------------------------------
--;ѯ¼Ϣ 
--Ŀƣ
--˵
--ʱ䣺2013/4/6 10:59:31
------------------------------------
CREATE PROCEDURE UrlEncodingRule_GetList
 AS 
	SELECT 
	RuleId,SiteId,TagName,AttributeName,DefaultFileType,Priority,KeepOriginalFileType,IsEnable,CreatedOn,UpdatedOn
	 FROM [UrlEncodingRule]

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NodeRule_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NodeRule_GetMaxId]
GO
------------------------------------
--;õֵֶ 
--Ŀƣ
--˵
--ʱ䣺2013/4/11 21:34:44
------------------------------------
CREATE PROCEDURE NodeRule_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([RuleId])+1 FROM [NodeRule]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NodeRule_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NodeRule_Exists]
GO
------------------------------------
--;ǷѾ 
--Ŀƣ
--˵
--ʱ䣺2013/4/11 21:34:44
------------------------------------
CREATE PROCEDURE NodeRule_Exists
@RuleId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [NodeRule] WHERE RuleId=@RuleId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NodeRule_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NodeRule_ADD]
GO
------------------------------------
--;һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/11 21:34:44
------------------------------------
CREATE PROCEDURE NodeRule_ADD
@RuleId int output,
@SiteId int,
@Name nvarchar(100),
@Expression nvarchar(2000),
@AttributeName nvarchar(200),
@OperationValue nvarchar(MAX),
@OperationIndex int,
@OperationType int,
@MatchUrl bit,
@Url nvarchar(2000),
@ExactMatch bit,
@Priority int,
@IsEnable bit,
@IsDefault bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [NodeRule](
	[SiteId],[Name],[Expression],[AttributeName],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[Url],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Name,@Expression,@AttributeName,@OperationValue,@OperationIndex,@OperationType,@MatchUrl,@Url,@ExactMatch,@Priority,@IsEnable,@IsDefault,@CreatedOn,@UpdatedOn
	)
	SET @RuleId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NodeRule_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NodeRule_Update]
GO
------------------------------------
--;޸һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/11 21:34:44
------------------------------------
CREATE PROCEDURE NodeRule_Update
@RuleId int,
@SiteId int,
@Name nvarchar(100),
@Expression nvarchar(2000),
@AttributeName nvarchar(200),
@OperationValue nvarchar(MAX),
@OperationIndex int,
@OperationType int,
@MatchUrl bit,
@Url nvarchar(2000),
@ExactMatch bit,
@Priority int,
@IsEnable bit,
@IsDefault bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [NodeRule] SET 
	[SiteId] = @SiteId,[Name] = @Name,[Expression] = @Expression,[AttributeName] = @AttributeName,[OperationValue] = @OperationValue,[OperationIndex] = @OperationIndex,[OperationType] = @OperationType,[MatchUrl] = @MatchUrl,[Url] = @Url,[ExactMatch] = @ExactMatch,[Priority] = @Priority,[IsEnable] = @IsEnable,[IsDefault] = @IsDefault,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NodeRule_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NodeRule_Delete]
GO
------------------------------------
--;ɾһ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/11 21:34:44
------------------------------------
CREATE PROCEDURE NodeRule_Delete
@RuleId int
 AS 
	DELETE [NodeRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NodeRule_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NodeRule_GetModel]
GO
------------------------------------
--;õʵϸϢ 
--Ŀƣ
--˵
--ʱ䣺2013/4/11 21:34:44
------------------------------------
CREATE PROCEDURE NodeRule_GetModel
@RuleId int
 AS 
	SELECT 
	RuleId,SiteId,Name,Expression,AttributeName,OperationValue,OperationIndex,OperationType,MatchUrl,Url,ExactMatch,Priority,IsEnable,IsDefault,CreatedOn,UpdatedOn
	 FROM [NodeRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NodeRule_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NodeRule_GetList]
GO
------------------------------------
--;ѯ¼Ϣ 
--Ŀƣ
--˵
--ʱ䣺2013/4/11 21:34:44
------------------------------------
CREATE PROCEDURE NodeRule_GetList
 AS 
	SELECT 
	RuleId,SiteId,Name,Expression,AttributeName,OperationValue,OperationIndex,OperationType,MatchUrl,Url,ExactMatch,Priority,IsEnable,IsDefault,CreatedOn,UpdatedOn
	 FROM [NodeRule]

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[SiteSetting_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [SiteSetting_GetMaxId]
GO
------------------------------------
--;õֵֶ 
--Ŀƣ
--˵
--ʱ䣺2013/4/11 21:36:28
------------------------------------
CREATE PROCEDURE SiteSetting_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([SettingId])+1 FROM [SiteSetting]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[SiteSetting_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [SiteSetting_Exists]
GO
------------------------------------
--;ǷѾ 
--Ŀƣ
--˵
--ʱ䣺2013/4/11 21:36:28
------------------------------------
CREATE PROCEDURE SiteSetting_Exists
@SettingId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [SiteSetting] WHERE SettingId=@SettingId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[SiteSetting_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [SiteSetting_ADD]
GO
------------------------------------
--;һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/11 21:36:28
------------------------------------
CREATE PROCEDURE SiteSetting_ADD
@SettingId int output,
@SiteId int,
@Name nvarchar(20),
@IsActive bit,
@HeadCode nvarchar(MAX),
@BodyCode nvarchar(MAX),
@CacheExpireTime int,
@Charset nvarchar(20),
@ForbiddenFileType nvarchar(255),
@CollectImage bit,
@FakeOriginalTitle bit,
@FakeOriginalContent bit,
@StaticExtension nvarchar(20),
@EnableBillboard bit,
@CustomInternalLinkKeyword nvarchar(255),
@InternalSearchTemplate nvarchar(50),
@SupportPandomain bit,
@UseProxy bit,
@SynchronizeIECookie bit,
@CookieString nvarchar(4000),
@EnableErrorLog bit,
@EnableStatisticalCode bit,
@ConvertToRedirectLink bit,
@WorkMode int,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [SiteSetting](
	[SiteId],[Name],[IsActive],[HeadCode],[BodyCode],[CacheExpireTime],[Charset],[ForbiddenFileType],[CollectImage],[FakeOriginalTitle],[FakeOriginalContent],[StaticExtension],[EnableBillboard],[CustomInternalLinkKeyword],[InternalSearchTemplate],[SupportPandomain],[UseProxy],[SynchronizeIECookie],[CookieString],[EnableErrorLog],[EnableStatisticalCode],[ConvertToRedirectLink],[WorkMode],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Name,@IsActive,@HeadCode,@BodyCode,@CacheExpireTime,@Charset,@ForbiddenFileType,@CollectImage,@FakeOriginalTitle,@FakeOriginalContent,@StaticExtension,@EnableBillboard,@CustomInternalLinkKeyword,@InternalSearchTemplate,@SupportPandomain,@UseProxy,@SynchronizeIECookie,@CookieString,@EnableErrorLog,@EnableStatisticalCode,@ConvertToRedirectLink,@WorkMode,@CreatedOn,@UpdatedOn
	)
	SET @SettingId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[SiteSetting_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [SiteSetting_Update]
GO
------------------------------------
--;޸һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/11 21:36:28
------------------------------------
CREATE PROCEDURE SiteSetting_Update
@SettingId int,
@SiteId int,
@Name nvarchar(20),
@IsActive bit,
@HeadCode nvarchar(MAX),
@BodyCode nvarchar(MAX),
@CacheExpireTime int,
@Charset nvarchar(20),
@ForbiddenFileType nvarchar(255),
@CollectImage bit,
@FakeOriginalTitle bit,
@FakeOriginalContent bit,
@StaticExtension nvarchar(20),
@EnableBillboard bit,
@CustomInternalLinkKeyword nvarchar(255),
@InternalSearchTemplate nvarchar(50),
@SupportPandomain bit,
@UseProxy bit,
@SynchronizeIECookie bit,
@CookieString nvarchar(4000),
@EnableErrorLog bit,
@EnableStatisticalCode bit,
@ConvertToRedirectLink bit,
@WorkMode int,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [SiteSetting] SET 
	[SiteId] = @SiteId,[Name] = @Name,[IsActive] = @IsActive,[HeadCode] = @HeadCode,[BodyCode] = @BodyCode,[CacheExpireTime] = @CacheExpireTime,[Charset] = @Charset,[ForbiddenFileType] = @ForbiddenFileType,[CollectImage] = @CollectImage,[FakeOriginalTitle] = @FakeOriginalTitle,[FakeOriginalContent] = @FakeOriginalContent,[StaticExtension] = @StaticExtension,[EnableBillboard] = @EnableBillboard,[CustomInternalLinkKeyword] = @CustomInternalLinkKeyword,[InternalSearchTemplate] = @InternalSearchTemplate,[SupportPandomain] = @SupportPandomain,[UseProxy] = @UseProxy,[SynchronizeIECookie] = @SynchronizeIECookie,[CookieString] = @CookieString,[EnableErrorLog] = @EnableErrorLog,[EnableStatisticalCode] = @EnableStatisticalCode,[ConvertToRedirectLink] = @ConvertToRedirectLink,[WorkMode] = @WorkMode,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE SettingId=@SettingId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[SiteSetting_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [SiteSetting_Delete]
GO
------------------------------------
--;ɾһ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/11 21:36:28
------------------------------------
CREATE PROCEDURE SiteSetting_Delete
@SettingId int
 AS 
	DELETE [SiteSetting]
	 WHERE SettingId=@SettingId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[SiteSetting_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [SiteSetting_GetModel]
GO
------------------------------------
--;õʵϸϢ 
--Ŀƣ
--˵
--ʱ䣺2013/4/11 21:36:28
------------------------------------
CREATE PROCEDURE SiteSetting_GetModel
@SettingId int
 AS 
	SELECT 
	SettingId,SiteId,Name,IsActive,HeadCode,BodyCode,CacheExpireTime,Charset,ForbiddenFileType,CollectImage,FakeOriginalTitle,FakeOriginalContent,StaticExtension,EnableBillboard,CustomInternalLinkKeyword,InternalSearchTemplate,SupportPandomain,UseProxy,SynchronizeIECookie,CookieString,EnableErrorLog,EnableStatisticalCode,ConvertToRedirectLink,WorkMode,CreatedOn,UpdatedOn
	 FROM [SiteSetting]
	 WHERE SettingId=@SettingId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[SiteSetting_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [SiteSetting_GetList]
GO
------------------------------------
--;ѯ¼Ϣ 
--Ŀƣ
--˵
--ʱ䣺2013/4/11 21:36:28
------------------------------------
CREATE PROCEDURE SiteSetting_GetList
 AS 
	SELECT 
	SettingId,SiteId,Name,IsActive,HeadCode,BodyCode,CacheExpireTime,Charset,ForbiddenFileType,CollectImage,FakeOriginalTitle,FakeOriginalContent,StaticExtension,EnableBillboard,CustomInternalLinkKeyword,InternalSearchTemplate,SupportPandomain,UseProxy,SynchronizeIECookie,CookieString,EnableErrorLog,EnableStatisticalCode,ConvertToRedirectLink,WorkMode,CreatedOn,UpdatedOn
	 FROM [SiteSetting]

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleCategory_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleCategory_GetMaxId]
GO
------------------------------------
--;õֵֶ 
--Ŀƣ
--˵
--ʱ䣺2013/4/27 21:47:28
------------------------------------
CREATE PROCEDURE TitleCategory_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([CategoryId])+1 FROM [TitleCategory]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleCategory_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleCategory_Exists]
GO
------------------------------------
--;ǷѾ 
--Ŀƣ
--˵
--ʱ䣺2013/4/27 21:47:28
------------------------------------
CREATE PROCEDURE TitleCategory_Exists
@CategoryId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [TitleCategory] WHERE CategoryId=@CategoryId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleCategory_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleCategory_ADD]
GO
------------------------------------
--;һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/27 21:47:28
------------------------------------
CREATE PROCEDURE TitleCategory_ADD
@CategoryId int output,
@SiteId int,
@CategoryName nvarchar(100),
@IsDefault bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [TitleCategory](
	[SiteId],[CategoryName],[IsDefault],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@CategoryName,@IsDefault,@CreatedOn,@UpdatedOn
	)
	SET @CategoryId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleCategory_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleCategory_Update]
GO
------------------------------------
--;޸һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/27 21:47:28
------------------------------------
CREATE PROCEDURE TitleCategory_Update
@CategoryId int,
@SiteId int,
@CategoryName nvarchar(100),
@IsDefault bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [TitleCategory] SET 
	[SiteId] = @SiteId,[CategoryName] = @CategoryName,[IsDefault] = @IsDefault,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE CategoryId=@CategoryId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleCategory_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleCategory_Delete]
GO
------------------------------------
--;ɾһ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/27 21:47:28
------------------------------------
CREATE PROCEDURE TitleCategory_Delete
@CategoryId int
 AS 
	DELETE [TitleCategory]
	 WHERE CategoryId=@CategoryId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleCategory_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleCategory_GetModel]
GO
------------------------------------
--;õʵϸϢ 
--Ŀƣ
--˵
--ʱ䣺2013/4/27 21:47:28
------------------------------------
CREATE PROCEDURE TitleCategory_GetModel
@CategoryId int
 AS 
	SELECT 
	CategoryId,SiteId,CategoryName,IsDefault,CreatedOn,UpdatedOn
	 FROM [TitleCategory]
	 WHERE CategoryId=@CategoryId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleCategory_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleCategory_GetList]
GO
------------------------------------
--;ѯ¼Ϣ 
--Ŀƣ
--˵
--ʱ䣺2013/4/27 21:47:28
------------------------------------
CREATE PROCEDURE TitleCategory_GetList
 AS 
	SELECT 
	CategoryId,SiteId,CategoryName,IsDefault,CreatedOn,UpdatedOn
	 FROM [TitleCategory]

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginal_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginal_GetMaxId]
GO
------------------------------------
--;õֵֶ 
--Ŀƣ
--˵
--ʱ䣺2013/4/27 21:47:38
------------------------------------
CREATE PROCEDURE TitleOriginal_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([OriginalId])+1 FROM [TitleOriginal]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginal_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginal_Exists]
GO
------------------------------------
--;ǷѾ 
--Ŀƣ
--˵
--ʱ䣺2013/4/27 21:47:38
------------------------------------
CREATE PROCEDURE TitleOriginal_Exists
@OriginalId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [TitleOriginal] WHERE OriginalId=@OriginalId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginal_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginal_ADD]
GO
------------------------------------
--;һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/27 21:47:38
------------------------------------
CREATE PROCEDURE TitleOriginal_ADD
@OriginalId int output,
@SiteId int,
@CategoryId int,
@Vocabulary nvarchar(1000),
@IsDefault bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [TitleOriginal](
	[SiteId],[CategoryId],[Vocabulary],[IsDefault],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@CategoryId,@Vocabulary,@IsDefault,@CreatedOn,@UpdatedOn
	)
	SET @OriginalId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginal_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginal_Update]
GO
------------------------------------
--;޸һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/27 21:47:38
------------------------------------
CREATE PROCEDURE TitleOriginal_Update
@OriginalId int,
@SiteId int,
@CategoryId int,
@Vocabulary nvarchar(1000),
@IsDefault bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [TitleOriginal] SET 
	[SiteId] = @SiteId,[CategoryId] = @CategoryId,[Vocabulary] = @Vocabulary,[IsDefault] = @IsDefault,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE OriginalId=@OriginalId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginal_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginal_Delete]
GO
------------------------------------
--;ɾһ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/27 21:47:38
------------------------------------
CREATE PROCEDURE TitleOriginal_Delete
@OriginalId int
 AS 
	DELETE [TitleOriginal]
	 WHERE OriginalId=@OriginalId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginal_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginal_GetModel]
GO
------------------------------------
--;õʵϸϢ 
--Ŀƣ
--˵
--ʱ䣺2013/4/27 21:47:38
------------------------------------
CREATE PROCEDURE TitleOriginal_GetModel
@OriginalId int
 AS 
	SELECT 
	OriginalId,SiteId,CategoryId,Vocabulary,IsDefault,CreatedOn,UpdatedOn
	 FROM [TitleOriginal]
	 WHERE OriginalId=@OriginalId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginal_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginal_GetList]
GO
------------------------------------
--;ѯ¼Ϣ 
--Ŀƣ
--˵
--ʱ䣺2013/4/27 21:47:38
------------------------------------
CREATE PROCEDURE TitleOriginal_GetList
 AS 
	SELECT 
	OriginalId,SiteId,CategoryId,Vocabulary,IsDefault,CreatedOn,UpdatedOn
	 FROM [TitleOriginal]

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginalRule_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginalRule_GetMaxId]
GO
------------------------------------
--;õֵֶ 
--Ŀƣ
--˵
--ʱ䣺2013/4/28 19:55:02
------------------------------------
CREATE PROCEDURE TitleOriginalRule_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([RuleId])+1 FROM [TitleOriginalRule]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginalRule_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginalRule_Exists]
GO
------------------------------------
--;ǷѾ 
--Ŀƣ
--˵
--ʱ䣺2013/4/28 19:55:02
------------------------------------
CREATE PROCEDURE TitleOriginalRule_Exists
@RuleId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [TitleOriginalRule] WHERE RuleId=@RuleId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginalRule_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginalRule_ADD]
GO
------------------------------------
--;һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/28 19:55:02
------------------------------------
CREATE PROCEDURE TitleOriginalRule_ADD
@RuleId int output,
@SiteId int,
@Name nvarchar(60),
@RuleType int,
@Delimiter nvarchar(60),
@Count int,
@CategoryId int,
@MatchUrl bit,
@Url nvarchar(2000),
@ExactMatch bit,
@Priority int,
@IsEnable bit,
@IsDefault bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [TitleOriginalRule](
	[SiteId],[Name],[RuleType],[Delimiter],[Count],[CategoryId],[MatchUrl],[Url],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Name,@RuleType,@Delimiter,@Count,@CategoryId,@MatchUrl,@Url,@ExactMatch,@Priority,@IsEnable,@IsDefault,@CreatedOn,@UpdatedOn
	)
	SET @RuleId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginalRule_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginalRule_Update]
GO
------------------------------------
--;޸һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/28 19:55:02
------------------------------------
CREATE PROCEDURE TitleOriginalRule_Update
@RuleId int,
@SiteId int,
@Name nvarchar(60),
@RuleType int,
@Delimiter nvarchar(60),
@Count int,
@CategoryId int,
@MatchUrl bit,
@Url nvarchar(2000),
@ExactMatch bit,
@Priority int,
@IsEnable bit,
@IsDefault bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [TitleOriginalRule] SET 
	[SiteId] = @SiteId,[Name] = @Name,[RuleType] = @RuleType,[Delimiter] = @Delimiter,[Count] = @Count,[CategoryId] = @CategoryId,[MatchUrl] = @MatchUrl,[Url] = @Url,[ExactMatch] = @ExactMatch,[Priority] = @Priority,[IsEnable] = @IsEnable,[IsDefault] = @IsDefault,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginalRule_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginalRule_Delete]
GO
------------------------------------
--;ɾһ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/28 19:55:02
------------------------------------
CREATE PROCEDURE TitleOriginalRule_Delete
@RuleId int
 AS 
	DELETE [TitleOriginalRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginalRule_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginalRule_GetModel]
GO
------------------------------------
--;õʵϸϢ 
--Ŀƣ
--˵
--ʱ䣺2013/4/28 19:55:02
------------------------------------
CREATE PROCEDURE TitleOriginalRule_GetModel
@RuleId int
 AS 
	SELECT 
	RuleId,SiteId,Name,RuleType,Delimiter,Count,CategoryId,MatchUrl,Url,ExactMatch,Priority,IsEnable,IsDefault,CreatedOn,UpdatedOn
	 FROM [TitleOriginalRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginalRule_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginalRule_GetList]
GO
------------------------------------
--;ѯ¼Ϣ 
--Ŀƣ
--˵
--ʱ䣺2013/4/28 19:55:02
------------------------------------
CREATE PROCEDURE TitleOriginalRule_GetList
 AS 
	SELECT 
	RuleId,SiteId,Name,RuleType,Delimiter,Count,CategoryId,MatchUrl,Url,ExactMatch,Priority,IsEnable,IsDefault,CreatedOn,UpdatedOn
	 FROM [TitleOriginalRule]

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[PageTitle_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [PageTitle_GetMaxId]
GO
------------------------------------
--;õֵֶ 
--Ŀƣ
--˵
--ʱ䣺2013/4/29 11:20:00
------------------------------------
CREATE PROCEDURE PageTitle_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([PageId])+1 FROM [PageTitle]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[PageTitle_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [PageTitle_Exists]
GO
------------------------------------
--;ǷѾ 
--Ŀƣ
--˵
--ʱ䣺2013/4/29 11:20:00
------------------------------------
CREATE PROCEDURE PageTitle_Exists
@PageId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [PageTitle] WHERE PageId=@PageId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[PageTitle_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [PageTitle_ADD]
GO
------------------------------------
--;һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/29 11:20:00
------------------------------------
CREATE PROCEDURE PageTitle_ADD
@PageId int output,
@SiteId int,
@PageIdentity nvarchar(36),
@Title nvarchar(2000),
@OldTitle nvarchar(2000),
@TitleMainPart nvarchar(2000),
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [PageTitle](
	[SiteId],[PageIdentity],[Title],[OldTitle],[TitleMainPart],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@PageIdentity,@Title,@OldTitle,@TitleMainPart,@CreatedOn,@UpdatedOn
	)
	SET @PageId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[PageTitle_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [PageTitle_Update]
GO
------------------------------------
--;޸һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/29 11:20:00
------------------------------------
CREATE PROCEDURE PageTitle_Update
@PageId int,
@SiteId int,
@PageIdentity nvarchar(36),
@Title nvarchar(2000),
@OldTitle nvarchar(2000),
@TitleMainPart nvarchar(2000),
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [PageTitle] SET 
	[SiteId] = @SiteId,[PageIdentity] = @PageIdentity,[Title] = @Title,[OldTitle] = @OldTitle,[TitleMainPart] = @TitleMainPart,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE PageId=@PageId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[PageTitle_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [PageTitle_Delete]
GO
------------------------------------
--;ɾһ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/29 11:20:00
------------------------------------
CREATE PROCEDURE PageTitle_Delete
@PageId int
 AS 
	DELETE [PageTitle]
	 WHERE PageId=@PageId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[PageTitle_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [PageTitle_GetModel]
GO
------------------------------------
--;õʵϸϢ 
--Ŀƣ
--˵
--ʱ䣺2013/4/29 11:20:00
------------------------------------
CREATE PROCEDURE PageTitle_GetModel
@PageId int
 AS 
	SELECT 
	PageId,SiteId,PageIdentity,Title,OldTitle,TitleMainPart,CreatedOn,UpdatedOn
	 FROM [PageTitle]
	 WHERE PageId=@PageId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[PageTitle_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [PageTitle_GetList]
GO
------------------------------------
--;ѯ¼Ϣ 
--Ŀƣ
--˵
--ʱ䣺2013/4/29 11:20:00
------------------------------------
CREATE PROCEDURE PageTitle_GetList
 AS 
	SELECT 
	PageId,SiteId,PageIdentity,Title,OldTitle,TitleMainPart,CreatedOn,UpdatedOn
	 FROM [PageTitle]

GO


INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( 1,0,N'960*90',N'//script[text()[contains(.,''width = 960'') and contains(.,''height = 90'')]]|//script[text()[contains(.,''960*90'')]]|//script[text()[contains(.,''width=960'') and contains(.,''height=90'')]]|//iframe[@width="960" and @height="90"]|//script[text()[contains(.,''960*90'')]]|//script[text()[contains(.,''96090'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636906" width="960" height="90" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 12:59:30',N'2013-4-11 13:25:38')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( 1,0,N'960*60',N'//script[text()[contains(.,''width = 960'') and contains(.,''height = 60'')]]|//script[text()[contains(.,''960*60'')]]|//script[text()[contains(.,''width=960'') and contains(.,''height=60'')]]|//iframe[@width="960" and @height="60"]|//script[text()[contains(.,''960*60'')]]|//script[text()[contains(.,''96060'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636907" width="960" height="60" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:23:42',N'2013-4-11 13:27:42')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'950*90',N'//script[text()[contains(.,''width = 950'') and contains(.,''height = 90'')]]|//script[text()[contains(.,''950*90'')]]|//script[text()[contains(.,''width=950'') and contains(.,''height=90'')]]|//iframe[@width="950" and @height="90"]|//script[text()[contains(.,''950*90'')]]|//script[text()[contains(.,''95090'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636908" width="950" height="90" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:29:09')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'760*90',N'//script[text()[contains(.,''width = 760'') and contains(.,''height = 90'')]]|//script[text()[contains(.,''760*90'')]]|//script[text()[contains(.,''width=760'') and contains(.,''height=90'')]]|//iframe[@width="760" and @height="90"]|//script[text()[contains(.,''760*90'')]]|//script[text()[contains(.,''76090'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636909" width="760" height="90" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:29:58')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'728*90',N'//script[text()[contains(.,''width = 728'') and contains(.,''height = 90'')]]|//script[text()[contains(.,''728*90'')]]|//script[text()[contains(.,''width=728'') and contains(.,''height=90'')]]|//iframe[@width="728" and @height="90"]|//script[text()[contains(.,''728*90'')]]|//script[text()[contains(.,''72890'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636910" width="728" height="90" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:30:35')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'728*15',N'//script[text()[contains(.,''width = 728'') and contains(.,''height = 15'')]]|//script[text()[contains(.,''728*15'')]]|//script[text()[contains(.,''width=728'') and contains(.,''height=15'')]]|//iframe[@width="728" and @height="15"]|//script[text()[contains(.,''728*15'')]]|//script[text()[contains(.,''72815'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636911" width="728" height="15" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:31:10')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'640*60',N'//script[text()[contains(.,''width = 640'') and contains(.,''height = 60'')]]|//script[text()[contains(.,''640*60'')]]|//script[text()[contains(.,''width=640'') and contains(.,''height=60'')]]|//iframe[@width="640" and @height="60"]|//script[text()[contains(.,''640*60'')]]|//script[text()[contains(.,''64060'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636912" width="640" height="60" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:31:54')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'580*90',N'//script[text()[contains(.,''width = 580'') and contains(.,''height = 90'')]]|//script[text()[contains(.,''580*90'')]]|//script[text()[contains(.,''width=580'') and contains(.,''height=90'')]]|//iframe[@width="580" and @height="90"]|//script[text()[contains(.,''580*90'')]]|//script[text()[contains(.,''58090'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636913" width="580" height="90" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:33:20')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'500*200',N'//script[text()[contains(.,''width = 500'') and contains(.,''height = 200'')]]|//script[text()[contains(.,''500*200'')]]|//script[text()[contains(.,''width=500'') and contains(.,''height=200'')]]|//iframe[@width="500" and @height="200"]|//script[text()[contains(.,''500*200'')]]|//script[text()[contains(.,''500200'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636914" width="500" height="200" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:33:55')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'480*160',N'//script[text()[contains(.,''width = 480'') and contains(.,''height = 160'')]]|//script[text()[contains(.,''480*160'')]]|//script[text()[contains(.,''width=480'') and contains(.,''height=160'')]]|//iframe[@width="480" and @height="160"]|//script[text()[contains(.,''480*160'')]]|//script[text()[contains(.,''480160'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636915" width="480" height="160" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:34:34')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'468*60',N'//script[text()[contains(.,''width = 468'') and contains(.,''height = 60'')]]|//script[text()[contains(.,''468*60'')]]|//script[text()[contains(.,''width=468'') and contains(.,''height=60'')]]|//iframe[@width="468" and @height="60"]|//script[text()[contains(.,''468*60'')]]|//script[text()[contains(.,''46860'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636916" width="468" height="60" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:35:12')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'468*15',N'//script[text()[contains(.,''width = 468'') and contains(.,''height = 15'')]]|//script[text()[contains(.,''468*15'')]]|//script[text()[contains(.,''width=468'') and contains(.,''height=15'')]]|//iframe[@width="468" and @height="15"]|//script[text()[contains(.,''468*15'')]]|//script[text()[contains(.,''46815'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636917" width="468" height="15" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:35:51')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'460*60',N'//script[text()[contains(.,''width = 460'') and contains(.,''height = 60'')]]|//script[text()[contains(.,''460*60'')]]|//script[text()[contains(.,''width=460'') and contains(.,''height=60'')]]|//iframe[@width="460" and @height="60"]|//script[text()[contains(.,''460*60'')]]|//script[text()[contains(.,''46060'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636918" width="460" height="60" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:36:30')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'360*300',N'//script[text()[contains(.,''width = 360'') and contains(.,''height = 300'')]]|//script[text()[contains(.,''360*300'')]]|//script[text()[contains(.,''width=360'') and contains(.,''height=300'')]]|//iframe[@width="360" and @height="300"]|//script[text()[contains(.,''360*300'')]]|//script[text()[contains(.,''360300'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636919" width="360" height="300" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:37:31')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'336*280',N'//script[text()[contains(.,''width = 336'') and contains(.,''height = 280'')]]|//script[text()[contains(.,''336*280'')]]|//script[text()[contains(.,''width=336'') and contains(.,''height=280'')]]|//iframe[@width="336" and @height="280"]|//script[text()[contains(.,''336*280'')]]|//script[text()[contains(.,''336280'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636920" width="336" height="280" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:38:07')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'320*50',N'//script[text()[contains(.,''width = 320'') and contains(.,''height = 50'')]]|//script[text()[contains(.,''320*50'')]]|//script[text()[contains(.,''width=320'') and contains(.,''height=50'')]]|//iframe[@width="320" and @height="50"]|//script[text()[contains(.,''320*50'')]]|//script[text()[contains(.,''32050'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636921" width="320" height="50" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:38:37')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'300*600',N'//script[text()[contains(.,''width = 300'') and contains(.,''height = 600'')]]|//script[text()[contains(.,''300*600'')]]|//script[text()[contains(.,''width=300'') and contains(.,''height=600'')]]|//iframe[@width="300" and @height="600"]|//script[text()[contains(.,''300*600'')]]|//script[text()[contains(.,''300600'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636922" width="300" height="600" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:39:26')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'300*250',N'//script[text()[contains(.,''width = 300'') and contains(.,''height = 250'')]]|//script[text()[contains(.,''300*250'')]]|//script[text()[contains(.,''width=300'') and contains(.,''height=250'')]]|//iframe[@width="300" and @height="250"]|//script[text()[contains(.,''300*250'')]]|//script[text()[contains(.,''300250'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636923" width="300" height="250" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:40:01')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'250*250',N'//script[text()[contains(.,''width = 250'') and contains(.,''height = 250'')]]|//script[text()[contains(.,''250*250'')]]|//script[text()[contains(.,''width=250'') and contains(.,''height=250'')]]|//iframe[@width="250" and @height="250"]|//script[text()[contains(.,''250*250'')]]|//script[text()[contains(.,''250250'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636924" width="250" height="250" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:40:26')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'234*60',N'//script[text()[contains(.,''width = 234'') and contains(.,''height = 60'')]]|//script[text()[contains(.,''234*60'')]]|//script[text()[contains(.,''width=234'') and contains(.,''height=60'')]]|//iframe[@width="234" and @height="60"]|//script[text()[contains(.,''234*60'')]]|//script[text()[contains(.,''23460'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636925" width="234" height="60" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:40:57')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'200*200',N'//script[text()[contains(.,''width = 200'') and contains(.,''height = 200'')]]|//script[text()[contains(.,''200*200'')]]|//script[text()[contains(.,''width=200'') and contains(.,''height=200'')]]|//iframe[@width="200" and @height="200"]|//script[text()[contains(.,''200*200'')]]|//script[text()[contains(.,''200200'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636926" width="200" height="200" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:41:27')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'200*90',N'//script[text()[contains(.,''width = 200'') and contains(.,''height = 90'')]]|//script[text()[contains(.,''200*90'')]]|//script[text()[contains(.,''width=200'') and contains(.,''height=90'')]]|//iframe[@width="200" and @height="90"]|//script[text()[contains(.,''200*90'')]]|//script[text()[contains(.,''20090'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636927" width="200" height="90" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:41:55')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'180*150',N'//script[text()[contains(.,''width = 180'') and contains(.,''height = 150'')]]|//script[text()[contains(.,''180*150'')]]|//script[text()[contains(.,''width=180'') and contains(.,''height=150'')]]|//iframe[@width="180" and @height="150"]|//script[text()[contains(.,''180*150'')]]|//script[text()[contains(.,''180150'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636928" width="180" height="150" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:42:28')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'180*90',N'//script[text()[contains(.,''width = 180'') and contains(.,''height = 90'')]]|//script[text()[contains(.,''180*90'')]]|//script[text()[contains(.,''width=180'') and contains(.,''height=90'')]]|//iframe[@width="180" and @height="90"]|//script[text()[contains(.,''180*90'')]]|//script[text()[contains(.,''18090'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636929" width="180" height="90" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:42:55')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'160*600',N'//script[text()[contains(.,''width = 160'') and contains(.,''height = 600'')]]|//script[text()[contains(.,''160*600'')]]|//script[text()[contains(.,''width=160'') and contains(.,''height=600'')]]|//iframe[@width="160" and @height="600"]|//script[text()[contains(.,''160*600'')]]|//script[text()[contains(.,''160600'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636930" width="160" height="600" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:43:34')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'160*90',N'//script[text()[contains(.,''width = 160'') and contains(.,''height = 90'')]]|//script[text()[contains(.,''160*90'')]]|//script[text()[contains(.,''width=160'') and contains(.,''height=90'')]]|//iframe[@width="160" and @height="90"]|//script[text()[contains(.,''160*90'')]]|//script[text()[contains(.,''16090'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636931" width="160" height="90" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:44:03')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'125*125',N'//script[text()[contains(.,''width = 125'') and contains(.,''height = 125'')]]|//script[text()[contains(.,''125*125'')]]|//script[text()[contains(.,''width=125'') and contains(.,''height=125'')]]|//iframe[@width="125" and @height="125"]|//script[text()[contains(.,''125*125'')]]|//script[text()[contains(.,''125125'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636932" width="125" height="125" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:44:37')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'120*600',N'//script[text()[contains(.,''width = 120'') and contains(.,''height = 600'')]]|//script[text()[contains(.,''120*600'')]]|//script[text()[contains(.,''width=120'') and contains(.,''height=600'')]]|//iframe[@width="120" and @height="600"]|//script[text()[contains(.,''120*600'')]]|//script[text()[contains(.,''120600'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636933" width="120" height="600" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:45:03')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'120*240',N'//script[text()[contains(.,''width = 120'') and contains(.,''height = 240'')]]|//script[text()[contains(.,''120*240'')]]|//script[text()[contains(.,''width=120'') and contains(.,''height=240'')]]|//iframe[@width="120" and @height="240"]|//script[text()[contains(.,''120*240'')]]|//script[text()[contains(.,''120240'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636934" width="120" height="240" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:45:29')
INSERT [NodeRule] ([IsDefault],[SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[CreatedOn]) VALUES ( 1,0,N'120*90',N'//script[text()[contains(.,''width = 120'') and contains(.,''height = 90'')]]|//script[text()[contains(.,''120*90'')]]|//script[text()[contains(.,''width=120'') and contains(.,''height=90'')]]|//iframe[@width="120" and @height="90"]|//script[text()[contains(.,''120*90'')]]|//script[text()[contains(.,''12090'')]]',N'<iframe src="http://ad.09ad.com/ads.htm?id=636935" width="120" height="90" scrolling="no" frameborder="0" style="display:block;margin:0"></iframe>',0,9,0,0,10,1,N'2013-4-11 13:45:59')

